/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDWorkAssignment;
import com.engisis.sysphs.language.simulink.SFDWorkVariable;
import com.engisis.sysphs.language.simulink.SFDerivativeAssignment;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputAssignment;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFUpdateAssignment;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFVariableAssignment;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SimulinkSF2Writer
extends TextWriter {
    protected SimulinkSF2Writer(Writer w) {
        super(w);
    }

    public void visit(SFunction2 object) throws IOException {
        int i;
        List<SFInputVariable> in = object.getInputs();
        List<SFContinuousStateVariable> cst = object.getContinuousStates();
        List<SFDiscreteStateVariable> dst = object.getDiscreteStates();
        List<SFDWorkVariable> dw = object.getDWorkStates();
        List<SFOutputVariable> out = object.getOutputs();
        ArrayList<SFDiscreteStateVariable> dws = new ArrayList<SFDiscreteStateVariable>(dst);
        dws.addAll(dw);
        this.append("function " + object.getName() + "(" + "block" + ")", 3);
        this.indent();
        this.append("setup(block);", 3);
        this.unindent();
        this.append("end", 3);
        this.append("function setup(block)", 3);
        this.indent();
        this.append("block.NumInputPorts =" + in.size() + ";", 3);
        for (i = 0; i < in.size(); ++i) {
            this.append("block.InputPort(" + (i + 1) + ").DirectFeedthrough=" + (in.get(i).isDirectFeedthrough() ? "1" : "0") + ";", 3);
        }
        this.append("block.NumOutputPorts =" + out.size() + ";", 3);
        for (i = 0; i < out.size(); ++i) {
            this.append("block.OutputPort(" + (i + 1) + ").SamplingMode = 'sample';", 3);
        }
        if (cst.size() > 0) {
            this.append("block.NumContStates = " + cst.size() + ";", 3);
        }
        if (dst.size() > 0) {
            this.append("block.NumDiscStates = " + dst.size() + ";", 3);
        }
        if (dws.size() > 0) {
            this.append("block.RegBlockMethod('PostPropagationSetup',@DoPostPropSetup);", 3);
        }
        if (dw.size() > 0) {
            this.append("block.RegBlockMethod('InitializeConditions',@InitConditions);", 3);
        }
        if (cst.size() != 0) {
            this.append("block.RegBlockMethod('Derivatives',@Derivatives);", 3);
        }
        if (dst.size() != 0) {
            this.append("block.RegBlockMethod('Update',@Update);", 3);
        }
        if (out.size() != 0) {
            this.append("block.RegBlockMethod('Outputs',@Outputs);", 3);
        }
        this.append("block.SampleTimes = [0 0];", 3);
        if (out.size() > 1) {
            this.append("block.RegBlockMethod('SetInputPortSamplingMode', @InputPortSamplingMode);", 3);
        }
        this.unindent();
        this.append("end", 3);
        if (out.size() > 1) {
            this.append("function InputPortSamplingMode(block, port, mode)", 3);
            this.indent();
            this.append("block.InputPort(port).SamplingMode = mode;", 3);
            this.unindent();
            this.append("end", 3);
        }
        if (dws.size() > 0) {
            this.append("function DoPostPropSetup(block)", 3);
            this.indent();
            this.append("block.NumDworks=" + dws.size() + ";", 3);
            for (i = 0; i < dws.size(); ++i) {
                SFVariable sw = (SFVariable)dws.get(i);
                String pref = "block.Dwork(" + (i + 1) + ")";
                this.append(pref + ".Name = '" + sw.getName() + "';", 3);
                int dim = 1;
                if (sw.getDimensions().size() > 0) {
                    dim = (Integer)sw.getDimensions().get(0);
                }
                if (sw.getDimensions().size() == 2) {
                    dim *= ((Integer)sw.getDimensions().get(1)).intValue();
                }
                this.append(pref + ".Dimensions = " + dim + ";", 3);
                this.append(pref + ".DatatypeID = 0;", 3);
                this.append(pref + ".Complexity = 'Real';", 3);
                if (dws.get(i) instanceof SFDiscreteStateVariable) {
                    this.append(pref + ".UsedAsDiscState = true;", 3);
                    continue;
                }
                this.append(pref + ".UsedAsDiscState = false;", 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        LinkedList<String> lInitial = new LinkedList<String>();
        LinkedList<String> lUpdate = new LinkedList<String>();
        LinkedList<String> lDeriv = new LinkedList<String>();
        LinkedList<String> lOutput = new LinkedList<String>();
        for (SFVariable sFVariable : dws) {
            if (sFVariable.getValue() == null) continue;
            lInitial.add(sFVariable.getName() + "=" + SimulinkSF2Writer.getValue(sFVariable) + ";");
        }
        for (SFVariableAssignment sFVariableAssignment : object.getAssignments()) {
            String expr = sFVariableAssignment.getExpression() + ";";
            if (sFVariableAssignment instanceof SFUpdateAssignment) {
                lUpdate.add(expr);
                continue;
            }
            if (sFVariableAssignment instanceof SFDerivativeAssignment) {
                lDeriv.add(expr);
                continue;
            }
            if (sFVariableAssignment instanceof SFOutputAssignment) {
                lOutput.add(expr);
                continue;
            }
            if (!(sFVariableAssignment instanceof SFDWorkAssignment)) continue;
            lInitial.add(expr);
        }
        if (dw.size() > 0) {
            this.append("function InitConditions(block)", 3);
            this.indent();
            for (String string : lInitial) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (cst.size() != 0) {
            this.append("function Derivatives(block)", 3);
            this.indent();
            for (String string : lDeriv) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (dst.size() != 0) {
            this.append("function Update(block)");
            this.indent();
            for (String string : lUpdate) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (out.size() != 0) {
            this.append("function Outputs(block)", 3);
            this.indent();
            for (String string : lOutput) {
                this.append(string, 3);
            }
            this.unindent();
            this.append("end", 3);
        }
    }

    public static String getValue(SFVariable svar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < svar.getValue().size(); ++i) {
            SDataValue sdv = (SDataValue)svar.getValue().get(i);
            if (i != 0) {
                sb.append(";");
            }
            if (sdv instanceof SExpressionValue) {
                sb.append(((SExpressionValue)sdv).getValue());
                continue;
            }
            if (!(sdv instanceof SDoubleValue)) continue;
            sb.append(((SDoubleValue)sdv).getValue());
        }
        return sb.toString();
    }
}

