/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simscape.SBranch;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SConnection;
import com.engisis.sysphs.language.simscape.SConversion;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SEquation;
import com.engisis.sysphs.language.simscape.SInput;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAccess;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SMemberPath;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SOutput;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SPropagation;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;

public class SimscapeWriter
extends TextWriter {
    public SimscapeWriter(Writer w) {
        super(w);
    }

    public void visit(SBranch object) throws IOException {
        this.append(object.getVariable().getName() + ": ", 1);
        if (object.getFrom() != null) {
            object.getFrom().accept(this.getDispatcher());
        } else {
            this.append("*");
        }
        this.append("->");
        if (object.getTo() != null) {
            object.getTo().accept(this.getDispatcher());
        } else {
            this.append("*");
        }
        this.append(";", 2);
    }

    public void visit(SComponent object) throws IOException {
        this.append("component", 1);
        if (object.isHidden() || object.getPropagation() != null && object.getPropagation() != SPropagation.PROPAGATES) {
            boolean first = true;
            this.append("(");
            if (object.isHidden()) {
                this.append("Hidden=true");
                first = false;
            }
            if (object.getPropagation() != null && object.getPropagation() != SPropagation.PROPAGATES) {
                if (!first) {
                    this.append(",");
                }
                this.append("Propagation=");
                switch (object.getPropagation()) {
                    case BLOCKS: {
                        this.append("blocks");
                        break;
                    }
                    case PROPAGATES: {
                        this.append("propagates");
                        break;
                    }
                    case SOURCE: {
                        this.append("source");
                        break;
                    }
                }
            }
            this.append(")");
        }
        this.append(" " + object.getName());
        if (object.getBaseComponent() != null) {
            this.append(" < " + object.getBaseComponent().getQualifiedName());
        }
        this.append("", 2);
        this.indent();
        LinkedList<SMember> smembers = new LinkedList<SMember>(object.getOwnedMembers());
        while (smembers.size() != 0) {
            SMember smember = smembers.get(0);
            this.getHeader(smember);
            this.indent();
            smember.accept(this.getDispatcher());
            int i = 1;
            while (i < smembers.size()) {
                if (SimscapeWriter.shareHeader(smember, smembers.get(i))) {
                    smembers.get(i).accept(this.getDispatcher());
                    smembers.remove(i);
                    continue;
                }
                ++i;
            }
            smembers.remove(0);
            this.unindent();
            this.append("end", 3);
        }
        this.append("function setup", 3);
        this.indent();
        for (SMemberAssignment sassignment : object.getOwnedAssignments()) {
            sassignment.accept(this.getDispatcher());
        }
        this.unindent();
        this.append("end", 3);
        if (object.getBranches().size() != 0) {
            this.append("branches", 3);
            this.indent();
            for (SBranch sbranch : object.getBranches()) {
                sbranch.accept(this.getDispatcher());
            }
            this.unindent();
            this.append("end", 3);
        }
        if (object.getOwnedConnections().size() != 0) {
            this.append("connections", 3);
            this.indent();
            for (SConnection sconnection : object.getOwnedConnections()) {
                this.append("connect(", 1);
                sconnection.accept(this.getDispatcher());
                this.append(");", 2);
            }
            this.unindent();
            this.append("end", 3);
        }
        if (object.getOwnedEquations().size() != 0) {
            this.append("equations", 3);
            this.indent();
            for (SEquation sequation : object.getOwnedEquations()) {
                sequation.accept(this.getDispatcher());
            }
            this.unindent();
            this.append("end", 3);
        }
        this.unindent();
        this.append("end", 3);
    }

    public void getHeader(SMember smember) throws IOException {
        if (smember instanceof SComponentReference) {
            this.append("components", 1);
        } else if (smember instanceof SParameter) {
            this.append("parameters", 1);
        } else if (smember instanceof SVariable) {
            this.append("variables", 1);
        } else if (smember instanceof SInput) {
            this.append("inputs", 1);
        } else if (smember instanceof SOutput) {
            this.append("outputs", 1);
        } else if (smember instanceof SNode) {
            this.append("nodes", 1);
        }
        LinkedList<String> options = new LinkedList<String>();
        if (smember.isHidden()) {
            options.add("Hidden=true");
        }
        if (smember.getAccess() != null && smember.getAccess() != SMemberAccess.PUBLIC) {
            options.add("Access=" + smember.getAccess().name().toLowerCase());
        }
        if (smember instanceof SParameter && ((SParameter)smember).getConversion() != SConversion.ABSOLUTE) {
            options.add("Conversion=relative");
        }
        if (smember instanceof SVariable && ((SVariable)smember).isBalancing()) {
            options.add("Balancing=true");
        }
        if (options.size() > 0) {
            this.append("(");
            for (int i = 0; i < options.size(); ++i) {
                if (i != 0) {
                    this.append(",");
                }
                this.append((String)options.get(i));
            }
            this.append(")");
        }
        this.append("", 2);
    }

    public static boolean shareHeader(SMember smember1, SMember smember2) {
        if (smember1 == null || smember2 == null) {
            throw new IllegalArgumentException("The compared members must not be null");
        }
        if (smember1.getClass() != smember2.getClass()) {
            return false;
        }
        if (smember1 instanceof SParameter && ((SParameter)smember1).getConversion() != ((SParameter)smember2).getConversion()) {
            return false;
        }
        if (smember1 instanceof SVariable && ((SVariable)smember1).isBalancing() != ((SVariable)smember2).isBalancing()) {
            return false;
        }
        return smember1.isHidden() == smember2.isHidden() && smember1.getAccess() == smember2.getAccess();
    }

    public void visit(SComponentReference object) throws IOException {
        this.append(object.getName() + "=" + object.getComponent().getQualifiedName() + ";", 3);
    }

    public void visit(SConnection object) throws IOException {
        for (int i = 0; i < object.getPoints().size(); ++i) {
            if (i != 0) {
                this.append(",");
            }
            ((SMemberPath)object.getPoints().get(i)).accept(this.getDispatcher());
        }
    }

    public void visit(SMemberPath object) throws IOException {
        for (int i = 0; i < object.getPath().size(); ++i) {
            if (i != 0) {
                this.append(".");
            }
            this.append(((SMember)object.getPath().get(i)).getName());
        }
    }

    public void visit(SDomain object) throws IOException {
        this.append("domain " + object.getName(), 3);
        this.indent();
        LinkedList<SParameter> sparameters = new LinkedList<SParameter>(object.getParameters());
        while (sparameters.size() != 0) {
            SParameter sparameter = sparameters.get(0);
            this.getHeader(sparameter);
            this.indent();
            sparameter.accept(this.getDispatcher());
            int i = 1;
            while (i < sparameters.size()) {
                if (SimscapeWriter.shareHeader(sparameter, sparameters.get(i))) {
                    sparameters.get(i).accept(this.getDispatcher());
                    sparameters.remove(i);
                    continue;
                }
                ++i;
            }
            sparameters.remove(0);
            this.unindent();
            this.append("end", 3);
        }
        LinkedList<SVariable> svariables = new LinkedList<SVariable>(object.getVariables());
        while (svariables.size() != 0) {
            SVariable svariable = svariables.get(0);
            svariable.setValue(null);
            this.getHeader(svariable);
            svariable.accept(this.getDispatcher());
            this.indent();
            int i = 1;
            while (i < svariables.size()) {
                if (SimscapeWriter.shareHeader(svariable, svariables.get(i))) {
                    SVariable svariable2 = svariables.get(i);
                    svariable2.setValue(null);
                    svariable2.accept(this.getDispatcher());
                    svariables.remove(i);
                    continue;
                }
                ++i;
            }
            svariables.remove(0);
            this.unindent();
            this.append("end", 3);
        }
        this.unindent();
        this.append("end", 3);
    }

    public void visit(SDoubleValue object) throws IOException {
        this.append(Double.toString(object.getValue()));
    }

    public void visit(SEquation object) throws IOException {
        this.append(object.getExpression() + ";", 3);
    }

    public void visit(SExpressionValue object) throws IOException {
        this.append(object.getValue());
    }

    public void visit(SInput object) throws IOException {
        this.append(object.getName() + "=", 1);
        String unit = object.getUnit();
        SDataValue value = object.getValue();
        if (unit != null) {
            this.append("{");
            this.valueOrZero(value);
            this.append(",'" + unit + "'}");
        } else {
            this.valueOrZero(value);
        }
        this.append(";");
        if (object.getLocation() == SLocation.RIGHT) {
            this.append("% :right", 2);
        } else {
            this.append("% :left", 2);
        }
    }

    private void valueOrZero(SDataValue svalue) throws IOException {
        if (svalue == null) {
            this.append("0");
        } else {
            svalue.accept(this.getDispatcher());
        }
    }

    public void visit(SMemberAssignment object) throws IOException {
        SMember smember;
        int i;
        int sz = object.getMemberPath().size();
        boolean isparam = sz > 0 ? object.getMemberPath().get(sz - 1) instanceof SParameter : false;
        this.append("", 1);
        for (i = 0; i < sz; ++i) {
            smember = (SMember)object.getMemberPath().get(i);
            if (i != 0) {
                this.append(".");
            }
            this.append(smember.getName());
        }
        this.append("=");
        if (object.getAssignedReference().size() != 0) {
            for (i = 0; i < object.getAssignedReference().size(); ++i) {
                smember = (SMember)object.getAssignedReference().get(i);
                if (i != 0) {
                    this.append(".");
                }
                this.append(smember.getName());
            }
        } else {
            if (!isparam) {
                this.append("{value=");
            }
            String unit = null;
            SMember lastmember = (SMember)object.getMemberPath().get(object.getMemberPath().size() - 1);
            if (lastmember instanceof SVariable) {
                unit = ((SVariable)lastmember).getUnit();
            } else if (lastmember instanceof SParameter) {
                unit = ((SParameter)lastmember).getUnit();
            }
            if (unit != null) {
                this.append("{");
            }
            object.getAssignedValue().accept(this.getDispatcher());
            if (unit != null) {
                this.append(",'" + unit + "'}");
            }
            if (!isparam) {
                this.append(", priority=priority.high}");
            }
        }
        this.append(";", 2);
    }

    public void visit(SNode object) throws IOException {
        this.append(object.getName() + "=" + object.getDomain().getQualifiedName() + ";", 1);
        if (object.getLocation() == SLocation.RIGHT) {
            this.append("% :right", 2);
        } else {
            this.append("% :left", 2);
        }
    }

    public void visit(SOutput object) throws IOException {
        this.append(object.getName() + "=", 1);
        String unit = object.getUnit();
        SDataValue value = object.getValue();
        if (unit != null) {
            this.append("{");
            this.valueOrZero(value);
            this.append(",'" + unit + "'}");
        } else {
            this.valueOrZero(value);
        }
        this.append(";");
        if (object.getLocation() == SLocation.RIGHT) {
            this.append("% :right", 2);
        } else {
            this.append("% :left", 2);
        }
    }

    public void visit(SParameter object) throws IOException {
        this.append(object.getName() + "=", 1);
        String unit = object.getUnit();
        SDataValue value = object.getValue();
        if (unit != null) {
            this.append("{");
            this.valueOrZero(value);
            this.append(",'" + unit + "'}");
        } else {
            this.valueOrZero(value);
        }
        this.append(";", 2);
    }

    public void visit(SVariable object) throws IOException {
        this.append(object.getName() + "=", 1);
        String unit = object.getUnit();
        SDataValue value = object.getValue();
        if (unit != null) {
            this.append("{");
            this.valueOrZero(value);
            this.append(",'" + unit + "'}");
        } else {
            this.valueOrZero(value);
        }
        this.append(";", 2);
    }
}

