/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.modelica;

import com.engisis.sysphs.language.modelica.MAccessControl;
import com.engisis.sysphs.language.modelica.MAlgorithm;
import com.engisis.sysphs.language.modelica.MBlock;
import com.engisis.sysphs.language.modelica.MBooleanValue;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MConnect;
import com.engisis.sysphs.language.modelica.MConnector;
import com.engisis.sysphs.language.modelica.MDataFlow;
import com.engisis.sysphs.language.modelica.MDirection;
import com.engisis.sysphs.language.modelica.MEquation;
import com.engisis.sysphs.language.modelica.MExpressionValue;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MHierarchy;
import com.engisis.sysphs.language.modelica.MIntegerValue;
import com.engisis.sysphs.language.modelica.MModel;
import com.engisis.sysphs.language.modelica.MModification;
import com.engisis.sysphs.language.modelica.MRealValue;
import com.engisis.sysphs.language.modelica.MStringValue;
import com.engisis.sysphs.language.modelica.MType;
import com.engisis.sysphs.language.modelica.MVariability;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ModelicaWriter
extends TextWriter {
    public ModelicaWriter(Writer w) {
        super(w);
    }

    public void visit(MAlgorithm object) throws IOException {
        this.append(object.getExpression(), 3);
    }

    public void visit(MBlock object) throws IOException {
        this.printClass(object, "block");
    }

    public void visit(MBooleanValue object) throws IOException {
        this.append(object.isValue() ? "true" : "false");
    }

    public void visit(MClass object) throws IOException {
        this.printClass(object, "class");
    }

    /*
     * WARNING - void declaration
     */
    public void printClass(MClass object, String prefix) throws IOException {
        LinkedList<MComponent> mcs_pro = new LinkedList<MComponent>();
        LinkedList<MComponent> mcs_pub = new LinkedList<MComponent>();
        for (MComponent mc : object.getComponents()) {
            if (mc.getRedefinedComponent() != null) continue;
            if (mc.getAccessControl() == MAccessControl.PROTECTED) {
                mcs_pro.add(mc);
                continue;
            }
            mcs_pub.add(mc);
        }
        LinkedList<MExtension> mes_pro = new LinkedList<MExtension>();
        LinkedList<MExtension> mes_pub = new LinkedList<MExtension>();
        for (MExtension mExtension : object.getExtensions()) {
            if (mExtension.getAccessControl() == MAccessControl.PROTECTED) {
                mes_pro.add(mExtension);
                continue;
            }
            mes_pub.add(mExtension);
        }
        if (mcs_pub.size() == 0 && mcs_pro.size() == 0 && object.getEquations().size() == 0 && object.getExtensions().size() == 1 && object.getOwnedClasses().size() == 0 && object.getAlgorithms().size() == 0 && (object instanceof MType || object instanceof MConnector)) {
            void var8_13;
            Iterator extension = (MExtension)object.getExtensions().get(0);
            String string = "";
            if (((MExtension)((Object)extension)).getDirection() == MDirection.INPUT) {
                String string2 = "input ";
            } else if (((MExtension)((Object)extension)).getDirection() == MDirection.OUTPUT) {
                String string3 = "output ";
            }
            this.append(prefix + " " + object.getName() + "=" + (String)var8_13 + ((MExtension)((Object)extension)).getExtendedClass().getName(), 1);
            LinkedList<MComponent> mcs_red = new LinkedList<MComponent>();
            for (MComponent mc : object.getComponents()) {
                MComponent red = mc.getRedefinedComponent();
                if (red == null || !((MExtension)((Object)extension)).getExtendedClass().getAllComponents().contains(red)) continue;
                mcs_red.add(mc);
            }
            this.serializeModificationsAndRedefinitions(((MExtension)((Object)extension)).getModifications(), mcs_red);
            this.append(";", 2);
            return;
        }
        this.append(prefix + " " + object.getName(), 3);
        this.indent();
        for (MExtension mExtension : mes_pub) {
            mExtension.accept(this.getDispatcher());
        }
        for (MComponent mComponent : mcs_pub) {
            this.append("", 1);
            mComponent.accept(this.getDispatcher());
            this.append(";", 2);
        }
        for (MClass mClass : object.getOwnedClasses()) {
            mClass.accept(this.getDispatcher());
        }
        boolean prot = false;
        for (MExtension e : mes_pro) {
            if (!prot) {
                this.unindent();
                this.append("protected", 3);
                this.indent();
                prot = true;
            }
            e.accept(this.getDispatcher());
        }
        for (MComponent c : mcs_pro) {
            if (!prot) {
                this.unindent();
                this.append("protected", 3);
                this.indent();
                prot = true;
            }
            this.append("", 1);
            c.accept(this.getDispatcher());
            this.append(";", 2);
        }
        if (object.getEquations().size() != 0) {
            this.unindent();
            this.append("equation", 3);
            this.indent();
            for (MEquation mequation : object.getEquations()) {
                mequation.accept(this.getDispatcher());
            }
        }
        if (object.getAlgorithms().size() != 0) {
            this.unindent();
            this.append("algorithm", 3);
            this.indent();
            for (MAlgorithm malgorithm : object.getAlgorithms()) {
                malgorithm.accept(this.getDispatcher());
            }
        }
        this.unindent();
        this.append("end " + object.getName() + ";", 3);
    }

    public void visit(MComponent object) throws IOException {
        MComponent red;
        if (object.getName() == null) {
            throw new NullPointerException("The component has no name: " + object + ", type " + object.getType() + ", owner " + object.getOwningClass());
        }
        if (object.getType() == null) {
            throw new NullPointerException("The type of " + object.getName() + " is null");
        }
        if (object.getRedefiningComponent().size() > 0) {
            this.append("replaceable ");
        }
        if ((red = object.getRedefinedComponent()) == null || object.getHierarchy() != red.getHierarchy()) {
            if (object.getHierarchy() == MHierarchy.INNER) {
                this.append("inner ");
            } else if (object.getHierarchy() == MHierarchy.OUTER) {
                this.append("outer ");
            }
        }
        if ((red == null || object.getDataFlow() != red.getDataFlow()) && object.getDataFlow() == MDataFlow.FLOW) {
            this.append("flow ");
        }
        if (red == null || object.getVariability() != red.getVariability()) {
            if (object.getVariability() == MVariability.CONSTANT) {
                this.append("constant ");
            } else if (object.getVariability() == MVariability.PARAMETER) {
                this.append("parameter ");
            } else if (object.getVariability() == MVariability.DISCRETE) {
                this.append("discrete ");
            }
        }
        if (red == null || object.getDirection() != red.getDirection()) {
            if (object.getDirection() == MDirection.INPUT) {
                this.append("input ");
            } else if (object.getDirection() == MDirection.OUTPUT) {
                this.append("output ");
            }
        }
        this.append(object.getType().getName());
        if (object.getDimensions().size() > 0) {
            this.append("[");
            for (int i = 0; i < object.getDimensions().size(); ++i) {
                if (i != 0) {
                    this.append(",");
                }
                this.append(String.valueOf(object.getDimensions().get(i)));
            }
            this.append("] ");
        }
        this.append(" ");
        this.append(object.getName());
        this.serializeModificationsAndRedefinitions(object.getModifications(), null);
        if (object.getValue() != null) {
            this.append("=");
            object.getValue().accept(this.getDispatcher());
        }
    }

    public void visit(MConnect object) throws IOException {
        this.append("connect(", 1);
        EList<MComponent> ref1 = object.getRef1();
        EList<MComponent> ref2 = object.getRef2();
        if (ref1.size() != 0 && ref2.size() != 0) {
            MComponent mc;
            int i;
            MComponent mc1 = (MComponent)ref1.get(ref1.size() - 1);
            MComponent mc2 = (MComponent)ref2.get(ref2.size() - 1);
            for (i = 0; i < ref1.size(); ++i) {
                if (i != 0) {
                    this.append(".");
                }
                mc = (MComponent)ref1.get(i);
                this.append(mc.getName());
            }
            if (mc1.getDimensions().size() == 1 && (Integer)mc1.getDimensions().get(0) == 1 && mc2.getDimensions().size() == 0) {
                this.append("[1]");
            }
            this.append(",");
            for (i = 0; i < ref2.size(); ++i) {
                if (i != 0) {
                    this.append(".");
                }
                mc = (MComponent)ref2.get(i);
                this.append(mc.getName());
            }
            if (mc2.getDimensions().size() == 1 && (Integer)mc2.getDimensions().get(0) == 1 && mc1.getDimensions().size() == 0) {
                this.append("[1]");
            }
        }
        this.append(");", 2);
    }

    public void visit(MConnector object) throws IOException {
        this.printClass(object, "connector");
    }

    public void visit(MEquation object) throws IOException {
        this.append(object.getExpression() + ";", 3);
    }

    public void visit(MExpressionValue object) throws IOException {
        this.append(object.getValue());
    }

    public void visit(MExtension object) throws IOException {
        LinkedList<MComponent> mcs_red = new LinkedList<MComponent>();
        for (MComponent mc : object.getOwningClass().getComponents()) {
            MComponent red = mc.getRedefinedComponent();
            if (!object.getExtendedClass().getAllComponents().contains(red)) continue;
            mcs_red.add(mc);
        }
        this.append("extends " + object.getExtendedClass().getName(), 1);
        this.serializeModificationsAndRedefinitions(object.getModifications(), mcs_red);
        this.append(";", 2);
    }

    public void visit(MIntegerValue object) throws IOException {
        this.append(String.valueOf(object.getValue()));
    }

    public void visit(MModel object) throws IOException {
        this.printClass(object, "model");
    }

    public void visit(MModification object) throws IOException {
        MComponent mc;
        int i;
        for (i = 0; i < object.getComponentPath().size(); ++i) {
            mc = (MComponent)object.getComponentPath().get(i);
            if (i != 0) {
                this.append(".");
            }
            if (mc == null) continue;
            this.append(mc.getName());
        }
        this.append("=");
        if (object.getAssignedValue() != null) {
            object.getAssignedValue().accept(this.getDispatcher());
        } else if (object.getAssignedReference() != null) {
            for (i = 0; i < object.getAssignedReference().size(); ++i) {
                mc = (MComponent)object.getAssignedReference().get(i);
                if (i != 0) {
                    this.append(".");
                }
                if (mc == null) continue;
                this.append(mc.getName());
            }
        }
    }

    public void visit(MRealValue object) throws IOException {
        this.append(String.valueOf(object.getValue()));
    }

    public void visit(MStringValue object) throws IOException {
        this.append("\"" + object.getValue() + "\"");
    }

    public void visit(MType object) throws IOException {
        this.printClass(object, "type");
    }

    public void serializeModificationsAndRedefinitions(List<MModification> modifications, List<MComponent> redefinitions) throws IOException {
        boolean first = true;
        if (modifications != null && modifications.size() != 0 || redefinitions != null && redefinitions.size() != 0) {
            this.append("(");
            if (modifications != null) {
                for (MModification modification : modifications) {
                    if (!first) {
                        this.append(",");
                    }
                    modification.accept(this.getDispatcher());
                    first = false;
                }
            }
            if (redefinitions != null) {
                for (MComponent redefinition : redefinitions) {
                    if (!first) {
                        this.append(",");
                    }
                    this.append("redeclare ");
                    redefinition.accept(this.getDispatcher());
                    first = false;
                }
            }
            this.append(")");
        }
    }
}

