/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.generation.simulink.MATLABBaseListener;
import com.engisis.sysphs.generation.simulink.MATLABParser;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDerivativeAssignment;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputAssignment;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFUpdateAssignment;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

public class SimulinkSF2Reader
extends MATLABBaseListener
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(SimulinkSF2Reader.class);
    private ParseTreeProperty<Object> values = new ParseTreeProperty();
    private Hashtable<String, String> substitutions = new Hashtable();
    private ParserRuleContext prc;
    private String fupd;
    private String fder;
    private String fout;
    private SFunction2 sf2;

    public SimulinkSF2Reader(ParserRuleContext prc) {
        this.prc = prc;
    }

    @Override
    public void process() {
        new ParseTreeWalker().walk(this, this.prc);
    }

    @Override
    public void enterFile(MATLABParser.FileContext ctx) {
        this.sf2 = SimulinkFactory.eINSTANCE.createSFunction2();
        SimulinkUtil.setName(this.sf2, ctx.function(0).f_def_line().ID(0).getText());
        log.info("Creating SFunction " + this.sf2.getName());
    }

    @Override
    public void exitFunction(MATLABParser.FunctionContext ctx) {
        block27: {
            String block;
            String name;
            block30: {
                block29: {
                    block28: {
                        name = ctx.f_def_line().ID(0).getText();
                        MATLABParser.F_inputContext fic = ctx.f_def_line().f_input();
                        if (fic == null || fic.ID().size() != 1) break block27;
                        block = fic.ID().get(0).getText();
                        if (!name.equals("setup")) break block28;
                        log.debug("Setup function detected");
                        for (MATLABParser.StatementContext sc : ctx.statement()) {
                            List<MATLABParser.ExprContext> exprs;
                            MATLABParser.ReferenceContext rc;
                            List<MATLABParser.Id_argContext> ref;
                            MATLABParser.ExprContext ec;
                            MATLABParser.AssignmentContext ac = sc.assignment();
                            if (ac != null && ac.reference().id_arg().size() == 2 && ac.reference().id_arg().get(0).ID().getText().equals(block) && ac.reference().id_arg().get(0).argument_list() == null) {
                                String prop = ac.reference().id_arg().get(1).ID().getText();
                                Object val = this.values.get(ac.expr());
                                if (prop.equals("NumInputPorts")) {
                                    if (val instanceof Integer) {
                                        for (int i = 0; i < (Integer)val; ++i) {
                                            log.debug("Adding input variable");
                                            SFInputVariable sfiv = SimulinkFactory.eINSTANCE.createSFInputVariable();
                                            this.sf2.getVariables().add(sfiv);
                                            SimulinkUtil.setName(sfiv, "_iv" + i);
                                            this.substitutions.put(".InputPort(" + (i + 1) + ").Data", sfiv.getName());
                                            SInport sinport = SimulinkFactory.eINSTANCE.createSInport();
                                            sinport.setOwningSystem(this.sf2);
                                            SimulinkUtil.setName(sinport, sfiv.getName());
                                        }
                                    }
                                } else if (prop.equals("NumOutputPorts")) {
                                    if (val instanceof Integer) {
                                        for (int i = 0; i < (Integer)val; ++i) {
                                            log.debug("Adding output variable");
                                            SFOutputVariable sfov = SimulinkFactory.eINSTANCE.createSFOutputVariable();
                                            this.sf2.getVariables().add(sfov);
                                            SimulinkUtil.setName(sfov, "_ov" + i);
                                            this.substitutions.put(".OutputPort(" + (i + 1) + ").Data", sfov.getName());
                                            SOutport soutport = SimulinkFactory.eINSTANCE.createSOutport();
                                            soutport.setOwningSystem(this.sf2);
                                            SimulinkUtil.setName(soutport, sfov.getName());
                                        }
                                    }
                                } else if (prop.equals("NumContStates")) {
                                    if (val instanceof Integer) {
                                        for (int i = 0; i < (Integer)val; ++i) {
                                            log.debug("Adding continuous state");
                                            SFContinuousStateVariable sfcs = SimulinkFactory.eINSTANCE.createSFContinuousStateVariable();
                                            this.sf2.getVariables().add(sfcs);
                                            SimulinkUtil.setName(sfcs, "_cs" + i);
                                            this.substitutions.put(".ContStates.Data(" + (i + 1) + ")", sfcs.getName());
                                            this.substitutions.put(".Derivatives.Data(" + (i + 1) + ")", "der(" + sfcs.getName() + ")");
                                        }
                                    }
                                } else if (prop.equals("NumDiscStates") && val instanceof Integer) {
                                    for (int i = 0; i < (Integer)val; ++i) {
                                        log.debug("Adding discrete state");
                                        SFDiscreteStateVariable sfds = SimulinkFactory.eINSTANCE.createSFDiscreteStateVariable();
                                        this.sf2.getVariables().add(sfds);
                                        SimulinkUtil.setName(sfds, "_ds" + i);
                                        this.substitutions.put(".DiscStates.Data(" + (i + 1) + ")", "pre(" + sfds.getName() + ")");
                                        this.substitutions.put(".Dwork(" + (i + 1) + ").Data", sfds.getName());
                                    }
                                }
                            }
                            if ((ec = sc.expr()) == null || !(this.values.get(ec) instanceof MATLABParser.ReferenceContext) || (ref = (rc = (MATLABParser.ReferenceContext)this.values.get(ec)).id_arg()).size() != 2) continue;
                            MATLABParser.Id_argContext ref0 = ref.get(0);
                            MATLABParser.Id_argContext ref1 = ref.get(1);
                            if (!ref0.getText().equals(block) || !ref1.ID().getText().equals("RegBlockMethod") || ref1.argument_list() == null || (exprs = ref1.argument_list().expr()).size() != 2) continue;
                            Object o0 = this.values.get(exprs.get(0));
                            Object o1 = this.values.get(exprs.get(1));
                            if (!(o0 instanceof String) || !(o1 instanceof TerminalNode)) continue;
                            if (o0.equals("Outputs")) {
                                this.fout = ((TerminalNode)o1).getText();
                                continue;
                            }
                            if (o0.equals("Updates")) {
                                this.fupd = ((TerminalNode)o1).getText();
                                continue;
                            }
                            if (!o0.equals("Derivatives")) continue;
                            this.fder = ((TerminalNode)o1).getText();
                        }
                        break block27;
                    }
                    if (!name.equals(this.fder)) break block29;
                    log.debug("Derivative function detected");
                    for (MATLABParser.StatementContext sc : ctx.statement()) {
                        MATLABParser.AssignmentContext ac = sc.assignment();
                        if (ac == null) continue;
                        String lhs = ac.reference().getText();
                        String rhs = ac.expr().getText();
                        for (int i = 0; i < this.sf2.getContinuousStates().size(); ++i) {
                            if (!lhs.equals(block + ".Derivatives.Data(" + (i + 1) + ")")) continue;
                            SFDerivativeAssignment sfda = SimulinkFactory.eINSTANCE.createSFDerivativeAssignment();
                            sfda.setVariable(this.sf2.getContinuousStates().get(i));
                            for (Map.Entry<String, String> ent : this.substitutions.entrySet()) {
                                lhs = lhs.replace(block + ent.getKey(), ent.getValue());
                                rhs = rhs.replace(block + ent.getKey(), ent.getValue());
                            }
                            sfda.setExpression(lhs + "=" + rhs);
                            this.sf2.getAssignments().add(sfda);
                            log.debug("Found derivative assignment");
                        }
                    }
                    break block27;
                }
                if (!name.equals(this.fupd)) break block30;
                log.debug("Update function detected");
                for (MATLABParser.StatementContext sc : ctx.statement()) {
                    MATLABParser.AssignmentContext ac = sc.assignment();
                    if (ac == null) continue;
                    String lhs = ac.reference().getText();
                    String rhs = ac.expr().getText();
                    for (int i = 0; i < this.sf2.getDiscreteStates().size(); ++i) {
                        if (!lhs.equals(block + ".DiscStates.Data(" + (i + 1) + ")")) continue;
                        SFUpdateAssignment sfua = SimulinkFactory.eINSTANCE.createSFUpdateAssignment();
                        sfua.setVariable(this.sf2.getDiscreteStates().get(i));
                        for (Map.Entry<String, String> ent : this.substitutions.entrySet()) {
                            lhs = lhs.replace(block + ent.getKey(), ent.getValue());
                            rhs = rhs.replace(block + ent.getKey(), ent.getValue());
                        }
                        sfua.setExpression(lhs + "=" + rhs);
                        this.sf2.getAssignments().add(sfua);
                        log.debug("Found update assignment");
                    }
                }
                break block27;
            }
            if (!name.equals(this.fout)) break block27;
            log.debug("Output function detected");
            for (MATLABParser.StatementContext sc : ctx.statement()) {
                MATLABParser.AssignmentContext ac = sc.assignment();
                if (ac == null) continue;
                String lhs = ac.reference().getText();
                String rhs = ac.expr().getText();
                for (int i = 0; i < this.sf2.getOutputs().size(); ++i) {
                    if (!lhs.equals(block + ".OutputPort(" + (i + 1) + ").Data")) continue;
                    SFOutputAssignment sfoa = SimulinkFactory.eINSTANCE.createSFOutputAssignment();
                    sfoa.setVariable(this.sf2.getOutputs().get(i));
                    for (Map.Entry<String, String> ent : this.substitutions.entrySet()) {
                        lhs = lhs.replace(block + ent.getKey(), ent.getValue());
                        rhs = rhs.replace(block + ent.getKey(), ent.getValue());
                    }
                    sfoa.setExpression(lhs + "=" + rhs);
                    this.sf2.getAssignments().add(sfoa);
                    log.debug("Found output assignment");
                }
            }
        }
    }

    @Override
    public void exitExpr(MATLABParser.ExprContext ctx) {
        if (ctx.expr2().size() == 1) {
            this.transfer(ctx, ctx.expr2().get(0));
        }
    }

    @Override
    public void exitExpr2(MATLABParser.Expr2Context ctx) {
        if (ctx.expr3().size() == 1) {
            this.transfer(ctx, ctx.expr3().get(0));
        }
    }

    @Override
    public void exitExpr3(MATLABParser.Expr3Context ctx) {
        if (ctx.expr4().size() == 1) {
            this.transfer(ctx, ctx.expr4().get(0));
        }
    }

    @Override
    public void exitExpr4(MATLABParser.Expr4Context ctx) {
        if (ctx.expr5().size() == 1) {
            this.transfer(ctx, ctx.expr5().get(0));
        }
    }

    @Override
    public void exitExpr5(MATLABParser.Expr5Context ctx) {
        if (ctx.expr6().size() == 1) {
            this.transfer(ctx, ctx.expr6().get(0));
        }
    }

    @Override
    public void exitExpr6(MATLABParser.Expr6Context ctx) {
        if (ctx.expr7().size() == 1) {
            this.transfer(ctx, ctx.expr7().get(0));
        }
    }

    @Override
    public void exitExpr7(MATLABParser.Expr7Context ctx) {
        if (ctx.expr8().size() == 1) {
            this.transfer(ctx, ctx.expr8().get(0));
        }
    }

    @Override
    public void exitExpr8(MATLABParser.Expr8Context ctx) {
        if (ctx.expr9().size() == 1) {
            this.transfer(ctx, ctx.expr9().get(0));
        }
    }

    @Override
    public void exitExpr9(MATLABParser.Expr9Context ctx) {
        this.transfer(ctx, ctx.expr10());
    }

    @Override
    public void exitExpr10(MATLABParser.Expr10Context ctx) {
        if (ctx.expr11().size() == 1) {
            this.transfer(ctx, ctx.expr11().get(0));
        }
    }

    @Override
    public void exitExpr11(MATLABParser.Expr11Context ctx) {
        if (ctx.INT() != null) {
            this.values.put(ctx, Integer.valueOf(ctx.INT().getText()));
        } else if (ctx.FLOAT() != null) {
            this.values.put(ctx, Double.valueOf(ctx.FLOAT().getText()));
        } else if (ctx.STRING() != null) {
            this.values.put(ctx, ctx.STRING().getText().substring(1, ctx.STRING().getText().length() - 1));
        } else if (ctx.reference() != null) {
            this.values.put(ctx, ctx.reference());
        } else if (ctx.ID() != null) {
            this.values.put(ctx, ctx.ID());
        } else if (ctx.expr() != null) {
            this.transfer(ctx, ctx.expr());
        }
    }

    private void transfer(ParseTree to, ParseTree from) {
        this.values.put(to, this.values.get(from));
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return null;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public SElement getRootElement() {
        return this.sf2;
    }
}

