/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.Format;
import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.language.simulink.SElement;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SimulinkFile {
    private static final Logger log = Logger.getLogger(SimulinkFile.class);
    private String filename;
    private Format format;
    private List<SimulinkReader> readers;

    public SimulinkFile(String filename, Format format) {
        this.filename = filename;
        this.format = format;
        this.readers = new LinkedList<SimulinkReader>();
    }

    public String getFilename() {
        return this.filename;
    }

    public Format getFormat() {
        return this.format;
    }

    public List<SimulinkReader> getReaders() {
        return this.readers;
    }

    public SElement getRootElement() {
        for (SimulinkReader sr : this.getReaders()) {
            if (sr.getRootElement() == null) continue;
            return sr.getRootElement();
        }
        log.error("No root element found for " + this.getFilename() + " #readers: " + this.getReaders().size());
        return null;
    }
}

