/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.modelica;

import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MNamedElement;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

public class ModelicaScope {
    private static final Logger log = Logger.getLogger(ModelicaScope.class);
    private String name;
    private List<ModelicaScope> children = new LinkedList<ModelicaScope>();
    private List<ModelicaScope> siblings = new LinkedList<ModelicaScope>();
    private ModelicaScope parent;
    private MNamedElement mnamedelement;
    private boolean pub = true;

    public ModelicaScope(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<ModelicaScope> getSiblings() {
        return this.siblings;
    }

    public void setParent(ModelicaScope parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        parent.children.add(this);
    }

    public ModelicaScope getParent() {
        return this.parent;
    }

    public void setMNamedElement(MNamedElement mnamedelement) {
        this.mnamedelement = mnamedelement;
    }

    public MNamedElement getMNamedElement() {
        return this.mnamedelement;
    }

    public void setPublic(boolean pub) {
        this.pub = pub;
    }

    public boolean isPublic() {
        return this.pub;
    }

    public List<MClass> getAllMClasses() {
        LinkedList<MClass> ret = new LinkedList<MClass>();
        this.addMClasses(ret);
        return ret;
    }

    private void addMClasses(List<MClass> list) {
        if (this.mnamedelement instanceof MClass && !this.mnamedelement.getName().contains(".")) {
            list.add((MClass)this.mnamedelement);
        }
        for (ModelicaScope child : this.children) {
            child.addMClasses(list);
        }
    }

    public ModelicaScope lookForElementGlobally(TerminalNode name) {
        ModelicaScope scope = this.lookForElementInScope(name);
        if (scope != null && scope.mnamedelement instanceof MClass) {
            return scope;
        }
        if (this.parent != null) {
            return this.parent.lookForElementGlobally(name);
        }
        return null;
    }

    public ModelicaScope lookForClass(List<TerminalNode> path) {
        ModelicaScope scope = this.lookForElementGlobally(path.get(0));
        if (scope == null) {
            ModelicaScope root = this.getRoot();
            for (ModelicaScope child : root.children) {
                MNamedElement mne = child.getMNamedElement();
                if (!mne.getName().equals(ModelicaScope.join(path)) || !(mne instanceof MClass)) continue;
                return child;
            }
            log.error("Can't find the element " + path.get(0) + " from " + path);
            return null;
        }
        for (int i = 1; i < path.size(); ++i) {
            if ((scope = scope.lookForElementInScope(path.get(i))) != null) continue;
            log.error("Can't find the element " + path.get(i) + " from " + path);
            return null;
        }
        if (scope.getMNamedElement() instanceof MClass) {
            return scope;
        }
        return null;
    }

    public ModelicaScope lookForElementInScope(TerminalNode name) {
        for (ModelicaScope scope : this.children) {
            if (scope.mnamedelement == null || !name.getText().equals(scope.mnamedelement.getName())) continue;
            return scope;
        }
        for (ModelicaScope sib : this.siblings) {
            ModelicaScope ret = sib.lookForElementInScope(name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ModelicaScope getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    private static String join(List<TerminalNode> path) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i != 0) {
                name.append(".");
            }
            name.append(path.get(i).getText());
        }
        return name.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parent != null) {
            sb.append(this.parent.toString() + "::");
        }
        sb.append(this.name);
        return sb.toString();
    }
}

