/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.modelica;

import com.engisis.sysphs.deserialization.modelica.ModelicaScope;
import com.engisis.sysphs.generation.modelica.ModelicaBaseListener;
import com.engisis.sysphs.generation.modelica.ModelicaParser;
import com.engisis.sysphs.language.modelica.MAccessControl;
import com.engisis.sysphs.language.modelica.MAlgorithm;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MDataFlow;
import com.engisis.sysphs.language.modelica.MDirection;
import com.engisis.sysphs.language.modelica.MElement;
import com.engisis.sysphs.language.modelica.MEquation;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MVariability;
import com.engisis.sysphs.language.modelica.ModelicaFactory;
import com.engisis.sysphs.translation.modelica.ModelicaUtil;
import com.engisis.sysphs.util.Util;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

public class ModelicaReaderPass1
extends ModelicaBaseListener {
    private static final Logger log = Logger.getLogger(ModelicaReaderPass1.class);
    private ParseTreeProperty<ModelicaScope> scopelist = new ParseTreeProperty();
    private Hashtable<ParseTree, List<TerminalNode>> resolutionlist;
    private Hashtable<MElement, ParseTree> expressions;
    private ModelicaScope globalscope;
    private ModelicaScope scope;

    public ModelicaReaderPass1(ModelicaScope globalscope) {
        this.globalscope = globalscope;
        this.scope = globalscope;
        this.resolutionlist = new Hashtable();
        this.expressions = new Hashtable();
    }

    public Hashtable<MElement, ParseTree> getExpressions() {
        return this.expressions;
    }

    public ParseTreeProperty<ModelicaScope> getScopeList() {
        return this.scopelist;
    }

    @Override
    public void enterStored_definition(ModelicaParser.Stored_definitionContext ctx) {
        super.enterStored_definition(ctx);
        this.scopelist.put(ctx, this.globalscope);
    }

    @Override
    public void enterClass_definition(ModelicaParser.Class_definitionContext ctx) {
        super.enterClass_definition(ctx);
        ModelicaParser.Class_specifierContext specifier = ctx.class_specifier();
        String name = specifier.IDENT(0).getText();
        ModelicaScope newscope = new ModelicaScope(name);
        newscope.setParent(this.scope);
        this.scope = newscope;
        this.scopelist.put(ctx, newscope);
        ModelicaParser.Class_prefixesContext prefix = ctx.class_prefixes();
        MClass mclass = null;
        if (prefix.CLASS() != null) {
            mclass = ModelicaFactory.eINSTANCE.createMClass();
        } else if (prefix.MODEL() != null) {
            mclass = ModelicaFactory.eINSTANCE.createMModel();
        } else if (prefix.BLOCK() != null) {
            mclass = ModelicaFactory.eINSTANCE.createMBlock();
        } else if (prefix.CONNECTOR() != null) {
            mclass = ModelicaFactory.eINSTANCE.createMConnector();
        } else if (prefix.TYPE() != null) {
            mclass = ModelicaFactory.eINSTANCE.createMType();
        }
        if (mclass != null) {
            ModelicaUtil.setName(mclass, name);
            log.info("Adding class " + name);
            this.scope.setMNamedElement(mclass);
            if (specifier.name_path() != null) {
                this.scopelist.put(specifier, this.scope);
                this.resolutionlist.put(specifier, specifier.name_path().IDENT());
            }
        } else {
            log.warn("Class type unsupported: " + name);
        }
    }

    @Override
    public void exitClass_definition(ModelicaParser.Class_definitionContext ctx) {
        super.exitClass_definition(ctx);
        this.scope = this.scope.getParent();
    }

    @Override
    public void enterExtends_clause(ModelicaParser.Extends_clauseContext ctx) {
        super.enterExtends_clause(ctx);
        if (!(this.scope.getMNamedElement() instanceof MClass)) {
            log.debug("Extend clause skipped as the class is not translated: " + this.scope);
            return;
        }
        this.scopelist.put(ctx, this.scope);
        this.resolutionlist.put(ctx, ctx.name_path().IDENT());
    }

    @Override
    public void enterComponent_clause(ModelicaParser.Component_clauseContext ctx) {
        super.enterComponent_clause(ctx);
        boolean flow = ctx.type_prefix().FLOW() != null;
        boolean discrete = ctx.type_prefix().DISCRETE() != null;
        boolean parameter = ctx.type_prefix().PARAMETER() != null;
        boolean constant = ctx.type_prefix().CONSTANT() != null;
        boolean input = ctx.type_prefix().INPUT() != null;
        boolean output = ctx.type_prefix().OUTPUT() != null;
        int[] dims = null;
        if (ctx.array_subscripts() != null) {
            dims = new int[ctx.array_subscripts().subscript().size()];
            for (int i = 0; i < ctx.array_subscripts().subscript().size(); ++i) {
                dims[i] = Util.toInt(ctx.array_subscripts().subscript().get(i).getText(), 0);
            }
        }
        for (ModelicaParser.Component_declarationContext component : ctx.component_list().component_declaration()) {
            String name = component.declaration().IDENT().getText();
            ModelicaScope newscope = new ModelicaScope(name);
            newscope.setParent(this.scope);
            this.scopelist.put(component, newscope);
            if (!(this.scope.getMNamedElement() instanceof MClass)) {
                log.warn("Component skipped because its type is skipped " + newscope);
                continue;
            }
            MComponent mcomponent = ModelicaFactory.eINSTANCE.createMComponent();
            mcomponent.setOwningClass((MClass)this.scope.getMNamedElement());
            ModelicaUtil.setName(mcomponent, name);
            if (this.scope.isPublic()) {
                mcomponent.setAccessControl(MAccessControl.PUBLIC);
            } else {
                mcomponent.setAccessControl(MAccessControl.PROTECTED);
            }
            if (flow) {
                mcomponent.setDataFlow(MDataFlow.FLOW);
            }
            if (input) {
                mcomponent.setDirection(MDirection.INPUT);
            } else if (output) {
                mcomponent.setDirection(MDirection.OUTPUT);
            }
            if (discrete) {
                mcomponent.setVariability(MVariability.DISCRETE);
            } else if (parameter) {
                mcomponent.setVariability(MVariability.PARAMETER);
            } else if (constant) {
                mcomponent.setVariability(MVariability.CONSTANT);
            } else {
                mcomponent.setVariability(MVariability.CONTINUOUS);
            }
            this.resolutionlist.put(component, ctx.type_specifier().name_path().IDENT());
            newscope.setMNamedElement(mcomponent);
            log.info("Adding component " + newscope);
        }
    }

    @Override
    public void enterComponent_clause1(ModelicaParser.Component_clause1Context ctx) {
        super.enterComponent_clause1(ctx);
        boolean flow = ctx.type_prefix().FLOW() != null;
        boolean discrete = ctx.type_prefix().DISCRETE() != null;
        boolean parameter = ctx.type_prefix().PARAMETER() != null;
        boolean constant = ctx.type_prefix().CONSTANT() != null;
        boolean input = ctx.type_prefix().INPUT() != null;
        boolean output = ctx.type_prefix().OUTPUT() != null;
        ModelicaParser.Component_declaration1Context component = ctx.component_declaration1();
        String name = component.declaration().IDENT().getText();
        ModelicaScope newscope = new ModelicaScope(name);
        newscope.setParent(this.scope);
        this.scopelist.put(component, newscope);
        if (!(this.scope.getMNamedElement() instanceof MClass)) {
            log.warn("Component skipped because its type is skipped " + newscope);
            return;
        }
        MComponent mcomponent = ModelicaFactory.eINSTANCE.createMComponent();
        mcomponent.setOwningClass((MClass)this.scope.getMNamedElement());
        ModelicaUtil.setName(mcomponent, name);
        if (this.scope.isPublic()) {
            mcomponent.setAccessControl(MAccessControl.PUBLIC);
        } else {
            mcomponent.setAccessControl(MAccessControl.PROTECTED);
        }
        if (flow) {
            mcomponent.setDataFlow(MDataFlow.FLOW);
        }
        if (input) {
            mcomponent.setDirection(MDirection.INPUT);
        } else if (output) {
            mcomponent.setDirection(MDirection.OUTPUT);
        }
        if (discrete) {
            mcomponent.setVariability(MVariability.DISCRETE);
        } else if (parameter) {
            mcomponent.setVariability(MVariability.PARAMETER);
        } else if (constant) {
            mcomponent.setVariability(MVariability.CONSTANT);
        } else {
            mcomponent.setVariability(MVariability.CONTINUOUS);
        }
        this.resolutionlist.put(component, ctx.type_specifier().name_path().IDENT());
        newscope.setMNamedElement(mcomponent);
        log.info("Adding redeclared component " + newscope);
    }

    @Override
    public void exitComponent_declaration(ModelicaParser.Component_declarationContext ctx) {
        super.exitComponent_declaration(ctx);
    }

    @Override
    public void exitEquation_section(ModelicaParser.Equation_sectionContext ctx) {
        super.exitEquation_section(ctx);
        if (!(this.scope.getMNamedElement() instanceof MClass)) {
            log.info("Skipping equation in scope " + this.scope.getName());
            return;
        }
        for (ModelicaParser.EquationContext ec : ctx.equation()) {
            if (ec.connect_clause() != null) continue;
            log.info("Added equation " + ec.getText());
            MEquation mequation = ModelicaFactory.eINSTANCE.createMEquation();
            mequation.setExpression(ec.getText());
            ((MClass)this.scope.getMNamedElement()).getEquations().add(mequation);
            this.expressions.put(mequation, ec);
        }
    }

    @Override
    public void exitAlgorithm_section(ModelicaParser.Algorithm_sectionContext ctx) {
        super.exitAlgorithm_section(ctx);
        if (!(this.scope.getMNamedElement() instanceof MClass)) {
            return;
        }
        MAlgorithm ma = ModelicaFactory.eINSTANCE.createMAlgorithm();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.statement().size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(ctx.statement(i).getText());
            sb.append(';');
        }
        ma.setExpression(sb.toString());
        this.expressions.put(ma, ctx);
        ((MClass)this.scope.getMNamedElement()).getAlgorithms().add(ma);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        super.visitTerminal(node);
        if (this.scope != null) {
            if (node.getSymbol().getType() == 50) {
                this.scope.setPublic(true);
            } else if (node.getSymbol().getType() == 49) {
                this.scope.setPublic(false);
            }
        }
    }

    public void resolve() {
        for (Map.Entry<ParseTree, List<TerminalNode>> entry : this.resolutionlist.entrySet()) {
            MExtension mextension;
            MComponent mcomponent2;
            ModelicaParser.Element_modificationContext emc;
            String name;
            ModelicaParser.ModificationContext mc;
            ParserRuleContext cdc;
            MClass mclass;
            ModelicaScope ms;
            MComponent mcomponent;
            ParseTree pt = entry.getKey();
            ModelicaScope scope = this.scopelist.get(pt);
            if (scope == null) {
                throw new IllegalStateException("A scope should have been provided in the resolution of " + pt);
            }
            if (pt instanceof ModelicaParser.Component_declarationContext) {
                if (!(scope.getMNamedElement() instanceof MComponent)) continue;
                mcomponent = (MComponent)scope.getMNamedElement();
                ms = scope.lookForClass(entry.getValue());
                if (ms != null) {
                    mclass = (MClass)ms.getMNamedElement();
                    log.info("Type of component " + mcomponent.getName() + " resolved to " + mclass.getName());
                    mcomponent.setType(mclass);
                    continue;
                }
                log.warn("Type of component " + mcomponent.getName() + " couldn't be resolved");
                mclass = this.createClassAnyway(entry.getValue());
                mcomponent.setType(mclass);
                cdc = (ModelicaParser.Component_declarationContext)pt;
                mc = ((ModelicaParser.Component_declarationContext)cdc).declaration().modification();
                if (mc == null || mc.class_modification() == null) continue;
                for (ModelicaParser.ArgumentContext ac : mc.class_modification().argument_list().argument()) {
                    if (ac.element_modification_or_replaceable().element_modification() == null || mclass.getComponentByName(name = (emc = ac.element_modification_or_replaceable().element_modification()).component_reference().IDENT(0).getText()) != null) continue;
                    mcomponent2 = ModelicaFactory.eINSTANCE.createMComponent();
                    mcomponent2.setOwningClass(mclass);
                    ModelicaUtil.setName(mcomponent2, name);
                }
                continue;
            }
            if (pt instanceof ModelicaParser.Component_declaration1Context) {
                if (!(scope.getMNamedElement() instanceof MComponent)) continue;
                mcomponent = (MComponent)scope.getMNamedElement();
                ms = scope.lookForClass(entry.getValue());
                if (ms != null) {
                    mclass = (MClass)ms.getMNamedElement();
                    log.info("Type of redeclared component " + mcomponent.getName() + " resolved to " + mclass.getName());
                    mcomponent.setType(mclass);
                    continue;
                }
                log.warn("Type of redeclared component " + mcomponent.getName() + " couldn't be resolved");
                mclass = this.createClassAnyway(entry.getValue());
                mcomponent.setType(mclass);
                cdc = (ModelicaParser.Component_declaration1Context)pt;
                mc = ((ModelicaParser.Component_declaration1Context)cdc).declaration().modification();
                if (mc == null || mc.class_modification() == null) continue;
                for (ModelicaParser.ArgumentContext ac : mc.class_modification().argument_list().argument()) {
                    if (ac.element_modification_or_replaceable().element_modification() == null || mclass.getComponentByName(name = (emc = ac.element_modification_or_replaceable().element_modification()).component_reference().IDENT(0).getText()) != null) continue;
                    mcomponent2 = ModelicaFactory.eINSTANCE.createMComponent();
                    mcomponent2.setOwningClass(mclass);
                    ModelicaUtil.setName(mcomponent2, name);
                }
                continue;
            }
            if (pt instanceof ModelicaParser.Extends_clauseContext) {
                MExtension mextension2;
                if (!(scope.getMNamedElement() instanceof MClass)) continue;
                ModelicaScope ms2 = scope.lookForClass(entry.getValue());
                scope.getSiblings().add(ms2);
                MClass mclass2 = (MClass)ms2.getMNamedElement();
                if (mclass2 != null) {
                    mextension2 = ModelicaFactory.eINSTANCE.createMExtension();
                    ((MClass)scope.getMNamedElement()).getExtensions().add(mextension2);
                    mextension2.setExtendedClass(mclass2);
                    log.info("Base class of " + ((MClass)scope.getMNamedElement()).getName() + " resolved to " + mclass2.getName());
                    ModelicaScope sc = new ModelicaScope(null);
                    sc.setMNamedElement(mclass2);
                    this.scopelist.put(pt, sc);
                    continue;
                }
                mextension2 = ModelicaFactory.eINSTANCE.createMExtension();
                ((MClass)scope.getMNamedElement()).getExtensions().add(mextension2);
                mextension2.setExtendedClass(this.createClassAnyway(entry.getValue()));
                log.warn("Based class " + entry.getValue() + " couldn't be resolved");
                continue;
            }
            if (!(pt instanceof ModelicaParser.Class_specifierContext) || !(scope.getMNamedElement() instanceof MClass)) continue;
            MClass mclass3 = (MClass)scope.lookForClass(entry.getValue()).getMNamedElement();
            ModelicaParser.Class_specifierContext csc = (ModelicaParser.Class_specifierContext)pt;
            MDirection direction = MDirection.NONE;
            if (csc.base_prefix().type_prefix().INPUT() != null) {
                direction = MDirection.INPUT;
            } else if (csc.base_prefix().type_prefix().OUTPUT() != null) {
                direction = MDirection.OUTPUT;
            }
            if (mclass3 != null) {
                mextension = ModelicaFactory.eINSTANCE.createMExtension();
                ((MClass)scope.getMNamedElement()).getExtensions().add(mextension);
                mextension.setExtendedClass(mclass3);
                mextension.setDirection(direction);
                log.info("Base class of " + ((MClass)scope.getMNamedElement()).getName() + " resolved to " + mclass3.getName());
                continue;
            }
            mextension = ModelicaFactory.eINSTANCE.createMExtension();
            ((MClass)scope.getMNamedElement()).getExtensions().add(mextension);
            mextension.setExtendedClass(this.createClassAnyway(entry.getValue()));
            mextension.setDirection(direction);
            log.warn("Based class " + entry.getValue() + " couldn't be resolved");
        }
    }

    private MClass createClassAnyway(List<TerminalNode> path) {
        String name = ModelicaReaderPass1.join(path);
        MClass mc = ModelicaFactory.eINSTANCE.createMClass();
        mc.setName(name);
        ModelicaScope ms = new ModelicaScope(name);
        ms.setParent(this.globalscope);
        ms.setMNamedElement(mc);
        log.info("Creating unresolved class " + name);
        return mc;
    }

    private static String join(List<TerminalNode> path) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i != 0) {
                name.append(".");
            }
            name.append(path.get(i).getText());
        }
        return name.toString();
    }
}

