/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.locators.ProviderIterableAdapter;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractBeans<K extends Annotation, V> {
    @Inject
    private BeanLocator locator;
    private final Key<?> key;
    private final boolean isProvider;

    AbstractBeans(Key<V> key) {
        TypeLiteral<V> type = key.getTypeLiteral();
        Class<V> clazz = type.getRawType();
        this.isProvider = Provider.class == clazz || com.google.inject.Provider.class == clazz;
        this.key = this.isProvider ? key.ofType(TypeParameters.get(type, 0)) : key;
    }

    protected final Iterable<Map.Entry<K, V>> beans() {
        ProviderIterableAdapter beans = this.locator.locate(this.key);
        return this.isProvider ? new ProviderIterableAdapter(beans) : beans;
    }
}

