/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import com.engisis.xmiutil.UMLModelErrorException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;

public class UMLUtil {
    private static final Logger log = Logger.getLogger(UMLUtil.class);
    private static final URI locationTypes = URI.createURI("http://www.omg.org/spec/UML/20161101/PrimitiveTypes.xmi#");
    private ResourceSet rs;
    private DataType ustring;
    private DataType uboolean;
    private DataType uinteger;
    private DataType udouble;

    public UMLUtil(ResourceSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException("You must provide a ResourceSet");
        }
        this.rs = rs;
        this.loadUML();
    }

    protected void loadUML() {
        this.ustring = this.loadDataType(locationTypes, "String");
        this.uboolean = this.loadDataType(locationTypes, "Boolean");
        this.uinteger = this.loadDataType(locationTypes, "Integer");
        this.udouble = this.loadDataType(locationTypes, "Real");
    }

    protected DataType loadDataType(URI location, String id) {
        Element element = UMLUtil.loadFromLocationAndID(this.rs, location, id);
        if (!(element instanceof DataType)) {
            throw new ClassCastException("The element identified by " + id + " at " + location + " is not a data type");
        }
        return (DataType)element;
    }

    protected static Element loadFromLocationAndID(ResourceSet rs, URI location, String id) {
        if (location == null) {
            throw new NullPointerException("You must provide a location");
        }
        if (id == null) {
            throw new NullPointerException("You must provide an id");
        }
        return (Element)rs.getEObject(location.appendFragment(id), true);
    }

    protected NamedElement loadFromNamespaceAndName(URI namespace, String name) throws UMLModelErrorException {
        if (namespace == null) {
            throw new IllegalArgumentException("You must provide a namespace");
        }
        if (name == null) {
            throw new IllegalArgumentException("You must provide a name");
        }
        Resource resource = this.rs.getResource(namespace, true);
        TreeIterator<EObject> treeiterator = resource.getAllContents();
        while (treeiterator.hasNext()) {
            EObject currenteobject = (EObject)treeiterator.next();
            if (!(currenteobject instanceof Namespace)) {
                treeiterator.prune();
                continue;
            }
            Namespace namedelement = (Namespace)currenteobject;
            if (!name.equals(namedelement.getName())) continue;
            return namedelement;
        }
        throw new UMLModelErrorException(resource, "Can't retrieve an element named " + name + " in " + namespace);
    }

    public DataType getUMLString() {
        return this.ustring;
    }

    public DataType getUMLBoolean() {
        return this.uboolean;
    }

    public DataType getUMLInteger() {
        return this.uinteger;
    }

    public DataType getUMLDouble() {
        return this.udouble;
    }

    public Set<Classifier> getGenerals(Classifier uclassifier, boolean recursive, boolean self) {
        LinkedHashSet<Classifier> ret = new LinkedHashSet<Classifier>();
        for (Generalization ugeneralization : uclassifier.getGeneralizations()) {
            if (ugeneralization.getSpecific() != uclassifier) continue;
            Classifier ugeneral = ugeneralization.getGeneral();
            if (recursive) {
                ret.addAll(this.getGenerals(ugeneral, true, false));
            }
            ret.add(ugeneral);
        }
        if (self) {
            ret.add(uclassifier);
        }
        return ret;
    }

    public Set<Classifier> getNestedClasses(Class uclass, boolean recursive, boolean self) {
        LinkedHashSet<Classifier> ret = new LinkedHashSet<Classifier>();
        for (Classifier unestedclassifier : uclass.getNestedClassifiers()) {
            ret.add(unestedclassifier);
            if (!recursive || !(unestedclassifier instanceof Class)) continue;
            ret.addAll(this.getNestedClasses((Class)unestedclassifier, true, false));
        }
        if (self) {
            ret.add(uclass);
        }
        return ret;
    }

    public Feature correctFeature(Feature ufeature, Classifier context) {
        if (ufeature == null) {
            return null;
        }
        Feature ret = ufeature;
        Set<Feature> ufeatures = this.getAllFeatures(context);
        boolean cont = true;
        block0: while (cont) {
            cont = false;
            for (Feature ufeature2 : ufeatures) {
                if (!ufeature2.getRedefinedElements().contains(ret)) continue;
                ret = ufeature2;
                cont = true;
                continue block0;
            }
        }
        return ret;
    }

    public Property correctProperty(Property uproperty, Classifier context) {
        if (uproperty == null) {
            return null;
        }
        Property ret = uproperty;
        Set<Property> uproperties = this.getAllAttributes(context);
        boolean cont = true;
        block0: while (cont) {
            cont = false;
            for (Property uprop : uproperties) {
                if (!uprop.getRedefinedProperties().contains(ret)) continue;
                ret = uprop;
                cont = true;
                continue block0;
            }
        }
        return ret;
    }

    public Connector correctConnector(Connector uconnector, Class context) {
        if (uconnector == null) {
            return null;
        }
        Connector ret = uconnector;
        Set<Connector> uconnectors = this.getAllConnectors(context);
        boolean cont = true;
        block0: while (cont) {
            cont = false;
            for (Connector uconn : uconnectors) {
                if (!uconn.getRedefinedConnectors().contains(ret)) continue;
                ret = uconn;
                cont = true;
                continue block0;
            }
        }
        return ret;
    }

    public Set<Constraint> getOwnedRules(Namespace unamespace) {
        return new LinkedHashSet<Constraint>(unamespace.getOwnedRules());
    }

    public Set<Constraint> getAllRules(Classifier uclassifier) {
        LinkedHashSet<Constraint> ret = new LinkedHashSet<Constraint>();
        for (Classifier ugeneral : this.getGenerals(uclassifier, true, true)) {
            ret.addAll(this.getOwnedRules(ugeneral));
        }
        return ret;
    }

    public Set<Feature> getOwnedFeatures(Classifier uclassifier) {
        LinkedHashSet<Feature> ret = new LinkedHashSet<Feature>(uclassifier.getFeatures());
        return ret;
    }

    public Set<Feature> getAllFeatures(Classifier uclassifier) {
        LinkedHashSet<Feature> ret = new LinkedHashSet<Feature>();
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            ret.addAll(this.getAllFeatures(ugeneral));
        }
        ret.addAll(this.getOwnedFeatures(uclassifier));
        return ret;
    }

    public Set<Feature> getAllCorrectedFeatures(Classifier uclassifier) {
        LinkedHashSet<Feature> ret = new LinkedHashSet<Feature>(this.getAllFeatures(uclassifier));
        LinkedHashSet<RedefinableElement> rem = new LinkedHashSet<RedefinableElement>();
        for (Feature f : ret) {
            rem.addAll(f.getRedefinedElements());
        }
        ret.removeAll(rem);
        return ret;
    }

    public Set<Connector> getOwnedConnectors(Class uclass) {
        LinkedHashSet<Connector> ret = new LinkedHashSet<Connector>();
        ret.addAll(uclass.getOwnedConnectors());
        return ret;
    }

    public Set<Connector> getAllConnectors(Class uclass) {
        LinkedHashSet<Connector> ret = new LinkedHashSet<Connector>();
        for (Classifier ugeneral : this.getGenerals(uclass, true, true)) {
            if (!(ugeneral instanceof Class)) continue;
            ret.addAll(((Class)ugeneral).getOwnedConnectors());
        }
        return ret;
    }

    public Set<Connector> getAllCorrectedConnectors(Class uclass) {
        LinkedHashSet<Connector> ret = new LinkedHashSet<Connector>(this.getAllConnectors(uclass));
        LinkedHashSet<Connector> rem = new LinkedHashSet<Connector>();
        for (Connector c : ret) {
            rem.addAll(c.getRedefinedConnectors());
        }
        ret.removeAll(rem);
        return ret;
    }

    public Set<Property> getOwnedAttributes(Classifier uclassifier) {
        if (uclassifier instanceof Class) {
            return new LinkedHashSet<Property>(((Class)uclassifier).getOwnedAttributes());
        }
        if (uclassifier instanceof Interface) {
            return new LinkedHashSet<Property>(((Interface)uclassifier).getOwnedAttributes());
        }
        if (uclassifier instanceof DataType) {
            return new LinkedHashSet<Property>(((DataType)uclassifier).getOwnedAttributes());
        }
        return new LinkedHashSet<Property>();
    }

    public Set<Property> getAllAttributes(Classifier uclassifier) {
        LinkedHashSet<Property> ret = new LinkedHashSet<Property>();
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            ret.addAll(this.getAllAttributes(ugeneral));
        }
        ret.addAll(this.getOwnedAttributes(uclassifier));
        return ret;
    }

    public Set<Property> getAllCorrectedAttributes(Classifier uclassifier) {
        LinkedHashSet<Property> ret = new LinkedHashSet<Property>(this.getAllAttributes(uclassifier));
        LinkedHashSet<Property> rem = new LinkedHashSet<Property>();
        for (Property p : ret) {
            rem.addAll(p.getRedefinedProperties());
        }
        ret.removeAll(rem);
        return ret;
    }

    public Set<Operation> getOwnedOperations(Classifier uclassifier) {
        if (uclassifier instanceof Class) {
            return new LinkedHashSet<Operation>(((Class)uclassifier).getOwnedOperations());
        }
        if (uclassifier instanceof Interface) {
            return new LinkedHashSet<Operation>(((Interface)uclassifier).getOwnedOperations());
        }
        if (uclassifier instanceof DataType) {
            return new LinkedHashSet<Operation>(((DataType)uclassifier).getOwnedOperations());
        }
        return new LinkedHashSet<Operation>();
    }

    public Set<Operation> getAllOperations(Classifier uclassifier) {
        LinkedHashSet<Operation> ret = new LinkedHashSet<Operation>();
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            ret.addAll(this.getAllOperations(ugeneral));
        }
        ret.addAll(this.getOwnedOperations(uclassifier));
        return ret;
    }

    public Set<Operation> getAllCorrectedOperations(Classifier uclassifier) {
        LinkedHashSet<Operation> ret = new LinkedHashSet<Operation>(this.getAllOperations(uclassifier));
        LinkedHashSet<Operation> rem = new LinkedHashSet<Operation>();
        for (Operation o : ret) {
            rem.addAll(o.getRedefinedOperations());
        }
        ret.removeAll(rem);
        return ret;
    }

    public Behavior getClassifierBehavior(Class uclass) {
        Behavior b = uclass.getClassifierBehavior();
        if (b != null) {
            return b;
        }
        for (Classifier c : uclass.getGenerals()) {
            if (!(c instanceof Class) || (b = this.getClassifierBehavior((Class)c)) == null) continue;
            return b;
        }
        return null;
    }

    public List<Region> getAllCorrectedRegions(StateMachine ustatemachine) {
        LinkedList<Region> ret = new LinkedList<Region>();
        for (Classifier c : ustatemachine.getGenerals()) {
            if (!(c instanceof StateMachine)) continue;
            ret.addAll(this.getAllCorrectedRegions((StateMachine)c));
        }
        for (Region r : ustatemachine.getRegions()) {
            ret.removeAll(r.getRedefinedElements());
        }
        ret.addAll(ustatemachine.getRegions());
        return ret;
    }

    public String getName(NamedElement ... nes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < nes.length; ++i) {
            if (i != 0) {
                ret.append("_");
            }
            NamedElement ne = nes[i];
            ret.append(this.getFilteredName(ne, null));
        }
        return ret.toString();
    }

    public String getFilteredName(NamedElement ne, String qualifiedseparator) {
        String n;
        StringBuilder ret = new StringBuilder();
        if (qualifiedseparator != null && ne.getOwner() instanceof NamedElement) {
            ret.append(this.getFilteredName((NamedElement)ne.getOwner(), qualifiedseparator) + qualifiedseparator);
        }
        if ((n = ne.getName()) != null) {
            for (int n2 : n.toCharArray()) {
                if (n2 == 8304) {
                    n2 = 48;
                } else if (n2 == 185) {
                    n2 = 49;
                } else if (n2 == 178) {
                    n2 = 50;
                } else if (n2 == 179) {
                    n2 = 51;
                } else if (n2 == 8308) {
                    n2 = 52;
                } else if (n2 == 8309) {
                    n2 = 53;
                } else if (n2 == 8310) {
                    n2 = 54;
                } else if (n2 == 8311) {
                    n2 = 55;
                } else if (n2 == 8312) {
                    n2 = 56;
                } else if (n2 == 8313) {
                    n2 = 57;
                } else if (n2 == 8314) {
                    n2 = 43;
                } else if (n2 == 8315) {
                    n2 = 45;
                }
                if (n2 != 95 && !Character.isLetter((char)n2) && (!Character.isDigit((char)n2) || ret.length() == 0)) continue;
                ret.append((char)n2);
            }
        }
        if (ret.length() == 0) {
            if (ne.getOwner() instanceof NamedElement) {
                ret.append(this.getName((NamedElement)ne.getOwner()));
            }
            ret.append("_");
            ret.append(ne.eClass().getName().toLowerCase());
            if (ne.getOwner() != null) {
                ret.append(ne.getOwner().getOwnedElements().indexOf(ne));
            }
            if (ne instanceof Connector) {
                Object object = ((Connector)ne).getEnds().iterator();
                while (object.hasNext()) {
                    ConnectorEnd ce = (ConnectorEnd)object.next();
                    if (ce.getDefiningEnd() != null) {
                        ret.append("_" + ce.getDefiningEnd().getName());
                        continue;
                    }
                    ret.append("_" + ((Connector)ne).getEnds().indexOf(ce));
                }
            }
        }
        return ret.toString();
    }

    public String getQualifiedName(String separator, NamedElement ... nes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < nes.length; ++i) {
            NamedElement ne;
            String n;
            if (i != 0) {
                ret.append("_");
            }
            if ((n = (ne = nes[i]).getName()) != null) {
                for (char c : n.toCharArray()) {
                    if (c != '_' && !Character.isLetter(c) && (!Character.isDigit(c) || ret.length() == 0)) continue;
                    ret.append(c);
                }
            }
            if (ret.length() != 0) continue;
            ret.append(this.getName((NamedElement)ne.getOwner()));
            ret.append("_");
            ret.append(ne.eClass().getName().toLowerCase());
            if (ne.getNamespace() == null) continue;
            ret.append(ne.getNamespace().getOwnedMembers().indexOf(ne));
        }
        return ret.toString();
    }

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    public static Resource createUMLModel(ResourceSet rs, URI file, List<URI> paths) {
        log.info("Creating " + file);
        Resource r = UMLResourceFactoryImpl.INSTANCE.createResource(file);
        rs.getResources().add(r);
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName("Data");
        r.getContents().add(model);
        return r;
    }
}

