/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import com.engisis.xmiutil.EMFConfiguration;
import com.engisis.xmiutil.Util;
import com.engisis.xmiutil.XMIPostWriter;
import com.engisis.xmiutil.XMIPreReader;
import com.engisis.xmiutil.XMIReferenceFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public class EMFUtil {
    private static final Logger log = Logger.getLogger(EMFUtil.class);

    public static ResourceSet createBasicResourceSet() throws FileNotFoundException {
        String[] umluris;
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put("RECORD_ANY_TYPE_NAMESPACE_DECLARATIONS", Boolean.TRUE);
        rs.getLoadOptions().put("DEFER_IDREF_RESOLUTION", false);
        EPackage.Registry registry = rs.getPackageRegistry();
        registry.put("http://www.eclipse.org/uml2/5.0.0/UML", UMLPackage.eINSTANCE);
        Map<URI, URI> urimap = rs.getURIConverter().getURIMap();
        Class<UMLResourcesUtil> umlre = UMLResourcesUtil.class;
        String url = umlre.getResource("/" + umlre.getName().replace('.', '/') + ".class").toExternalForm();
        if (url.indexOf("!/") == -1) {
            throw new FileNotFoundException("The UML2 resource library must be in a JAR: " + url);
        }
        URI umljar = URI.createURI(url.substring(0, url.lastIndexOf(33) + 2));
        UMLPlugin.getEPackageNsURIToProfileLocationMap().put("http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard", umljar.appendSegment("profiles").appendSegment("Standard.profile.uml").appendFragment("_0"));
        urimap.put(URI.createURI("pathmap://UML_METAMODELS/UML.metamodel.uml"), umljar.appendSegment("metamodels").appendSegment("UML.metamodel.uml"));
        urimap.put(URI.createURI("pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), umljar.appendSegment("libraries").appendSegment("UMLPrimitiveTypes.library.uml"));
        for (String umluri : umluris = new String[]{"http://www.omg.org/spec/UML/20110701", "http://www.omg.org/spec/UML/20131001", "http://www.omg.org/spec/UML/20161101"}) {
            registry.put(umluri, UMLPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put(umluri, UMLPackage.eINSTANCE);
            registry.put(umluri + "/StandardProfile", StandardPackage.eINSTANCE);
            UMLPlugin.getEPackageNsURIToProfileLocationMap().put(umluri + "/StandardProfile", umljar.appendSegment("profiles").appendSegment("Standard.profile.uml").appendFragment("_0"));
            urimap.put(URI.createURI(umluri + "/UML.xmi"), umljar.appendSegment("metamodels").appendSegment("UML.metamodel.uml"));
            urimap.put(URI.createURI(umluri + "/PrimitiveTypes.xmi"), umljar.appendSegment("libraries").appendSegment("UMLPrimitiveTypes.library.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfile.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfileL2.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
            urimap.put(URI.createURI(umluri + "/StandardProfileL3.xmi"), umljar.appendSegment("profiles").appendSegment("Standard.profile.uml"));
        }
        Map<String, Object> extension2factory = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extension2factory.put("uml", UMLResource.Factory.INSTANCE);
        extension2factory.put("xmi", UMLResource.Factory.INSTANCE);
        extension2factory.put("xml", UMLResource.Factory.INSTANCE);
        urimap.put(URI.createURI("pathmap://UML_LIBRARIES/"), umljar.appendSegment("libraries").appendSegment(""));
        urimap.put(URI.createURI("pathmap://UML_METAMODELS/"), umljar.appendSegment("metamodels").appendSegment(""));
        urimap.put(URI.createURI("pathmap://UML_PROFILES/"), umljar.appendSegment("profiles").appendSegment(""));
        return rs;
    }

    public static ResourceSet createResourceSet() throws FileNotFoundException {
        ResourceSet rs = EMFUtil.createBasicResourceSet();
        Map<URI, URI> urimap = rs.getURIConverter().getURIMap();
        for (Map.Entry<URI, URI> localmapentry : EMFConfiguration.getLocationMappings().entrySet()) {
            urimap.put(localmapentry.getKey(), localmapentry.getValue());
        }
        return rs;
    }

    public static Resource loadResourceWithDependencies(ResourceSet rs, URI modeluri, List<URI> paths) {
        Resource resource = null;
        Stack<URI> toprepare = new Stack<URI>();
        toprepare.push(modeluri);
        Hashtable<URI, HashSet<URI>> deps = new Hashtable<URI, HashSet<URI>>();
        while (toprepare.size() != 0) {
            URI input = (URI)toprepare.pop();
            log.info("Analyzing " + input);
            try {
                InputStream is = rs.getURIConverter().createInputStream(input);
                Object object = null;
                try {
                    XMIReferenceFinder xmir = new XMIReferenceFinder(is, EMFConfiguration.getReaderIDMappings(), EMFConfiguration.getLocationMappings(), modeluri, paths);
                    xmir.run();
                    is.close();
                    for (URI uriref : xmir.getReferences()) {
                        log.debug("Found reference " + uriref);
                    }
                    deps.put(input, xmir.getReferences());
                    for (URI ref : xmir.getReferences()) {
                        log.debug("Dependency between " + input.lastSegment() + " and " + ref.lastSegment());
                        if (deps.containsKey(ref)) continue;
                        toprepare.push(ref);
                    }
                }
                catch (Throwable xmir) {
                    object = xmir;
                    throw xmir;
                }
                finally {
                    if (is == null) continue;
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable xmir) {
                            ((Throwable)object).addSuppressed(xmir);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Couldn't parse the XMI for dependencies", e);
            }
            catch (XMLStreamException e) {
                log.error("Couldn't parse the XMI for dependencies", e);
            }
            catch (FactoryConfigurationError e) {
                log.error("Couldn't parse the XMI for dependencies", e);
            }
        }
        ArrayList<URI> toload = new ArrayList<URI>();
        while (toload.size() != deps.keySet().size()) {
            boolean action = false;
            block17: for (URI uri : deps.keySet()) {
                if (toload.contains(uri)) continue;
                for (URI ref : (HashSet)deps.get(uri)) {
                    if (toload.contains(ref) || ref.equals(uri)) continue;
                    continue block17;
                }
                log.debug("Added " + uri.lastSegment() + " to load list");
                toload.add(uri);
                action = true;
            }
            if (action) continue;
            log.error("Dependency resolution problem");
            break;
        }
        for (int i = 0; i < toload.size(); ++i) {
            resource = EMFUtil.loadResource(rs, (URI)toload.get(i), paths);
        }
        EcoreUtil.resolveAll(rs);
        return resource;
    }

    public static Resource loadResource(ResourceSet rs, URI fileuri, List<URI> paths) {
        log.info("Loading file " + fileuri);
        Resource r = rs.createResource(fileuri);
        try {
            PipedInputStream pis = new PipedInputStream(2048);
            PipedOutputStream pos = new PipedOutputStream(pis);
            InputStream is = rs.getURIConverter().createInputStream(fileuri);
            XMIPreReader xmif = new XMIPreReader(rs, is, pos, fileuri, EMFConfiguration.getReaderIDMappings(), EMFConfiguration.getReaderNSMappings(), paths);
            Thread th = new Thread(xmif);
            th.start();
            try {
                r.load(pis, null);
            }
            catch (Exception e) {
                log.error("Error while loading " + fileuri, e);
            }
            pis.close();
            pos.close();
            is.close();
            log.debug("Resource " + r + " loaded");
            LinkedList<Profile> profiles = new LinkedList<Profile>();
            Hashtable applications = new Hashtable();
            TreeIterator<EObject> allcontent = r.getAllContents();
            while (allcontent.hasNext()) {
                EObject eo = (EObject)allcontent.next();
                if (!(eo instanceof Package)) {
                    allcontent.prune();
                    continue;
                }
                Package p = (Package)eo;
                LinkedList<Profile> linkedList = new LinkedList<Profile>();
                applications.put(p, linkedList);
                for (Profile prof : p.getAppliedProfiles()) {
                    linkedList.add(prof);
                }
                if (!(p instanceof Profile)) continue;
                Profile prof = (Profile)p;
                profiles.add(prof);
            }
            for (Profile prof : profiles) {
                EMFUtil.flatten(prof);
                String string = prof.getURI();
                if (!prof.isDefined()) {
                    EPackage definition = prof.define();
                    log.debug("Definition: " + definition.getName() + "  with " + definition.getNsPrefix() + " :" + definition.getNsURI() + " at " + EcoreUtil.getURI(definition) + "--" + EcoreUtil.getURI(prof));
                    log.debug("Registering " + string + " for " + definition.getNsURI());
                    UMLPlugin.getEPackageNsURIToProfileLocationMap().put(string, EcoreUtil.getURI(definition));
                    rs.getPackageRegistry().put(string, definition);
                    String alt = EMFConfiguration.getReaderNSMappings().get(string);
                    if (alt == null || alt.equals(string)) continue;
                    log.debug("Registering alternative " + alt + " for " + definition.getNsURI());
                    UMLPlugin.getEPackageNsURIToProfileLocationMap().put(alt, EcoreUtil.getURI(definition));
                    rs.getPackageRegistry().put(alt, definition);
                    continue;
                }
                log.debug("Profile " + string + " defined");
            }
            LinkedList<DynamicEObjectImpl> ldeos = new LinkedList<DynamicEObjectImpl>();
            for (EObject eObject : r.getContents()) {
                if (!(eObject instanceof AnyTypeImpl)) continue;
                AnyTypeImpl at = (AnyTypeImpl)eObject;
                String name = at.eClass().getName();
                for (Profile profile : profiles) {
                    for (EClassifier ec : profile.getDefinition().getEClassifiers()) {
                        if (!(ec instanceof EClass) || !ec.getName().equals(name)) continue;
                        DynamicEObjectImpl deo = new DynamicEObjectImpl((EClass)ec);
                        ldeos.add(deo);
                        for (FeatureMap.Entry fm : at.getAnyAttribute()) {
                            String attname = fm.getEStructuralFeature().getName();
                            EStructuralFeature esf = ((EClass)ec).getEStructuralFeature(attname);
                            if (esf != null) {
                                if (esf instanceof EAttribute) {
                                    String etypename = ((EAttribute)esf).getEType().getInstanceClassName();
                                    try {
                                        if (etypename.equals("boolean")) {
                                            deo.eSet(esf, (Object)Util.toBoolean(fm.getValue().toString(), false));
                                            continue;
                                        }
                                        if (etypename.equals("int")) {
                                            deo.eSet(esf, (Object)Util.toInt(fm.getValue().toString(), 0));
                                            continue;
                                        }
                                        if (etypename.equals("double")) {
                                            deo.eSet(esf, (Object)Util.toDouble(fm.getValue().toString(), 0.0));
                                            continue;
                                        }
                                        if (etypename.equals("java.lang.String")) {
                                            deo.eSet(esf, (Object)fm.getValue().toString());
                                            continue;
                                        }
                                        log.warn("Unsupported type: " + etypename);
                                    }
                                    catch (Exception e) {
                                        log.warn("Can't assign value " + fm.getValue() + " to " + esf);
                                    }
                                    continue;
                                }
                                if (esf instanceof EReference) {
                                    deo.eSet(esf, (Object)r.getEObject(fm.getValue().toString()));
                                    continue;
                                }
                            }
                            log.error("Coundn't set value of " + ec + "::" + esf);
                        }
                    }
                }
            }
            r.getContents().addAll(ldeos);
            for (Map.Entry entry : applications.entrySet()) {
                for (Profile prof : (LinkedList)entry.getValue()) {
                    log.info("Applying profile " + prof.getName() + " defined in " + EcoreUtil.getURI(prof) + ": " + prof.getDefinition());
                    ((Package)entry.getKey()).applyProfile(prof);
                }
            }
        }
        catch (IOException e) {
            log.error("Couldn't read the file", e);
        }
        catch (XMLStreamException e) {
            log.error("Error during the XML parsing", e);
        }
        catch (FactoryConfigurationError e) {
            log.error("Error during the StAX configuration", e);
        }
        catch (Exception e) {
            log.error("Reading error", e);
        }
        EcoreUtil.resolveAll(r);
        return r;
    }

    public static void saveResource(Resource r, String target, String outputfile) throws IOException {
        try (PipedOutputStream pos = new PipedOutputStream();
             PipedInputStream pis = new PipedInputStream();){
            pos.connect(pis);
            XMIPostWriter cleaner = new XMIPostWriter(pis, outputfile, EMFConfiguration.getWriterLocationMappings(target), EMFConfiguration.getWriterIDMappings(target), EMFConfiguration.getWriterNSMappings(target), EMFConfiguration.getNamespaceBlacklist(target), EMFConfiguration.getNamespaceWhitelist(target), EMFConfiguration.getElementBlacklist(target), EMFConfiguration.getElementWhitelist(target));
            Thread th = new Thread(cleaner);
            th.start();
            log.info("Starting EMF saving");
            r.save(pos, Collections.EMPTY_MAP);
            log.info("Finished EMF saving");
            log.info("Closing output stream");
            pos.close();
            th.join();
        }
        catch (IOException e) {
            log.error("Can't save " + r.getURI(), e);
        }
        catch (InterruptedException e) {
            log.error("Can't save " + r.getURI(), e);
        }
        log.info("Saved " + r.getURI());
    }

    public static void saveResource(Resource r, String target) throws IOException {
        EMFUtil.saveResource(r, target, r.getURI().toFileString());
    }

    private static void flatten(Profile profile) {
        EMFUtil.move(profile, profile);
    }

    private static void move(Package from, Profile to) {
        int i = 0;
        while (i != from.getPackagedElements().size()) {
            PackageableElement pe = (PackageableElement)from.getPackagedElements().get(i);
            if (pe instanceof Package) {
                EMFUtil.move((Package)pe, to);
                from.getPackagedElements().remove(i);
                continue;
            }
            if (from != to) {
                from.getPackagedElements().remove(i);
                to.getPackagedElements().add(pe);
                continue;
            }
            ++i;
        }
    }

    public static File locateFile(List<URI> paths, String name) {
        for (URI path : paths) {
            File f = new File(path.toFileString(), name);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static NamedElement getNamedElement(Resource r, String fullname) {
        if (fullname == null) {
            return null;
        }
        String[] spl = fullname.split("::");
        Namespace ns = null;
        for (int i = 0; i < spl.length; ++i) {
            String name = spl[i];
            if (ns == null) {
                for (EObject eo : r.getContents()) {
                    if (!(eo instanceof Namespace) || !((Namespace)eo).getName().equals(name)) continue;
                    ns = (Namespace)eo;
                }
            } else {
                for (NamedElement ne : ns.getOwnedMembers()) {
                    if (!name.equals(ne.getName())) continue;
                    if (i == spl.length - 1) {
                        return ne;
                    }
                    if (ne instanceof Namespace) {
                        ns = (Namespace)ne;
                        continue;
                    }
                    log.warn("NamedElement " + name + " in position " + i + " in " + fullname + " is not a namespace");
                }
            }
            if (ns != null) continue;
            log.warn("NamedElement " + name + " in position " + i + " not found in " + fullname);
            return null;
        }
        return null;
    }
}

