/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

public class DebugUtil {
    static final Logger log = Logger.getLogger(DebugUtil.class);

    public static void checkResource(Resource r) {
        TreeIterator<EObject> allcontent = r.getAllContents();
        log.debug("Checking " + r.getURI());
        while (allcontent.hasNext()) {
            EObject eo = (EObject)allcontent.next();
            if (eo instanceof PackageImport) {
                PackageImport pi = (PackageImport)eo;
                log.debug("imported: " + pi.getImportedPackage().getQualifiedName() + "- uri: " + pi.getImportedPackage().getURI() + "- proxy: " + pi.getImportedPackage().eIsProxy() + "- content: " + pi.getImportedPackage().eContents().size());
                continue;
            }
            if (!(eo instanceof ProfileApplication)) continue;
            ProfileApplication pa = (ProfileApplication)eo;
            Profile prof = pa.getAppliedProfile();
            EPackage definition = pa.getAppliedDefinition();
            if (definition == null) {
                log.debug("Can't retrieve the definition for " + prof + ", size: " + prof.getPackagedElements().size());
                EAnnotation ea = pa.createEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
                ea.getReferences().add((EPackage)r.getResourceSet().getPackageRegistry().get(prof.getURI()));
                log.debug(pa.getAppliedDefinition());
                continue;
            }
            log.debug("applied: " + pa.getAppliedProfile().getQualifiedName() + "- prefix: " + definition.getNsPrefix() + "- uri: " + definition.getNsURI() + "- proxy: " + definition.eIsProxy() + "- info: " + definition + "- content: " + definition.eContents().size());
        }
    }

    public static void printLoadedResources(ResourceSet rs) {
        EList<Resource> resources = rs.getResources();
        log.debug(resources.size() + " resources loaded:");
        for (Resource r : resources) {
            log.debug(" " + r.getURI() + "-" + r.isLoaded() + "-" + r.getContents().size() + " elements");
        }
    }

    public static void printAppliedStereotypes(NamedElement ne) {
        StringBuilder sb = new StringBuilder();
        sb.append("Applied to " + ne + ":");
        for (EObject eObject : ne.getAppliedStereotypes()) {
            sb.append(" " + eObject);
        }
        sb.append("\n");
        log.info(sb);
    }

    public static void printStereotypes(Resource r2) {
        TreeIterator<EObject> allcontent2 = r2.getAllContents();
        while (allcontent2.hasNext()) {
            EObject eo = (EObject)allcontent2.next();
            if (!(eo instanceof Stereotype)) continue;
            Stereotype st = (Stereotype)eo;
            log.debug("Stereotype found: " + st.getQualifiedName());
        }
    }

    public static void printStereotypedElements(Resource r) {
        log.debug("Stereotyped elements:");
        TreeIterator<EObject> allcontent = r.getAllContents();
        while (allcontent.hasNext()) {
            Element el;
            EObject eo = (EObject)allcontent.next();
            if (!(eo instanceof Element) || (el = (Element)eo).getAppliedStereotypes().isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(el + " has: ");
            for (Stereotype st : el.getAppliedStereotypes()) {
                sb.append(" " + st.getName() + "-" + el.getStereotypeApplication(st));
            }
            log.debug(sb);
        }
    }
}

