/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SInput;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SOutput;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDWorkAssignment;
import com.engisis.sysphs.language.simulink.SFDWorkVariable;
import com.engisis.sysphs.language.simulink.SFDerivativeAssignment;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputAssignment;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFUpdateAssignment;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFVariableAssignment;
import com.engisis.sysphs.language.simulink.SFunction;
import com.engisis.sysphs.language.simulink.SFunction1;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.util.ExpressionLanguageParser;
import com.engisis.sysphs.util.ExpressionLanguageToSimulation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;

public class ExpressionLanguageToMatlabTranslator
extends ExpressionLanguageToSimulation {
    private static final Logger log = Logger.getLogger(ExpressionLanguageToMatlabTranslator.class);
    private SComponent scomponent;
    private SFunction sfunction;
    private SFVariableAssignment sfassignment;
    private ExpressionLanguageParser.PrimaryContext convertContext;
    private ExpressionLanguageParser.ExpressionContext ec = null;
    private Hashtable<String, String> ht = new Hashtable();
    private Hashtable<String, String> htLHS = new Hashtable();
    private Hashtable<String, String> htRHS = new Hashtable();
    private List<SFInputVariable> lsfiv;
    private List<String> lsp;

    @Override
    protected void beforeParsing() {
        super.beforeParsing();
        this.convertContext = null;
        this.sfassignment = null;
    }

    @Override
    protected void afterParsing() {
        super.afterParsing();
        this.scomponent = null;
        this.ht = null;
        this.sfunction = null;
        this.htLHS = null;
        this.htRHS = null;
        this.lsfiv = null;
        this.lsp = null;
    }

    public void prepareNextEquationParsing(SComponent scomponent, Hashtable<String, String> ht) {
        this.scomponent = scomponent;
        this.ht = ht;
    }

    public void prepareNextEquationParsing(SFunction sfunction, Hashtable<String, String> htLHS, Hashtable<String, String> htRHS, List<SFInputVariable> lsfiv) {
        this.sfunction = sfunction;
        this.htLHS = htLHS;
        this.htRHS = htRHS;
        this.lsfiv = lsfiv;
        this.lsp = new LinkedList<String>();
    }

    public SFVariableAssignment getAssignment() {
        return this.sfassignment;
    }

    @Override
    public void enterEquation(ExpressionLanguageParser.EquationContext ctx) {
        if (ctx.EQUALS() != null) {
            if (this.sfunction instanceof SFunction1) {
                this.htRHS.put("time", "t");
            } else if (this.sfunction instanceof SFunction2) {
                this.htRHS.put("time", "block.CurrentTime");
            }
        }
        super.enterEquation(ctx);
    }

    @Override
    public void exitEquation(ExpressionLanguageParser.EquationContext ctx) {
        if (this.sfunction != null && ctx.EQUALS() != null) {
            SFDWorkVariable sfv;
            EList<Integer> dims;
            String key;
            String val;
            if (this.htLHS != null && (val = this.htLHS.get(key = this.getValue(ctx.simple_expression()))) != null) {
                this.setValue(ctx.simple_expression(), val);
                for (SFVariable sfv2 : this.sfunction.getVariables()) {
                    SFVariableAssignment assignment;
                    if (sfv2 instanceof SFContinuousStateVariable) {
                        if (key.equals("der(" + sfv2.getName() + ")")) {
                            assignment = SimulinkFactory.eINSTANCE.createSFDerivativeAssignment();
                            ((SFDerivativeAssignment)assignment).setVariable((SFContinuousStateVariable)sfv2);
                            this.sfassignment = assignment;
                            continue;
                        }
                        if (!key.equals(sfv2.getName())) continue;
                        assignment = SimulinkFactory.eINSTANCE.createSFDerivativeAssignment();
                        ((SFDerivativeAssignment)assignment).setVariable((SFContinuousStateVariable)sfv2);
                        this.sfassignment = assignment;
                        continue;
                    }
                    if (sfv2 instanceof SFDiscreteStateVariable && key.equals("next(" + sfv2.getName() + ")")) {
                        assignment = SimulinkFactory.eINSTANCE.createSFUpdateAssignment();
                        ((SFUpdateAssignment)assignment).setVariable((SFDiscreteStateVariable)sfv2);
                        this.sfassignment = assignment;
                        continue;
                    }
                    if (sfv2 instanceof SFOutputVariable && key.equals(sfv2.getName())) {
                        assignment = SimulinkFactory.eINSTANCE.createSFOutputAssignment();
                        ((SFOutputAssignment)assignment).setVariable((SFOutputVariable)sfv2);
                        this.sfassignment = assignment;
                        if (this.lsp == null || this.lsfiv == null) continue;
                        for (SFInputVariable sfiv : this.lsfiv) {
                            if (!this.lsp.contains(sfiv.getName())) continue;
                            sfiv.setDirectFeedthrough(true);
                        }
                        continue;
                    }
                    if (!(sfv2 instanceof SFDWorkVariable) || !key.equals(sfv2.getName())) continue;
                    assignment = SimulinkFactory.eINSTANCE.createSFDWorkAssignment();
                    ((SFDWorkAssignment)assignment).setVariable((SFDWorkVariable)sfv2);
                    this.sfassignment = assignment;
                }
            }
            if (this.sfassignment instanceof SFDWorkAssignment && (dims = (sfv = ((SFDWorkAssignment)this.sfassignment).getVariable()).getDimensions()).size() == 2) {
                this.setValue(ctx, this.getValue(ctx.simple_expression()) + "=reshape(" + this.getValue(ctx.expression()) + "," + (Integer)dims.get(0) * (Integer)dims.get(1) + ",[])");
                this.afterParsing();
                return;
            }
            this.setValue(ctx, this.getValue(ctx.simple_expression()) + "=" + this.getValue(ctx.expression()));
            this.afterParsing();
            return;
        }
        super.exitEquation(ctx);
    }

    @Override
    public void enterSimple_expression(ExpressionLanguageParser.Simple_expressionContext ctx) {
        super.enterSimple_expression(ctx);
    }

    @Override
    public void exitSimple_expression(ExpressionLanguageParser.Simple_expressionContext ctx) {
        super.exitSimple_expression(ctx);
    }

    @Override
    public void enterExpression(ExpressionLanguageParser.ExpressionContext ctx) {
        if (ctx.getParent() instanceof ExpressionLanguageParser.EquationContext) {
            this.ec = ctx;
        }
        super.enterExpression(ctx);
    }

    @Override
    public void exitIf_equation(ExpressionLanguageParser.If_equationContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 2) {
                    sb.append("if");
                    continue;
                }
                if (t == 4) {
                    sb.append("elseif");
                    continue;
                }
                if (t == 5) {
                    sb.append("else\n");
                    continue;
                }
                if (t != 6) continue;
                sb.append("end");
                break;
            }
            if (pt instanceof ExpressionLanguageParser.ExpressionContext) {
                sb.append(" " + this.getValue(pt) + "\n");
                continue;
            }
            if (!(pt instanceof ExpressionLanguageParser.EquationContext)) continue;
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitIf_statement(ExpressionLanguageParser.If_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 2) {
                    sb.append("if");
                    continue;
                }
                if (t == 4) {
                    sb.append("elseif");
                    continue;
                }
                if (t == 5) {
                    sb.append("else\n");
                    continue;
                }
                if (t != 6) continue;
                sb.append("end");
                break;
            }
            if (pt instanceof ExpressionLanguageParser.ExpressionContext) {
                sb.append(" " + this.getValue(pt) + "\n");
                continue;
            }
            if (!(pt instanceof ExpressionLanguageParser.StatementContext)) continue;
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_statement(ExpressionLanguageParser.For_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (ExpressionLanguageParser.For_indexContext fic : ctx.for_indices().for_index()) {
            if (fic != ctx.for_indices().for_index(0)) {
                sb.append("\n");
            }
            sb.append("for " + this.getValue(fic) + "\n");
            for (ExpressionLanguageParser.StatementContext sc : ctx.statement()) {
                sb.append(this.getValue(sc) + ";\n");
            }
            sb.append("end");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_indices(ExpressionLanguageParser.For_indicesContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitWhile_statement(ExpressionLanguageParser.While_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("while " + this.getValue(ctx.expression()));
        for (ExpressionLanguageParser.StatementContext sc : ctx.statement()) {
            sb.append(this.getValue(sc) + ";\n");
        }
        sb.append("end");
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitExpression(ExpressionLanguageParser.ExpressionContext ctx) {
        if (ctx.getParent() instanceof ExpressionLanguageParser.EquationContext) {
            this.ec = null;
        }
        StringBuilder sb = new StringBuilder();
        if (ctx.simple_expression() != null) {
            sb.append(this.getValue(ctx.simple_expression()));
        } else {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                ParseTree pt = ctx.getChild(i);
                if (pt instanceof TerminalNode) {
                    int t = ((TerminalNode)pt).getSymbol().getType();
                    if (t == 2) {
                        sb.append("if ");
                        continue;
                    }
                    if (t == 3) {
                        sb.append(" then ");
                        continue;
                    }
                    if (t == 4) {
                        sb.append(" elseif ");
                        continue;
                    }
                    if (t != 5) continue;
                    sb.append(" else ");
                    continue;
                }
                if (!(pt instanceof ExpressionLanguageParser.ExpressionContext)) continue;
                sb.append(this.getValue(pt));
            }
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void enterPrimary(ExpressionLanguageParser.PrimaryContext ctx) {
        String name;
        super.enterPrimary(ctx);
        if (ctx.function_call_args() != null && ctx.name_path() != null && this.scomponent != null && ((name = ctx.name_path().getText()).equals("sin") || name.equals("cos") || name.equals("tan") || name.equals("asin") || name.equals("acos") || name.equals("atan") || name.equals("atan2") || name.equals("sinh") || name.equals("cosh") || name.equals("tanh") || name.equals("log") || name.equals("log10") || name.equals("exp"))) {
            this.convertContext = ctx;
        }
    }

    @Override
    public void exitPrimary(ExpressionLanguageParser.PrimaryContext ctx) {
        super.exitPrimary(ctx);
        if (ctx == this.convertContext) {
            this.convertContext = null;
        }
        String key = this.getValue(ctx);
        if (this.ec != null && this.htRHS != null) {
            String val = this.htRHS.get(key);
            if (val != null) {
                this.setValue(ctx, val);
            }
            if (this.lsp != null) {
                this.lsp.add(key);
            }
        }
    }

    @Override
    public void exitComponent_reference(ExpressionLanguageParser.Component_referenceContext ctx) {
        String rep;
        super.exitComponent_reference(ctx);
        String val = this.getValue(ctx);
        if (this.ht != null && (rep = this.ht.get(val)) != null) {
            val = rep;
            this.setValue(ctx, val);
        }
        if (this.convertContext != null) {
            SComponent sc = this.scomponent;
            SDomain sd = null;
            SMember sm = null;
            String unit = null;
            int size = ctx.IDENT().size();
            if (size == 1 && ctx.IDENT(0).getText().equals("time")) {
                this.setValue(ctx, "(" + val + "/{1,'s'})");
                return;
            }
            for (int i = 0; i < size; ++i) {
                if (sc != null) {
                    sm = sc.getMember(ctx.IDENT(i).getText());
                    if (sm instanceof SNode) {
                        sc = null;
                        sd = ((SNode)sm).getDomain();
                        continue;
                    }
                    if (sm instanceof SComponentReference) {
                        sc = ((SComponentReference)sm).getComponent();
                        sd = null;
                        continue;
                    }
                    if (sm instanceof SParameter) {
                        unit = ((SParameter)sm).getUnit();
                        continue;
                    }
                    if (sm instanceof SVariable) {
                        unit = ((SVariable)sm).getUnit();
                        continue;
                    }
                    if (sm instanceof SInput) {
                        unit = ((SInput)sm).getUnit();
                        continue;
                    }
                    if (!(sm instanceof SOutput)) continue;
                    unit = ((SOutput)sm).getUnit();
                    continue;
                }
                if (sd == null) continue;
                sm = sd.getMember(ctx.IDENT(i).getText());
            }
            if (unit != null) {
                this.setValue(ctx, "(" + val + "/{1,'" + unit + "'})");
            } else {
                log.warn("Member without unit: " + ctx.getText() + " in " + this.scomponent.getName());
            }
        }
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int t = node.getSymbol().getType();
        if (t == 22) {
            this.setValue(node, "==");
        } else if (t == 30) {
            this.setValue(node, "~=");
        } else if (t == 15) {
            this.setValue(node, "~");
        } else if (t == 14) {
            this.setValue(node, "&&");
        } else if (t == 13) {
            this.setValue(node, "||");
        } else if (t == 9) {
            this.setValue(node, "=");
        } else if (t == 23) {
            this.setValue(node, "=");
        } else {
            super.visitTerminal(node);
        }
    }
}

