/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.modelica;

import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MModel;
import com.engisis.sysphs.language.modelica.MNamedElement;
import com.engisis.sysphs.language.modelica.MPrimitiveType;
import com.engisis.sysphs.language.modelica.MType;
import com.engisis.sysphs.language.modelica.ModelicaFactory;
import java.util.ArrayList;
import java.util.List;

public class ModelicaUtil {
    private static MPrimitiveType mstringtype;
    private static MPrimitiveType mbooleantype;
    private static MPrimitiveType mintegertype;
    private static MPrimitiveType mrealtype;
    private static MType mstring;
    private static MType mboolean;
    private static MType minteger;
    private static MType mreal;
    private static MModel minitialstep;
    private static MModel mstep;
    private static MModel mtransition;

    private static MPrimitiveType getStringType() {
        if (mstringtype == null) {
            mstringtype = ModelicaFactory.eINSTANCE.createMPrimitiveType();
            mstringtype.setName("StringType");
        }
        return mstringtype;
    }

    private static MPrimitiveType getBooleanType() {
        if (mbooleantype == null) {
            mbooleantype = ModelicaFactory.eINSTANCE.createMPrimitiveType();
            mbooleantype.setName("BooleanType");
        }
        return mbooleantype;
    }

    private static MPrimitiveType getIntegerType() {
        if (mintegertype == null) {
            mintegertype = ModelicaFactory.eINSTANCE.createMPrimitiveType();
            mintegertype.setName("IntegerType");
        }
        return mintegertype;
    }

    private static MPrimitiveType getRealType() {
        if (mrealtype == null) {
            mrealtype = ModelicaFactory.eINSTANCE.createMPrimitiveType();
            mrealtype.setName("RealType");
        }
        return mrealtype;
    }

    public static MType getReal() {
        if (mreal == null) {
            mreal = ModelicaFactory.eINSTANCE.createMType();
            mreal.setName("Real");
            ModelicaUtil.addComponentToType(mreal, "quantity", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(mreal, "unit", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(mreal, "displayUnit", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(mreal, "start", ModelicaUtil.getRealType());
            ModelicaUtil.addComponentToType(mreal, "fixed", ModelicaUtil.getBooleanType());
        }
        return mreal;
    }

    public static MType getInteger() {
        if (minteger == null) {
            minteger = ModelicaFactory.eINSTANCE.createMType();
            minteger.setName("Integer");
            ModelicaUtil.addComponentToType(minteger, "quantity", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(minteger, "start", ModelicaUtil.getIntegerType());
            ModelicaUtil.addComponentToType(minteger, "fixed", ModelicaUtil.getBooleanType());
        }
        return minteger;
    }

    public static MType getBoolean() {
        if (mboolean == null) {
            mboolean = ModelicaFactory.eINSTANCE.createMType();
            mboolean.setName("Boolean");
            ModelicaUtil.addComponentToType(mboolean, "quantity", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(mboolean, "start", ModelicaUtil.getBooleanType());
            ModelicaUtil.addComponentToType(mboolean, "fixed", ModelicaUtil.getBooleanType());
        }
        return mboolean;
    }

    public static MType getString() {
        if (mstring == null) {
            mstring = ModelicaFactory.eINSTANCE.createMType();
            mstring.setName("String");
            ModelicaUtil.addComponentToType(mstring, "quantity", ModelicaUtil.getStringType());
            ModelicaUtil.addComponentToType(mstring, "start", ModelicaUtil.getStringType());
        }
        return mstring;
    }

    public static MModel getInitialStep() {
        if (minitialstep == null) {
            minitialstep = ModelicaFactory.eINSTANCE.createMModel();
            minitialstep.setName("Modelica.StateGraph.InitialStep");
            MComponent nIn = ModelicaFactory.eINSTANCE.createMComponent();
            nIn.setName("nIn");
            minitialstep.getComponents().add(nIn);
            MComponent nOut = ModelicaFactory.eINSTANCE.createMComponent();
            nOut.setName("nOut");
            minitialstep.getComponents().add(nOut);
            MComponent active = ModelicaFactory.eINSTANCE.createMComponent();
            active.setName("active");
            minitialstep.getComponents().add(active);
        }
        return minitialstep;
    }

    public static MModel getStep() {
        if (mstep == null) {
            mstep = ModelicaFactory.eINSTANCE.createMModel();
            mstep.setName("Modelica.StateGraph.Step");
            MComponent nIn = ModelicaFactory.eINSTANCE.createMComponent();
            nIn.setName("nIn");
            mstep.getComponents().add(nIn);
            MComponent nOut = ModelicaFactory.eINSTANCE.createMComponent();
            nOut.setName("nOut");
            mstep.getComponents().add(nOut);
            MComponent active = ModelicaFactory.eINSTANCE.createMComponent();
            active.setName("active");
            mstep.getComponents().add(active);
        }
        return mstep;
    }

    public static MModel getTransition() {
        if (mtransition == null) {
            mtransition = ModelicaFactory.eINSTANCE.createMModel();
            mtransition.setName("Modelica.StateGraph.Transition");
            MComponent condition = ModelicaFactory.eINSTANCE.createMComponent();
            condition.setName("condition");
            mtransition.getComponents().add(condition);
            MComponent enabletimer = ModelicaFactory.eINSTANCE.createMComponent();
            enabletimer.setName("enableTimer");
            mtransition.getComponents().add(enabletimer);
            MComponent waittime = ModelicaFactory.eINSTANCE.createMComponent();
            waittime.setName("waitTime");
            mtransition.getComponents().add(waittime);
        }
        return mtransition;
    }

    private static void addComponentToType(MType mtype, String name, MClass type) {
        if (mtype == null) {
            throw new IllegalArgumentException("You must provide a modelica type");
        }
        if (name == null) {
            throw new IllegalArgumentException("You must provide a name");
        }
        if (type == null) {
            throw new IllegalArgumentException("You must provide a modelica");
        }
        MComponent mcomponent = ModelicaFactory.eINSTANCE.createMComponent();
        mcomponent.setName(name);
        mcomponent.setType(type);
        mtype.getComponents().add(mcomponent);
    }

    public static void setName(MNamedElement mne, String name) {
        String nname;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (name != null) {
            for (char c : name.toCharArray()) {
                if (first) {
                    if (!Character.isLetter(c) && c != '_') continue;
                    sb.append(c);
                    first = false;
                    continue;
                }
                if (!Character.isLetter(c) && c != '_' && !Character.isDigit(c)) continue;
                sb.append(c);
            }
        }
        String fname = sb.length() == 0 ? mne.getClass().getName() : sb.toString();
        ArrayList<MNamedElement> mnes = new ArrayList<MNamedElement>();
        if (mne instanceof MClass && ((MClass)mne).getOwningClass() != null) {
            mnes.addAll(((MClass)mne).getOwningClass().getOwnedClasses());
            mnes.addAll(((MClass)mne).getOwningClass().getComponents());
        } else if (mne instanceof MComponent && ((MComponent)mne).getOwningClass() != null) {
            mnes.addAll(((MComponent)mne).getOwningClass().getOwnedClasses());
            mnes.addAll(((MComponent)mne).getOwningClass().getComponents());
        }
        if (!ModelicaUtil.isPresent(fname, mnes)) {
            mne.setName(fname);
            return;
        }
        int i = 0;
        while (ModelicaUtil.isPresent(nname = fname + i++, mnes)) {
        }
        mne.setName(nname);
    }

    private static boolean isPresent(String name, List<MNamedElement> mnes) {
        if (name != null) {
            for (MNamedElement mne : mnes) {
                if (!name.equals(mne.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

