/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.modelica;

import com.engisis.sysphs.deserialization.modelica.ModelicaDeserializer;
import com.engisis.sysphs.language.modelica.MAccessControl;
import com.engisis.sysphs.language.modelica.MAlgorithm;
import com.engisis.sysphs.language.modelica.MBooleanValue;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MConnect;
import com.engisis.sysphs.language.modelica.MConnector;
import com.engisis.sysphs.language.modelica.MDataFlow;
import com.engisis.sysphs.language.modelica.MDataValue;
import com.engisis.sysphs.language.modelica.MDirection;
import com.engisis.sysphs.language.modelica.MElement;
import com.engisis.sysphs.language.modelica.MEquation;
import com.engisis.sysphs.language.modelica.MExpressionValue;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MIntegerValue;
import com.engisis.sysphs.language.modelica.MModification;
import com.engisis.sysphs.language.modelica.MNamedElement;
import com.engisis.sysphs.language.modelica.MRealValue;
import com.engisis.sysphs.language.modelica.MStringValue;
import com.engisis.sysphs.language.modelica.MType;
import com.engisis.sysphs.language.modelica.MVariability;
import com.engisis.sysphs.translation.modelica.ModelicaExpressionExtractor;
import com.engisis.sysphs.translation.modelica.ModelicaUtil;
import com.engisis.sysphs.util.SimulationToSysMLTranslator;
import com.engisis.sysphs.util.SysPhSUtil;
import com.engisis.sysphs.util.Util;
import com.engisis.xmiutil.EMFUtil;
import com.engisis.xmiutil.UMLModelErrorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.VisibilityKind;

public class ModelicaToSysMLTranslator
extends SimulationToSysMLTranslator {
    private static final Logger log = Logger.getLogger(ModelicaToSysMLTranslator.class);
    private SysPhSUtil sysphsutil;
    private Hashtable<ReferenceKey, NamedElement> refs = new Hashtable();
    private Stack<ReferenceKey> toProcess = new Stack();
    private Stack<ReferenceKey> toProcess2 = new Stack();
    private Hashtable<MClass, Class> porttypes = new Hashtable();
    private Hashtable<MElement, ParseTree> expressions;
    private Package root;

    private static ReferenceKey getKey(MNamedElement ... elements) {
        return new ReferenceKey(elements);
    }

    public ModelicaToSysMLTranslator(Set<Object> options) {
        this.loadOptions(options);
    }

    @Override
    public void loadOptions(Set<Object> options) {
        super.loadOptions(options);
    }

    @Override
    public Set<java.lang.Class<?>> getOptions() {
        HashSet hs = new HashSet();
        return hs;
    }

    private static TranslatedType getTranslatedType(MNamedElement mnamedelement) {
        if (mnamedelement instanceof MClass) {
            MClass mc = (MClass)mnamedelement;
            for (MExtension mext : mc.getExtensions()) {
                if (ModelicaToSysMLTranslator.getTranslatedType(mext.getExtendedClass()) != TranslatedType.DATATYPE) continue;
                return TranslatedType.DATATYPE;
            }
            if (mnamedelement instanceof MType) {
                return TranslatedType.DATATYPE;
            }
            if (mnamedelement instanceof MConnector) {
                return TranslatedType.SIMBLOCK;
            }
            for (MComponent mcomponent : mc.getComponents()) {
                TranslatedType tt = ModelicaToSysMLTranslator.getTranslatedType(mcomponent);
                if (tt != TranslatedType.INITIALSTATE && tt != TranslatedType.STATE && tt != TranslatedType.TRANSITION) continue;
                return TranslatedType.STATEMACHINE;
            }
            return TranslatedType.BLOCK;
        }
        if (mnamedelement instanceof MComponent) {
            if (((MComponent)mnamedelement).getType() == ModelicaUtil.getInitialStep()) {
                return TranslatedType.INITIALSTATE;
            }
            if (((MComponent)mnamedelement).getType() == ModelicaUtil.getStep()) {
                return TranslatedType.STATE;
            }
            if (((MComponent)mnamedelement).getType() == ModelicaUtil.getTransition()) {
                return TranslatedType.TRANSITION;
            }
            return TranslatedType.COMPONENT;
        }
        return TranslatedType.NONE;
    }

    @Override
    public void execute(String model, ResourceSet rs, File outputdirectory, String target, String[] paths) throws IOException, UMLModelErrorException {
        TranslatedType tt;
        MNamedElement nme;
        ReferenceKey key;
        if (model == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        if (rs == null) {
            throw new IllegalArgumentException("The ResourceSet can't be null");
        }
        File file = new File(model);
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("The file must be readable");
        }
        ArrayList<URI> lpath = new ArrayList<URI>(paths != null ? paths.length + 1 : 1);
        if (paths != null) {
            for (String path : paths) {
                lpath.add(URI.createFileURI(new File(path).getAbsolutePath()));
            }
        }
        lpath.add(URI.createFileURI(file.getParentFile().getAbsolutePath()));
        URI uri = null;
        String fn = null;
        if (outputdirectory == null) {
            uri = URI.createFileURI(model).trimFileExtension();
            fn = uri.lastSegment() + this.getFileNameSuffix();
            uri = uri.trimSegments(1).appendSegment(fn).appendFileExtension("xmi");
        } else {
            uri = URI.createFileURI(outputdirectory.getAbsolutePath());
            fn = URI.createFileURI(model).trimFileExtension().lastSegment() + this.getFileNameSuffix();
            uri = uri.appendSegment(fn).appendFileExtension("xmi");
        }
        Resource r = SysPhSUtil.createSysPhSModel(rs, uri, lpath);
        this.sysphsutil = new SysPhSUtil(r.getResourceSet());
        ModelicaDeserializer md = new ModelicaDeserializer(file);
        List<MClass> list = md.getClasses();
        this.expressions = md.getExpressions();
        this.root = (Package)r.getContents().stream().filter(c -> c instanceof Package).findFirst().orElseThrow(() -> new NullPointerException("No root package found in SysPhS model"));
        for (MClass mclass : list) {
            this.createClass(mclass);
        }
        while (this.toProcess.size() != 0) {
            key = this.toProcess.pop();
            nme = key.getKey()[0];
            tt = ModelicaToSysMLTranslator.getTranslatedType(nme);
            if (nme instanceof MClass) {
                if (tt == TranslatedType.STATEMACHINE) {
                    this.processStateMachine((MClass)nme);
                    this.toProcess2.push(key);
                    continue;
                }
                this.processClass((MClass)nme);
                this.toProcess2.push(key);
                continue;
            }
            if (!(nme instanceof MComponent)) continue;
            if (tt == TranslatedType.INITIALSTATE) {
                this.processInitialState((MComponent)nme);
                continue;
            }
            if (tt == TranslatedType.STATE) {
                this.processState((MComponent)nme);
                continue;
            }
            if (tt == TranslatedType.TRANSITION) {
                this.processTransition((MComponent)nme);
                continue;
            }
            this.processProperty((MComponent)nme);
            this.toProcess2.push(key);
        }
        while (this.toProcess2.size() != 0) {
            key = this.toProcess2.pop();
            nme = key.getKey()[0];
            tt = ModelicaToSysMLTranslator.getTranslatedType(nme);
            if (nme instanceof MClass) {
                if (tt == TranslatedType.STATEMACHINE) {
                    this.processStateMachine2((MClass)nme);
                    continue;
                }
                this.processClass2((MClass)nme);
                continue;
            }
            if (!(nme instanceof MComponent)) continue;
            this.processProperty2((MComponent)nme);
        }
        for (MClass mc : list) {
            if (mc instanceof MType) continue;
            if (mc.getComponents().size() == 1 && mc.getEquations().size() == 0) {
                MComponent first = (MComponent)mc.getComponents().get(0);
                if (first.getType() == null) {
                    log.error("Type of " + first.getName() + " is null");
                } else {
                    NamedElement ne = this.refs.get(ModelicaToSysMLTranslator.getKey(first.getType()));
                    if (ne instanceof Class) {
                        this.outputrootname = ((Class)ne).getQualifiedName();
                        log.info("Setting root element to " + this.outputrootname);
                        break;
                    }
                }
            }
            NamedElement ne = this.refs.get(ModelicaToSysMLTranslator.getKey(mc));
            if (!(mc instanceof Class)) continue;
            this.outputrootname = ((Class)ne).getQualifiedName();
            log.info("Setting root element to " + this.outputrootname);
            break;
        }
        log.info("Saving " + r.getURI());
        this.outputfilename = r.getURI().toFileString();
        EMFUtil.saveResource(r, target);
    }

    private Classifier createClass(MClass mclass) {
        if (mclass == null) {
            throw new IllegalArgumentException("The class should not be null");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mclass);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Classifier) {
                return (Classifier)uelement;
            }
            throw new IllegalStateException("The element is not a class: " + mclass.getName());
        }
        OperationOwner uclass = null;
        block0 : switch (ModelicaToSysMLTranslator.getTranslatedType(mclass)) {
            case BLOCK: {
                log.info("Creating block " + mclass.getName());
                uclass = UMLFactory.eINSTANCE.createClass();
                this.root.getPackagedElements().add((PackageableElement)((Object)uclass));
                uclass.applyStereotype(this.sysphsutil.getBlock());
                break;
            }
            case SIMBLOCK: {
                log.info("Creating port type " + mclass.getName());
                uclass = UMLFactory.eINSTANCE.createClass();
                this.root.getPackagedElements().add((PackageableElement)((Object)uclass));
                uclass.applyStereotype(this.sysphsutil.getBlock());
                for (MComponent mc : mclass.getAllComponents()) {
                    if (mc.getDataFlow() != MDataFlow.FLOW) continue;
                    Class scs = this.sysphsutil.getConservedSubstance();
                    if (scs == null) {
                        log.error("Couldn't find conserved substance block");
                        break block0;
                    }
                    Generalization ugeneralization = UMLFactory.eINSTANCE.createGeneralization();
                    ugeneralization.setGeneral(scs);
                    ugeneralization.setSpecific((Classifier)((Object)uclass));
                    uclass.getGeneralizations().add(ugeneralization);
                    break block0;
                }
                break;
            }
            case DATATYPE: {
                log.info("Creating datatype " + mclass.getName());
                DataType udatatype = null;
                if (mclass == ModelicaUtil.getReal()) {
                    udatatype = this.sysphsutil.getSysMLDouble();
                } else if (mclass == ModelicaUtil.getInteger()) {
                    udatatype = this.sysphsutil.getSysMLInteger();
                } else if (mclass == ModelicaUtil.getBoolean()) {
                    udatatype = this.sysphsutil.getSysMLBoolean();
                } else if (mclass == ModelicaUtil.getString()) {
                    udatatype = this.sysphsutil.getSysMLString();
                } else {
                    uclass = UMLFactory.eINSTANCE.createDataType();
                    this.root.getPackagedElements().add((PackageableElement)((Object)uclass));
                }
                if (udatatype == null) break;
                this.refs.put(key, udatatype);
                return udatatype;
            }
        }
        if (uclass == null) {
            log.error("Couldn't translate class " + mclass.getName());
            return null;
        }
        this.refs.put(key, (NamedElement)((Object)uclass));
        this.toProcess.push(key);
        return uclass;
    }

    private StateMachine createStateMachine(MClass mclass) {
        if (mclass == null) {
            throw new IllegalArgumentException("The class should not be null");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mclass);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof StateMachine) {
                return (StateMachine)uelement;
            }
            throw new IllegalStateException("The element is not a state machine: " + mclass.getName());
        }
        log.info("Creating state machine " + mclass.getName());
        StateMachine ustatemachine = UMLFactory.eINSTANCE.createStateMachine();
        this.refs.put(key, ustatemachine);
        this.toProcess.add(key);
        return ustatemachine;
    }

    private Property createProperty(MComponent mcomponent) {
        if (mcomponent == null) {
            throw new IllegalArgumentException("The component should not be null");
        }
        if (ModelicaToSysMLTranslator.getTranslatedType(mcomponent) != TranslatedType.COMPONENT) {
            throw new IllegalStateException("The method can only be called on a component");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mcomponent);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Property) {
                return (Property)uelement;
            }
            throw new IllegalStateException("The element is not a component: " + mcomponent.getName());
        }
        Property uproperty = null;
        if (mcomponent.getDirection() == MDirection.INPUT || mcomponent.getDirection() == MDirection.OUTPUT || mcomponent.getType() instanceof MConnector) {
            log.info("Creating port " + mcomponent.getName());
            uproperty = UMLFactory.eINSTANCE.createPort();
            if (mcomponent.getDirection() == MDirection.OUTPUT) {
                uproperty.setIsConjugated(true);
            }
        } else {
            log.info("Creating property " + mcomponent.getName() + " from " + mcomponent.getOwningClass().getName());
            uproperty = UMLFactory.eINSTANCE.createProperty();
            SysPhSUtil.setName(uproperty, mcomponent.getOwningClass().getName() + "__" + mcomponent.getName());
        }
        this.refs.put(key, uproperty);
        this.toProcess.push(key);
        return uproperty;
    }

    private Classifier processClass(MClass mclass) {
        log.info("Processing classifier " + mclass.getName());
        Classifier uclassifier = this.createClass(mclass);
        SysPhSUtil.setName(uclassifier, mclass.getName());
        EList<Property> properties = null;
        if (uclassifier instanceof StructuredClassifier) {
            properties = ((StructuredClassifier)uclassifier).getOwnedAttributes();
        } else if (uclassifier instanceof DataType) {
            properties = ((DataType)uclassifier).getOwnedAttributes();
        } else if (uclassifier instanceof Interface) {
            properties = ((Interface)uclassifier).getOwnedAttributes();
        } else if (uclassifier instanceof Signal) {
            properties = ((Signal)uclassifier).getOwnedAttributes();
        } else if (uclassifier instanceof Artifact) {
            properties = ((Artifact)uclassifier).getOwnedAttributes();
        } else {
            log.info("Attributes of " + mclass.getName() + " skipped");
        }
        if (properties != null) {
            for (MComponent mcomponent : mclass.getComponents()) {
                if (ModelicaToSysMLTranslator.getTranslatedType(mcomponent.getType()) == TranslatedType.STATEMACHINE) {
                    if (!(uclassifier instanceof Class)) continue;
                    StateMachine ustatemachine = this.createStateMachine(mcomponent.getType());
                    ((Class)uclassifier).setClassifierBehavior(ustatemachine);
                    continue;
                }
                Property uproperty = this.createProperty(mcomponent);
                properties.add(uproperty);
            }
        }
        for (MExtension extension : mclass.getExtensions()) {
            Classifier general = this.createClass(extension.getExtendedClass());
            if (general != null) {
                log.info("Adding generalization between " + uclassifier.getName() + " and " + general.getName());
                Generalization generaliz = UMLFactory.eINSTANCE.createGeneralization();
                generaliz.setGeneral(general);
                uclassifier.getGeneralizations().add(generaliz);
                for (MModification mmodification : extension.getModifications()) {
                    if (mmodification.getComponentPath().size() == 1 && ((MComponent)mmodification.getComponentPath().get(0)).getName().equals("unit") && mmodification.getAssignedValue() instanceof MStringValue) {
                        log.info("Unit detected " + mmodification.getAssignedValue());
                        uclassifier.applyStereotype(this.sysphsutil.getValueType());
                        InstanceSpecification unit = UMLFactory.eINSTANCE.createInstanceSpecification();
                        uclassifier.getNearestPackage().getPackagedElements().add(unit);
                        unit.getClassifiers().add(this.sysphsutil.getUnit());
                        Slot symbol = UMLFactory.eINSTANCE.createSlot();
                        unit.getSlots().add(symbol);
                        symbol.setDefiningFeature(this.sysphsutil.getUnit().getAttribute("symbol", null));
                        LiteralString ls = UMLFactory.eINSTANCE.createLiteralString();
                        ls.setValue(((MStringValue)mmodification.getAssignedValue()).getValue());
                        symbol.getValues().add(ls);
                        uclassifier.setValue(this.sysphsutil.getValueType(), "unit", unit);
                        continue;
                    }
                    log.warn("Extend modification not used : " + mmodification.getComponentPath() + "---" + mmodification.getAssignedValue());
                }
                continue;
            }
            log.error("The extension of " + mclass.getName() + " can't be translated");
        }
        return uclassifier;
    }

    private Classifier processClass2(MClass mclass) {
        log.info("Processing classifier " + mclass.getName() + " a second time");
        Classifier uclassifier = this.createClass(mclass);
        if (mclass.getEquations().size() > 0 && uclassifier instanceof Class) {
            Class constraint = UMLFactory.eINSTANCE.createClass();
            this.root.getPackagedElements().add(constraint);
            SysPhSUtil.setName(constraint, mclass.getName() + "Constraint");
            constraint.applyStereotype(this.sysphsutil.getConstraintBlock());
            StringBuilder sbproperty = new StringBuilder();
            for (char c : constraint.getName().toCharArray()) {
                if (!Character.isUpperCase(c)) continue;
                sbproperty.append(c);
            }
            Property ucproperty = UMLFactory.eINSTANCE.createProperty();
            Class uclass = (Class)uclassifier;
            uclass.getOwnedAttributes().add(ucproperty);
            SysPhSUtil.setName(ucproperty, sbproperty.toString());
            ucproperty.setType(constraint);
            Hashtable<List<String>, String> parameters = new Hashtable<List<String>, String>();
            for (MEquation mEquation : mclass.getEquations()) {
                if (mEquation instanceof MConnect) {
                    MConnect mconnect = (MConnect)mEquation;
                    log.info("Adding connector");
                    Connector uconnector = UMLFactory.eINSTANCE.createConnector();
                    uclass.getOwnedConnectors().add(uconnector);
                    ConnectorEnd ce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                    uconnector.getEnds().add(ce0);
                    LinkedList<Property> lp0 = new LinkedList<Property>();
                    for (MComponent mc : mconnect.getRef1()) {
                        Property up = this.createProperty(mc);
                        if (up == null) continue;
                        lp0.add(up);
                    }
                    this.sysphsutil.updatePropertyPath(ce0, lp0);
                    ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                    uconnector.getEnds().add(ce1);
                    LinkedList<Property> lp1 = new LinkedList<Property>();
                    for (MComponent mc : mconnect.getRef2()) {
                        Property up = this.createProperty(mc);
                        if (up == null) continue;
                        lp1.add(up);
                    }
                    this.sysphsutil.updatePropertyPath(ce1, lp1);
                    continue;
                }
                log.info("Analyzing constraint " + mEquation.getExpression());
                ParseTree pt = this.expressions.get(mEquation);
                if (pt != null) {
                    ParseTreeWalker ptw = new ParseTreeWalker();
                    ModelicaExpressionExtractor mee = new ModelicaExpressionExtractor();
                    mee.prepareForConstraint();
                    ptw.walk(mee, pt);
                    List<String> lb = mee.getLBinding();
                    List<String> rb = mee.getRBinding();
                    if (lb != null && rb != null) {
                        MComponent mcl = mclass.getComponentByName(lb.get(0));
                        if (mcl == null) {
                            log.warn("Can't find component " + lb.get(0) + " in " + mclass.getName());
                            continue;
                        }
                        MComponent mcr = mclass.getComponentByName(rb.get(0));
                        if (mcr == null) {
                            log.warn("Can't find component " + rb.get(0) + " in " + mclass.getName());
                            continue;
                        }
                        TranslatedType ttl = ModelicaToSysMLTranslator.getTranslatedType(mcl.getType());
                        TranslatedType ttr = ModelicaToSysMLTranslator.getTranslatedType(mcr.getType());
                        if (ttl != TranslatedType.STATEMACHINE && ttr != TranslatedType.STATEMACHINE) {
                            Connector ubinding = UMLFactory.eINSTANCE.createConnector();
                            uclass.getOwnedConnectors().add(ubinding);
                            ubinding.applyStereotype(this.sysphsutil.getBindingConnector());
                            LinkedList<Property> lp0 = new LinkedList<Property>();
                            lp0.add(this.createProperty(mcl));
                            for (int i = 1; i < lb.size(); ++i) {
                                MClass type = mcl.getType();
                                if (type == null) {
                                    log.error("The type of " + mcl.getName() + " is null, in binding " + pt.getText());
                                    break;
                                }
                                mcl = type.getComponentByName(lb.get(i));
                                if (mcl == null) {
                                    log.error("No component named " + lb.get(i) + " in " + type.getName() + ", in binding " + pt.getText());
                                    break;
                                }
                                lp0.add(this.createProperty(mcl));
                            }
                            ConnectorEnd ce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                            ubinding.getEnds().add(ce0);
                            this.sysphsutil.updatePropertyPath(ce0, lp0);
                            LinkedList<Property> lp1 = new LinkedList<Property>();
                            lp1.add(this.createProperty(mcr));
                            for (int i = 1; i < rb.size(); ++i) {
                                MClass type = mcr.getType();
                                if (type == null) {
                                    log.error("The type of " + mcr.getName() + " is null, in binding " + pt.getText());
                                    break;
                                }
                                mcr = type.getComponentByName(rb.get(i));
                                if (mcr == null) {
                                    log.error("No component named " + rb.get(i) + " in " + type.getName() + ", in binding " + pt.getText());
                                    break;
                                }
                                lp1.add(this.createProperty(mcr));
                            }
                            ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                            ubinding.getEnds().add(ce1);
                            this.sysphsutil.updatePropertyPath(ce1, lp1);
                            log.info("Created binding for " + pt.getText());
                            continue;
                        }
                        if (ttl == TranslatedType.STATEMACHINE) {
                            log.warn("Skipping binding " + pt.getText());
                            this.refs.put(ModelicaToSysMLTranslator.getKey(mcl.getComponentByName(lb.get(1))), this.refs.get(ModelicaToSysMLTranslator.getKey(mcr)));
                            continue;
                        }
                        if (ttr != TranslatedType.STATEMACHINE) continue;
                        log.warn("Skipping binding " + pt.getText());
                        this.refs.put(ModelicaToSysMLTranslator.getKey(mcr.getComponentByName(rb.get(1))), this.refs.get(ModelicaToSysMLTranslator.getKey(mcl)));
                        continue;
                    }
                    log.info("Creating constraint, adding " + mee.getParameters().size() + " parameters");
                    Constraint c = UMLFactory.eINSTANCE.createConstraint();
                    constraint.getOwnedRules().add(c);
                    OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                    c.setSpecification(oe);
                    oe.getBodies().add(mee.getValue(pt));
                    oe.getLanguages().add("sysphs");
                    parameters.putAll(mee.getParameters());
                    continue;
                }
                log.error("Unable to get parse tree for the equation");
            }
            block6: for (Map.Entry entry : parameters.entrySet()) {
                List key = (List)entry.getKey();
                String val = (String)entry.getValue();
                log.info("Adding constraint parameter " + val);
                Property uparameter = UMLFactory.eINSTANCE.createProperty();
                constraint.getOwnedAttributes().add(uparameter);
                SysPhSUtil.setName(uparameter, val);
                uparameter.setType(this.sysphsutil.getSysMLDouble());
                Connector uconnector = UMLFactory.eINSTANCE.createConnector();
                uclass.getOwnedConnectors().add(uconnector);
                uconnector.applyStereotype(this.sysphsutil.getBindingConnector());
                ConnectorEnd ce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                uconnector.getEnds().add(ce0);
                ArrayList<Property> lp0 = new ArrayList<Property>(2);
                lp0.add(ucproperty);
                lp0.add(uparameter);
                this.sysphsutil.updatePropertyPath(ce0, lp0);
                ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                uconnector.getEnds().add(ce1);
                ArrayList<Property> lp1 = new ArrayList<Property>();
                MClass curclas = mclass;
                MComponent curcomp = null;
                for (int i = 0; i < key.size(); ++i) {
                    curcomp = curclas.getComponentByName((String)key.get(i));
                    if (curcomp == null) {
                        log.error("No component " + (String)key.get(i) + " in " + curclas.getName());
                        continue block6;
                    }
                    Property uprop = this.createProperty(curcomp);
                    lp1.add(uprop);
                    curclas = curcomp.getType();
                }
                this.sysphsutil.updatePropertyPath(ce1, lp1);
            }
        }
        return uclassifier;
    }

    private StateMachine processStateMachine(MClass mclass) {
        log.info("Processing state machine " + mclass.getName());
        StateMachine ustatemachine = this.createStateMachine(mclass);
        Region uregion = UMLFactory.eINSTANCE.createRegion();
        for (MComponent mcomponent : mclass.getComponents()) {
            TranslatedType tt = ModelicaToSysMLTranslator.getTranslatedType(mcomponent);
            if (tt == TranslatedType.INITIALSTATE) {
                Pseudostate ups = this.createInitialState(mcomponent);
                uregion.getSubvertices().add(ups);
                continue;
            }
            if (tt == TranslatedType.STATE) {
                State us = this.createState(mcomponent);
                uregion.getSubvertices().add(us);
                continue;
            }
            if (tt != TranslatedType.TRANSITION) continue;
            Transition ut = this.createTransition(mcomponent);
            uregion.getTransitions().add(ut);
        }
        ustatemachine.getRegions().add(uregion);
        for (MEquation equation : mclass.getEquations()) {
            String n2;
            String n1;
            if (!(equation instanceof MConnect)) continue;
            MConnect mconnect = (MConnect)equation;
            NamedElement ne1 = this.refs.get(ModelicaToSysMLTranslator.getKey((MNamedElement)mconnect.getRef1().get(0)));
            NamedElement ne2 = this.refs.get(ModelicaToSysMLTranslator.getKey((MNamedElement)mconnect.getRef2().get(0)));
            if (ne1 instanceof Vertex && ne2 instanceof Transition) {
                n1 = ((MComponent)mconnect.getRef1().get(1)).getName();
                n2 = ((MComponent)mconnect.getRef2().get(1)).getName();
                if (n1.equals("outPort") && n2.equals("inPort")) {
                    log.info("Setting source of " + ne2.getName() + " to " + ne1.getName());
                    ((Transition)ne2).setSource((Vertex)ne1);
                    continue;
                }
                if (!n1.equals("inPort") || !n2.equals("outPort")) continue;
                log.info("Setting target of " + ne2.getName() + " to " + ne1.getName());
                ((Transition)ne2).setTarget((Vertex)ne1);
                continue;
            }
            if (!(ne1 instanceof Transition) || !(ne2 instanceof Vertex)) continue;
            n1 = ((MComponent)mconnect.getRef1().get(1)).getName();
            n2 = ((MComponent)mconnect.getRef2().get(1)).getName();
            if (n1.equals("outPort") && n2.equals("inPort")) {
                log.info("Setting target of " + ne1.getName() + " to " + ne2.getName());
                ((Transition)ne1).setTarget((Vertex)ne2);
                continue;
            }
            if (!n1.equals("inPort") || !n2.equals("outPort")) continue;
            log.info("Setting source of " + ne1.getName() + " to " + ne2.getName());
            ((Transition)ne1).setSource((Vertex)ne2);
        }
        return ustatemachine;
    }

    private StateMachine processStateMachine2(MClass mclass) {
        log.info("Processing state machine " + mclass.getName() + " a second time");
        StateMachine ustatemachine = this.createStateMachine(mclass);
        Hashtable<String, String> substitutions = new Hashtable<String, String>();
        for (Property uproperty : this.sysphsutil.getAllAttributes(ustatemachine.getContext())) {
            Type type = uproperty.getType();
            if (!this.porttypes.values().contains(type)) continue;
            Property sp = this.sysphsutil.getAllPhSProperties((Class)type).get(0);
            substitutions.put(uproperty.getName(), uproperty.getName() + "." + sp.getName());
        }
        for (MComponent mcomponent : mclass.getComponents()) {
            NamedElement mne = this.refs.get(ModelicaToSysMLTranslator.getKey(mcomponent));
            if (!(mne instanceof Transition)) continue;
            for (MModification mmodification : mcomponent.getModifications()) {
                String modname = ((MComponent)mmodification.getComponentPath().get(0)).getName();
                if (modname.equals("condition")) {
                    OpaqueExpression oe;
                    TimeExpression texp;
                    TimeEvent te;
                    ParseTree pt = this.expressions.get(mmodification);
                    if (pt == null) continue;
                    ParseTreeWalker ptw = new ParseTreeWalker();
                    ModelicaExpressionExtractor mee = new ModelicaExpressionExtractor();
                    mee.setSubstitutions(substitutions);
                    ptw.walk(mee, pt);
                    String v = mee.getValue(pt);
                    if (v == null) continue;
                    String sval = v.toString();
                    String te0 = "time>";
                    String te1 = "time>=";
                    Trigger t = null;
                    if (sval.startsWith(te0)) {
                        sval = sval.substring(te0.length());
                        t = UMLFactory.eINSTANCE.createTrigger();
                        te = UMLFactory.eINSTANCE.createTimeEvent();
                        mne.getNearestPackage().getPackagedElements().add(te);
                        t.setEvent(te);
                        texp = UMLFactory.eINSTANCE.createTimeExpression();
                        te.setWhen(texp);
                        oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                        texp.setExpr(oe);
                        oe.getBodies().add(sval);
                        oe.getLanguages().add("sysphs");
                        te.setIsRelative(false);
                    } else if (sval.startsWith(te1)) {
                        sval = sval.substring(te1.length());
                        t = UMLFactory.eINSTANCE.createTrigger();
                        te = UMLFactory.eINSTANCE.createTimeEvent();
                        mne.getNearestPackage().getPackagedElements().add(te);
                        t.setEvent(te);
                        texp = UMLFactory.eINSTANCE.createTimeExpression();
                        te.setWhen(texp);
                        oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                        texp.setExpr(oe);
                        oe.getBodies().add(sval);
                        oe.getLanguages().add("sysphs");
                        te.setIsRelative(false);
                    } else if (!"true".equals(sval)) {
                        t = UMLFactory.eINSTANCE.createTrigger();
                        ChangeEvent ce = UMLFactory.eINSTANCE.createChangeEvent();
                        mne.getNearestPackage().getPackagedElements().add(ce);
                        t.setEvent(ce);
                        OpaqueExpression oe2 = UMLFactory.eINSTANCE.createOpaqueExpression();
                        ce.setChangeExpression(oe2);
                        oe2.getBodies().add(sval);
                        oe2.getLanguages().add("sysphs");
                    }
                    if (t == null) continue;
                    ((Transition)mne).getTriggers().add(t);
                    continue;
                }
                if (!modname.equals("waitTime")) continue;
                Trigger t = UMLFactory.eINSTANCE.createTrigger();
                TimeEvent te = UMLFactory.eINSTANCE.createTimeEvent();
                mne.getNearestPackage().getPackagedElements().add(te);
                t.setEvent(te);
                TimeExpression texp = UMLFactory.eINSTANCE.createTimeExpression();
                te.setWhen(texp);
                texp.setExpr(ModelicaToSysMLTranslator.getValueSpecification(mmodification.getAssignedValue()));
                te.setIsRelative(true);
                ((Transition)mne).getTriggers().add(t);
            }
        }
        for (MAlgorithm malgorithm : mclass.getAlgorithms()) {
            ParseTree pt = this.expressions.get(malgorithm);
            if (pt == null) continue;
            ParseTreeWalker ptw = new ParseTreeWalker();
            ModelicaExpressionExtractor mee = new ModelicaExpressionExtractor();
            Hashtable<String, String> stateactions = new Hashtable<String, String>();
            mee.setStateActions(stateactions);
            mee.setSubstitutions(substitutions);
            ptw.walk(mee, pt);
            for (Map.Entry<String, String> ent : stateactions.entrySet()) {
                State st = (State)this.refs.get(ModelicaToSysMLTranslator.getKey(mclass.getComponentByName(ent.getKey())));
                if (st == null) continue;
                OpaqueBehavior ob = UMLFactory.eINSTANCE.createOpaqueBehavior();
                ob.getBodies().add(ent.getValue());
                ob.getLanguages().add("sysphs");
                st.setEntry(ob);
            }
        }
        return ustatemachine;
    }

    private Property processProperty(MComponent mcomponent) {
        Property uproperty = this.createProperty(mcomponent);
        log.info("Processing property " + mcomponent.getName());
        SysPhSUtil.setName(uproperty, mcomponent.getName());
        MClass type = mcomponent.getType();
        if (type == null) {
            log.error("Type of " + mcomponent.getName() + " not available");
            return null;
        }
        if (type.getName().contains(".")) {
            block0: for (SysPhSUtil.LibraryComponent lc : this.sysphsutil.getModelicaComponents()) {
                if (!type.getName().equals(lc.getName())) continue;
                HashMap<String, String> hmlib = new HashMap<String, String>();
                for (SysPhSUtil.LibraryParameter lp : lc.getParameters()) {
                    hmlib.put(lp.getName(), lp.getValue());
                }
                LinkedList<MModification> todelete = new LinkedList<MModification>();
                HashMap<String, MDataValue> hmmod = new HashMap<String, MDataValue>();
                for (MModification mModification : mcomponent.getModifications()) {
                    String nam = ((MComponent)mModification.getComponentPath().get(0)).getName();
                    MDataValue mDataValue = mModification.getAssignedValue();
                    hmmod.put(nam, mDataValue);
                    if (!hmlib.containsKey(nam)) continue block0;
                    String val2 = (String)hmlib.get(nam);
                    if (val2 == null) continue;
                    if (mDataValue instanceof MRealValue && ((MRealValue)mDataValue).getValue() != Util.toDouble(val2, 0.0) || mDataValue instanceof MIntegerValue && ((MIntegerValue)mDataValue).getValue() != Util.toInt(val2, 0) || mDataValue instanceof MBooleanValue && ((MBooleanValue)mDataValue).isValue() != Util.toBoolean(val2, false)) continue block0;
                    todelete.add(mModification);
                }
                for (Map.Entry entry : hmlib.entrySet()) {
                    if (hmmod.containsKey(entry.getKey())) continue;
                    continue block0;
                }
                log.info("Setting library block " + lc.getName() + " as type");
                uproperty.setType(lc.getClas());
                this.refs.put(ModelicaToSysMLTranslator.getKey(type), lc.getClas());
                mcomponent.getModifications().removeAll(todelete);
                log.info("Associating block " + type.getName() + " with " + lc.getName());
                block4: for (MComponent mComponent : type.getComponents()) {
                    for (SysPhSUtil.LibraryParameter libraryParameter : lc.getParameters()) {
                        if (!libraryParameter.getName().equals(mComponent.getName())) continue;
                        log.info("Associating property " + mComponent.getName());
                        this.refs.put(ModelicaToSysMLTranslator.getKey(mComponent), libraryParameter.getProperty());
                        continue block4;
                    }
                    for (SysPhSUtil.LibraryPort libraryPort : lc.getPorts()) {
                        if (!libraryPort.getName().equals(mComponent.getName())) continue;
                        log.info("Associating port " + mComponent.getName());
                        this.refs.put(ModelicaToSysMLTranslator.getKey(mComponent), libraryPort.getPort());
                        continue block4;
                    }
                }
            }
            if (uproperty.getType() == null) {
                log.error("Couldn't find any library type for " + mcomponent.getName());
            }
        } else if (mcomponent.getDirection() == MDirection.INPUT || mcomponent.getDirection() == MDirection.OUTPUT || type instanceof MConnector) {
            uproperty.setType(this.getPortType(type));
        } else {
            uproperty.setType(this.createClass(type));
        }
        if (mcomponent.getAccessControl() == MAccessControl.PROTECTED) {
            uproperty.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        } else {
            uproperty.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (type instanceof MType) {
            if (mcomponent.getVariability() == MVariability.CONSTANT) {
                uproperty.setIsReadOnly(true);
            } else if (mcomponent.getVariability() == MVariability.PARAMETER) {
                uproperty.applyStereotype(this.sysphsutil.getPhSConstant());
            } else {
                uproperty.applyStereotype(this.sysphsutil.getPhSVariable());
                if (mcomponent.getVariability() == MVariability.DISCRETE) {
                    uproperty.setValue(this.sysphsutil.getPhSVariable(), "isContinuous", false);
                } else {
                    uproperty.setValue(this.sysphsutil.getPhSVariable(), "isContinuous", true);
                }
                if (mcomponent.getDataFlow() == MDataFlow.FLOW) {
                    uproperty.setValue(this.sysphsutil.getPhSVariable(), "isConserved", true);
                }
            }
        }
        return uproperty;
    }

    private Property processProperty2(MComponent mcomponent) {
        Property uproperty = this.createProperty(mcomponent);
        log.info("Processing property " + mcomponent.getName() + " a second time");
        if (mcomponent.getValue() != null && (mcomponent.getVariability() == MVariability.PARAMETER || mcomponent.getVariability() == MVariability.CONSTANT)) {
            uproperty.setDefaultValue(ModelicaToSysMLTranslator.getValueSpecification(mcomponent.getValue()));
        }
        if (mcomponent.getRedefinedComponent() != null) {
            Property redefined = this.createProperty(mcomponent.getRedefinedComponent());
            uproperty.getRedefinedProperties().add(redefined);
        }
        EList<MModification> mmodifications = mcomponent.getModifications();
        if (mcomponent.getType() != null) {
            for (MModification mmodification : mmodifications) {
                if (mmodification.getComponentPath().size() == 0) {
                    log.warn("Skipping modification without path");
                    continue;
                }
                if (mmodification.getAssignedValue() != null) {
                    log.info("Assigned value");
                    MComponent previousmc = mcomponent;
                    Slot previousslot = null;
                    for (MComponent currentmc : mmodification.getComponentPath()) {
                        log.info("Component " + currentmc.getName());
                        if (previousmc.getType() instanceof MType && currentmc.getName().equals("start")) break;
                        if (!this.refs.containsKey(ModelicaToSysMLTranslator.getKey(currentmc))) {
                            log.warn("Ignoring modification, unknown component " + currentmc.getName());
                            mmodification.setAssignedValue(null);
                            break;
                        }
                        Property currentp = this.createProperty(currentmc);
                        Slot currentslot = null;
                        if (previousslot != null) {
                            block2: for (ValueSpecification vs : previousslot.getValues()) {
                                if (!(vs instanceof InstanceValue)) continue;
                                for (Slot slot2 : ((InstanceValue)vs).getInstance().getSlots()) {
                                    if (slot2.getDefiningFeature() != currentp) continue;
                                    log.info("Found existing slot in previous slot " + currentmc.getName());
                                    currentslot = slot2;
                                    continue block2;
                                }
                            }
                        } else if (uproperty.getDefaultValue() instanceof InstanceValue) {
                            for (Slot slot2 : ((InstanceValue)uproperty.getDefaultValue()).getInstance().getSlots()) {
                                if (slot2.getDefiningFeature() != currentp) continue;
                                log.info("Found existing slot in default value");
                                currentslot = slot2;
                                break;
                            }
                        }
                        if (currentslot == null) {
                            InstanceValue iv;
                            InstanceSpecification is;
                            log.info("Creating slot");
                            currentslot = UMLFactory.eINSTANCE.createSlot();
                            currentslot.setDefiningFeature(currentp);
                            if (previousslot == null) {
                                if (uproperty.getDefaultValue() instanceof InstanceValue) {
                                    log.info("Assigning to existing default value");
                                    ((InstanceValue)uproperty.getDefaultValue()).getInstance().getSlots().add(currentslot);
                                } else {
                                    is = UMLFactory.eINSTANCE.createInstanceSpecification();
                                    uproperty.getNearestPackage().getPackagedElements().add(is);
                                    is.getClassifiers().add(this.createClass(currentmc.getType()));
                                    is.getSlots().add(currentslot);
                                    iv = UMLFactory.eINSTANCE.createInstanceValue();
                                    iv.setInstance(is);
                                    log.info("Assigning to new default value");
                                    uproperty.setDefaultValue(iv);
                                }
                            } else if (previousslot.getValues().size() == 0 || !(previousslot.getValues().get(0) instanceof InstanceValue)) {
                                is = UMLFactory.eINSTANCE.createInstanceSpecification();
                                uproperty.getNearestPackage().getPackagedElements().add(is);
                                is.getClassifiers().add(this.createClass(currentmc.getType()));
                                is.getSlots().add(currentslot);
                                iv = UMLFactory.eINSTANCE.createInstanceValue();
                                iv.setInstance(is);
                                previousslot.getValues().add(iv);
                                log.info("Assigning to previous slot with new instance spec: " + previousmc.getName());
                            } else {
                                ((InstanceValue)previousslot.getValues().get(0)).getInstance().getSlots().add(currentslot);
                                log.info("Assigning to previous slot with existing instance spec" + previousmc.getName());
                            }
                        }
                        previousslot = currentslot;
                        previousmc = currentmc;
                    }
                    if (mmodification.getAssignedValue() == null) continue;
                    ValueSpecification val = ModelicaToSysMLTranslator.getValueSpecification(mmodification.getAssignedValue());
                    if (previousslot == null) {
                        log.info("Assigning value to default value");
                        uproperty.setDefaultValue(val);
                        continue;
                    }
                    log.info("Assigning value to previous slot " + previousmc.getName() + "--" + previousslot.getValues().size());
                    previousslot.getValues().add(val);
                    continue;
                }
                if (mmodification.getAssignedReference().size() > 0) {
                    MComponent mc;
                    int i;
                    log.info("Assigned reference");
                    LinkedList<Property> lp0 = new LinkedList<Property>();
                    LinkedList<Property> lp1 = new LinkedList<Property>();
                    lp0.add(uproperty);
                    for (i = 0; i < mmodification.getComponentPath().size(); ++i) {
                        mc = (MComponent)mmodification.getComponentPath().get(i);
                        if (mc.getName().equals("start") && i == mmodification.getComponentPath().size() - 2) continue;
                        lp0.add(this.createProperty(mc));
                    }
                    for (i = 0; i < mmodification.getAssignedReference().size(); ++i) {
                        mc = (MComponent)mmodification.getAssignedReference().get(i);
                        if (mc.getName().equals("start") && i == mmodification.getAssignedReference().size() - 2) continue;
                        lp1.add(this.createProperty(mc));
                    }
                    log.info("Creating binding between " + lp0 + " and " + lp1);
                    Connector uconnector = UMLFactory.eINSTANCE.createConnector();
                    ((Class)uproperty.getOwner()).getOwnedConnectors().add(uconnector);
                    uconnector.applyStereotype(this.sysphsutil.getBindingConnector());
                    ConnectorEnd ce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                    uconnector.getEnds().add(ce0);
                    this.sysphsutil.updatePropertyPath(ce0, lp0);
                    ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                    uconnector.getEnds().add(ce1);
                    this.sysphsutil.updatePropertyPath(ce1, lp1);
                    continue;
                }
                log.error("Modification without assigned value or reference");
            }
        }
        return uproperty;
    }

    private Pseudostate createInitialState(MComponent mcomponent) {
        if (mcomponent == null) {
            throw new IllegalArgumentException("The component should not be null");
        }
        if (ModelicaToSysMLTranslator.getTranslatedType(mcomponent) != TranslatedType.INITIALSTATE) {
            throw new IllegalStateException("The method can only be called on an initial state");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mcomponent);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Pseudostate) {
                return (Pseudostate)uelement;
            }
            throw new IllegalStateException("The element is not an initial state: " + mcomponent.getName());
        }
        log.info("Creating initial pseudostate " + mcomponent.getName());
        Pseudostate upseudostate = UMLFactory.eINSTANCE.createPseudostate();
        this.refs.put(key, upseudostate);
        this.toProcess.add(key);
        return upseudostate;
    }

    private Pseudostate processInitialState(MComponent mcomponent) {
        Pseudostate upseudostate = this.createInitialState(mcomponent);
        log.info("Processing initial pseudostate " + mcomponent.getName());
        SysPhSUtil.setName(upseudostate, mcomponent.getName());
        return upseudostate;
    }

    private State createState(MComponent mcomponent) {
        if (mcomponent == null) {
            throw new IllegalArgumentException("The component should not be null");
        }
        if (ModelicaToSysMLTranslator.getTranslatedType(mcomponent) != TranslatedType.STATE) {
            throw new IllegalStateException("The method can only be called on a state");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mcomponent);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof State) {
                return (State)uelement;
            }
            throw new IllegalStateException("The element is not a state: " + mcomponent.getName());
        }
        log.info("Creating state " + mcomponent.getName());
        State ustate = UMLFactory.eINSTANCE.createState();
        this.refs.put(key, ustate);
        this.toProcess.add(key);
        return ustate;
    }

    private State processState(MComponent mcomponent) {
        State ustate = this.createState(mcomponent);
        log.info("Processing state " + mcomponent.getName());
        SysPhSUtil.setName(ustate, mcomponent.getName());
        return ustate;
    }

    private Transition createTransition(MComponent mcomponent) {
        if (mcomponent == null) {
            throw new IllegalArgumentException("The component should not be null");
        }
        if (ModelicaToSysMLTranslator.getTranslatedType(mcomponent) != TranslatedType.TRANSITION) {
            throw new IllegalStateException("The method can only be called on a transition");
        }
        ReferenceKey key = ModelicaToSysMLTranslator.getKey(mcomponent);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Transition) {
                return (Transition)uelement;
            }
            throw new IllegalStateException("The element is not a transition: " + mcomponent.getName());
        }
        log.info("Creating transition " + mcomponent.getName());
        Transition utransition = UMLFactory.eINSTANCE.createTransition();
        this.refs.put(key, utransition);
        this.toProcess.add(key);
        return utransition;
    }

    private Transition processTransition(MComponent mcomponent) {
        Transition utransition = this.createTransition(mcomponent);
        log.info("Processing transition " + mcomponent.getName());
        return utransition;
    }

    private Class getPortType(MClass mclass) {
        Class ret = this.porttypes.get(mclass);
        if (ret != null) {
            return ret;
        }
        Classifier uclassifier = this.createClass(mclass);
        Class porttype = UMLFactory.eINSTANCE.createClass();
        this.root.getPackagedElements().add(porttype);
        porttype.applyStereotype(this.sysphsutil.getBlock());
        SysPhSUtil.setName(porttype, "PhS" + mclass.getName());
        Property fp = UMLFactory.eINSTANCE.createProperty();
        porttype.getOwnedAttributes().add(fp);
        SysPhSUtil.setName(fp, "phs" + mclass.getName());
        fp.applyStereotype(this.sysphsutil.getFlowProperty());
        for (MExtension mext : mclass.getExtensions()) {
            if (mext.getDirection() == MDirection.INPUT) {
                fp.setValue(this.sysphsutil.getFlowProperty(), "direction", this.sysphsutil.getFlowPropertyIn());
                fp.applyStereotype(this.sysphsutil.getPhSVariable());
                continue;
            }
            if (mext.getDirection() != MDirection.OUTPUT) continue;
            fp.setValue(this.sysphsutil.getFlowProperty(), "direction", this.sysphsutil.getFlowPropertyOut());
            fp.applyStereotype(this.sysphsutil.getPhSVariable());
        }
        fp.setType(uclassifier);
        this.porttypes.put(mclass, porttype);
        return porttype;
    }

    private static ValueSpecification getValueSpecification(MDataValue value) {
        if (value instanceof MRealValue) {
            LiteralReal lr = UMLFactory.eINSTANCE.createLiteralReal();
            lr.setValue(((MRealValue)value).getValue());
            return lr;
        }
        if (value instanceof MIntegerValue) {
            LiteralInteger li = UMLFactory.eINSTANCE.createLiteralInteger();
            li.setValue(((LiteralInteger)((Object)value)).getValue());
            return li;
        }
        if (value instanceof MBooleanValue) {
            LiteralBoolean lb = UMLFactory.eINSTANCE.createLiteralBoolean();
            lb.setValue(((MBooleanValue)value).isValue());
            return lb;
        }
        if (value instanceof MExpressionValue) {
            OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe.getBodies().add(((MExpressionValue)value).getValue());
            oe.getLanguages().add("sysphs");
            return oe;
        }
        return null;
    }

    private static enum TranslatedType {
        BLOCK,
        SIMBLOCK,
        DATATYPE,
        COMPONENT,
        STATEMACHINE,
        INITIALSTATE,
        STATE,
        TRANSITION,
        NONE;

    }

    protected static class ReferenceKey {
        private MNamedElement[] key;

        public ReferenceKey(MNamedElement[] key) {
            this.key = (MNamedElement[])key.clone();
        }

        public MNamedElement[] getKey() {
            return (MNamedElement[])this.key.clone();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReferenceKey) {
                ReferenceKey rk = (ReferenceKey)obj;
                if (rk.key.length != this.key.length) {
                    return false;
                }
                for (int i = 0; i < this.key.length; ++i) {
                    if (rk.key[i] == this.key[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (MNamedElement melem : this.key) {
                sb.append(melem.getName() + " ");
            }
            return sb.toString();
        }
    }
}

