/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.language.simscape;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SConversion implements Enumerator
{
    ABSOLUTE(0, "absolute", "absolute"),
    RELATIVE(1, "relative", "relative");

    public static final int ABSOLUTE_VALUE = 0;
    public static final int RELATIVE_VALUE = 1;
    private static final SConversion[] VALUES_ARRAY;
    public static final List<SConversion> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SConversion get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SConversion result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SConversion getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SConversion result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SConversion get(int value) {
        switch (value) {
            case 0: {
                return ABSOLUTE;
            }
            case 1: {
                return RELATIVE;
            }
        }
        return null;
    }

    private SConversion(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public String serialize() {
        switch (this) {
            case ABSOLUTE: {
                return "absolute";
            }
            case RELATIVE: {
                return "relative";
            }
        }
        return null;
    }

    static {
        VALUES_ARRAY = new SConversion[]{ABSOLUTE, RELATIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

