/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.deserialization.simulink.StateflowXMLReaderPass1;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SConnectNode;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.StateflowFactory;
import com.engisis.sysphs.util.Util;
import com.engisis.sysphs.util.XMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class StateflowXMLReaderPass2
extends XMLReader
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(StateflowXMLReaderPass2.class);
    private Collection<SimulinkReference> references;
    private Hashtable<Integer, SElement> ids;
    private InputStream is;

    public StateflowXMLReaderPass2(StateflowXMLReaderPass1 sxmlr, InputStream inputStream) {
        this.references = sxmlr.getReferences();
        this.ids = sxmlr.getIDs();
        this.is = inputStream;
    }

    @Override
    public void process() {
        try {
            XmlPullParserFactory xmlppf = XmlPullParserFactory.newInstance();
            this.xmlpp = xmlppf.newPullParser();
            this.xmlpp.setInput(this.is, null);
            this.lookForElement("ModelInformation");
            this.processModelInformation();
        }
        catch (XmlPullParserException e) {
            log.error(e);
        }
        catch (IOException e) {
            log.error(e);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {}
        }
    }

    private void processModelInformation() throws XmlPullParserException, IOException {
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("Stateflow")) {
                this.processStateflow();
                continue;
            }
            this.skipToEnd();
        }
    }

    private SStateflow processStateflow() throws XmlPullParserException, IOException {
        SStateflow sstateflow = StateflowFactory.eINSTANCE.createSStateflow();
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("instance")) {
                this.processInstance();
                continue;
            }
            if (name.equals("machine")) {
                this.processMachine();
                continue;
            }
            this.skipToEnd();
        }
        return sstateflow;
    }

    private void processInstance() throws XmlPullParserException, IOException {
        log.info("Resolving Instance");
        String sid = this.xmlpp.getAttributeValue(null, "ID");
        SElement selement = this.getElement(sid);
        if (selement instanceof SInstance) {
            SInstance sinstance = (SInstance)selement;
            int depth = this.xmlpp.getDepth();
            int et = this.xmlpp.getEventType();
            while (et != 3 || depth != this.xmlpp.getDepth()) {
                if (et != 2) continue;
                if (this.xmlpp.getName().equals("P")) {
                    String name = this.xmlpp.getAttributeValue(null, "Name");
                    String val = this.xmlpp.nextText();
                    if ("machine".equals(name)) {
                        selement = this.getElement(val);
                        if (!(selement instanceof SMachine)) continue;
                        sinstance.setMachine((SMachine)selement);
                        continue;
                    }
                    if (!"chart".equals(name) || !((selement = this.getElement(val)) instanceof SChart)) continue;
                    sinstance.setChart((SChart)selement);
                    continue;
                }
                this.skipToEnd();
            }
        }
    }

    private void processMachine() throws XmlPullParserException, IOException {
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("Children")) {
                int depth2 = this.xmlpp.getDepth();
                while (et != 3 || depth2 != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (et != 2) continue;
                    name = this.xmlpp.getName();
                    if (name.equals("chart")) {
                        this.processChart();
                        continue;
                    }
                    this.skipToEnd();
                }
                continue;
            }
            this.skipToEnd();
        }
    }

    private void processChart() throws XmlPullParserException, IOException {
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("Children")) {
                int depth2 = this.xmlpp.getDepth();
                while (et != 3 || depth2 != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (et != 2) continue;
                    String name2 = this.xmlpp.getName();
                    if (name2.equals("transition")) {
                        this.processTransition();
                        continue;
                    }
                    this.skipToEnd();
                }
                continue;
            }
            this.skipToEnd();
        }
    }

    private void processTransition() throws XmlPullParserException, IOException {
        String sid = this.xmlpp.getAttributeValue(null, "SSID");
        SElement selement = this.getElement(sid);
        if (selement instanceof STransition) {
            log.info("Resolving Transition");
            STransition stransition = (STransition)selement;
            int depth = this.xmlpp.getDepth();
            int et = this.xmlpp.getEventType();
            while (et != 3 || depth != this.xmlpp.getDepth()) {
                int depth2;
                et = this.xmlpp.next();
                if (et != 2) continue;
                String name = this.xmlpp.getName();
                if (name.equals("src")) {
                    depth2 = this.xmlpp.getDepth();
                    while (et != 3 || this.xmlpp.getDepth() != depth2) {
                        et = this.xmlpp.next();
                        if (et != 2 || !this.xmlpp.getName().equals("P") || !"SSID".equals(name = this.xmlpp.getAttributeValue(null, "Name"))) continue;
                        selement = this.getElement(this.xmlpp.nextText());
                        if (selement instanceof SConnectNode) {
                            log.info("Setting transition source");
                            stransition.setSrc((SConnectNode)((Object)selement));
                            continue;
                        }
                        log.error("Unable to set transition source");
                    }
                    continue;
                }
                if (name.equals("dst")) {
                    depth2 = this.xmlpp.getDepth();
                    while (et != 3 || this.xmlpp.getDepth() != depth2) {
                        et = this.xmlpp.next();
                        if (et != 2 || !this.xmlpp.getName().equals("P") || !"SSID".equals(name = this.xmlpp.getAttributeValue(null, "Name"))) continue;
                        selement = this.getElement(this.xmlpp.nextText());
                        if (selement instanceof SConnectNode) {
                            log.info("Setting transition target");
                            stransition.setDst((SConnectNode)((Object)selement));
                            continue;
                        }
                        log.error("Unable to set transition target");
                    }
                    continue;
                }
                this.skipToEnd();
            }
        }
    }

    private SElement getElement(String sid) {
        return this.ids.get(Util.toInt(sid, 0));
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    public void setIDs(Hashtable<Integer, SElement> ids) {
        this.ids = ids;
    }

    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public SElement getRootElement() {
        return null;
    }
}

