/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.generation.simulink.SimscapeBaseListener;
import com.engisis.sysphs.generation.simulink.SimscapeParser;
import com.engisis.sysphs.language.simscape.SBranch;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SConnection;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SEquation;
import com.engisis.sysphs.language.simscape.SInput;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAccess;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SOutput;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

public class SimscapeReaderPass1
extends SimscapeBaseListener
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(SimscapeReaderPass1.class);
    private Collection<SimulinkReference> references;
    private ParseTreeProperty<SElement> objects;
    private ParseTreeProperty<ParseTree> exprs;
    private Hashtable<SElement, ParseTree> expressions;
    private SComponent scomponent = null;
    private SDomain sdomain = null;
    private ParserRuleContext prc;
    private CommonTokenStream cts;

    public SimscapeReaderPass1(CommonTokenStream cts, ParserRuleContext prc) {
        this.cts = cts;
        this.prc = prc;
        this.references = new LinkedList<SimulinkReference>();
        this.objects = new ParseTreeProperty();
        this.exprs = new ParseTreeProperty();
    }

    public void setExpressions(Hashtable<SElement, ParseTree> expressions) {
        this.expressions = expressions;
    }

    @Override
    public void process() {
        new ParseTreeWalker().walk(this, this.prc);
    }

    @Override
    public void enterComponent(SimscapeParser.ComponentContext ctx) {
        log.info("Defining component " + ctx.ID().getText());
        this.scomponent = SimscapeFactory.eINSTANCE.createSComponent();
        this.objects.put(ctx, this.scomponent);
        SimulinkUtil.setName(this.scomponent, ctx.ID().getText());
        if (ctx.reference() != null) {
            this.references.add(new SimulinkReference(this.scomponent, ctx.reference().getText(), SimulinkReference.ReferenceType.COMPONENT));
        }
    }

    @Override
    public void enterDomain(SimscapeParser.DomainContext ctx) {
        log.info("Defining domain " + ctx.ID());
        this.sdomain = SimscapeFactory.eINSTANCE.createSDomain();
        this.objects.put(ctx, this.sdomain);
        SimulinkUtil.setName(this.sdomain, ctx.ID().getText());
    }

    @Override
    public void enterNodes(SimscapeParser.NodesContext ctx) {
        for (int i = 0; i < ctx.declaration().size(); ++i) {
            SimscapeParser.DeclarationContext dc = ctx.declaration(i);
            String name = dc.ID().getText();
            log.info("Defining node " + name);
            SNode snode = SimscapeFactory.eINSTANCE.createSNode();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(snode);
            }
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(snode);
            scpb.setOwningSystem(this.scomponent);
            SimulinkUtil.setName(snode, name);
            this.objects.put(dc, snode);
            Token semi = ctx.SEMI(i).getSymbol();
            int j = semi.getTokenIndex();
            List<Token> lts = this.cts.getHiddenTokensToRight(j, 1);
            if (lts != null) {
                String str = lts.get(0).getText();
                if (str.contains(":left")) {
                    snode.setLocation(SLocation.LEFT);
                    scpb.setLocation(SLocation.LEFT);
                } else if (str.contains(":right")) {
                    snode.setLocation(SLocation.RIGHT);
                    scpb.setLocation(SLocation.RIGHT);
                }
            }
            this.references.add(new SimulinkReference(snode, dc.expr().getText(), SimulinkReference.ReferenceType.DOMAIN));
        }
    }

    @Override
    public void enterVariables(SimscapeParser.VariablesContext ctx) {
        SMemberAccess access = SMemberAccess.PUBLIC;
        boolean balancing = false;
        if (ctx.modifiers() != null) {
            for (SimscapeParser.DeclarationContext ac : ctx.modifiers().declaration()) {
                if (ac.ID().getText().equals("Access")) {
                    String val = ac.expr().getText();
                    if (val.equals("private")) {
                        access = SMemberAccess.PRIVATE;
                        continue;
                    }
                    if (!val.equals("protected")) continue;
                    access = SMemberAccess.PROTECTED;
                    continue;
                }
                if (!ac.ID().getText().equals("Balancing") || !ac.expr().getText().equals("true")) continue;
                balancing = true;
            }
        }
        for (SimscapeParser.DeclarationContext dc : ctx.declaration()) {
            String name = dc.ID().getText();
            log.info("Defining variable " + name);
            SVariable svariable = SimscapeFactory.eINSTANCE.createSVariable();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(svariable);
            }
            if (this.sdomain != null) {
                this.sdomain.getVariables().add(svariable);
            }
            this.objects.put(dc, svariable);
            SimulinkUtil.setName(svariable, name);
            svariable.setAccess(access);
            svariable.setBalancing(balancing);
        }
    }

    @Override
    public void exitVariables(SimscapeParser.VariablesContext ctx) {
        for (SimscapeParser.DeclarationContext dc : ctx.declaration()) {
            SVariable svariable = (SVariable)this.objects.get(dc);
            this.setMemberValue(svariable, dc.expr());
        }
    }

    @Override
    public void enterParameters(SimscapeParser.ParametersContext ctx) {
        SMemberAccess access = SMemberAccess.PUBLIC;
        if (ctx.modifiers() != null) {
            for (SimscapeParser.DeclarationContext ac : ctx.modifiers().declaration()) {
                if (!ac.ID().equals("Access")) continue;
                String val = ac.expr().getText();
                if (val.equals("private")) {
                    access = SMemberAccess.PRIVATE;
                    continue;
                }
                if (!val.equals("protected")) continue;
                access = SMemberAccess.PROTECTED;
            }
        }
        for (SimscapeParser.DeclarationContext dc : ctx.declaration()) {
            String name = dc.ID().getText();
            log.info("Defining parameter " + name);
            SParameter sparameter = SimscapeFactory.eINSTANCE.createSParameter();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(sparameter);
            }
            if (this.sdomain != null) {
                this.sdomain.getParameters().add(sparameter);
            }
            SimulinkUtil.setName(sparameter, name);
            this.objects.put(dc, sparameter);
            sparameter.setAccess(access);
        }
    }

    @Override
    public void exitParameters(SimscapeParser.ParametersContext ctx) {
        for (SimscapeParser.DeclarationContext dc : ctx.declaration()) {
            SParameter sparameter = (SParameter)this.objects.get(dc);
            this.setMemberValue(sparameter, dc.expr());
        }
    }

    @Override
    public void enterInputs(SimscapeParser.InputsContext ctx) {
        for (int i = 0; i < ctx.declaration().size(); ++i) {
            SimscapeParser.DeclarationContext dc = ctx.declaration(i);
            String name = dc.ID().getText();
            log.info("Defining input " + name);
            SInput sinput = SimscapeFactory.eINSTANCE.createSInput();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(sinput);
            }
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(sinput);
            scpb.setOwningSystem(this.scomponent);
            SimulinkUtil.setName(sinput, name);
            this.objects.put(dc, sinput);
            sinput.setLocation(SLocation.LEFT);
            scpb.setLocation(SLocation.LEFT);
        }
    }

    @Override
    public void exitInputs(SimscapeParser.InputsContext ctx) {
        for (int i = 0; i < ctx.declaration().size(); ++i) {
            SimscapeParser.DeclarationContext dc = ctx.declaration(i);
            SInput sinput = (SInput)this.objects.get(dc);
            this.setMemberValue(sinput, dc.expr());
        }
    }

    @Override
    public void enterOutputs(SimscapeParser.OutputsContext ctx) {
        for (int i = 0; i < ctx.declaration().size(); ++i) {
            SimscapeParser.DeclarationContext dc = ctx.declaration(i);
            String name = dc.ID().getText();
            log.info("Defining output " + name);
            SOutput soutput = SimscapeFactory.eINSTANCE.createSOutput();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(soutput);
            }
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(soutput);
            scpb.setOwningSystem(this.scomponent);
            SimulinkUtil.setName(soutput, name);
            this.objects.put(dc, soutput);
            soutput.setLocation(SLocation.RIGHT);
            scpb.setLocation(SLocation.RIGHT);
        }
    }

    @Override
    public void exitOutputs(SimscapeParser.OutputsContext ctx) {
        for (int i = 0; i < ctx.declaration().size(); ++i) {
            SimscapeParser.DeclarationContext dc = ctx.declaration(i);
            SOutput soutput = (SOutput)this.objects.get(dc);
            this.setMemberValue(soutput, dc.expr());
        }
    }

    @Override
    public void enterComponents(SimscapeParser.ComponentsContext ctx) {
        for (SimscapeParser.DeclarationContext dc : ctx.declaration()) {
            String name = dc.ID().getText();
            SComponentReference scomponentreference = SimscapeFactory.eINSTANCE.createSComponentReference();
            if (this.scomponent != null) {
                this.scomponent.getOwnedMembers().add(scomponentreference);
            }
            SimulinkUtil.setName(scomponentreference, name);
            this.objects.put(dc, scomponentreference);
            this.references.add(new SimulinkReference(scomponentreference, dc.expr().getText(), SimulinkReference.ReferenceType.COMPONENT));
        }
    }

    @Override
    public void enterEquations(SimscapeParser.EquationsContext ctx) {
        if (this.scomponent == null) {
            return;
        }
        for (SimscapeParser.EquationContext eq : ctx.equation()) {
            SEquation seq = SimscapeFactory.eINSTANCE.createSEquation();
            this.objects.put(eq, seq);
            seq.setExpression(eq.getText());
            this.scomponent.getOwnedEquations().add(seq);
            if (this.expressions == null) continue;
            this.expressions.put(seq, eq);
        }
    }

    @Override
    public void enterConnections(SimscapeParser.ConnectionsContext ctx) {
        if (this.scomponent == null) {
            return;
        }
        for (SimscapeParser.ConnectionContext cc : ctx.connection()) {
            SConnection sc = SimscapeFactory.eINSTANCE.createSConnection();
            this.objects.put(cc, sc);
            this.scomponent.getOwnedConnections().add(sc);
        }
    }

    @Override
    public void enterBranches(SimscapeParser.BranchesContext ctx) {
        if (this.scomponent == null) {
            return;
        }
        for (SimscapeParser.BranchContext bc : ctx.branch()) {
            SBranch sbranch = SimscapeFactory.eINSTANCE.createSBranch();
            this.objects.put(bc, sbranch);
            this.scomponent.getBranches().add(sbranch);
        }
    }

    @Override
    public void exitExpr(SimscapeParser.ExprContext ctx) {
        if (ctx.expr2().size() == 1) {
            this.assignProperty(ctx, ctx.expr2(0));
        }
    }

    @Override
    public void exitExpr2(SimscapeParser.Expr2Context ctx) {
        if (ctx.expr3().size() == 1) {
            this.assignProperty(ctx, ctx.expr3(0));
        }
    }

    @Override
    public void exitExpr3(SimscapeParser.Expr3Context ctx) {
        if (ctx.expr4().size() == 1) {
            this.assignProperty(ctx, ctx.expr4(0));
        }
    }

    @Override
    public void exitExpr4(SimscapeParser.Expr4Context ctx) {
        if (ctx.expr5().size() == 1) {
            this.assignProperty(ctx, ctx.expr5(0));
        }
    }

    @Override
    public void exitExpr5(SimscapeParser.Expr5Context ctx) {
        if (ctx.expr6().size() == 1) {
            this.assignProperty(ctx, ctx.expr6(0));
        }
    }

    @Override
    public void exitExpr6(SimscapeParser.Expr6Context ctx) {
        if (ctx.expr7().size() == 1) {
            this.assignProperty(ctx, ctx.expr7(0));
        }
    }

    @Override
    public void exitExpr7(SimscapeParser.Expr7Context ctx) {
        if (ctx.expr8().size() == 1) {
            this.assignProperty(ctx, ctx.expr8(0));
        }
    }

    @Override
    public void exitExpr8(SimscapeParser.Expr8Context ctx) {
        if (ctx.expr9().size() == 1) {
            this.assignProperty(ctx, ctx.expr9(0));
        }
    }

    @Override
    public void exitExpr9(SimscapeParser.Expr9Context ctx) {
        if (ctx.unary() == null) {
            this.assignProperty(ctx, ctx.expr10());
        }
    }

    @Override
    public void exitExpr10(SimscapeParser.Expr10Context ctx) {
        if (ctx.expr11().size() == 1) {
            this.assignProperty(ctx, ctx.expr11(0));
        }
    }

    @Override
    public void exitExpr11(SimscapeParser.Expr11Context ctx) {
        if (ctx.INT() != null) {
            this.exprs.put(ctx, ctx.INT());
        } else if (ctx.FLOAT() != null) {
            this.exprs.put(ctx, ctx.FLOAT());
        } else if (ctx.BOOL() != null) {
            this.exprs.put(ctx, ctx.BOOL());
        } else if (ctx.STRING() != null) {
            this.exprs.put(ctx, ctx.STRING());
        } else if (ctx.array() != null) {
            this.exprs.put(ctx, ctx.array());
        } else if (ctx.reference() != null) {
            this.exprs.put(ctx, ctx.reference());
        } else if (ctx.expr() != null) {
            this.exprs.put(ctx, ctx.expr());
        } else if (ctx.object() != null) {
            this.exprs.put(ctx, ctx.object());
        }
    }

    private void setMemberValue(SMember smember, SimscapeParser.ExprContext expr) {
        SDataValue sdv = null;
        String unit = null;
        ParseTree pt = this.exprs.get(expr);
        if (pt instanceof TerminalNode) {
            sdv = this.getValue(expr);
        } else if (pt instanceof SimscapeParser.ObjectContext) {
            SimscapeParser.ObjectContext oc = (SimscapeParser.ObjectContext)pt;
            if (oc.val().size() == 1) {
                if (oc.val(0).ID().getText().equals("value")) {
                    ParseTree exp = this.exprs.get(oc.val(0).expr());
                    if (exp instanceof SimscapeParser.ObjectContext) {
                        SimscapeParser.ObjectContext oc2 = (SimscapeParser.ObjectContext)exp;
                        if (oc2.val().size() == 2) {
                            sdv = this.getValue(oc2.val(0));
                            unit = SimscapeReaderPass1.getUnit(this.exprs.get(oc2.val(1)));
                        } else {
                            log.error("Expecting two values in object " + oc2.getText());
                        }
                    } else {
                        log.error("Expecting object for value " + oc.getText());
                    }
                } else {
                    log.error("Expecting value key for object " + oc.getText());
                }
            } else if (oc.val().size() == 2) {
                for (int i = 0; i < oc.val().size(); ++i) {
                    if (oc.val(i).ID() == null) {
                        if (i == 0) {
                            sdv = this.getValue(oc.val(i).expr());
                            continue;
                        }
                        unit = SimscapeReaderPass1.getUnit(this.exprs.get(oc.val(i).expr()));
                        continue;
                    }
                    if (oc.val(i).ID().getText().equals("value")) {
                        ParseTree exp = this.exprs.get(oc.val(i).expr());
                        if (exp instanceof SimscapeParser.ObjectContext) {
                            SimscapeParser.ObjectContext oc2 = (SimscapeParser.ObjectContext)exp;
                            if (oc2.val().size() == 2) {
                                sdv = this.getValue(oc2.val(0));
                                unit = SimscapeReaderPass1.getUnit(this.exprs.get(oc2.val(1)));
                                continue;
                            }
                            log.error("Expecting two values in object " + oc2.getText());
                            continue;
                        }
                        log.error("Expecting object for value " + exp.getText());
                        continue;
                    }
                    log.warn("Unexpected key " + oc.val(i).getText());
                }
            } else {
                log.error("Expecting object of size 1 or 2 " + oc.getText());
            }
        }
        if (smember instanceof SVariable) {
            log.info("Assigning value " + sdv + " and unit " + unit + " to variable " + smember.getName());
            SVariable sv = (SVariable)smember;
            sv.setValue(sdv);
            sv.setUnit(unit);
        } else if (smember instanceof SParameter) {
            log.info("Assigning value " + sdv + " and unit " + unit + " to parameter " + smember.getName());
            SParameter sp = (SParameter)smember;
            sp.setValue(sdv);
            sp.setUnit(unit);
        } else if (smember instanceof SInput) {
            log.info("Assigning value " + sdv + " and unit " + unit + " to input " + smember.getName());
            SInput si = (SInput)smember;
            si.setValue(sdv);
            si.setUnit(unit);
        } else if (smember instanceof SOutput) {
            log.info("Assigning value " + sdv + " and unit " + unit + " to output " + smember.getName());
            SOutput so = (SOutput)smember;
            so.setValue(sdv);
            so.setUnit(unit);
        }
    }

    public SDataValue getValue(ParseTree pt) {
        ParseTree expr = this.exprs.get(pt);
        if (expr == null) {
            log.warn("No value for " + pt.getText());
        } else if (expr instanceof TerminalNode) {
            TerminalNode tn = (TerminalNode)expr;
            if (tn.getSymbol().getType() == 65 || tn.getSymbol().getType() == 66) {
                SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
                sdv.setValue(Double.parseDouble(tn.getText()));
                return sdv;
            }
            log.warn("Can't parse variable value " + tn.getText());
        } else {
            log.warn("Unrecognized value " + expr.getText());
        }
        return null;
    }

    static String getUnit(ParseTree pt) {
        if (pt instanceof TerminalNode && ((TerminalNode)pt).getSymbol().getType() == 68) {
            String sunit = pt.getText();
            return sunit.substring(1, sunit.length() - 1);
        }
        return null;
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    private void assignProperty(ParseTree from, ParseTree to) {
        this.exprs.put(from, this.exprs.get(to));
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public SElement getRootElement() {
        return this.scomponent != null ? this.scomponent : this.sdomain;
    }

    public ParseTreeProperty<SElement> getObjects() {
        return this.objects;
    }
}

