/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.modelica;

import com.engisis.sysphs.deserialization.modelica.ModelicaReaderPass1;
import com.engisis.sysphs.deserialization.modelica.ModelicaReaderPass2;
import com.engisis.sysphs.deserialization.modelica.ModelicaScope;
import com.engisis.sysphs.generation.modelica.ModelicaBaseListener;
import com.engisis.sysphs.generation.modelica.ModelicaLexer;
import com.engisis.sysphs.generation.modelica.ModelicaParser;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MElement;
import com.engisis.sysphs.translation.modelica.ModelicaUtil;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ModelicaDeserializer
extends ModelicaBaseListener {
    private List<MClass> classes;
    private Hashtable<MElement, ParseTree> expressions;

    public ModelicaDeserializer(File file) throws IOException {
        ModelicaLexer ml = new ModelicaLexer(new ANTLRFileStream(file.getAbsolutePath()));
        CommonTokenStream cts = new CommonTokenStream(ml);
        ModelicaParser mp = new ModelicaParser(cts);
        ModelicaParser.Stored_definitionContext tree = mp.stored_definition();
        ParseTreeWalker ptw = new ParseTreeWalker();
        ModelicaScope globalscope = new ModelicaScope("");
        ModelicaScope msstring = new ModelicaScope("String");
        msstring.setMNamedElement(ModelicaUtil.getString());
        msstring.setParent(globalscope);
        ModelicaScope msreal = new ModelicaScope("Real");
        msreal.setMNamedElement(ModelicaUtil.getReal());
        msreal.setParent(globalscope);
        ModelicaScope msboolean = new ModelicaScope("Boolean");
        msboolean.setMNamedElement(ModelicaUtil.getBoolean());
        msboolean.setParent(globalscope);
        ModelicaScope msinteger = new ModelicaScope("Integer");
        msinteger.setMNamedElement(ModelicaUtil.getInteger());
        msinteger.setParent(globalscope);
        ModelicaScope msinitialstep = new ModelicaScope(ModelicaUtil.getInitialStep().getName());
        msinitialstep.setMNamedElement(ModelicaUtil.getInitialStep());
        msinitialstep.setParent(globalscope);
        ModelicaScope msstep = new ModelicaScope(ModelicaUtil.getStep().getName());
        msstep.setMNamedElement(ModelicaUtil.getStep());
        msstep.setParent(globalscope);
        ModelicaScope mstransition = new ModelicaScope(ModelicaUtil.getTransition().getName());
        mstransition.setMNamedElement(ModelicaUtil.getTransition());
        mstransition.setParent(globalscope);
        ModelicaReaderPass1 mpd = new ModelicaReaderPass1(globalscope);
        ptw.walk(mpd, tree);
        mpd.resolve();
        ModelicaReaderPass2 mpr = new ModelicaReaderPass2(mpd);
        ptw.walk(mpr, tree);
        this.classes = globalscope.getAllMClasses();
        this.expressions = mpd.getExpressions();
    }

    public List<MClass> getClasses() {
        return this.classes;
    }

    public Hashtable<MElement, ParseTree> getExpressions() {
        return this.expressions;
    }
}

