/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs;

import com.engisis.sysphs.util.SysMLPreProcessor;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.sysphs.util.SysPhSUtil;
import com.engisis.xmiutil.EMFUtil;
import com.engisis.xmiutil.SysMLUtil;
import com.engisis.xmiutil.UMLModelErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class SysMLToSimulationTranslationManager {
    private static final Logger log = Logger.getLogger(SysMLToSimulationTranslationManager.class);
    private Class rootclass;
    private String rootclassname;
    private Resource resource;
    private SysMLToSimulationTranslator translator;
    private File outputdirectory;
    private boolean preproc = false;
    private boolean preprocdone = false;

    public SysMLToSimulationTranslationManager(String model, String[] paths) throws IOException, FileNotFoundException, UMLModelErrorException, XMLStreamException {
        if (model == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        ArrayList<URI> lpaths = new ArrayList<URI>();
        if (paths != null) {
            for (String path : paths) {
                File fpath = new File(path);
                lpaths.add(URI.createFileURI(fpath.getAbsolutePath() + File.separator));
            }
        }
        ResourceSet rs = EMFUtil.createResourceSet();
        this.resource = EMFUtil.loadResourceWithDependencies(rs, URI.createFileURI(new File(model).getAbsolutePath()), lpaths);
        if (rs.getPackageRegistry().get(SysMLUtil.nsSysML.toString()) == null) {
            throw new UMLModelErrorException(this.resource, "The model doesn't import the SysML profile");
        }
        if (rs.getPackageRegistry().get(SysPhSUtil.nsSysPhS.toString()) == null) {
            throw new UMLModelErrorException(this.resource, "The model doesn't import the SysPhS profile");
        }
    }

    public List<String> getClasses() {
        LinkedList<String> ret = new LinkedList<String>();
        TreeIterator<EObject> iter = this.resource.getAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (!(eo instanceof NamedElement)) {
                iter.prune();
                continue;
            }
            if (!(eo instanceof Class)) continue;
            ret.add(((Class)eo).getQualifiedName());
        }
        return ret;
    }

    public void setInputRootName(String rootclass) throws UMLModelErrorException {
        if (rootclass == null) {
            throw new IllegalArgumentException("The root element can't be null");
        }
        this.rootclassname = rootclass;
        String[] fqname = rootclass.split("::");
        Model umodel = null;
        for (EObject object : this.resource.getContents()) {
            if (!(object instanceof Model) || !fqname[0].equals(((Model)object).getName())) continue;
            umodel = (Model)object;
        }
        if (umodel == null) {
            throw new UMLModelErrorException(this.resource, "Could not find a root model in the XMI file named " + fqname[0]);
        }
        Namespace currentelement = umodel;
        NamedElement nerootblock = null;
        for (int i = 1; i < fqname.length; ++i) {
            String nextname = fqname[i];
            NamedElement nextelement = currentelement.getMember(nextname);
            if (nextelement == null) {
                log.error("Unknown element: " + currentelement.getQualifiedName() + "::" + fqname[i]);
                break;
            }
            if (rootclass.equals(nextelement.getQualifiedName())) {
                nerootblock = nextelement;
                continue;
            }
            if (nextelement instanceof Namespace) {
                currentelement = (Namespace)nextelement;
                continue;
            }
            log.error("Not a namespace: " + currentelement.getQualifiedName() + "::" + fqname[i]);
            break;
        }
        if (nerootblock == null) {
            throw new UMLModelErrorException(this.resource, "Could not find the root block in the model");
        }
        if (!(nerootblock instanceof Class)) {
            throw new UMLModelErrorException(this.resource, "The root block is not a Class");
        }
        this.rootclass = (Class)nerootblock;
    }

    public String getInputRootName() {
        return this.rootclassname;
    }

    public void setPreprocessing(boolean preproc) {
        this.preproc = preproc;
    }

    public void setOutputDirectory(File outputdirectory) {
        this.outputdirectory = outputdirectory;
    }

    public void setTranslator(SysMLToSimulationTranslator translator) {
        this.translator = translator;
    }

    public void execute() throws UMLModelErrorException, IOException {
        if (this.translator == null) {
            throw new IllegalStateException("A generator must be provided first");
        }
        if (this.rootclass == null) {
            throw new IllegalStateException("A root class must be provided first");
        }
        log.info("started");
        if (this.preproc && !this.preprocdone) {
            if (this.outputdirectory == null) {
                this.resource.setURI(this.resource.getURI().appendFileExtension("bak"));
            } else {
                this.resource.setURI(URI.createFileURI(this.outputdirectory.getAbsolutePath()).appendSegment(this.resource.getURI().lastSegment()).appendFileExtension("preprocessed"));
            }
            SysMLPreProcessor sysmlt = new SysMLPreProcessor(this.resource);
            sysmlt.execute();
            this.resource.save(null);
            this.preprocdone = true;
        }
        this.translator.execute(this.rootclass, this.resource, this.outputdirectory);
    }
}

