/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.binders;

import com.google.inject.spi.TypeEncounter;
import javax.inject.Provider;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.guice.bean.inject.PropertyBinder;
import org.sonatype.guice.bean.inject.PropertyBinding;
import org.sonatype.guice.bean.reflect.BeanProperty;
import org.sonatype.guice.plexus.binders.OptionalPropertyBinding;
import org.sonatype.guice.plexus.binders.PlexusBeanManager;
import org.sonatype.guice.plexus.binders.PlexusConfigurations;
import org.sonatype.guice.plexus.binders.PlexusRequirements;
import org.sonatype.guice.plexus.binders.ProvidedPropertyBinding;
import org.sonatype.guice.plexus.config.PlexusBeanMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusPropertyBinder
implements PropertyBinder {
    private static final boolean OPTIONAL_SUPPORTED;
    private final PlexusBeanManager manager;
    private final PlexusBeanMetadata metadata;
    private final PlexusConfigurations configurations;
    private final PlexusRequirements requirements;

    PlexusPropertyBinder(PlexusBeanManager manager, TypeEncounter<?> encounter, PlexusBeanMetadata metadata) {
        this.manager = manager;
        this.metadata = metadata;
        this.configurations = new PlexusConfigurations(encounter);
        this.requirements = new PlexusRequirements(encounter);
    }

    @Override
    public <T> PropertyBinding bindProperty(BeanProperty<T> property) {
        if (this.metadata.isEmpty()) {
            return PropertyBinder.LAST_BINDING;
        }
        Configuration configuration = this.metadata.getConfiguration(property);
        if (null != configuration) {
            Provider<T> valueProvider = this.configurations.lookup(configuration, property);
            return new ProvidedPropertyBinding<T>(property, valueProvider);
        }
        Requirement requirement = this.metadata.getRequirement(property);
        if (null != requirement) {
            PropertyBinding managedBinding;
            if (null != this.manager && null != (managedBinding = this.manager.manage(property))) {
                return managedBinding;
            }
            Provider<T> roleProvider = this.requirements.lookup(requirement, property);
            if (OPTIONAL_SUPPORTED && requirement.optional()) {
                return new OptionalPropertyBinding<T>(property, roleProvider);
            }
            return new ProvidedPropertyBinding<T>(property, roleProvider);
        }
        return null;
    }

    static {
        boolean optionalSupported = true;
        try {
            Requirement.class.getDeclaredMethod("optional", new Class[0]);
        }
        catch (Exception e) {
            optionalSupported = false;
        }
        catch (LinkageError e) {
            optionalSupported = false;
        }
        OPTIONAL_SUPPORTED = optionalSupported;
    }
}

