/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.BehaviorOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineOperations
extends BehaviorOperations {
    protected StateMachineOperations() {
    }

    public static boolean validateClassifierContext(StateMachine stateMachine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateContextClassifier(StateMachine stateMachine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static Region LCA(StateMachine stateMachine, Vertex s1, Vertex s2) {
        if (StateMachineOperations.ancestor(stateMachine, s1, s2)) {
            return s2.getContainer();
        }
        if (StateMachineOperations.ancestor(stateMachine, s2, s1)) {
            return s1.getContainer();
        }
        Region container1 = s1.getContainer();
        State state1 = container1 == null ? null : container1.getState();
        Region container2 = s2.getContainer();
        State state2 = container2 == null ? null : container2.getState();
        return state1 != null && state2 != null ? StateMachineOperations.LCA(stateMachine, state1, state2) : null;
    }

    public static boolean ancestor(StateMachine stateMachine, Vertex s1, Vertex s2) {
        if (s1 == s2) {
            return true;
        }
        Region container1 = s1.getContainer();
        if (container1 != null && container1.getStateMachine() != null) {
            return true;
        }
        Region container2 = s2.getContainer();
        if (container2 != null) {
            if (container2.getStateMachine() != null) {
                return false;
            }
            State state2 = container2.getState();
            if (state2 != null) {
                return StateMachineOperations.ancestor(stateMachine, s1, state2);
            }
        }
        return false;
    }

    public static State LCAState(StateMachine stateMachine, Vertex v1, Vertex v2) {
        if (v2 instanceof State && StateMachineOperations.ancestor(stateMachine, v1, v2)) {
            return (State)v2;
        }
        if (v1 instanceof State && StateMachineOperations.ancestor(stateMachine, v2, v1)) {
            return (State)v1;
        }
        Region container1 = v1.getContainer();
        State state1 = container1 == null ? null : container1.getState();
        Region container2 = v2.getContainer();
        State state2 = container2 == null ? null : container2.getState();
        return state1 == null || state2 == null ? null : StateMachineOperations.LCAState(stateMachine, state1, state2);
    }

    public static boolean validateConnectionPoints(StateMachine stateMachine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateMethod(StateMachine stateMachine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean isConsistentWith(StateMachine stateMachine, RedefinableElement redefiningElement) {
        if (redefiningElement != null && redefiningElement.isRedefinitionContextValid(stateMachine)) {
            StateMachine redefiningStateMachine = (StateMachine)redefiningElement;
            EList<Region> allRegions = StateMachineOperations.getAllRegions(stateMachine);
            for (Region redefiningRegion : redefiningStateMachine.getRegions()) {
                Region extendedRegion = redefiningRegion.getExtendedRegion();
                if (!allRegions.contains(extendedRegion) || extendedRegion.isConsistentWith(redefiningRegion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRedefinitionContextValid(StateMachine stateMachine, RedefinableElement redefinedElement) {
        if (redefinedElement instanceof StateMachine) {
            BehavioredClassifier context = stateMachine.getContext();
            return context != null && context.getRedefinedClassifiers().contains(((StateMachine)redefinedElement).getContext());
        }
        return false;
    }

    protected static EList<StateMachine> getAllExtendedStateMachines(StateMachine stateMachine, EList<StateMachine> allExtendedStateMachines) {
        for (StateMachine extendedStateMachine : stateMachine.getExtendedStateMachines()) {
            if (!allExtendedStateMachines.add(extendedStateMachine)) continue;
            StateMachineOperations.getAllExtendedStateMachines(extendedStateMachine, allExtendedStateMachines);
        }
        return allExtendedStateMachines;
    }

    protected static EList<StateMachine> getAllExtendedStateMachines(StateMachine stateMachine) {
        return StateMachineOperations.getAllExtendedStateMachines(stateMachine, new UniqueEList.FastCompare<StateMachine>());
    }

    protected static EList<Region> getAllRegions(StateMachine stateMachine) {
        UniqueEList.FastCompare<Region> allRegions = new UniqueEList.FastCompare<Region>(stateMachine.getRegions());
        for (StateMachine extendedStateMachine : StateMachineOperations.getAllExtendedStateMachines(stateMachine)) {
            allRegions.addAll(extendedStateMachine.getRegions());
        }
        return RedefinableElementOperations.excludeRedefinedElements(allRegions);
    }
}

