/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import com.engisis.xmiutil.EMFUtil;
import com.engisis.xmiutil.UMLModelErrorException;
import com.engisis.xmiutil.UMLUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class SysMLUtil
extends UMLUtil {
    private static final Logger log = Logger.getLogger(SysMLUtil.class);
    private Stereotype sblock;
    private Stereotype sconstraintblock;
    private Stereotype sbindingconnector;
    private Stereotype snestedconnectorend;
    private Stereotype svaluetype;
    private Class sunit;
    private Class squantitykind;
    private Stereotype spropertyspecifictype;
    private Stereotype sflowproperty;
    private Stereotype sinterfaceblock;
    private Stereotype sdirectedfeature;
    private Stereotype sconnectorproperty;
    private Stereotype sparticipantproperty;
    private Stereotype sadjunctproperty;
    private DataType sstring;
    private DataType sboolean;
    private DataType sinteger;
    private DataType sdouble;
    public static final URI nsSysML = URI.createURI("http://www.omg.org/spec/SysML/20181001/SysML");
    public static final URI urlSysML = URI.createURI("http://www.omg.org/spec/SysML/20181001/SysML.xmi");

    public SysMLUtil(ResourceSet rs) throws UMLModelErrorException {
        super(rs);
        this.loadSysML();
    }

    public void loadSysML() throws UMLModelErrorException {
        this.sblock = this.loadStereotype(nsSysML, "Block");
        this.sconstraintblock = this.loadStereotype(nsSysML, "ConstraintBlock");
        this.sbindingconnector = this.loadStereotype(nsSysML, "BindingConnector");
        this.snestedconnectorend = this.loadStereotype(nsSysML, "NestedConnectorEnd");
        this.svaluetype = this.loadStereotype(nsSysML, "ValueType");
        this.sunit = this.loadClass(nsSysML, "Unit");
        this.squantitykind = this.loadClass(nsSysML, "QuantityKind");
        this.spropertyspecifictype = this.loadStereotype(nsSysML, "PropertySpecificType");
        this.sflowproperty = this.loadStereotype(nsSysML, "FlowProperty");
        this.sinterfaceblock = this.loadStereotype(nsSysML, "InterfaceBlock");
        this.sdirectedfeature = this.loadStereotype(nsSysML, "DirectedFeature");
        this.sconnectorproperty = this.loadStereotype(nsSysML, "ConnectorProperty");
        this.sparticipantproperty = this.loadStereotype(nsSysML, "ParticipantProperty");
        this.sadjunctproperty = this.loadStereotype(nsSysML, "AdjunctProperty");
        this.sstring = this.loadDataType(urlSysML, "SysML_dataType.String");
        this.sboolean = this.loadDataType(urlSysML, "SysML_dataType.Boolean");
        this.sinteger = this.loadDataType(urlSysML, "SysML_dataType.Integer");
        this.sdouble = this.loadDataType(urlSysML, "SysML_dataType.Real");
    }

    protected Stereotype loadStereotype(URI namespace, String name) throws UMLModelErrorException {
        NamedElement namedelement = this.loadFromNamespaceAndName(namespace, name);
        if (!(namedelement instanceof Stereotype)) {
            throw new ClassCastException("The element named " + name + " in " + namespace + " is not a stereotype");
        }
        return (Stereotype)namedelement;
    }

    private Class loadClass(URI namespace, String name) throws UMLModelErrorException {
        NamedElement element = this.loadFromNamespaceAndName(namespace, name);
        if (!(element instanceof Class)) {
            throw new ClassCastException("The element named " + name + " in " + namespace + " is not a class");
        }
        return (Class)element;
    }

    public Stereotype getBlock() {
        return this.sblock;
    }

    public Stereotype getConstraintBlock() {
        return this.sconstraintblock;
    }

    public Stereotype getBindingConnector() {
        return this.sbindingconnector;
    }

    public Stereotype getNestedConnectorEnd() {
        return this.snestedconnectorend;
    }

    public Stereotype getValueType() {
        return this.svaluetype;
    }

    public Class getUnit() {
        return this.sunit;
    }

    public Class getQuantityKind() {
        return this.squantitykind;
    }

    public Stereotype getPropertySpecificType() {
        return this.spropertyspecifictype;
    }

    public Stereotype getFlowProperty() {
        return this.sflowproperty;
    }

    public EnumerationLiteral getFlowPropertyIn() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("in");
    }

    public EnumerationLiteral getFlowPropertyOut() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("out");
    }

    public EnumerationLiteral getFlowPropertyInout() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("inout");
    }

    public Stereotype getInterfaceBlock() {
        return this.sinterfaceblock;
    }

    public Stereotype getDirectedFeature() {
        return this.sdirectedfeature;
    }

    public Stereotype getConnectorProperty() {
        return this.sconnectorproperty;
    }

    public Stereotype getParticipantProperty() {
        return this.sparticipantproperty;
    }

    public Stereotype getAdjunctProperty() {
        return this.sadjunctproperty;
    }

    public DataType getSysMLString() {
        return this.sstring;
    }

    public DataType getSysMLBoolean() {
        return this.sboolean;
    }

    public DataType getSysMLInteger() {
        return this.sinteger;
    }

    public DataType getSysMLDouble() {
        return this.sdouble;
    }

    public List<Property> getPropertyPath(ConnectorEnd end) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (end.isStereotypeApplied(this.snestedconnectorend)) {
            List properties = (List)end.getValue(this.snestedconnectorend, "propertyPath");
            for (Object property : properties) {
                result.add((Property)property);
            }
        } else if (end.getPartWithPort() != null) {
            result.add(end.getPartWithPort());
        }
        if (!(end.getRole() instanceof Property)) {
            throw new IllegalArgumentException("The connector role " + end.getRole() + " should be a property");
        }
        result.add((Property)end.getRole());
        return result;
    }

    public void updatePropertyPath(ConnectorEnd end, List<Property> lp) {
        if (lp.size() > 0) {
            end.setRole(lp.get(lp.size() - 1));
        }
        if (lp.size() > 1) {
            ArrayList<Property> pp;
            if (!end.isStereotypeApplied(this.getNestedConnectorEnd())) {
                end.applyStereotype(this.getNestedConnectorEnd());
            }
            if ((pp = (ArrayList<Property>)end.getValue(this.getNestedConnectorEnd(), "propertyPath")) == null) {
                pp = new ArrayList<Property>(lp.size() - 1);
                end.setValue(this.getNestedConnectorEnd(), "propertyPath", pp);
            }
            pp.clear();
            for (int i = 0; i < lp.size() - 1; ++i) {
                pp.add(lp.get(i));
            }
        }
    }

    public Set<Property> getOwnedFlowProperties(Classifier uclassifier) {
        Set<Property> lp = this.getOwnedAttributes(uclassifier);
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.sflowproperty) || uproperty.getType() == null) continue;
            properties.add(uproperty);
        }
        return properties;
    }

    public Set<Property> getAllFlowProperties(Classifier uclassifier) {
        Set<Property> lp = this.getAllCorrectedAttributes(uclassifier);
        LinkedHashSet<Property> ret = new LinkedHashSet<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.sflowproperty) || uproperty.getType() == null) continue;
            ret.add(uproperty);
        }
        return ret;
    }

    public List<Property> getCorrectedPropertyPath(ConnectorEnd ce, Classifier context) {
        if (ce == null) {
            throw new IllegalArgumentException("The connector end can't be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context end can't be null");
        }
        List<Property> lp = this.getPropertyPath(ce);
        ArrayList<Property> ret = new ArrayList<Property>(lp.size());
        Classifier c = context;
        for (Property p : lp) {
            Property p2 = this.correctProperty(p, c);
            ret.add(p2);
            if (ret.size() == lp.size()) continue;
            if (p2.getType() instanceof Classifier) {
                c = (Classifier)p2.getType();
                continue;
            }
            log.error("The property has no classifier type: " + p2.getQualifiedName());
            break;
        }
        return ret;
    }

    public static Resource createSysMLModel(ResourceSet rs, URI file, List<URI> paths) {
        Resource r = UMLUtil.createUMLModel(rs, file, paths);
        Model model = r.getContents().stream().filter(e -> e instanceof Model).findFirst().orElse(null);
        if (model != null) {
            URL fsysml = SysMLUtil.class.getResource("/SysML.xmi");
            if (fsysml != null) {
                Resource sysml = EMFUtil.loadResource(rs, URI.createURI(fsysml.toString()), paths);
                Profile sysmlprofile = (Profile)EcoreUtil.getObjectByType(sysml.getContents(), UMLPackage.Literals.PROFILE);
                model.applyProfile(sysmlprofile);
            } else {
                log.error("Unable to locate the SysML profile file in the path");
            }
        }
        return r;
    }
}

