/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import com.engisis.xmiutil.CoreConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class EMFConfiguration
extends CoreConfiguration {
    private static final Logger log = Logger.getLogger(EMFConfiguration.class);
    public static final String RESOURCE_MAP = "resourcemap";
    public static final String LOCATION_MAP = "locmap";
    public static final String NAMESPACE_MAP = "nsmap";
    public static final String ID_MAP = "idmap";
    public static final String NS_FILTER = "nsfilter";
    public static final String EL_FILTER = "elfilter";
    private static Hashtable<URI, URI> locmaps_r = null;
    private static Hashtable<String, Hashtable<String, String>> locmaps_w = null;
    private static Hashtable<String, String> nsmaps_r = null;
    private static Hashtable<String, Hashtable<String, String>> nsmaps_w = null;
    private static Hashtable<String, String> idmaps_r = null;
    private static Hashtable<String, Hashtable<String, String>> idmaps_w = null;
    private static Hashtable<String, Set<String>> nsfilter_bl = null;
    private static Hashtable<String, Set<String>> nsfilter_wl = null;
    private static Hashtable<String, Set<QName>> elfilter_bl = null;
    private static Hashtable<String, Set<QName>> elfilter_wl = null;

    public static synchronized void loadProperties() {
        if (locmaps_r != null) {
            return;
        }
        locmaps_r = new Hashtable();
        locmaps_w = new Hashtable();
        nsmaps_r = new Hashtable();
        nsmaps_w = new Hashtable();
        idmaps_r = new Hashtable();
        idmaps_w = new Hashtable();
        nsfilter_bl = new Hashtable();
        nsfilter_wl = new Hashtable();
        elfilter_bl = new Hashtable();
        elfilter_wl = new Hashtable();
        for (CharSequence[] charSequenceArray : EMFConfiguration.getValues()) {
            Set<QName> s;
            CharSequence el;
            CharSequence ns;
            Object to;
            Object from;
            Hashtable<String, String> ht;
            CharSequence to2;
            CharSequence from2;
            CharSequence target;
            if (charSequenceArray.length <= 1) continue;
            if (charSequenceArray[0].equals("nsmap_r")) {
                if (charSequenceArray.length < 3) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                String from22 = charSequenceArray[1];
                String to22 = charSequenceArray[2];
                nsmaps_r.put(from22, to22);
                log.info("add ns mapping from " + from22 + " to " + to22);
                continue;
            }
            if (charSequenceArray[0].equals("nsmap_w")) {
                if (charSequenceArray.length < 4) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                from2 = charSequenceArray[2];
                to2 = charSequenceArray[3];
                ht = nsmaps_w.get(target);
                if (ht == null) {
                    ht = new Hashtable();
                    nsmaps_w.put((String)target, ht);
                }
                ht.put((String)from2, (String)to2);
                log.info("add ns mapping from " + (String)from2 + " to " + (String)to2 + " in target " + (String)target);
                continue;
            }
            if (charSequenceArray[0].equals(ID_MAP) || ((String)charSequenceArray[0]).equals("idmap_r")) {
                if (charSequenceArray.length < 3) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                from = charSequenceArray[1];
                to = charSequenceArray[2];
                idmaps_r.put((String)from, (String)to);
                log.info("add id mapping from " + (String)from + " to " + (String)to);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("idmap_w")) {
                if (charSequenceArray.length < 4) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                from2 = charSequenceArray[2];
                to2 = charSequenceArray[3];
                ht = idmaps_w.get(target);
                if (ht == null) {
                    ht = new Hashtable();
                    idmaps_w.put((String)target, ht);
                }
                ht.put((String)from2, (String)to2);
                log.info("add id mapping from " + (String)from2 + " to " + (String)to2 + " in target " + (String)target);
                continue;
            }
            if (((String)charSequenceArray[0]).equals(RESOURCE_MAP) || ((String)charSequenceArray[0]).equals("locmap_r")) {
                if (charSequenceArray.length < 3) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                from = URI.createURI((String)charSequenceArray[1]);
                to = URI.createURI(EMFConfiguration.transformResource(EMFConfiguration.class.getResource((String)charSequenceArray[2]).toString()));
                locmaps_r.put((URI)from, (URI)to);
                log.info("add resource mapping from " + from + " to " + to);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("locmap_w")) {
                if (charSequenceArray.length < 4) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                from2 = charSequenceArray[2];
                to2 = charSequenceArray[3];
                ht = locmaps_w.get(target);
                if (ht == null) {
                    ht = new Hashtable();
                    locmaps_w.put((String)target, ht);
                }
                ht.put((String)from2, (String)to2);
                log.info("add location mapping from " + (String)from2 + " to " + (String)to2);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("nsfilter_bl")) {
                if (charSequenceArray.length < 3) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                ns = charSequenceArray[2];
                Set<String> s2 = nsfilter_bl.get(target);
                if (s2 == null) {
                    s2 = new HashSet<String>();
                    nsfilter_bl.put((String)target, s2);
                }
                s2.add((String)ns);
                log.info("add namespace " + s2 + " to blacklist in target " + (String)target);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("nsfilter_wl")) {
                if (charSequenceArray.length < 3) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                ns = charSequenceArray[2];
                Set<String> s2 = nsfilter_wl.get(target);
                if (s2 == null) {
                    s2 = new HashSet<String>();
                    nsfilter_wl.put((String)target, s2);
                }
                s2.add((String)ns);
                log.info("add namespace " + s2 + " to whitelist in target " + (String)target);
                continue;
            }
            if (((String)charSequenceArray[0]).equals("elfilter_bl")) {
                if (charSequenceArray.length < 4) {
                    log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                    continue;
                }
                target = charSequenceArray[1];
                ns = charSequenceArray[2];
                el = charSequenceArray[3];
                s = elfilter_bl.get(target);
                if (s == null) {
                    s = new HashSet<QName>();
                    elfilter_bl.put((String)target, s);
                }
                s.add(new QName((String)ns, (String)el));
                log.info("add element " + s + " to blacklist in target " + (String)target);
                continue;
            }
            if (!((String)charSequenceArray[0]).equals("nsfilter_wl")) continue;
            if (charSequenceArray.length < 4) {
                log.error("Line in the wrong format: " + String.join((CharSequence)" ", charSequenceArray));
                continue;
            }
            target = charSequenceArray[1];
            ns = charSequenceArray[2];
            el = charSequenceArray[3];
            s = elfilter_wl.get(target);
            if (s == null) {
                s = new HashSet<QName>();
                elfilter_wl.put((String)target, s);
            }
            s.add(new QName((String)ns, (String)el));
            log.info("add element " + s + " to whitelist in target " + (String)target);
        }
    }

    private static String transformResource(String suri) {
        if (suri.contains("!") && !suri.startsWith("jar:")) {
            return "jar:" + suri;
        }
        return suri;
    }

    public static Hashtable<URI, URI> getLocationMappings() {
        if (locmaps_r == null) {
            EMFConfiguration.loadProperties();
        }
        return locmaps_r;
    }

    public static Hashtable<String, String> getWriterLocationMappings(String target) {
        if (locmaps_w == null) {
            EMFConfiguration.loadProperties();
        }
        return locmaps_w.get(target);
    }

    public static Hashtable<String, String> getReaderNSMappings() {
        if (nsmaps_r == null) {
            EMFConfiguration.loadProperties();
        }
        return nsmaps_r;
    }

    public static Hashtable<String, String> getWriterNSMappings(String target) {
        if (nsmaps_w == null) {
            EMFConfiguration.loadProperties();
        }
        return nsmaps_w.get(target);
    }

    public static Hashtable<String, String> getReaderIDMappings() {
        if (idmaps_r == null) {
            EMFConfiguration.loadProperties();
        }
        return idmaps_r;
    }

    public static Hashtable<String, String> getWriterIDMappings(String target) {
        if (idmaps_w == null) {
            EMFConfiguration.loadProperties();
        }
        return idmaps_w.get(target);
    }

    public static Set<QName> getElementBlacklist(String target) {
        if (elfilter_bl == null) {
            EMFConfiguration.loadProperties();
        }
        return elfilter_bl.get(target);
    }

    public static Set<QName> getElementWhitelist(String target) {
        if (elfilter_wl == null) {
            EMFConfiguration.loadProperties();
        }
        return elfilter_wl.get(target);
    }

    public static Set<String> getNamespaceBlacklist(String target) {
        if (nsfilter_bl == null) {
            EMFConfiguration.loadProperties();
        }
        return nsfilter_bl.get(target);
    }

    public static Set<String> getNamespaceWhitelist(String target) {
        if (nsfilter_wl == null) {
            EMFConfiguration.loadProperties();
        }
        return nsfilter_wl.get(target);
    }

    public static Collection<String> getTargets() {
        if (idmaps_w == null) {
            EMFConfiguration.loadProperties();
        }
        return Collections.unmodifiableCollection(idmaps_w.keySet());
    }
}

