/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.ANTLRErrorListener;
import com.engisis.sysphs.util.ExpressionLanguageLexer;
import com.engisis.sysphs.util.ExpressionLanguageParser;
import com.engisis.sysphs.util.ExpressionLanguageToSimulation;
import com.engisis.xmiutil.UMLModelErrorException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class SysMLToSimulationTranslator {
    private static final Logger log = Logger.getLogger(SysMLToSimulationTranslator.class);
    private Hashtable<ValueSpecification, ParserRuleContext> htVSs = new Hashtable();
    private Hashtable<OpaqueBehavior, ParserRuleContext> htOBs = new Hashtable();
    private String filenamesuffix;
    private String modelnamesuffix;
    protected Resource r;
    protected String outputfilename;

    public void setFileNameSuffix(String suffix) {
        this.filenamesuffix = suffix;
    }

    public String getFileNameSuffix() {
        return this.filenamesuffix == null ? "" : this.filenamesuffix;
    }

    public void setModelNameSuffix(String suffix) {
        this.modelnamesuffix = suffix;
    }

    public String getModelNameSuffix() {
        return this.modelnamesuffix == null ? "" : this.modelnamesuffix;
    }

    public void loadOptions(Set<Object> options) {
        if (options == null) {
            return;
        }
        Set<Object> values = this.getOptionValues();
        for (Object o : options) {
            if (values.contains(o)) continue;
            throw new IllegalArgumentException("The option is not valid: " + o);
        }
    }

    public abstract Set<java.lang.Class<?>> getOptions();

    public final Set<Object> getOptionValues() {
        HashSet<Object> res = new HashSet<Object>();
        Set<java.lang.Class<?>> options = this.getOptions();
        if (options != null) {
            for (java.lang.Class<?> en : options) {
                if (!en.isEnum()) continue;
                for (Object o : en.getEnumConstants()) {
                    res.add(o);
                }
            }
        }
        return res;
    }

    public abstract void execute(Class var1, Resource var2, File var3) throws UMLModelErrorException, IOException;

    public void reset() {
        this.htVSs.clear();
        this.htOBs.clear();
    }

    public String getOutputFileName() {
        return this.outputfilename;
    }

    public static ReferenceKey getKey(Element ... elements) {
        return new ReferenceKey(elements);
    }

    public static String print(Element element) {
        StringBuilder sb = new StringBuilder();
        if (element instanceof Connector) {
            Connector c = (Connector)element;
            for (int i = 0; i < c.getEnds().size(); ++i) {
                if (i != 0) {
                    sb.append("-");
                }
                sb.append(SysMLToSimulationTranslator.print((Element)c.getEnds().get(i)));
            }
        }
        if (element instanceof NamedElement) {
            NamedElement ne = (NamedElement)element;
            if (ne.getNamespace() != null) {
                sb.append(ne.getNamespace().getQualifiedName() + "::");
            }
            sb.append(ne.getName());
        } else {
            sb.append(EcoreUtil.getURI(element).fragment());
        }
        return sb.toString();
    }

    public static String print(ReferenceKey rk) {
        StringBuilder sb = new StringBuilder();
        for (Element elem : rk.getKey()) {
            if (elem != rk.getKey()[0]) {
                sb.append("/");
            }
            sb.append(SysMLToSimulationTranslator.print(elem));
        }
        return sb.toString();
    }

    protected abstract String getOpaqueLanguage();

    protected abstract ExpressionLanguageToSimulation getExpressionTranslator();

    public String getEquation(ValueSpecification vs) throws UMLModelErrorException {
        ParserRuleContext prc = this.htVSs.get(vs);
        if (prc == null) {
            OpaqueExpression oe;
            EList<String> languages;
            String val = vs.stringValue();
            if (vs instanceof OpaqueExpression && (languages = (oe = (OpaqueExpression)vs).getLanguages()).size() > 0) {
                for (int i = 0; i < languages.size(); ++i) {
                    String lng = ((String)languages.get(i)).trim();
                    if (this.getOpaqueLanguage().equals(lng)) {
                        return (String)oe.getBodies().get(i);
                    }
                    if (lng == null || lng.equals("") || lng.equals("sysphs")) {
                        val = ((String)oe.getBodies().get(i)).trim();
                        continue;
                    }
                    log.warn("Unrecognized language " + lng);
                }
            }
            if (val != null) {
                ExpressionLanguageLexer ell = new ExpressionLanguageLexer(new ANTLRInputStream(val));
                CommonTokenStream cts = new CommonTokenStream(ell);
                ExpressionLanguageParser elp = new ExpressionLanguageParser(cts);
                elp.removeErrorListeners();
                elp.addErrorListener(new ANTLRErrorListener(log));
                prc = elp.equation();
                this.htVSs.put(vs, prc);
            } else {
                throw new UMLModelErrorException(this.r, "No body found with: " + SysMLToSimulationTranslator.print(vs));
            }
        }
        ParseTreeWalker ptw = new ParseTreeWalker();
        ExpressionLanguageToSimulation translator = this.getExpressionTranslator();
        ptw.walk(translator, prc);
        return translator.getValue(prc);
    }

    public String getExpression(ValueSpecification vs) throws UMLModelErrorException {
        ParserRuleContext prc = this.htVSs.get(vs);
        if (prc == null) {
            OpaqueExpression oe;
            EList<String> languages;
            String val = vs.stringValue();
            if (vs instanceof OpaqueExpression && (languages = (oe = (OpaqueExpression)vs).getLanguages()).size() > 0) {
                for (int i = 0; i < languages.size(); ++i) {
                    String lng = ((String)languages.get(i)).trim();
                    if (this.getOpaqueLanguage().equals(lng)) {
                        return (String)oe.getBodies().get(i);
                    }
                    if (lng == null || lng.equals("") || lng.equals("sysphs")) {
                        val = ((String)oe.getBodies().get(i)).trim();
                        continue;
                    }
                    log.warn("Unrecognized language " + lng);
                }
            }
            if (val != null) {
                ExpressionLanguageLexer ell = new ExpressionLanguageLexer(new ANTLRInputStream(val));
                CommonTokenStream cts = new CommonTokenStream(ell);
                ExpressionLanguageParser elp = new ExpressionLanguageParser(cts);
                elp.removeErrorListeners();
                elp.addErrorListener(new ANTLRErrorListener(log));
                prc = elp.expression();
                this.htVSs.put(vs, prc);
            } else {
                throw new UMLModelErrorException(this.r, "No body found with: " + SysMLToSimulationTranslator.print(vs));
            }
        }
        ParseTreeWalker ptw = new ParseTreeWalker();
        ExpressionLanguageToSimulation translator = this.getExpressionTranslator();
        ptw.walk(translator, prc);
        return translator.getValue(prc);
    }

    public String getAssignments(OpaqueBehavior ob) throws UMLModelErrorException {
        ParserRuleContext prc = this.htOBs.get(ob);
        if (prc == null) {
            String val = null;
            EList<String> languages = ob.getLanguages();
            if (languages.size() > 0) {
                for (int i = 0; i < languages.size(); ++i) {
                    String lng = ((String)languages.get(i)).trim();
                    if (this.getOpaqueLanguage().equals(lng)) {
                        return (String)ob.getBodies().get(i);
                    }
                    if (lng == null || lng.isEmpty() || lng.equals("sysphs")) {
                        val = ((String)ob.getBodies().get(i)).trim();
                        continue;
                    }
                    log.warn("Unrecognized language " + lng);
                }
            } else if (ob.getBodies().size() != 0) {
                val = (String)ob.getBodies().get(0);
            }
            if (val == null) {
                throw new UMLModelErrorException(this.r, "No body found with: " + SysMLToSimulationTranslator.print(ob));
            }
            ExpressionLanguageLexer ell = new ExpressionLanguageLexer(new ANTLRInputStream(val));
            CommonTokenStream cts = new CommonTokenStream(ell);
            ExpressionLanguageParser elp = new ExpressionLanguageParser(cts);
            elp.removeErrorListeners();
            elp.addErrorListener(new ANTLRErrorListener(log));
            prc = elp.statements();
            this.htOBs.put(ob, prc);
        }
        ParseTreeWalker ptw = new ParseTreeWalker();
        ptw.walk(this.getExpressionTranslator(), prc);
        return this.getExpressionTranslator().getValue(prc);
    }

    public static class ReferenceKey {
        private Element[] key;

        public ReferenceKey(Element[] key) {
            this.key = (Element[])key.clone();
        }

        public Element[] getKey() {
            return (Element[])this.key.clone();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReferenceKey) {
                ReferenceKey rk = (ReferenceKey)obj;
                if (rk.key.length != this.key.length) {
                    return false;
                }
                for (int i = 0; i < this.key.length; ++i) {
                    if (EcoreUtil.getURI(rk.key[i]).equals(EcoreUtil.getURI(this.key[i]))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Element elem : this.key) {
                sb.append(EcoreUtil.getURI(elem) + " ");
            }
            return sb.toString();
        }
    }
}

