/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.SysPhSUtil;
import com.engisis.xmiutil.UMLModelErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class SysMLPreProcessor {
    private static final Logger log = Logger.getLogger(SysMLPreProcessor.class);
    private SysPhSUtil sysphsutil;
    private Resource r;
    private List<Class> classes;
    private List<AssociationClass> associationclasses;
    private List<Property> properties;
    private List<Port> ports;
    private List<Connector> connectors;
    private List<InstanceSpecification> instances;
    private Hashtable<Classifier, List<Port>> htports1;
    private Hashtable<Port, List<Port>> htports2;

    public SysMLPreProcessor(Resource r) throws UMLModelErrorException {
        this.sysphsutil = new SysPhSUtil(r.getResourceSet());
        this.r = r;
        this.classes = new LinkedList<Class>();
        this.associationclasses = new LinkedList<AssociationClass>();
        this.properties = new LinkedList<Property>();
        this.ports = new LinkedList<Port>();
        this.connectors = new LinkedList<Connector>();
        this.instances = new LinkedList<InstanceSpecification>();
        this.htports1 = new Hashtable();
        this.htports2 = new Hashtable();
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws UMLModelErrorException {
        Object uconnector;
        Object is0;
        int iit;
        List<Property> sps;
        Class uclass;
        int cit;
        int poit;
        int coit;
        TreeIterator<EObject> ti = this.r.getAllContents();
        while (ti.hasNext()) {
            EObject eo = (EObject)ti.next();
            if (eo instanceof AssociationClass) {
                this.associationclasses.add((AssociationClass)eo);
                for (Connector uconnector2 : ((Class)eo).getOwnedConnectors()) {
                    this.connectors.add(uconnector2);
                }
            } else if (eo instanceof Class) {
                this.classes.add((Class)eo);
                for (Connector uconnector2 : ((Class)eo).getOwnedConnectors()) {
                    this.connectors.add(uconnector2);
                }
            } else if (eo instanceof Port) {
                this.ports.add((Port)eo);
            } else if (eo instanceof Property) {
                this.properties.add((Property)eo);
            } else if (eo instanceof InstanceSpecification) {
                this.instances.add((InstanceSpecification)eo);
            }
            if (eo instanceof Namespace) continue;
            ti.prune();
        }
        for (coit = 0; coit < this.connectors.size(); ++coit) {
            Connector c = this.connectors.get(coit);
            if (!c.isStereotypeApplied(this.sysphsutil.getBindingConnector())) continue;
            List<Property> lp0 = this.sysphsutil.getPropertyPath((ConnectorEnd)c.getEnds().get(0));
            List<Property> lp1 = this.sysphsutil.getPropertyPath((ConnectorEnd)c.getEnds().get(1));
            Property p0 = lp0.get(lp0.size() - 1);
            Type type = p0.getType();
            Property p1 = lp1.get(lp1.size() - 1);
            Type t1 = p1.getType();
            Property proxy = null;
            if (!(type instanceof Class) || !(t1 instanceof Class)) continue;
            log.info("Taking care of binding " + this.print(c));
            List<Property> fr = null;
            Object to = null;
            if (lp0.size() > lp1.size()) {
                fr = lp1;
                to = lp0;
                proxy = p1;
            } else if (lp1.size() > lp0.size()) {
                fr = lp0;
                to = lp1;
                proxy = p0;
            } else {
                log.error("Binding connector between two elements at the same level: " + this.print(c));
                continue;
            }
            if (fr.size() > 0 && to.size() > 0) {
                for (int i = 0; i < this.connectors.size(); ++i) {
                    Connector connector = this.connectors.get(i);
                    block5: for (ConnectorEnd ce : connector.getEnds()) {
                        List<Property> lp = this.sysphsutil.getPropertyPath(ce);
                        block6: for (int i2 = 0; i2 < lp.size(); ++i2) {
                            int j;
                            for (j = 0; j < fr.size(); ++j) {
                                if (lp.get(i2 + j) != fr.get(j)) continue block6;
                            }
                            for (j = 0; j < fr.size(); ++j) {
                                lp.remove(i2);
                            }
                            lp.addAll(i2, (Collection<Property>)to);
                            this.sysphsutil.updatePropertyPath(ce, lp);
                            log.info("Changed connector to " + this.print(c));
                            continue block5;
                        }
                    }
                }
            }
            log.info("Removing binding " + this.print(c));
            this.connectors.remove(coit--);
            EcoreUtil.delete(c, true);
            log.info("Removing proxy " + this.print(proxy));
            EcoreUtil.delete(proxy, true);
            this.properties.remove(proxy);
            this.ports.remove(proxy);
        }
        for (int pit = 0; pit < this.properties.size(); ++pit) {
            Property p = this.properties.get(pit);
            if (!p.isStereotypeApplied(this.sysphsutil.getConnectorProperty()) || p.getValue(this.sysphsutil.getConnectorProperty(), "connector") == null) continue;
            this.transformConnectorProperty(p);
            this.properties.remove(pit--);
            log.info("Removing connector property " + this.print(p));
            EcoreUtil.delete(p, true);
        }
        for (poit = 0; poit > this.ports.size(); ++poit) {
            Port uport = this.ports.get(poit);
            Type utype = uport.getType();
            if (!(utype instanceof Classifier) || this.isPortType((Classifier)uport.getType())) continue;
            log.info("Replacing port " + this.print(uport));
            Property uproperty = UMLFactory.eINSTANCE.createProperty();
            ((Class)uport.getOwner()).getOwnedAttributes().add(uproperty);
            this.replace(uport, uproperty);
            this.ports.remove(poit--);
            EcoreUtil.delete(uport, true);
            this.properties.add(uproperty);
        }
        LinkedList<Classifier> spclasses = new LinkedList<Classifier>();
        for (cit = 0; cit < this.classes.size(); ++cit) {
            Classifier spcontainer;
            uclass = this.classes.get(cit);
            sps = this.sysphsutil.getOwnedPhSProperties(uclass);
            if (sps.size() <= 0) continue;
            if (this.isPortType(uclass)) {
                void var11_24;
                Property fp = sps.get(0);
                SysMLPreProcessor.moveProperty(fp, uclass);
                spclasses.add(uclass);
                boolean bl = true;
                while (var11_24 < sps.size()) {
                    fp = sps.get((int)var11_24);
                    spcontainer = this.createPhSPropertyContainer(fp);
                    if (spcontainer instanceof Class) {
                        this.classes.add((Class)spcontainer);
                    }
                    spclasses.add(spcontainer);
                    SysMLPreProcessor.moveProperty(fp, spcontainer);
                    this.addGeneralization(uclass, spcontainer);
                    ++var11_24;
                }
                continue;
            }
            for (int j = 0; j < sps.size(); ++j) {
                Property property = sps.get(j);
                spcontainer = this.createPhSPropertyContainer(property);
                if (spcontainer instanceof Class) {
                    this.classes.add((Class)spcontainer);
                }
                spclasses.add(spcontainer);
                SysMLPreProcessor.moveProperty(property, spcontainer);
                this.addGeneralization(uclass, spcontainer);
            }
        }
        for (cit = 0; cit < this.classes.size(); ++cit) {
            uclass = this.classes.get(cit);
            if (this.isPortType(uclass)) continue;
            sps = new LinkedList<Property>();
            for (Classifier classifier : uclass.getGenerals()) {
                if (!this.isPortType(classifier)) continue;
                sps.addAll(this.sysphsutil.getAllPhSProperties(classifier));
            }
            LinkedList<Port> lports = new LinkedList<Port>();
            for (Property sp : sps) {
                Port p = UMLFactory.eINSTANCE.createPort();
                uclass.getOwnedPorts().add(p);
                this.setUniqueName(p, SysMLPreProcessor.lowerFirst(uclass.getName()) + SysMLPreProcessor.upperFirst(sp.getName()));
                log.info("Adding port " + p.getName() + " for inherited " + this.print(sp) + " in " + this.print(uclass));
                this.ports.add(p);
                Classifier sptype = this.findBetterPortType(uclass, sp);
                log.info("Setting type " + sptype.getQualifiedName());
                p.setType(sptype);
                lports.add(p);
                block17: for (coit = 0; coit < this.connectors.size(); ++coit) {
                    Connector uconnector3 = this.connectors.get(coit);
                    for (ConnectorEnd connectorEnd : uconnector3.getEnds()) {
                        Type type = (Type)uconnector3.getOwner();
                        if (type == null) {
                            log.error("Owner of " + this.print(uconnector3) + " null");
                            continue;
                        }
                        Object var19_69 = null;
                        if (!(connectorEnd.getRole() instanceof Property)) continue block17;
                        List<Property> lp = this.sysphsutil.getPropertyPath(connectorEnd);
                        boolean mod = false;
                        for (int k = 0; k < lp.size(); ++k) {
                            void var19_75;
                            void var19_73;
                            void var18_55;
                            Property property = lp.get(k);
                            if (var18_55 instanceof Classifier) {
                                Property property2 = this.sysphsutil.correctProperty(property, (Classifier)var18_55);
                            }
                            if (var18_55.conformsTo(uclass) && var19_73 == sp) {
                                Port port = p;
                                lp.add(k++, p);
                                mod = true;
                            }
                            Type type2 = var19_75.getType();
                        }
                        if (!mod) continue;
                        this.sysphsutil.updatePropertyPath(connectorEnd, lp);
                        log.info("Updating " + this.print(connectorEnd));
                    }
                    for (iit = 0; iit < this.instances.size(); ++iit) {
                        is0 = this.instances.get(iit);
                        for (Slot slot : is0.getSlots()) {
                            if (slot.getDefiningFeature() != sp) continue;
                            InstanceSpecification instanceSpecification = UMLFactory.eINSTANCE.createInstanceSpecification();
                            is0.getNearestPackage().getPackagedElements().add(instanceSpecification);
                            instanceSpecification.getClassifiers().add((Classifier)p.getType());
                            Slot s1 = UMLFactory.eINSTANCE.createSlot();
                            instanceSpecification.getSlots().add(s1);
                            s1.setDefiningFeature(sp);
                            s1.getValues().addAll(slot.getValues());
                            slot.setDefiningFeature(p);
                            slot.getValues().clear();
                            InstanceValue iv0 = UMLFactory.eINSTANCE.createInstanceValue();
                            iv0.setInstance(instanceSpecification);
                            slot.getValues().add(iv0);
                        }
                    }
                }
            }
            if (lports.isEmpty()) continue;
            this.htports1.put(uclass, lports);
        }
        for (poit = 0; poit < this.ports.size(); ++poit) {
            Port p = this.ports.get(poit);
            if (!(p.getType() instanceof Classifier) || !this.isPortType((Classifier)p.getType()) || (sps = this.sysphsutil.getAllPhSProperties((Classifier)p.getType())).size() == 0) continue;
            LinkedList<Port> lports = new LinkedList<Port>();
            Classifier classifier = (Classifier)p.getType();
            p.setType(this.findBetterPortType(classifier, sps.get(0)));
            log.info("Not changing port " + p.getName() + " for sp " + this.sysphsutil.getName(sps.get(0)));
            for (int i = 1; i < sps.size(); ++i) {
                Port p2 = UMLFactory.eINSTANCE.createPort();
                Class uclass2 = (Class)p.getOwner();
                uclass2.getOwnedPorts().add(p2);
                this.ports.add(poit++, p2);
                Property sp = sps.get(i);
                p2.setType(this.findBetterPortType(classifier, sp));
                this.setUniqueName(p2, SysMLPreProcessor.lowerFirst(uclass2.getName()) + SysMLPreProcessor.upperFirst(sp.getName()));
                log.info("Adding port " + p2.getName() + " for additional sp " + this.sysphsutil.getName(sp));
                lports.add(p2);
                for (coit = 0; coit < this.connectors.size(); ++coit) {
                    ConnectorEnd connectorEnd;
                    Connector uconnector4 = this.connectors.get(coit);
                    Iterator iterator = uconnector4.getEnds().iterator();
                    while (iterator.hasNext() && (connectorEnd = (ConnectorEnd)iterator.next()).getRole() instanceof Property) {
                        List<Property> list = this.sysphsutil.getPropertyPath(connectorEnd);
                        boolean mod = false;
                        for (int k = 0; k < list.size() - 1; ++k) {
                            if (list.get(k) != p || list.get(k + 1) != sp) continue;
                            list.remove(k);
                            list.add(k, p2);
                            mod = true;
                        }
                        if (!mod) continue;
                        this.sysphsutil.updatePropertyPath(connectorEnd, list);
                        log.info("Updating " + this.print(connectorEnd));
                    }
                }
                for (iit = 0; iit < this.instances.size(); ++iit) {
                    is0 = this.instances.get(iit);
                    block28: for (Slot slot : is0.getSlots()) {
                        if (slot.getDefiningFeature() != p || slot.getValues().size() != 1) continue;
                        InstanceSpecification instanceSpecification = ((InstanceValue)slot.getValues().get(0)).getInstance();
                        for (Slot s1 : instanceSpecification.getSlots()) {
                            if (s1.getDefiningFeature() != sp) continue;
                            slot.getValues().clear();
                            slot.setDefiningFeature(p2);
                            continue block28;
                        }
                    }
                }
            }
            if (lports.isEmpty()) continue;
            this.htports2.put(p, lports);
        }
        LinkedList<Connector> newconnectors = new LinkedList<Connector>();
        for (coit = 0; coit < this.connectors.size(); ++coit) {
            uconnector = this.connectors.get(coit);
            if (uconnector.isStereotypeApplied(this.sysphsutil.getBindingConnector())) continue;
            ConnectorEnd uconnectorend0 = (ConnectorEnd)uconnector.getEnds().get(0);
            Type type = uconnectorend0.getRole().getType();
            ConnectorEnd uconnectorend1 = (ConnectorEnd)uconnector.getEnds().get(1);
            Type e1t = uconnectorend1.getRole().getType();
            if (type instanceof Classifier && e1t instanceof Classifier) {
                List<Property> lsp0 = this.sysphsutil.getAllPhSProperties((Classifier)type);
                List<Property> lsp1 = this.sysphsutil.getAllPhSProperties((Classifier)e1t);
                if (lsp0 == null || lsp1 == null) continue;
                block31: for (Property property : lsp0) {
                    for (Property property3 : lsp1) {
                        if (property.getType() == null || property.getType() != property3.getType()) continue;
                        List<Property> path0 = this.correctPath(uconnectorend0, property);
                        List<Property> path1 = this.correctPath(uconnectorend1, property3);
                        if (path0 != null && path1 != null) {
                            Connector nuconnector = UMLFactory.eINSTANCE.createConnector();
                            ((Class)uconnector.getOwner()).getOwnedConnectors().add(nuconnector);
                            newconnectors.add(nuconnector);
                            ConnectorEnd nuconnectorend0 = UMLFactory.eINSTANCE.createConnectorEnd();
                            nuconnector.getEnds().add(nuconnectorend0);
                            this.sysphsutil.updatePropertyPath(nuconnectorend0, path0);
                            ConnectorEnd nuconnectorend1 = UMLFactory.eINSTANCE.createConnectorEnd();
                            nuconnector.getEnds().add(nuconnectorend1);
                            this.sysphsutil.updatePropertyPath(nuconnectorend1, path1);
                            log.info("Creating connector " + this.print(nuconnector) + " for " + this.print((Connector)uconnector));
                            continue block31;
                        }
                        log.error("Can't create connector for " + this.print((Connector)uconnector) + ": " + this.print(path0) + "//" + this.print(path1));
                        continue block31;
                    }
                }
            }
            log.info("Removing " + this.print((Connector)uconnector));
            EcoreUtil.delete((EObject)uconnector, true);
            this.connectors.remove(coit--);
        }
        this.connectors.addAll(newconnectors);
        for (Classifier uclassifier : spclasses) {
            log.info("Removing generalizations from " + this.sysphsutil.getName(uclassifier));
            uclassifier.getGeneralizations().clear();
        }
        for (Class uclass3 : this.classes) {
            if (this.isPortType(uclass3)) continue;
            ListIterator listIterator = uclass3.getGeneralizations().listIterator();
            while (listIterator.hasNext()) {
                Generalization ugeneralization = (Generalization)listIterator.next();
                if (ugeneralization.getSpecific() != uclass3 || !this.isPortType(ugeneralization.getGeneral())) continue;
                listIterator.remove();
                log.info("Removing generalization between " + uclass3.getQualifiedName() + " and " + ugeneralization.getGeneral().getQualifiedName());
            }
        }
        for (Class uclass4 : this.classes) {
            List<Property> list = this.sysphsutil.getAllPhSProperties(uclass4);
            for (Property simproperty : list) {
                Property simvariable;
                Set<Property> attrs;
                Type simpropertytype = simproperty.getType();
                if (!(simpropertytype instanceof Class) || (attrs = this.sysphsutil.getAllAttributes((Class)simpropertytype)).size() != 1 || !(simvariable = attrs.iterator().next()).isStereotypeApplied(this.sysphsutil.getPhSVariable()) || ((Boolean)simvariable.getValue(this.sysphsutil.getPhSVariable(), "isConserved")).booleanValue()) continue;
                simproperty.setType(simvariable.getType());
                for (Connector connector : this.connectors) {
                    block39: for (ConnectorEnd uconnectorend : connector.getEnds()) {
                        List<Property> lp = this.sysphsutil.getPropertyPath(uconnectorend);
                        for (int k = 0; k < lp.size() - 1; ++k) {
                            if (lp.get(k) != simproperty || lp.get(k + 1) != simvariable) continue;
                            lp.remove(k + 1);
                            this.sysphsutil.updatePropertyPath(uconnectorend, lp);
                            continue block39;
                        }
                    }
                }
            }
        }
        block41: for (coit = 0; coit < this.connectors.size(); ++coit) {
            uconnector = this.connectors.get(coit);
            if (uconnector.isStereotypeApplied(this.sysphsutil.getBindingConnector())) continue;
            for (int i = 0; i < uconnector.getEnds().size(); ++i) {
                ConnectorEnd connectorEnd = (ConnectorEnd)uconnector.getEnds().get(i);
                List<Property> lp = this.sysphsutil.getPropertyPath(connectorEnd);
                if (lp.size() <= 2) continue;
                log.info("Splitting connector " + this.print((Connector)uconnector));
                Property last = lp.get(lp.size() - 1);
                while (lp.size() != 2) {
                    Property penu = lp.get(lp.size() - 2);
                    Property antepenu = lp.get(lp.size() - 3);
                    Type tantepenu = antepenu.getType();
                    if (!(tantepenu instanceof Class)) {
                        log.error("Element must be a class: " + tantepenu.getQualifiedName());
                        continue block41;
                    }
                    Port port = UMLFactory.eINSTANCE.createPort();
                    ((Class)tantepenu).getOwnedPorts().add(port);
                    this.setUniqueName(port, last.getName());
                    this.ports.add(port);
                    port.setType(last.getType());
                    Connector connector = UMLFactory.eINSTANCE.createConnector();
                    ((Class)tantepenu).getOwnedConnectors().add(connector);
                    this.connectors.add(connector);
                    ArrayList<Property> arrayList = new ArrayList<Property>(2);
                    arrayList.add(penu);
                    arrayList.add(last);
                    ConnectorEnd nce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                    connector.getEnds().add(nce0);
                    this.sysphsutil.updatePropertyPath(nce0, arrayList);
                    ConnectorEnd nce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                    connector.getEnds().add(nce1);
                    nce1.setRole(port);
                    log.info("Adding connector " + this.print(connector));
                    lp.remove(lp.size() - 1);
                    lp.remove(lp.size() - 1);
                    lp.add(port);
                }
                this.sysphsutil.updatePropertyPath((ConnectorEnd)uconnector.getEnds().get(i), lp);
                log.info("Changed connector to " + this.print((Connector)uconnector));
            }
        }
    }

    private void transformAssociationBlocks(AssociationClass ac) {
        log.debug("Transforming association class " + ac.getQualifiedName());
        BasicEList<Property> memberends = new BasicEList<Property>(ac.getMemberEnds());
        for (int i = 0; i < memberends.size(); ++i) {
            Property member = (Property)memberends.get(i);
            Port port = UMLFactory.eINSTANCE.createPort();
            ac.getOwnedPorts().add(port);
            log.info("Replacing member end " + this.sysphsutil.getName(member));
            this.replace(member, port);
        }
        ListIterator<Property> pit = this.properties.listIterator();
        while (pit.hasNext()) {
            Connector conn;
            Property uproperty = pit.next();
            if (!uproperty.isStereotypeApplied(this.sysphsutil.getConnectorProperty()) || (conn = (Connector)uproperty.getValue(this.sysphsutil.getConnectorProperty(), "connector")) == null || conn.getType() != ac) continue;
            StructuredClassifier owner = (StructuredClassifier)conn.getOwner();
            for (int i = 0; i < conn.getEnds().size(); ++i) {
                Connector nconn = UMLFactory.eINSTANCE.createConnector();
                ConnectorEnd ce = (ConnectorEnd)conn.getEnds().get(i);
                ConnectorEnd nce0 = UMLFactory.eINSTANCE.createConnectorEnd();
                nce0.setPartWithPort(ce.getPartWithPort());
                nce0.setRole(ce.getRole());
                ConnectorEnd nce1 = UMLFactory.eINSTANCE.createConnectorEnd();
                nce1.setPartWithPort(uproperty);
                nce1.setRole((ConnectableElement)ac.getOwnedPorts().get(i));
                nconn.getEnds().add(nce0);
                nconn.getEnds().add(nce1);
                owner.getOwnedConnectors().add(nconn);
                this.connectors.add(nconn);
            }
            EcoreUtil.delete(conn, true);
            this.connectors.remove(conn);
        }
        Class c = UMLFactory.eINSTANCE.createClass();
        Package owner = ac.getNearestPackage();
        owner.getPackagedElements().add(c);
        this.replace(ac, c);
        if (!c.isStereotypeApplied(this.sysphsutil.getBlock())) {
            c.applyStereotype(this.sysphsutil.getBlock());
        }
        this.classes.add(c);
    }

    private void transformConnectorProperty(Property cp) throws UMLModelErrorException {
        Class owner = (Class)cp.getOwner();
        Type t = cp.getType();
        Connector c = (Connector)cp.getValue(this.sysphsutil.getConnectorProperty(), "connector");
        if (t == null || t != c.getType()) {
            throw new UMLModelErrorException(this.r, "The connector property and its connector must have the same type");
        }
        AssociationClass ac = (AssociationClass)t;
        Hashtable<Property, Property> map = new Hashtable<Property, Property>();
        for (Property ap : this.sysphsutil.getAllAttributes(ac)) {
            if (ap.isStereotypeApplied(this.sysphsutil.getParticipantProperty()) || ac.getMemberEnds().contains(ap)) continue;
            Property ap2 = null;
            ap2 = ap instanceof Port ? UMLFactory.eINSTANCE.createPort() : UMLFactory.eINSTANCE.createProperty();
            owner.getOwnedAttributes().add(ap2);
            this.copy(ap, ap2);
            String ap2name = ap2.getName();
            ap2.setName(null);
            this.setUniqueName(ap2, ap2name);
            log.info("Adding " + this.print(ap2) + " to " + this.print(owner) + " for " + this.print(cp) + "." + this.print(ap));
            map.put(ap, ap2);
            for (Connector c2 : owner.getOwnedConnectors()) {
                block2: for (ConnectorEnd connectorEnd : c2.getEnds()) {
                    List<Property> lp = this.sysphsutil.getPropertyPath(connectorEnd);
                    for (int i = 0; i < lp.size() - 1; ++i) {
                        if (lp.get(i) != cp || lp.get(i + 1) != ap) continue;
                        lp.remove(i);
                        lp.remove(i);
                        lp.add(i, ap2);
                        String from = this.print(c2);
                        this.sysphsutil.updatePropertyPath(connectorEnd, lp);
                        log.info("Changing connector from " + from + " to " + this.print(c2));
                        continue block2;
                    }
                }
            }
            for (int iit = 0; iit < this.instances.size(); ++iit) {
                InstanceSpecification is0 = this.instances.get(iit);
                block5: for (Slot slot : is0.getSlots()) {
                    if (slot.getDefiningFeature() != cp || slot.getValues().size() != 1) continue;
                    InstanceSpecification is1 = ((InstanceValue)slot.getValues().get(0)).getInstance();
                    for (Slot s1 : is1.getSlots()) {
                        if (s1.getDefiningFeature() != ap2) continue;
                        slot.getValues().clear();
                        slot.setDefiningFeature(ap2);
                        slot.getValues().addAll(s1.getValues());
                        continue block5;
                    }
                }
            }
        }
        for (Connector oc : ac.getOwnedConnectors()) {
            Connector oc2 = UMLFactory.eINSTANCE.createConnector();
            owner.getOwnedConnectors().add(oc2);
            if (oc.isStereotypeApplied(this.sysphsutil.getBindingConnector())) {
                oc2.applyStereotype(this.sysphsutil.getBindingConnector());
            }
            this.connectors.add(oc2);
            List<Property> lp0 = this.sysphsutil.getPropertyPath((ConnectorEnd)oc.getEnds().get(0));
            List<Property> lp1 = this.sysphsutil.getPropertyPath((ConnectorEnd)oc.getEnds().get(1));
            Property lp0p = lp0.get(0);
            if (lp0p.isStereotypeApplied(this.sysphsutil.getParticipantProperty())) {
                lp0.remove(0);
                for (ConnectorEnd connectorEnd : c.getEnds()) {
                    if (connectorEnd.getRole().getType() == null || lp0p.getType() == null || !connectorEnd.getRole().getType().conformsTo(lp0p.getType())) continue;
                    lp0.addAll(0, this.sysphsutil.getPropertyPath(connectorEnd));
                    break;
                }
            } else if (map.containsKey(lp0p)) {
                lp0.remove(0);
                lp0.add(0, (Property)map.get(lp0p));
            } else {
                log.warn("Property " + this.print(lp0p) + " not a participant nor mapped");
            }
            Property lp1p = lp1.get(0);
            if (lp1p.isStereotypeApplied(this.sysphsutil.getParticipantProperty())) {
                lp1.remove(0);
                for (ConnectorEnd ce2 : c.getEnds()) {
                    if (ce2.getRole().getType() == null || lp1p.getType() == null || !ce2.getRole().getType().conformsTo(lp1p.getType())) continue;
                    lp1.addAll(0, this.sysphsutil.getPropertyPath(ce2));
                    break;
                }
            } else if (map.containsKey(lp1p)) {
                lp1.remove(0);
                lp1.add(0, (Property)map.get(lp1p));
            } else {
                log.warn("Property " + this.print(lp1p) + " not a participant nor mapped");
            }
            ConnectorEnd connectorEnd = UMLFactory.eINSTANCE.createConnectorEnd();
            oc2.getEnds().add(connectorEnd);
            this.sysphsutil.updatePropertyPath(connectorEnd, lp0);
            ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
            oc2.getEnds().add(ce1);
            this.sysphsutil.updatePropertyPath(ce1, lp1);
            log.info("Creating " + this.print(oc2) + " for " + this.print(oc));
        }
        log.info("Removing " + this.print(c));
        EcoreUtil.delete(c, true);
        this.connectors.remove(c);
    }

    private boolean isPortType(Classifier uclassifier) {
        EList<Property> attrs = null;
        if (uclassifier instanceof Class) {
            attrs = ((Class)uclassifier).getOwnedAttributes();
        } else if (uclassifier instanceof Interface) {
            attrs = ((Interface)uclassifier).getOwnedAttributes();
        } else {
            return false;
        }
        if (attrs == null || attrs.size() == 0) {
            return false;
        }
        for (Property prop : attrs) {
            if (this.sysphsutil.isPhSProperty(prop)) continue;
            return false;
        }
        return true;
    }

    private Classifier findBetterPortType(Classifier uclassifier, Property sp) {
        Property cursp = this.getPhSPropertyOfPortType(uclassifier);
        if (cursp == sp) {
            return uclassifier;
        }
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            Classifier ret = this.findBetterPortType(ugeneral, sp);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Property getPhSPropertyOfPortType(Classifier uclassifier) {
        if (!this.isPortType(uclassifier)) {
            return null;
        }
        List<Property> lp = this.sysphsutil.getOwnedPhSProperties(uclassifier);
        if (lp.size() > 0) {
            return lp.get(0);
        }
        Property ret = null;
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            Property sp = this.getPhSPropertyOfPortType(ugeneral);
            if (sp == null) continue;
            if (ret == null) {
                ret = sp;
                continue;
            }
            return null;
        }
        return ret;
    }

    private static void moveProperty(Property uproperty, Classifier target) {
        EList<Property> lsp = null;
        Classifier source = (Classifier)uproperty.getOwner();
        if (source instanceof Class) {
            lsp = ((Class)source).getOwnedAttributes();
        } else if (source instanceof Interface) {
            lsp = ((Interface)source).getOwnedAttributes();
        } else {
            log.warn("Can't move property " + uproperty.getQualifiedName());
            return;
        }
        EList<Property> ltp = null;
        if (target instanceof Class) {
            ltp = ((Class)target).getOwnedAttributes();
        } else if (target instanceof Interface) {
            ltp = ((Interface)target).getOwnedAttributes();
        } else {
            log.warn("Can't move property " + uproperty.getQualifiedName());
            return;
        }
        lsp.remove(uproperty);
        ltp.add(uproperty);
    }

    private Classifier createPhSPropertyContainer(Property sp) {
        Classifier owner = (Classifier)sp.getOwner();
        if (owner instanceof Class) {
            Class uclass = (Class)sp.getOwner();
            Class uclass2 = UMLFactory.eINSTANCE.createClass();
            uclass.getNearestPackage().getPackagedElements().add(uclass2);
            uclass2.applyStereotype(this.sysphsutil.getBlock());
            uclass.getOwnedAttributes().remove(sp);
            uclass2.getOwnedAttributes().add(sp);
            uclass2.setName(this.sysphsutil.getName(sp.getType()) + "Sim");
            log.info("Moving sp " + this.sysphsutil.getName(sp) + " from " + this.sysphsutil.getName(uclass) + " to " + this.sysphsutil.getName(uclass2));
            return uclass2;
        }
        if (owner instanceof Interface) {
            Interface uinterface = (Interface)sp.getOwner();
            Interface uinterface2 = UMLFactory.eINSTANCE.createInterface();
            uinterface.getNearestPackage().getPackagedElements().add(uinterface2);
            uinterface.getOwnedAttributes().remove(sp);
            uinterface2.getOwnedAttributes().add(sp);
            uinterface2.setName(this.sysphsutil.getName(sp.getType()) + "Sim");
            log.info("Moving sp " + this.sysphsutil.getName(sp) + " from " + this.sysphsutil.getName(uinterface) + " to " + this.sysphsutil.getName(uinterface2));
            return uinterface2;
        }
        return null;
    }

    private List<Property> correctPath(ConnectorEnd uconnectorend, Property sp) {
        if (uconnectorend == null || sp == null) {
            return null;
        }
        List<Property> path = this.sysphsutil.getPropertyPath(uconnectorend);
        if (path == null) {
            return null;
        }
        int size = path.size();
        if (size == 0) {
            return null;
        }
        Property last = path.get(size - 1);
        Type lasttype = last.getType();
        if (lasttype instanceof Classifier) {
            Classifier clasttype = (Classifier)lasttype;
            Classifier spcontainer = this.findBetterPortType(clasttype, sp);
            if (!this.isPortType(clasttype)) {
                List<Port> lports = this.getPortList(clasttype);
                for (Port uport : lports) {
                    if (uport.getType() != spcontainer) continue;
                    path.add(uport);
                    return path;
                }
                log.error("Couldn't get the port for " + this.print(sp) + " in " + clasttype.getQualifiedName() + ", found " + lports.size() + " potentially");
            } else {
                List<Port> lports;
                if (clasttype == spcontainer) {
                    return path;
                }
                Class ucontainer = null;
                if (size == 1) {
                    ucontainer = (Class)((Connector)uconnectorend.getOwner()).getOwner();
                } else if (path.get(size - 2).getType() instanceof Class) {
                    ucontainer = (Class)path.get(size - 2).getType();
                }
                if (ucontainer != null && (lports = this.htports2.get(last)) != null) {
                    for (Port uport : lports) {
                        if (uport.getType() != spcontainer) continue;
                        path.remove(size - 1);
                        path.add(uport);
                        return path;
                    }
                }
                log.error("Couldn't get the port for " + this.print(sp) + " in " + clasttype.getQualifiedName());
            }
        }
        return null;
    }

    private List<Port> getPortList(Classifier uclassifier) {
        LinkedList<Port> ret = new LinkedList<Port>();
        List<Port> lp = this.htports1.get(uclassifier);
        if (lp != null) {
            ret.addAll(lp);
        }
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            ret.addAll(this.getPortList(ugeneral));
        }
        return ret;
    }

    private void addGeneralization(Classifier specific, Classifier general) {
        if (!specific.getGenerals().contains(general)) {
            Generalization ugeneralization = UMLFactory.eINSTANCE.createGeneralization();
            ugeneralization.setGeneral(general);
            ugeneralization.setSpecific(specific);
            specific.getGeneralizations().add(ugeneralization);
            log.info("Adding generalization between " + this.sysphsutil.getName(specific) + " and " + this.sysphsutil.getName(general));
        }
    }

    private void setUniqueName(Property uproperty, String name) {
        String name2;
        Classifier owner = (Classifier)uproperty.getOwner();
        Set<Property> attrs = this.sysphsutil.getAllAttributes(owner);
        ArrayList<String> strs = new ArrayList<String>(attrs.size());
        for (Property up : attrs) {
            strs.add(up.getName());
        }
        if (!strs.contains(name)) {
            uproperty.setName(name);
            return;
        }
        int i = 2;
        while (strs.contains(name2 = name + i++)) {
        }
        uproperty.setName(name2);
    }

    private static String lowerFirst(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    private static String upperFirst(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private void copy(EObject efrom, EObject eto) {
        if (efrom instanceof Element && eto instanceof Element) {
            Element elfrom = (Element)efrom;
            Element elto = (Element)eto;
            for (Stereotype st : elfrom.getAppliedStereotypes()) {
                if (!elto.isStereotypeApplicable(st)) continue;
                elto.applyStereotype(st);
                for (Property p : this.sysphsutil.getAllAttributes(st)) {
                    Object v;
                    String pname = p.getName();
                    if (pname.startsWith("base_") || (v = elfrom.getValue(st, pname)) == null) continue;
                    elto.setValue(st, pname, v);
                }
            }
        }
        for (EAttribute ea : efrom.eClass().getEAllAttributes()) {
            if (!ea.isChangeable() || ea.isDerived() || !efrom.eIsSet(ea)) continue;
            if (eto.eClass().getEAllAttributes().contains(ea)) {
                eto.eSet(ea, efrom.eGet(ea));
                continue;
            }
            log.warn("Can't copy attribute " + efrom.eClass().getName() + "." + ea.getName() + ", not contained in " + eto.eClass().getName());
        }
        for (EReference er : efrom.eClass().getEAllReferences()) {
            if (!er.isChangeable() || er.isDerived() || !efrom.eIsSet(er)) continue;
            if (eto.eClass().getEAllReferences().contains(er)) {
                eto.eSet(er, efrom.eGet(er));
                continue;
            }
            log.warn("Can't copy reference " + efrom.eClass().getName() + "." + er.getName() + ", not contained in " + eto.eClass().getName());
        }
    }

    private void replace(EObject eold, EObject enew) {
        if (eold instanceof Element && enew instanceof Element) {
            Element elold = (Element)eold;
            Iterator elnew = (Element)enew;
            while (elold.getAppliedStereotypes().size() != 0) {
                Stereotype stereotype = (Stereotype)elold.getAppliedStereotypes().get(0);
                if (elnew.isStereotypeApplicable(stereotype)) {
                    elnew.applyStereotype(stereotype);
                    for (Property p : this.sysphsutil.getAllAttributes(stereotype)) {
                        Object v;
                        String pname = p.getName();
                        if (pname.startsWith("base_") || (v = elold.getValue(stereotype, pname)) == null) continue;
                        elnew.setValue(stereotype, pname, v);
                    }
                }
                elold.unapplyStereotype(stereotype);
            }
        }
        ResourceSet rs = eold.eResource().getResourceSet();
        if (!eold.eContainmentFeature().getEReferenceType().isSuperTypeOf(enew.eClass())) {
            log.error("The old object can't be replaced by the new one: incompatible containment feature");
            return;
        }
        for (EReference eReference : eold.eClass().getEAllContainments()) {
            SysMLPreProcessor.replace(eold, enew, eReference);
        }
        for (EAttribute eAttribute : eold.eClass().getEAllAttributes()) {
            if (!eAttribute.isChangeable() || eAttribute.isDerived() || !eold.eIsSet(eAttribute)) continue;
            if (enew.eClass().getEAllAttributes().contains(eAttribute)) {
                enew.eSet(eAttribute, eold.eGet(eAttribute));
                continue;
            }
            log.warn("Can't translate attribute " + eold.eClass().getName() + "." + eAttribute.getName() + ", not contained in " + enew.eClass().getName());
        }
        for (EReference eReference : eold.eClass().getEAllReferences()) {
            SysMLPreProcessor.replace(eold, enew, eReference);
        }
        Collection<EStructuralFeature.Setting> sets = EcoreUtil.UsageCrossReferencer.find(eold, rs);
        for (EStructuralFeature.Setting set : sets) {
            EReference er = (EReference)set.getEStructuralFeature();
            EObject eo = set.getEObject();
            if (!er.isChangeable() || er.isDerived()) continue;
            if (er.isMany()) {
                EList el = (EList)eo.eGet(er);
                int i = el.indexOf(eold);
                while (i != -1) {
                    el.remove(i);
                    if (er.getEReferenceType().isSuperTypeOf(enew.eClass())) {
                        if (er.isUnique() && !el.contains(enew)) {
                            el.add(i, enew);
                        }
                    } else {
                        log.warn("Can't translate reference list " + eo.eClass().getName() + "." + er.getName() + ", " + enew.eClass().getName() + " incompatible with " + er.getEReferenceType().getName());
                    }
                    i = el.indexOf(eold);
                }
                continue;
            }
            eo.eUnset(er);
            if (er.getEReferenceType().isSuperTypeOf(enew.eClass())) {
                eo.eSet(er, enew);
                continue;
            }
            log.warn("Can't translate reference " + eo.eClass().getName() + "." + er.getName() + ", " + enew.eClass().getName() + " incompatible with " + er.getEReferenceType().getName());
        }
        EObject eObject = eold.eContainer();
        EReference er = eold.eContainmentFeature();
        if (eObject != null && er != null) {
            if (er.isMany()) {
                EList el = (EList)eObject.eGet(er);
                int i = el.indexOf(eold);
                el.remove(i);
                if (!er.isUnique() && el.contains(enew)) {
                    el.add(i, enew);
                }
            } else {
                eObject.eSet(er, enew);
                log.info("set " + eObject.eClass().getName() + "." + er.getName());
            }
        }
        sets = EcoreUtil.UsageCrossReferencer.find(eold, rs);
        for (EStructuralFeature.Setting set : sets) {
            er = (EReference)set.getEStructuralFeature();
            EObject eObject2 = set.getEObject();
            log.error("Usage not treated: " + eObject2.eClass().getName() + "." + er.getName());
        }
    }

    private static void replace(EObject eold, EObject enew, EReference er) {
        if (!er.isChangeable() || er.isDerived() || !eold.eIsSet(er)) {
            return;
        }
        EReference er2 = er.getEOpposite();
        String sref = eold.eClass().getName() + "." + er.getName();
        if (er2 != null) {
            sref = sref + "(" + er.getEType().getName() + "." + er2.getName() + ")";
        }
        boolean moved = true;
        if (!enew.eClass().getEAllReferences().contains(er) && !enew.eClass().getEAllContainments().contains(er)) {
            log.warn("Can't translate reference " + sref + ", not contained in " + enew.eClass().getName());
            moved = false;
        }
        if (er.isMany()) {
            EList el = (EList)eold.eGet(er);
            while (el.size() != 0) {
                int i = -1;
                EObject eo = (EObject)el.get(0);
                if (er2 != null && er2.isChangeable() && !er2.isDerived() && er2.isMany()) {
                    i = ((EList)eo.eGet(er2)).indexOf(eold);
                }
                el.remove(0);
                if (moved) {
                    EList el2 = (EList)enew.eGet(er);
                    el2.add(eo);
                }
                if (i != -1 && moved) {
                    ((EList)eo.eGet(er2)).move(i, enew);
                    continue;
                }
                log.info("set " + sref);
            }
        } else {
            EObject eo = (EObject)eold.eGet(er);
            int i = -1;
            if (er2 != null && er2.isChangeable() && !er2.isDerived() && er2.isMany()) {
                i = ((EList)eo.eGet(er2)).indexOf(eold);
            }
            eold.eUnset(er);
            if (moved) {
                enew.eSet(er, eo);
            }
            if (i != -1 && moved) {
                ((EList)eo.eGet(er2)).move(i, enew);
            } else {
                log.info("set " + sref);
            }
        }
    }

    private static void print(EObject eo) {
        log.debug("Printing " + Integer.toHexString(eo.hashCode()));
        for (EStructuralFeature esf : eo.eClass().getEAllStructuralFeatures()) {
            Object v = eo.eGet(esf);
            if (v instanceof EList) {
                log.debug("Attr " + esf.getName() + ":");
                for (Object o : (EList)v) {
                    if (o instanceof EObject) {
                        log.debug(" " + Integer.toHexString(o.hashCode()));
                        continue;
                    }
                    log.debug(" " + o);
                }
                continue;
            }
            if (v == null) continue;
            log.debug("Attr " + esf.getName() + ":");
            if (v instanceof EObject) {
                log.debug(v.hashCode());
                continue;
            }
            log.debug(v);
        }
    }

    private String print(Connector c) {
        StringBuilder sb = new StringBuilder();
        if (c.getOwner() instanceof Class) {
            sb.append(((Class)c.getOwner()).getName() + "::");
        }
        for (int i = 0; i < c.getEnds().size(); ++i) {
            if (i != 0) {
                sb.append("-");
            }
            sb.append(this.print((ConnectorEnd)c.getEnds().get(i)));
        }
        return sb.toString();
    }

    private String print(ConnectorEnd ce) {
        return this.print(this.sysphsutil.getPropertyPath(ce));
    }

    private String print(List<Property> lp) {
        if (lp == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lp.size(); ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(this.print(lp.get(i)));
        }
        return sb.toString();
    }

    private String print(Property p) {
        return p.getName() == null ? p.toString() : p.getQualifiedName();
    }

    private String print(Class c) {
        return c.getQualifiedName();
    }
}

