/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SPackage;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;

public class SimscapeUtil {
    private static final Logger log = Logger.getLogger(SimscapeUtil.class);
    private static SPackage spackage;
    private static SComponent ssolverconfiguration;
    private static SComponent sps2sim;
    private static SComponent ssim2ps;
    private static SComponent lcpc;
    private static SComponent rcpc;
    private static Set<SDomain> domains;

    public static synchronized SPackage getUtilityPackage() {
        if (spackage == null) {
            spackage = SimscapeFactory.eINSTANCE.createSPackage();
            spackage.setName("nesl_utility");
            spackage.setGenerated(false);
        }
        return spackage;
    }

    public static synchronized SComponent getSolverConfiguration() {
        if (ssolverconfiguration == null) {
            ssolverconfiguration = SimscapeFactory.eINSTANCE.createSComponent();
            ssolverconfiguration.setName("Solver\nConfiguration");
            ssolverconfiguration.setPhysicalDomain("network_engine_domain");
            ssolverconfiguration.setSubClass("solver");
            ssolverconfiguration.setOwningPackage(SimscapeUtil.getUtilityPackage());
            SNode snode = SimscapeFactory.eINSTANCE.createSNode();
            snode.setLocation(SLocation.RIGHT);
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setLocation(SLocation.RIGHT);
            scpb.setMember(snode);
            scpb.setOwningSystem(ssolverconfiguration);
            ssolverconfiguration.getOwnedMembers().add(snode);
        }
        return ssolverconfiguration;
    }

    public static synchronized SComponent getSimulink2PS() {
        if (ssim2ps == null) {
            ssim2ps = SimscapeFactory.eINSTANCE.createSComponent();
            ssim2ps.setName("Simulink-PS\nConverter");
            ssim2ps.setPhysicalDomain("network_engine_domain");
            ssim2ps.setSubClass("ps_output");
            ssim2ps.setOwningPackage(SimscapeUtil.getUtilityPackage());
            SInport sinport = SimulinkFactory.eINSTANCE.createSInport();
            sinport.setOwningSystem(ssim2ps);
            SNode snode = SimscapeFactory.eINSTANCE.createSNode();
            snode.setLocation(SLocation.RIGHT);
            ssim2ps.getOwnedMembers().add(snode);
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(snode);
            scpb.setLocation(SLocation.RIGHT);
            scpb.setOwningSystem(ssim2ps);
        }
        return ssim2ps;
    }

    public static synchronized SComponent getPS2Simulink() {
        if (sps2sim == null) {
            sps2sim = SimscapeFactory.eINSTANCE.createSComponent();
            sps2sim.setName("PS-Simulink\nConverter");
            sps2sim.setPhysicalDomain("network_engine_domain");
            sps2sim.setSubClass("ps_input");
            sps2sim.setOwningPackage(SimscapeUtil.getUtilityPackage());
            SOutport soutport = SimulinkFactory.eINSTANCE.createSOutport();
            soutport.setOwningSystem(sps2sim);
            SNode snode = SimscapeFactory.eINSTANCE.createSNode();
            snode.setLocation(SLocation.LEFT);
            sps2sim.getOwnedMembers().add(snode);
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(snode);
            scpb.setLocation(SLocation.LEFT);
            scpb.setOwningSystem(sps2sim);
        }
        return sps2sim;
    }

    public static synchronized SComponent getConnectionPortComponent() {
        if (rcpc == null) {
            rcpc = SimscapeFactory.eINSTANCE.createSComponent();
            SNode sn = SimscapeFactory.eINSTANCE.createSNode();
            sn.setLocation(SLocation.RIGHT);
            rcpc.getOwnedMembers().add(sn);
            SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
            scpb.setMember(sn);
            scpb.setLocation(SLocation.RIGHT);
            scpb.setOwningSystem(rcpc);
        }
        return rcpc;
    }

    public static SDomain getDomain(Class uclass) {
        if (domains == null) {
            domains = new HashSet<SDomain>();
            SDomain sdelectrical = SimscapeFactory.eINSTANCE.createSDomain();
            sdelectrical.setName("foundation.electrical.electrical");
            SVariable svi = SimscapeFactory.eINSTANCE.createSVariable();
            svi.setName("i");
            svi.setUnit("A");
            svi.setBalancing(true);
            sdelectrical.getVariables().add(svi);
            SVariable svv = SimscapeFactory.eINSTANCE.createSVariable();
            svv.setName("v");
            svv.setUnit("V");
            sdelectrical.getVariables().add(svv);
            domains.add(sdelectrical);
            SDomain sdhydraulic = SimscapeFactory.eINSTANCE.createSDomain();
            sdhydraulic.setName("foundation.hydraulic.hydraulic");
            SVariable svq = SimscapeFactory.eINSTANCE.createSVariable();
            svq.setName("q");
            svq.setUnit("m^3/s");
            svq.setBalancing(true);
            sdhydraulic.getVariables().add(svq);
            SVariable svp = SimscapeFactory.eINSTANCE.createSVariable();
            svp.setName("p");
            svp.setUnit("Pa");
            sdhydraulic.getVariables().add(svp);
            domains.add(sdhydraulic);
            SDomain sdmagnetic = SimscapeFactory.eINSTANCE.createSDomain();
            sdmagnetic.setName("foundation.magnetic.magnetic");
            SVariable phi = SimscapeFactory.eINSTANCE.createSVariable();
            phi.setName("phi");
            phi.setUnit("Wb");
            phi.setBalancing(true);
            sdmagnetic.getVariables().add(phi);
            SVariable mmf = SimscapeFactory.eINSTANCE.createSVariable();
            mmf.setName("mmf");
            mmf.setUnit("A");
            sdmagnetic.getVariables().add(mmf);
            domains.add(sdmagnetic);
            SDomain sdrotational = SimscapeFactory.eINSTANCE.createSDomain();
            sdrotational.setName("foundation.mechanical.rotational");
            SVariable t = SimscapeFactory.eINSTANCE.createSVariable();
            t.setName("t");
            t.setUnit("N*m");
            t.setBalancing(true);
            sdrotational.getVariables().add(t);
            SVariable w = SimscapeFactory.eINSTANCE.createSVariable();
            w.setName("w");
            w.setUnit("rad/s");
            sdrotational.getVariables().add(w);
            domains.add(sdrotational);
            SDomain sdtranslational = SimscapeFactory.eINSTANCE.createSDomain();
            sdtranslational.setName("foundation.mechanical.translational");
            SVariable f = SimscapeFactory.eINSTANCE.createSVariable();
            f.setName("f");
            f.setUnit("N");
            f.setBalancing(true);
            sdtranslational.getVariables().add(f);
            SVariable v = SimscapeFactory.eINSTANCE.createSVariable();
            v.setName("v");
            v.setUnit("m/s");
            sdtranslational.getVariables().add(v);
            domains.add(sdtranslational);
            SDomain sdpneumatic = SimscapeFactory.eINSTANCE.createSDomain();
            sdpneumatic.setName("foundation.pneumatic.pneumatic");
            SVariable g = SimscapeFactory.eINSTANCE.createSVariable();
            g.setName("G");
            g.setUnit("kg/s");
            g.setBalancing(true);
            sdpneumatic.getVariables().add(g);
            SVariable q = SimscapeFactory.eINSTANCE.createSVariable();
            q.setName("Q");
            q.setUnit("J/s");
            q.setBalancing(true);
            sdpneumatic.getVariables().add(q);
            SVariable p = SimscapeFactory.eINSTANCE.createSVariable();
            p.setName("p");
            p.setUnit("Pa");
            sdpneumatic.getVariables().add(p);
            SVariable t2 = SimscapeFactory.eINSTANCE.createSVariable();
            t2.setName("t");
            t2.setUnit("K");
            sdpneumatic.getVariables().add(t2);
            domains.add(sdpneumatic);
            SDomain sdthermal = SimscapeFactory.eINSTANCE.createSDomain();
            sdthermal.setName("foundation.thermal.thermal");
            q = SimscapeFactory.eINSTANCE.createSVariable();
            q.setName("Q");
            q.setUnit("J/s");
            q.setBalancing(true);
            sdthermal.getVariables().add(q);
            SVariable t3 = SimscapeFactory.eINSTANCE.createSVariable();
            t3.setName("t");
            q.setUnit("J/s");
            sdthermal.getVariables().add(t3);
            domains.add(sdthermal);
        }
        for (SDomain domain : domains) {
            if (!SimscapeUtil.match(uclass, domain)) continue;
            return domain;
        }
        return null;
    }

    private static boolean match(Class c, SDomain sd) {
        if (c == null || sd == null) {
            return false;
        }
        if (c.getOwnedAttributes().size() != sd.getVariables().size()) {
            return false;
        }
        for (Property p : c.getOwnedAttributes()) {
            boolean ok = false;
            for (SVariable sv : sd.getVariables()) {
                if (!p.getName().equals(sv.getName())) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    static {
        domains = null;
    }
}

