/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.client.gui;

import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.sysphs.client.gui.WorkerDialog;
import com.engisis.sysphs.translation.modelica.SysMLToModelicaTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.xmiutil.UMLModelErrorException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;

public class SysMLToSimulationFrame
extends JFrame {
    private static final long serialVersionUID = 3776110556936924804L;
    private static final Logger log = Logger.getLogger(SysMLToSimulationFrame.class);
    private File fmodel;
    private File foutput;
    private JPanel jpBlock;
    private JList<String> jlBlocks;
    private JPanel jpInformation;
    private JLabel jlFiles;
    private JLabel jlBlock;
    private ButtonGroup bgTranslator;
    private JPanel jpTranslator;
    private JLabel jlTranslator;
    private JRadioButton jrbModelica;
    private JRadioButton jrbSimulink;
    private JLabel jlPreproc;
    private JCheckBox jcbPreproc;
    private ButtonGroup bgFormat;
    private JLabel jlFormat;
    private JRadioButton jrbText;
    private JRadioButton jrbXML;
    private ButtonGroup bgSF;
    private JLabel jlSF;
    private JRadioButton jrbSimscape;
    private JRadioButton jrbSF1;
    private JRadioButton jrbSF2;
    private ButtonGroup bgDomain;
    private JLabel jlDomain;
    private JRadioButton jrbCreate;
    private JRadioButton jrbReuse;
    private JPanel jpOutput;
    private JButton jbOutput;
    private JLabel jlOutput;
    private JButton jbTranslate;
    private SysMLToSimulationTranslationManager sysml2simulation;
    private SysMLToSimulationTranslator translator;
    private WorkerDialog swd;

    public SysMLToSimulationFrame(final String model, final String rootblock, final String[] paths) {
        super("Simulation frame");
        this.fmodel = new File(model);
        this.foutput = this.fmodel.getParentFile();
        if (!SysMLToSimulationFrame.isWritable(this.foutput)) {
            this.foutput = new File(System.getProperty("user.home"));
        }
        this.setDefaultCloseOperation(3);
        this.swd = new WorkerDialog(this);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                WorkerDialog.Worker<Boolean, Void> sw = new WorkerDialog.Worker<Boolean, Void>(SysMLToSimulationFrame.this.swd){

                    @Override
                    public Boolean doInBackground() {
                        try {
                            SysMLToSimulationFrame.this.sysml2simulation = new SysMLToSimulationTranslationManager(model, paths);
                            SysMLToSimulationFrame.this.jlBlocks.setListData(SysMLToSimulationFrame.this.sysml2simulation.getClasses().toArray(new String[0]));
                            if (rootblock != null) {
                                for (int i = 0; i < SysMLToSimulationFrame.this.jlBlocks.getModel().getSize(); ++i) {
                                    if (!((String)SysMLToSimulationFrame.this.jlBlocks.getModel().getElementAt(i)).equals(rootblock)) continue;
                                    SysMLToSimulationFrame.this.jlBlocks.setSelectedIndex(i);
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            log.error("File error during the initialization", e);
                            return false;
                        }
                        catch (UMLModelErrorException e) {
                            log.error("Bad model error during the initialization", e);
                            return false;
                        }
                        catch (XMLStreamException e) {
                            log.error("XML error during the initialization", e);
                            return false;
                        }
                        catch (IOException e) {
                            log.error("IO error during the initialization", e);
                            return false;
                        }
                        return true;
                    }

                    @Override
                    protected void done() {
                        super.done();
                        try {
                            Boolean res = (Boolean)this.get();
                            if (res == null || !res.booleanValue()) {
                                JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "The initialization failed");
                            }
                        }
                        catch (InterruptedException e) {
                            JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "The initialization failed, " + e);
                        }
                        catch (ExecutionException e) {
                            JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "The initialization failed, " + e);
                        }
                    }
                };
                SysMLToSimulationFrame.this.swd.show(sw, "Initializing");
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (SysMLToSimulationFrame.this.sysml2simulation != null) {
                        SysMLToSimulationFrame.this.sysml2simulation.setTranslator(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jpBlock = new JPanel();
        this.getContentPane().add(this.jpBlock);
        this.jpBlock.setBorder(BorderFactory.createTitledBorder("Blocks"));
        this.jpBlock.setLayout(new BorderLayout());
        this.jlBlocks = new JList();
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.jlBlocks);
        this.jpBlock.add(jsp);
        this.jpInformation = new JPanel();
        this.getContentPane().add(this.jpInformation);
        GroupLayout glInformation = new GroupLayout(this.jpInformation);
        this.jpInformation.setLayout(glInformation);
        this.jpInformation.setBorder(BorderFactory.createTitledBorder("Information"));
        this.jlFiles = new JLabel();
        StringBuilder sbinfo = new StringBuilder();
        sbinfo.append("Files: " + model);
        this.jlFiles.setText(sbinfo.toString());
        this.jlBlock = new JLabel();
        this.jlBlock.setText("Block: " + rootblock);
        glInformation.setHorizontalGroup(glInformation.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlFiles).addComponent(this.jlBlock));
        glInformation.setVerticalGroup(glInformation.createSequentialGroup().addComponent(this.jlFiles).addComponent(this.jlBlock));
        this.jpTranslator = new JPanel();
        this.getContentPane().add(this.jpTranslator);
        GroupLayout glTranslator = new GroupLayout(this.jpTranslator);
        this.jpTranslator.setLayout(glTranslator);
        this.jpTranslator.setBorder(BorderFactory.createTitledBorder("Translator"));
        this.jlTranslator = new JLabel("Target language:");
        this.jrbModelica = new JRadioButton("Modelica");
        this.jrbSimulink = new JRadioButton("Simulink");
        this.bgTranslator = new ButtonGroup();
        this.bgTranslator.add(this.jrbModelica);
        this.bgTranslator.add(this.jrbSimulink);
        this.jrbModelica.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SysMLToSimulationFrame.this.translator = new SysMLToModelicaTranslator();
                    SysMLToSimulationFrame.this.jrbText.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbXML.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbSF1.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbSF2.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbSimscape.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbReuse.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbCreate.setEnabled(false);
                    SysMLToSimulationFrame.this.bgFormat.clearSelection();
                    SysMLToSimulationFrame.this.bgSF.clearSelection();
                    SysMLToSimulationFrame.this.bgDomain.clearSelection();
                }
            }
        });
        this.jrbSimulink.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SysMLToSimulationFrame.this.translator = new SysMLToSimulinkTranslator();
                SysMLToSimulationFrame.this.jrbText.setEnabled(true);
                SysMLToSimulationFrame.this.jrbXML.setEnabled(true);
                SysMLToSimulationFrame.this.jrbSF1.setEnabled(true);
                SysMLToSimulationFrame.this.jrbSF2.setEnabled(true);
                SysMLToSimulationFrame.this.jrbSimscape.setEnabled(true);
            }
        });
        this.jlFormat = new JLabel("Format:");
        this.jrbText = new JRadioButton("Text (.mdl)");
        this.jrbXML = new JRadioButton("XML (.sdl)");
        this.bgFormat = new ButtonGroup();
        this.bgFormat.add(this.jrbText);
        this.bgFormat.add(this.jrbXML);
        this.jlSF = new JLabel("S-Function or Simscape:");
        this.jrbSF1 = new JRadioButton("S-Function version 1");
        this.jrbSF2 = new JRadioButton("S-Function version 2");
        this.jrbSimscape = new JRadioButton("Simscape");
        this.jrbSimscape.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SysMLToSimulationFrame.this.jrbCreate.setEnabled(true);
                    SysMLToSimulationFrame.this.jrbReuse.setEnabled(true);
                } else {
                    SysMLToSimulationFrame.this.jrbCreate.setEnabled(false);
                    SysMLToSimulationFrame.this.jrbReuse.setEnabled(false);
                    SysMLToSimulationFrame.this.bgDomain.clearSelection();
                }
            }
        });
        this.bgSF = new ButtonGroup();
        this.bgSF.add(this.jrbSimscape);
        this.bgSF.add(this.jrbSF2);
        this.bgSF.add(this.jrbSF1);
        this.jlDomain = new JLabel("Simscape port libraries:");
        this.jrbCreate = new JRadioButton("Create new port types");
        this.jrbReuse = new JRadioButton("Reuse existing port types");
        this.bgDomain = new ButtonGroup();
        this.bgDomain.add(this.jrbCreate);
        this.bgDomain.add(this.jrbReuse);
        this.jlPreproc = new JLabel();
        this.jlPreproc.setText("Preprocessing transformations (Experimental)");
        this.jcbPreproc = new JCheckBox();
        glTranslator.setHorizontalGroup(glTranslator.createSequentialGroup().addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlTranslator).addComponent(this.jlFormat).addComponent(this.jlSF).addComponent(this.jlDomain).addComponent(this.jlPreproc)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jrbModelica).addComponent(this.jrbText).addComponent(this.jrbSimscape).addComponent(this.jrbCreate).addComponent(this.jcbPreproc)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jrbSimulink).addComponent(this.jrbXML).addComponent(this.jrbSF2).addComponent(this.jrbReuse).addGap(0)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0).addGap(0).addComponent(this.jrbSF1).addGap(0).addGap(0)));
        glTranslator.setVerticalGroup(glTranslator.createSequentialGroup().addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlTranslator).addComponent(this.jrbModelica).addComponent(this.jrbSimulink).addGap(0)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlFormat).addComponent(this.jrbText).addComponent(this.jrbXML).addGap(0)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlSF).addComponent(this.jrbSimscape).addComponent(this.jrbSF2).addComponent(this.jrbSF1)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlDomain).addComponent(this.jrbCreate).addComponent(this.jrbReuse).addGap(0)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlPreproc).addComponent(this.jcbPreproc).addGap(0).addGap(0)));
        this.jpOutput = new JPanel();
        this.getContentPane().add(this.jpOutput);
        GroupLayout glOutput = new GroupLayout(this.jpOutput);
        this.jpOutput.setLayout(glOutput);
        this.jpOutput.setBorder(BorderFactory.createTitledBorder("Output directory"));
        this.jbOutput = new JButton();
        this.jbOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setCurrentDirectory(SysMLToSimulationFrame.this.foutput);
                jfc.setDialogTitle("Select output directory");
                jfc.setFileSelectionMode(1);
                jfc.setAcceptAllFileFilterUsed(false);
                if (jfc.showOpenDialog(SysMLToSimulationFrame.this) == 0) {
                    SysMLToSimulationFrame.this.foutput = jfc.getSelectedFile();
                    SysMLToSimulationFrame.this.updateOutput();
                }
            }
        });
        this.jlOutput = new JLabel();
        glOutput.setHorizontalGroup(glOutput.createSequentialGroup().addComponent(this.jbOutput).addComponent(this.jlOutput));
        glOutput.setVerticalGroup(glOutput.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbOutput).addComponent(this.jlOutput));
        this.jbTranslate = new JButton();
        this.jbTranslate.setText("Translate");
        this.jbTranslate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    HashSet<Object> options = new HashSet<Object>();
                    if (SysMLToSimulationFrame.this.jrbText.isEnabled() && SysMLToSimulationFrame.this.jrbText.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.Format.TEXT);
                    } else if (SysMLToSimulationFrame.this.jrbXML.isEnabled() && SysMLToSimulationFrame.this.jrbText.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.Format.XML);
                    }
                    if (SysMLToSimulationFrame.this.jrbSF1.isEnabled() && SysMLToSimulationFrame.this.jrbSF1.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.SFunction.Level1);
                    } else if (SysMLToSimulationFrame.this.jrbSF2.isEnabled() && SysMLToSimulationFrame.this.jrbSF2.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.SFunction.Level2);
                    } else if (SysMLToSimulationFrame.this.jrbSimscape.isEnabled() && SysMLToSimulationFrame.this.jrbSimscape.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.SFunction.Simscape);
                    }
                    if (SysMLToSimulationFrame.this.jrbCreate.isEnabled() && SysMLToSimulationFrame.this.jrbCreate.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.Domains.CREATE);
                    } else if (SysMLToSimulationFrame.this.jrbReuse.isEnabled() && SysMLToSimulationFrame.this.jrbReuse.isSelected()) {
                        options.add((Object)SysMLToSimulinkTranslator.Domains.REUSE);
                    }
                    if (SysMLToSimulationFrame.this.translator == null) {
                        JOptionPane.showMessageDialog(SysMLToSimulationFrame.this, "You must select a translator");
                        return;
                    }
                    if (SysMLToSimulationFrame.this.jlBlocks.getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(SysMLToSimulationFrame.this, "You must select a root class");
                        return;
                    }
                    SysMLToSimulationFrame.this.translator.reset();
                    SysMLToSimulationFrame.this.translator.loadOptions(options);
                    SysMLToSimulationFrame.this.sysml2simulation.setInputRootName((String)SysMLToSimulationFrame.this.jlBlocks.getSelectedValue());
                    SysMLToSimulationFrame.this.sysml2simulation.setPreprocessing(SysMLToSimulationFrame.this.jcbPreproc.isSelected());
                    SysMLToSimulationFrame.this.sysml2simulation.setTranslator(SysMLToSimulationFrame.this.translator);
                    SysMLToSimulationFrame.this.sysml2simulation.setOutputDirectory(SysMLToSimulationFrame.this.foutput);
                }
                catch (Exception e) {
                    log.error("Could not create the translator", e);
                }
                WorkerDialog.Worker<Void, Void> sw = new WorkerDialog.Worker<Void, Void>(SysMLToSimulationFrame.this.swd){

                    @Override
                    public Void doInBackground() {
                        try {
                            SysMLToSimulationFrame.this.sysml2simulation.execute();
                        }
                        catch (UMLModelErrorException e) {
                            JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "The translation failed");
                            log.error("Bad model error during the translation");
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "The translation failed");
                            log.error("IO error during the translation", e);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(SysMLToSimulationFrame.this.swd, "Unexpected exception");
                            log.error("Other error during the translation", e);
                        }
                        return null;
                    }
                };
                SysMLToSimulationFrame.this.swd.show(sw, "Translating file");
            }
        });
        this.getContentPane().add(this.jbTranslate);
        this.pack();
        this.jrbModelica.setSelected(true);
        this.updateOutput();
    }

    private void updateOutput() {
        log.debug("Changed output directory to " + this.foutput);
        this.jbOutput.setText(this.foutput.getAbsolutePath());
        if (SysMLToSimulationFrame.isWritable(this.foutput)) {
            this.jlOutput.setText("");
            this.jlOutput.setForeground(Color.BLACK);
        } else {
            this.jlOutput.setText("Readonly directory");
            this.jlOutput.setForeground(Color.RED);
        }
    }

    private static boolean isWritable(File dir) {
        if (!(dir != null && dir.exists() && dir.isDirectory() && dir.canWrite())) {
            return false;
        }
        try {
            File tmp = File.createTempFile("sim", "tmp", dir);
            tmp.delete();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

