/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.client.gui;

import com.engisis.sysphs.SimulationToSysMLTranslationManager;
import com.engisis.sysphs.client.gui.WorkerDialog;
import com.engisis.sysphs.translation.modelica.ModelicaToSysMLTranslator;
import com.engisis.sysphs.translation.simulink.SimulinkToSysMLTranslator;
import com.engisis.sysphs.util.SimulationToSysMLTranslator;
import com.engisis.xmiutil.EMFConfiguration;
import com.engisis.xmiutil.UMLModelErrorException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class SimulationToSysMLFrame
extends JFrame {
    private static final long serialVersionUID = -1105097960685575427L;
    private static final Logger log = Logger.getLogger(SimulationToSysMLFrame.class);
    private File fmodel;
    private File foutput;
    private SimulationToSysMLTranslationManager simulation2sysml;
    private SimulationToSysMLTranslator translator;
    private WorkerDialog swd;
    private JPanel jpInformation;
    private JLabel jlFiles;
    private JPanel jpTranslator;
    private JLabel jlTranslator;
    private JRadioButton jrbModelica;
    private JRadioButton jrbSimulink;
    private ButtonGroup bgTranslator;
    private JPanel jpTarget;
    private JComboBox<String> jcbTarget;
    private JPanel jpOutput;
    private JButton jbOutput;
    private JLabel jlOutput;
    private JButton jbTranslate;

    public SimulationToSysMLFrame(String model, String rootblock, String[] paths) {
        super("Simulation frame");
        this.fmodel = new File(model);
        this.foutput = this.fmodel.getParentFile();
        if (!SimulationToSysMLFrame.isWritable(this.foutput)) {
            this.foutput = new File(System.getProperty("user.home"));
        }
        this.setDefaultCloseOperation(3);
        this.swd = new WorkerDialog(this);
        try {
            this.simulation2sysml = new SimulationToSysMLTranslationManager(model, paths);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (SimulationToSysMLFrame.this.simulation2sysml != null) {
                        SimulationToSysMLFrame.this.simulation2sysml.setTranslator(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jpInformation = new JPanel();
        this.getContentPane().add(this.jpInformation);
        this.jpInformation.setBorder(BorderFactory.createTitledBorder("Information"));
        this.jlFiles = new JLabel();
        this.jpInformation.add(this.jlFiles);
        StringBuilder sbinfo = new StringBuilder();
        sbinfo.append("Files: " + model);
        this.jlFiles.setText(sbinfo.toString());
        this.jpTranslator = new JPanel();
        this.getContentPane().add(this.jpTranslator);
        GroupLayout glTranslator = new GroupLayout(this.jpTranslator);
        this.jpTranslator.setLayout(glTranslator);
        this.jpTranslator.setBorder(BorderFactory.createTitledBorder("Translator"));
        this.jlTranslator = new JLabel("Source language:");
        this.jrbModelica = new JRadioButton("Modelica");
        this.jrbModelica.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SimulationToSysMLFrame.this.translator = new ModelicaToSysMLTranslator(null);
                }
            }
        });
        this.jrbSimulink = new JRadioButton("Simulink");
        this.jrbSimulink.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SimulationToSysMLFrame.this.translator = new SimulinkToSysMLTranslator();
                }
            }
        });
        this.bgTranslator = new ButtonGroup();
        this.bgTranslator.add(this.jrbModelica);
        this.bgTranslator.add(this.jrbSimulink);
        String ext = model.toLowerCase();
        if (ext.endsWith(".slx") || ext.endsWith(".mdl")) {
            this.jrbSimulink.setSelected(true);
        } else if (ext.endsWith(".mo")) {
            this.jrbModelica.setSelected(true);
        }
        glTranslator.setHorizontalGroup(glTranslator.createSequentialGroup().addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlTranslator)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jrbModelica)).addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jrbSimulink)));
        glTranslator.setVerticalGroup(glTranslator.createSequentialGroup().addGroup(glTranslator.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlTranslator).addComponent(this.jrbModelica).addComponent(this.jrbSimulink)));
        this.jpTarget = new JPanel();
        this.getContentPane().add(this.jpTarget);
        GroupLayout glTarget = new GroupLayout(this.jpTarget);
        this.jpTarget.setLayout(glTarget);
        this.jpTarget.setBorder(BorderFactory.createTitledBorder("XMI target"));
        JLabel jlTarget = new JLabel("Target:");
        this.jcbTarget = new JComboBox();
        this.jcbTarget.setEditable(false);
        for (String target : EMFConfiguration.getTargets()) {
            this.jcbTarget.addItem(target);
        }
        glTarget.setHorizontalGroup(glTarget.createSequentialGroup().addGroup(glTarget.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jlTarget)).addGroup(glTarget.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jcbTarget)));
        glTarget.setVerticalGroup(glTarget.createSequentialGroup().addGroup(glTarget.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jlTarget).addComponent(this.jcbTarget)));
        this.jpOutput = new JPanel();
        this.getContentPane().add(this.jpOutput);
        GroupLayout glOutput = new GroupLayout(this.jpOutput);
        this.jpOutput.setLayout(glOutput);
        this.jpOutput.setBorder(BorderFactory.createTitledBorder("Output directory"));
        this.jbOutput = new JButton();
        this.jbOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setCurrentDirectory(SimulationToSysMLFrame.this.foutput);
                jfc.setDialogTitle("Select output directory");
                jfc.setFileSelectionMode(1);
                jfc.setAcceptAllFileFilterUsed(false);
                if (jfc.showOpenDialog(SimulationToSysMLFrame.this) == 0) {
                    SimulationToSysMLFrame.this.foutput = jfc.getSelectedFile();
                    SimulationToSysMLFrame.this.updateOutput();
                }
            }
        });
        this.jlOutput = new JLabel();
        glOutput.setHorizontalGroup(glOutput.createSequentialGroup().addComponent(this.jbOutput).addComponent(this.jlOutput));
        glOutput.setVerticalGroup(glOutput.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbOutput).addComponent(this.jlOutput));
        this.jbTranslate = new JButton();
        this.jbTranslate.setText("Translate");
        this.jbTranslate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (SimulationToSysMLFrame.this.translator == null) {
                        JOptionPane.showMessageDialog(SimulationToSysMLFrame.this, "You must select a translator");
                        return;
                    }
                    SimulationToSysMLFrame.this.simulation2sysml.setTranslator(SimulationToSysMLFrame.this.translator);
                    SimulationToSysMLFrame.this.simulation2sysml.setOutputDirectory(SimulationToSysMLFrame.this.foutput);
                    int i = SimulationToSysMLFrame.this.jcbTarget.getSelectedIndex();
                    if (i != -1) {
                        SimulationToSysMLFrame.this.simulation2sysml.setTarget((String)SimulationToSysMLFrame.this.jcbTarget.getItemAt(i));
                    }
                }
                catch (Exception e) {
                    log.error("Could not create the translator", e);
                }
                WorkerDialog.Worker<Void, Void> sw = new WorkerDialog.Worker<Void, Void>(SimulationToSysMLFrame.this.swd){

                    @Override
                    public Void doInBackground() {
                        try {
                            SimulationToSysMLFrame.this.simulation2sysml.execute();
                        }
                        catch (UMLModelErrorException e) {
                            JOptionPane.showMessageDialog(SimulationToSysMLFrame.this.swd, "The translation failed");
                            log.error("Bad model error during the translation", e);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(SimulationToSysMLFrame.this.swd, "The translation failed");
                            log.error("IO error during the translation", e);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(SimulationToSysMLFrame.this.swd, "Unexpected exception");
                            log.error("Other error during the translation", e);
                        }
                        return null;
                    }
                };
                SimulationToSysMLFrame.this.swd.show(sw, "Translating file");
            }
        });
        this.getContentPane().add(this.jbTranslate);
    }

    private void updateOutput() {
        log.debug("Changed output directory to " + this.foutput);
        this.jbOutput.setText(this.foutput.getAbsolutePath());
        if (SimulationToSysMLFrame.isWritable(this.foutput)) {
            this.jlOutput.setText("");
            this.jlOutput.setForeground(Color.BLACK);
        } else {
            this.jlOutput.setText("Readonly directory");
            this.jlOutput.setForeground(Color.RED);
        }
    }

    private static boolean isWritable(File dir) {
        if (!(dir != null && dir.exists() && dir.isDirectory() && dir.canWrite())) {
            return false;
        }
        try {
            File tmp = File.createTempFile("sim", "tmp", dir);
            tmp.delete();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

