function sulfate2_release
%  diffusion-reaction equation with moving boundary 
%  c1=U0, c2=U0 (identical concentration on both exposed faces)
%  change in diffusivity due to damage
%  starts as 1D case (infinite slab), then adapted to 2D (infinite square prism)
clear all

r=0;
x=0;
tmp ='1';
% Open Data File
fid = fopen('sulfate_model_data2.dat','rt');
data =[0];

for i = 1:100
    
     num = fscanf(fid,'%g%g%g',1); % Read in numbers
     name = fscanf(fid,'%s',1); % Filter out string at beginning of line
     
     if(i==1)
%       names = name; % Add 1st text string
       result = num; % Add 1st row
     else
 %      names = str2mat(names,name); % Add next string
       result = [result;num]; % Add additional rows
     end
end

fclose(fid);

Ainp = result;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT RATE CONSTANT OF REACTION  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
L=Ainp(1);  % thickness of square prism (meters)
H=Ainp(2);  % gage length (meters)
D2=Ainp(3); % diffusion coefficient of uncracked material (m^2/s)
D1=D2*Ainp(4); % maximum diffusion coefficient for a cracked material (m^2/s)
U0=Ainp(5);  % sulfate boundary concentration (mol/m^3 of material)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT CONCRETE/MORTAR PARAMETERS %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Cement_content=Ainp(6);         % cement dosage (kg/m^3 of material)
MVC=Ainp(7);                   % BSG of cement
wc=Ainp(8);                    % water/cement ratio
DRcement=Ainp(9);               % degree of hydration of cement
phi_frac=Ainp(10);               % fraction of capillay porosity that can be filled
CC3Ai=Ainp(11);                 % C3A content of cement
Gypsum=Ainp(12);               % gypsum content of cement
DRC3A=Ainp(13);                  % degree of reaction of C3A
k=Ainp(14);                      % rate constant of reaction between sulfates and aluminates (m^3/mol.s)
E0=Ainp(15);                   % Young's modulus of material before test(MPa)
ft=Ainp(16);                       % tensile strength of material (MPa)
residual_stress= Ainp(17);         % residual hydrostatic expansive stress in the pore microstructure (MPa)

 str5=strcat('out',num2str(Ainp(18)),'.dat');
 str6=strcat('info',num2str(Ainp(18)),'.dat');
 fid2 = fopen(str5,'w');
 fid3 = fopen(str6,'w');

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT PHYSICAL PARAMETERS  %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%L=25.4e-3;  % thickness of square prism (meters)
%H=279.4e-3;  % gage length (meters)
%D2=1e-12; % diffusion coefficient of uncracked material (m^2/s)
%D1=D2*10; % maximum diffusion coefficient for a cracked material (m^2/s)
%U0=35.2;  % sulfate boundary concentration (mol/m^3 of material)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT CONCRETE/MORTAR PARAMETERS %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%Cement_content=388;         % cement dosage (kg/m^3 of material)
%MVC=3.15;                   % BSG of cement
%wc=0.485;                    % water/cement ratio
%DRcement=0.9;               % degree of hydration of cement
%phi_frac=.45;               % fraction of capillay porosity that can be filled
%CC3Ai=0.06;                 % C3A content of cement
%Gypsum=0.06;               % gypsum content of cement
%DRC3A=0.9;                  % degree of reaction of C3A
%E0=28000;                   % Young's modulus of material before test(MPa)
%ft=3;                       % tensile strength of material (MPa)
%residual_stress= 20;         % residual hydrostatic expansive stress in the pore microstructure (MPa)
%fid = fopen('c:\research\sulfate_model\model\release\test.dat','w');

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT RATE CONSTANT OF REACTION  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% k=1e-7; % rate constant of reaction between sulfates and aluminates (m^3/mol.s)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INPUT PARAMETERS FOR FINITE DIFFERENCE SCHEME  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
M=2000000;% number of time increments (useful when one wants to let the process run only for a limited given duration)
% otherwise, choose M very large to make sure the process is completed
N=25;% initial number of space intervals.
FN=1e8; % ratio dT/dX 
Nplot=M/100000; % number of profile concentration plotted.  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% CALL SUBROUTINE FOR COMPUTIMG PHYSICAL PARAMETERS  %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%physical_parameters % call physical_parameters subroutine (see subroutine for values)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE TO COMPUTE PHYSICO-CHEMICAL PARAMETERS OF MATERIAL %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% see thesis page 102 to 105
%
fc=Cement_content/1000/MVC; % cement fraction
phi=fc*(wc-.39*DRcement)/(wc+.32); % capillary porosity
phi=phi_frac*phi; % accessible capillary porosity
MV=[3.03,1.95,2.02]*1e6; % vector of the BSG of each of the 3 calcium aluminates reacting with sulfates
MM=[268,620,558]; % vector of the molar masses of these calcium aluminates
MC3Ai=Cement_content*1000*CC3Ai/268; % molar C3A content in concrete
MGypsum=Cement_content*Gypsum*1000/172; % molar gypsum content in concrete
UC3A=(1-DRC3A)*MC3Ai; % unreacted molar C3A content in concrete
Mono=min(MGypsum,DRC3A*MC3Ai); % molar monosulfate content in concrete
C4AH13=max(DRC3A*MC3Ai-Mono,0);% C4AH13 content in concrete
Molar=[UC3A,Mono,C4AH13]; % vector of molar concentrations
mp=Molar/sum(Molar);% vector of molar relative proportions
q=[3,2,3]*mp'; % compounded stoechiometric coefficient for reaction
dVC3A=1.26;% expansion coeff. for C3A
dVMono=0.51;% expansion coeff. for mono
dVC4AH13=0.48;% expansion coeff. for C4AH13
dV=[dVC3A,dVMono,dVC4AH13];% expansion vector
VUC3A=UC3A*268/3.03e6;% volumetric content of C3A
VMono=Mono*620/1.95e6;% volumetric content of monosulfate
VC4AH13=C4AH13*558/2.02e6;% volumetric content of C4AH13
VV=[VUC3A;VMono;VC4AH13];% volumetric content vector
Epsv0=dV*VV;% potential volumetric expansion
exco=sum(dV.*mp.*MM./MV); % coefficient to be applied to ["CA"]reacted to obtain expansion
Ca=MC3Ai; % just a "rename" instruction for compatibility with main program

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% COMPUTE PARAMETERS FOR FINITE DIFFERENCE SCHEME    %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
dX=0.5*L/N; % compute space increment
dT=dX*FN; % derive time increment
K=dX^2/dT; % compute K
X=dX*[0:N];X=X'; % compute values of initial space intervals
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% INITIALIZE PARAMETERS FOR MOVING GRID SCHEME         %%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
X_initial=X; % initialize  X_initial
S=0; % initialize position of the moving boundary
U=[U0;zeros(N,1)];% initialize sulfate concentration
C3A=Ca*ones(N+1,1);%initialize available "CA" concentration
C3Ar=Ca*ones(N+1,1);%initialize "CA" reacted
D=D2*ones(N+1,1);%initialize vector of diffusivity values
%Epsv=zeros(N+1,1);%initialize Epsv (volumetric strain)
Z0=-q*Ca;Z=Z0*ones(N+1,1);%initialize variable Z
front=zeros(N+2,2);
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% CALL SUBROUTINE FOR COMPUTIMG MECHANICAL PARAMETERS  %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% mechanical_parameters % call mechanical_parameters subroutine 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SUBROUTINE TO COMPUTE MECHANICAL PARAMETERS OF MATERIAL       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% see thesis page 98 to 101
%
eps_A=0.4*ft/E0;% compute strain at end of elastic zone
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% backcalculate peak strain Eps_B  by solving using damage function (Shah)      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
eps_B=eps_A+1e-6; % initialize eps_B
ik=1;tolerance=1; % initialize indice and tolerance for iterative solution
% start iteration
while tolerance>1e-7
   eps_B(ik+1)=ft/E0/(1-16*0.16*(1-eps_A/eps_B(ik))^2.3/9); % damage function
   tolerance=abs(eps_B(ik)-eps_B(ik+1));
   ik=ik+1;
end
eps_B=eps_B(ik);
% end of iteration 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compute peak damage parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
w0=eps_B*H; % deformation at peak
x0=eps_B-ft/E0; % irreversible strain
Cd0=.16*(1-eps_A/eps_B)^2.3;om0=16*Cd0/9; % crack density and damage at peak
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% build look-up table for omega and w in post-peak region %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
oml=[om0:0.001:1]; % generate set of lookup values for damage parameter
wl=w0*sqrt(tan(pi*om0/2)./tan(pi*oml/2)).*(log(sec(pi*oml/2))/log(sec(pi*om0/2)))-w0; % compute corresponding lookup values for w 
il=max(find(wl==max(wl))); % find maximum value of w
oml(il+1:end)=[];wl(il+1:end)=[];% remove "tail" of Hori's model in look-up table
sigl=ft*sqrt(tan(pi*om0/2)./tan(pi*oml/2)); % compute lookup values for stress
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize mechanical parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
E=E0*ones(N+1,1);Emean=E0;% initialize Young's modulus vector (one component per space increment)
Emean=E0; % initialize composite Young's modulus
ave_app_str=zeros(N+1,1);% initialize applied strain
crackstate=zeros(N+1,1); % initialize vector carrying integers defining the state of cracking (position in stress-strain curve)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% LAST PREPARATIONS BEFORE LAUNCHING TIME ITERATIONS   %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Cx=Ca-(3*eps_A/exco); %  determine threshold concentration for moving boundary
% what follows is just a storage of all parameters values and names  in two vectors
stak=[L;H;D2;D1;U0;wc;Cement_content;fc;CC3Ai;Gypsum;phi;...
      phi_frac;DRcement;DRC3A;exco;Ca;q;k;N;dX;dT;K;E0;ft;
   eps_A;eps_B;w0;om0;max(wl);max(oml);Cx];
stal=strvcat('L','H','D2','D1','U0','wc','Cement_content','fc','CC3Ai','Gypsum','phi',...
      'phi_frac','DRcement','DRC3A','exco','Ca','q','k','N','dX','dT','K','E0','ft',...
   'eps_A','eps_B','w0','om0','max(wl)','max(oml)','Cx');
% preparations for 2D case adaptation
% see thesis pages 105 to 112
dY=(L/2)/(N+1); % definition of space increment when one more interval is created
% compute area of concentric layers
for i=1:N+1
   arealayer(N+2-i)=4*dY^2*(2*i-1);
end
XXX=dY*[0:N+1]; % even space intervals location
LL=tril(ones(N+2,N+2))*Ca; % prepare triangular matrix to compute 2D values of [CA]reacted
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                START TIME ITERATIONS                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% see thesis appendices A, C, E, G
%
for j=[1:M]% begin time iterations
%    DZmbD_2D % call program that computes values of Z
 % sub-routine to compute value of Z for main program
% moving boundary ->uneven space interval

   switch S % redirect to sub-routines
   case 0
 %     mbzs0D_2D  % call sub-routine for S=0
    	a=-2*(1+K/D2)*ones(N,1);
   	b=2*(1-K/D2)*ones(N,1);
   	c_left=ones(N-1,1);
   	c_right=ones(N-1,1);
  		d(1)=	-2*(U0) ;
		d(2:N)= zeros(N-1,1);
  		% build matrices A and B
  		A=sparse(diag(c_left,-1)+ diag(ones(N-1,1),+1)+diag(a));
  		A(N,N-1)=2;
  		B=sparse(-diag(c_right,-1)-diag(ones(N-1,1),+1)+diag(b));
  		B(N,N-1)=-2;
		% solve system
   	Z(2:N+1,j+1)=A\(B*Z(2:N+1,j)+d');
      Z(1,j+1)=U0;

   otherwise 
 %     mbzsiD_2D % call sub-routine for other values of S
   	% build main diagonal of A
      for i=2:N-1
         a(i)=(D(i,j)+D(i+1,j))/(2*K)+1;
      end
      a(1)=dT*(D(2,j)/dX+D(1,j)/ds)/(ds+dX)+1;
      a(N)=dT*(D(N+1,j)*dX+D(N,j)*dX1)/(dX*dX1*(dX+dX1))+1;
      a(N+1)=D(N+1,j)/K1+1;
      % build lower diagonal of A
      for i=1:N-2
         low_a(i)=D(i+1,j)/(2*K);
      end
      low_a(N-1)=D(N,j)*dT/dX/(dX+dX1);
      low_a(N)=D(N+1,j)/K1;
      % build upper diagonal of A
      for i=2:N-1
         upp_a(i)=D(i+1,j)/(2*K);
      end
      upp_a(1)=D(2,j)*dT/dX/(ds+dX);
      upp_a(N)=D(N+1,j)*dT/dX1/(dX+dX1);
      % build A
      A=sparse(-diag(a)+diag(low_a,-1)+diag(upp_a,1));
      % build main diagonal of B
      for i=2:N-1
         b(i)=(D(i,j)+D(i+1,j))/(2*K)-1;
      end
      b(1)=dT*(D(2,j)/dX+D(1,j)/ds)/(ds+dX)-1;
      b(N)=dT*(D(N+1,j)*dX+D(N,j)*dX1)/(dX*dX1*(dX+dX1))-1;
      b(N+1)=D(N+1,j)/K1-1;
		% build lower diagonal of B
      low_b=-low_a;
      % build upper diagonal of B
      upp_b=-upp_a;
      % build B
      B=sparse(diag(b)+diag(low_b,-1)+diag(upp_b,1));
      d= zeros(N+1,1);
      d(1)=-2*D(1,j)*U0*dT/(dX+ds)/ds;
      % solve system
      Z(2:N+2,j+1)=A\(B*Z(2:N+2,j)+d);
      Z(1,j+1)=U0;

 
 
   end

% will return to main program 

   
%   	mbUHsD % call program that computes values of UH
   % sub-routine to compute UH for main program
switch S 
   case 0
      UH(N)=U(N+1,j)+D2*(U(N,j)-U(N+1,j))/K + dT*k*U(N+1,j)*(Z(N,j+1)-U(N+1,j))/(2*q);
      for i=[2:N]
         UH(i-1)=U(i,j)+D2*(U(i+1,j)-2*U(i,j)+...
            U(i-1,j))/(2*K)+ dT*k*U(i,j)*(Z(i,j+1)-U(i,j))/(2*q);
      end
      % page 21 of Von Rosenberg textbook. U2= U(3), U1=U(2), U0=U(1)
   otherwise

		UH(1)=U(3,j)*D(2,j)*dT/dX/(dX+ds)+...
   		U(2,j)*(1-dT*(D(1,j)/ds+D(2,j)/dX)/(ds+dX))+...
         U0*D(1,j)*dT/ds/(dX+ds)+dT*k*U(2)*(Z(2,j+1)-U(2,j))/(2*q);
      
      UH(N)=U(N+2,j)*D(N+1,j)*dT/dX1/(dX+dX1)+...
         U(N+1,j)*(1-dT*(D(N,j)/dX+D(N+1,j)/dX1)/(dX1+dX))+...
         dT*D(N,j)*U(N,j)/dX/(dX+dX1)+...
         dT*k*U(N+1)*(Z(N+1,j+1)-U(N+1,j))/(2*q);
      
      UH(N+1)=U(N+2,j)+D(N+1,j)*(U(N+1,j)-U(N+2,j))/K1 +...
         dT*k*U(N+2,j)*(Z(N+2,j+1)-U(N+2,j))/(2*q);
      
      for i=[3:N]

      UH(i-1)=D(i,j)*U(i+1,j)/(2*K)+U(i,j)*(1-(D(i-1,j)+D(i,j))/(2*K))...
		   +D(i-1,j)*U(i-1,j)/(2*K)+dT*k*U(i,j)*(Z(i,j+1)-U(i,j))/(2*q);
   	end   
   end
 

switch S % redirect to sub-routines that compute values of U depending on position of moving boundary
        case 0
%            mbUs0D_2D  % call sub-routine for S=0 (boundary has not moved yet)

% FINITE DIFFERENCE SUBROUTINE FOR FIRST TIME INCREMENT

a=-2*(1+k*dX^2*UH/((2*q)*D2)+K/D2);
   b=2*(1+k*dX^2*UH/((2*q)*D2)-K/D2);
   	c_left=ones(N-1,1);
   	c_right=ones(N-1,1);
		d(1)=	-2*(U0+k*dX^2*UH(1)*Z(2,j+1)/(3*D2)) ;
		d(2:N)= -2*k*dX^2*Z(3:N+1,j+1).*(UH(2:N))'/(3*D2);

  		% build matrices A and B
  		A=sparse(diag(c_left,-1)+ diag(ones(N-1,1),+1)+diag(a));
  		A(N,N-1)=2;
  		B=sparse(-diag(c_right,-1)-diag(ones(N-1,1),+1)+diag(b));
  		B(N,N-1)=-2;
		% solve system
   	U(2:N+1,j+1)=A\(B*U(2:N+1,j)+d');
      U(1,j+1)=U0;
      



otherwise
  %          mbUsiD_2D % call sub-routine for other values of S (boundary in motion)
  % FINITE DIFFERENCE SUBROUTINE FOR SUBSEQUENT TIME INCREMENTS


% build main diagonal of A
      for i=2:N-1
         a(i)=(D(i,j)+D(i+1,j))/(2*K)+1+k*dT*UH(i)/(2*q);
      end
      a(1)=dT*(D(2,j)/dX+D(1,j)/ds)/(ds+dX)+1+k*dT*UH(1)/(2*q);
      a(N)=dT*(D(N+1,j)*dX+D(N,j)*dX1)/(dX*dX1*(dX+dX1))+1+k*UH(N)*dT/(2*q);
      a(N+1)=D(N+1,j)/K1+1+k*UH(N+1)*dT/(2*q);
      % build lower diagonal of A
      for i=1:N-2
         low_a(i)=D(i+1,j)/(2*K);
      end
      low_a(N-1)=D(N,j)*dT/dX/(dX+dX1);
      low_a(N)=D(N+1,j)/K1;
      % build upper diagonal of A
      for i=2:N-1
         upp_a(i)=D(i+1,j)/(2*K);
      end
      upp_a(1)=D(2,j)*dT/dX/(ds+dX);
      upp_a(N)=D(N+1,j)*dT/dX1/(dX+dX1);
      % build A
      A=sparse(-diag(a)+diag(low_a,-1)+diag(upp_a,1));
      % build main diagonal of B
      for i=2:N-1
         b(i)=(D(i,j)+D(i+1,j))/(2*K)-1+k*dT*UH(i)/(2*q);
      end
      b(1)=dT*(D(2,j)/dX+D(1,j)/ds)/(ds+dX)-1+k*dT*UH(1)/(2*q);
      b(N)=dT*(D(N+1,j)*dX+D(N,j)*dX1)/(dX*dX1*(dX+dX1))-1+k*UH(N)*dT/(2*q);
      b(N+1)=D(N+1,j)/K1-1+k*UH(N+1)*dT/(2*q);
      % build lower diagonal of B
      low_b=-low_a;
      % build upper diagonal of B
      upp_b=-upp_a;
      % build B
      B=sparse(diag(b)+diag(low_b,-1)+diag(upp_b,1));
      d= -k*Z(2:N+2,j+1).*UH(:)*dT/3;
	   d(1)=-2*D(1,j)*U0*dT/(dX+ds)/ds-k*Z(2,j+1).*UH(1)*dT/3;
      % solve system
      U(2:N+2,j+1)=A\(B*U(2:N+2,j)+d);
      U(1,j+1)=U0;


  
  
  
end
   % now implemente moving grid procedure 
   ind3=min(find(U(:,j+1)<=0)); % find last positive value of U
   if isempty(ind3)==0 % clean up small oscillations of U 
      U(ind3:end,j+1)=0;
   end
   % 
   if j==1 | S==0 % particular case where there is one less space interval than later (first time increment or boundary still at X=0)
      C3A(2:N+1,j+1)=(U(2:N+1,j+1)-Z(2:N+1,j+1))/q; % derive [CA] from U and Z
      ii=min(find((C3A(:,j+1))>Cx));% find location where criterion for boundary motion is met
      	if isempty(ii)==1 % test for homogeneous material (no boundary motion)
         S=0;
      	else
         X_int(j)=interp1([C3A(ii-1,j+1),C3A(ii,j+1)],[X(ii-1),X(ii)],Cx); % new grid
         ds=X_int(j)-X(ii-1);del(j)=ds;% compute gap between old and new grid
         dX1=dX-ds;K1=dX1^2/dT;% compute parameters for uneven interval scheme
         S=1;% define material as composite now
         X_old=X;% temporary variable defined
         X(:,j+1)=X(:,j)+ds;% shift grid to left
         X(N+1,j+1)=L/2;% reset last X at L/2
         X=[[0,0];X];% reset first X at 0 and add one fictitious component to match the size of future matrix X
         U1(:,j)=U(:,j+1);% store "old" values of U
         U=[[U0,U0];U];% add one fictitious component to match the size of future matrix U
         U(:,j+1)=interp1(X_old,U1(:,j),X(:,j+1));% interpolation of value of U at new grid
         X_old=[0;X_old];% add one fictitious component to match the size of future matrix X_old
         U1=[0;U1];% add one fictitious component to match the size of future matrix U1
         C3A=[[0,0];C3A];% add one fictitious component to match the size of future matrix C3A
      	end % end nested test for homogeneous material 
      
    elseif j>1 % inner test for all j>1
      C3A(2:N+2,j+1)=(U(2:N+2,j+1)-Z(2:N+2,j+1))/q; % derive [CA] from U and Z
      ii=min(find((C3A(:,j+1))>Cx));% find location where criterion for boundary motion is met
      if isempty(ii)==1 front(j,1)=j;front(j,2)=0; else front(j,1)=j;front(j,2)=X(ii); end
      if isempty(ii)==1 | S==N+1% test for homogeneous material, totally uncracked or totally cracked
         S=N+1; % fix internal boundary at mid-slab (material totally cracked)
      %   D(:,j+1)=D1;
      else % implement interpolation, moving grid method
         X_int(j)=interp1([C3A(ii-1,j+1),C3A(ii,j+1)],[X(ii-1,j),X(ii,j)],Cx);
         del(j)=X_int(j)-X(ii-1,j);% distance between location of moving boundary and next grid point
         X_old=X(:,j);% temporary variable defined
         X(:,j+1)=X(:,j)+del(j);% shift X to left
         if X(2,j+1)>dX % limitation of first interval to a maximum value of dX
            X(:,j+1)=X(:,j)-(dX-del(j));
            X(1,j+1)=0;X(N+2,j+1)=L/2;
            S=S+1;% increment indice of moving boundary
       %     D(1:S,j+1)=D1;D(S+1:N+1,j+1)=D2;
         else % case where the length of the first interval does not exceed dX
            X(1,j+1)=0;X(N+2,j+1)=L/2; 
        %    D(:,j+1)=D(:,j);
         end      
         U1(:,j)=U(:,j+1);
         U(:,j+1)=interp1(X_old,U1(:,j),X(:,j+1));
         ds=X(2,j+1);dX1=dX-ds;K1=dX1^2/dT;
      end % end test for homogeneous material (second test)
      
  end % end test on j==1 | S==0
  %
  % call subroutine to compute interpolated values of Z
  % interpolZ
  
  
% SUBROUTINE FOR INTERPOLATING VALUES OF Z

if S==0 | S==N+1
   % do nothing
else
	if j==1
      Z1(:,j)=Z(:,j+1);% old U
      Z=[[U0,U0];Z];% add one fictitious component to match future size
      Z(:,j+1)=interp1(X_old(2:end),Z1(:,j),X(:,j+1));
      Z1=[0;Z1];% add one fictitious component to match future size
   else % inner test for all j>1
      if isempty(ii)==1 % test for homogeneous material
       % do nothing  
      else % implement interpolation, moving grid method            
         Z1(:,j)=Z(:,j+1);
         Z(:,j+1)=interp1(X_old,Z1(:,j),X(:,j+1));
      end % end test on ii  
   end % end test on j==1
end
  %
  % compute interpolated values for [CA]
  C3A(2:N+2,j+1)=(U(2:N+2,j+1)-Z(2:N+2,j+1))/q; 
  C3Ar(2:N+2,j+1)=Ca-C3A(2:N+2,j+1);C3Ar(1,j+1)=Ca;% deduce C3A reacted
  % now re-interpolate to get values at points evenly spaced, but with one more interval, compared to initial X
   if size(U)==size(X)% means that grid is still moving
      U_int=interp1(X(:,j+1),U(:,j+1),XXX);
      Z_int=interp1(X(:,j+1),Z(:,j+1),XXX);
   else % take in account fact that grid is fixed at S=N+1,
      % thus X is not updated anymore from this time on.
      U_int=interp1(X(:,end),U(:,j+1),XXX);
      Z_int=interp1(X(:,end),Z(:,j+1),XXX);
   end
    for ii=1:N+2 % adapt 1D values of U to 2D case
   		for jj=1:ii
      		u2U(ii,jj)=U0+(U_int(ii)-U0)*(U_int(jj)-U0)/(-U0);
   		end
    end
    for ii=1:N+2 % adapt 1D values of Z to 2D case
	   for jj=1:ii
         u2Z(ii,jj)=U0+(Z_int(ii)-U0)*(Z_int(jj)-U0)/(Z0-U0);
       end
	end
   	u2C3A=(u2U-u2Z)/q;% adapt 1D values of C3A to 2D case
   	u2C3Ar=LL-u2C3A;% adapt 1D values of C3Ar to 2D case
   for it=1:N+2 % transpose matrix to complete entire half-section
   		for jt=1:N+2
      		if it==jt
         	AAA(it,jt)=0;
      		else
         	AAA(it,jt)=u2C3Ar(jt,it);
      		end
   		end
	end
	BBB=AAA+u2C3Ar;
	clear AAA % clear temporary matrix
    % test defining end of process by depletion of available reactive aluminates
   	for hk=1:27
   		simplint(hk)=(2/L)*trapz(XXX,BBB(hk,:));
    end
      clear BBB% clear temporary matrix
      taux=mean(simplint)/Ca;
      if taux>.9999,break,end
   Epsv(:,:,j)=exco*u2C3Ar; % computes volumetric strain in 2D case
   %
   %
   
			%						mechanicsD2_b2    % call mechanical program
            
            
            % SUBROUTINE FOR COMPUTATION OF MECHANICAL PARAMETERS


for i=1:N+1
   ave(i,j)=(Epsv(i,i,j)+Epsv(N+2,i,j)+2*sum(Epsv(i+1:N+1,i,j)))/(2*(N+1-i)+2);
end
ave(N+2,j)=Epsv(N+2,N+2,j);

for i=1:N
   ave2(i,j)=((N+2-i)*ave(i,j)+(N+2-(i+1))*ave(i+1,j))/((N+2-i)+(N+2-(i+1)));
end
ave2(N+1,j)=(8*ave(N+1,j)+ave(N+2,j))/9;


for i=1:N+1
   ave_app_str(i,j)=(1/3)*(ave2(i,j)-phi);
   ave_app_str(i,j)=max([0,ave_app_str(i,j)]);
%   ave_app_str(i,j)=max([0, ave_app_str(i,j)]);
   if ave_app_str(i,j)==0; % no strain applied
      E(i,j+1)=E0;om(i,j+1)=0;
      crackstate(i,j+1)=1;
          
  elseif ave_app_str(i,j)<eps_A % linear part
      E(i,j+1)=E0;om(i,j+1)=0;
      crackstate(i,j+1)=2;
   elseif ave_app_str(i,j)>=eps_A & ave_app_str(i,j)<eps_B % pre-peak
		Cd=0.16*(1-eps_A./ave_app_str(i,j)).^2.3;
      om(i,j+1)=16*Cd/9;
      E(i,j+1)=(1-om(i,j+1))*E0;

      crackstate(i,j+1)=3;
   elseif ave_app_str(i,j)>=eps_B % post-peak
      wt=ave_app_str(i,j)*H;
      w(i,j+1)=wt-w0;
      if w<=max(wl)
      	om(i,j+1)=interp1(wl,oml,w(i,j+1));
         sigma(i,j)=ft*sqrt(tan(pi*om0/2)./tan(pi*om(i,j+1)/2));
         
         E(i,j+1)=sigma(i,j)/(ave_app_str(i,j)-x0);%ave_app_str(i)
   	else % case when outside look-up table
         E(i,j+1)=50;
         om(i,j+1)=max(oml);
      end
         crackstate(i,j+1)=4; 
   end % end test on strain
	D(i,j+1)=om(i,j+1)*(D1-D2)+D2;   
end % loop on i
Eave(j+1)=(1/L^2)*sum(E(:,j+1).*arealayer');

Eave_crack(1)=E0;
Eave_internal(1)=E0;
% alpha = H/L;     % specimen aspect ratio

%  Eave_crack(j+1)=      (1/L^2)*sum(E(1:S,j+1).*arealayer(1,1:S)')*ii/max(size(arealayer(1,1:S)));
%  Eave_internal(j+1)=   (1/L^2)*sum(E(S:end,j+1).*arealayer(1,S:end)')*ii/max(size(arealayer(1,S:end)));
  Eave_crack(j+1)=      mean(E(1:S,j+1));
  % Eave_internal(j+1)=   mean(E(S:end,j+1));

[ldam,iter_num]=max(front(:,2));
exmean_2(j+1)=residual_stress*((1/Eave_crack(j+1)-1/E0)*2*ldam+(1/Eave(j+1)-1/E0)*(H-2*ldam))/H;
exmean(j+1)=residual_stress*(1/Eave(j+1)-1/E0);
% return to main program

% plotting routine for concentration and strain profiles
%           if rem(j,Nplot)==0 % plotting routine: two cases
%				if size(U)==size(X)% means that grid is still moving
%                 figure (9),plot(X(:,j+1),U(:,j+1),'r',X(:,j+1),C3Ar(:,j+1),'b:'),hold on;
%                 title('C_3A concentration vs. distance from surface up to the centerline');
%   xlabel('distance from surface, m');
%   ylabel('Sulfate Concentration and Reacted C_3A, mol/m^3 ');legend('Available Sulfate concentration, U',' Reacted C_3A ')
%   figure(10),plot(X(:,end),Epsv(end,:,j-1),'b'),hold on;
%                title('Strain Profile across the specimen up to the centerline');
%  xlabel('distance from surface, m');
%   ylabel('Volumetric Strain');legend('strain, mm/mm')
%             else % take in account fact that grid is fixed at S=N+1,
%              % thus X is not updated anymore from this time on.
%              	figure (9), plot(X(:,end),U(:,j+1),'r',X(:,end),C3Ar(:,j+1),'b:'),hold on;
%             	figure(10),plot(X(:,end),Epsv(end,:,j-1),'b'),hold on;
%            end
%       end % end test for plotting routine
ST(j)=S;

end % end iteration on j

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% RESULTS PRESENTATION   %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% graphs formatting
			% axis ([0 L/2 0 max([U0,Ca])]);
			%axis ([0 L/2 0 max(max(Epsv))])
			%hold off
Final_Time=j*dT/3600/24; % compute end of reaction time in days
if S~=0
   Invasion_time=min(find(ST==max(ST)))*dT/3600/24;
   % compute time for cracking all specimen (in days)
end
timedays=[1:j]*dT/3600/24; % convert time in days 


Eave(1) = E0;
%  figure,plot(timedays,Eave),title('Degradation of Elastic Modulus as a Function of Time');
%   xlabel('Time, days');
%   ylabel('Effective E, MPa');

td=timedays;ex=exmean;
if size(ex)==size(td)+[0,1]
        ex(end)=[];
        exmean(end)=[];
end
%
%plot of expansion vs. time graph
%figure,plot(timedays,exmean,'k'),title('Expansion vs. Time');
%   xlabel('Time, days');
%   ylabel('Linear Expansion , mm/mm');

%figure,plot(timedays,1000*front(1:j,2),'b'),hold on,
% xlabel('Time, Days');
%   ylabel('Depth of Penetration , mm');
   
   
% plot of state of cracking
%		[XL,Xc]=meshgrid([1:N],[1:j]);
%		figure,mesh(crackstate)
%             view(-37.50,30.00)
%        title('0=no strain, 1=linear,2=damage evolution, 3=strain softening, 4=completely cracked ');
%   xlabel('Time, days');
%   ylabel('Distance From Surface, mm');
%   zlabel('crack state, 0,1,2,3,4');        

   
%
%  Output the time, in days, strain in percent, and Average E across the cross section in KPa
%  in a file called out_sulfate.dat
%



outdata= [timedays(1:end)',exmean(1:end)'*100.,1000*front(1:j,2),Eave(1:end)'/1e3];
fprintf(fid2,'time [days], Axial strain  [percent], crack front location [mm],Average E across the cross section [MPa], %g.\n');
fprintf(fid2,'\n');
fprintf(fid2,'%6.2f %12.8f %12.8f %12.8f \n',outdata(:,:)');

fprintf(fid2,'time_[days], Axial_strain_[percent], crack_front_location_[mm], Average_E_[MPa], %g.\n');
fprintf(fid2,'\n');
fprintf(fid2,'%12.8f %12.8f %12.8f %12.8f \n',outdata(:,:)');

fprintf(fid3,'\n');
fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,' %%%%%% INPUT PARAMETERS MIX DESIGN AND GEOMETRY      %%%%%%   \n');
fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,'\n');
fprintf(fid3,'  thickness of square prism (mm), L ,    %12.4f      \n',L*1000 );
fprintf(fid3,'  gage length (mm), H  ,                 %12.3f      \n',H*1000 );
fprintf(fid3,'  cement dosage (kg/m^3 of material)     %12.2f      \n',Cement_content );
fprintf(fid3,'  BSG of cement ,                        %12.3f      \n',MVC );
fprintf(fid3,'  water/cement ratio                     %12.3f      \n',wc );
fprintf(fid3,'  degree of hydration of cement,         %12.3f      \n',DRcement );
fprintf(fid3,'\n');

fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,' %%%%%% INPUT PARAMETERS FOR EXPANSIVE REACTIONS      %%%%%%   \n');
fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,'\n');

fprintf(fid3,'  C3A content of cement ,                %12.4f      \n',CC3Ai);
fprintf(fid3,'  degree of reaction of C3A ,            %12.4f      \n',DRC3A);
fprintf(fid3,'  gypsum content of cement,              %12.4f      \n',Gypsum );
fprintf(fid3,'  rate constant of reaction between sulfates and aluminates (m^3/mol.s)     %12.8g      \n',k );
fprintf(fid3,'  diffusion coefficient of uncracked material (m^2/s)                       %12.8g      \n',D2 );
fprintf(fid3,'  Ratio of maximum diffusion coefficient to the uncracked material (D1/D2)  %12.3f      \n',Ainp(4));
fprintf(fid3,'  sulfate boundary concentration (mol/m^3 of material)                      %12.4f      \n',U0 );
fprintf(fid3,'  fraction of capillay porosity that can be filled                          %12.4f      \n',phi_frac );
fprintf(fid3,'\n');

fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,' %%%%%% MECHANICAL PROPERTIES                         %%%%%%   \n');
fprintf(fid3,' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   \n');
fprintf(fid3,'\n');

fprintf(fid3,'  Young''s modulus of undamaged material (MPa)                               %12.8f      \n',Ainp(15));
fprintf(fid3,'  tensile strength of material (MPa)                                         %12.3f      \n',ft );
fprintf(fid3,'  residual hydrostatic expansive stress in the pore microstructure (MPa)     %12.3f    \n',Ainp(17) );
fprintf(fid3,'\n');

%
fclose(fid2);
fclose(fid3);
fprintf('program execution completed')
  









