#!/usr/bin/ruby
# 2013-03-05 12:00
# val1-Rtable.rb  DWF
# Convert profiling output from val1 to an R table with fixed columns.
# Based on Linux version.
#
# Usage:  val1-Rtable.rb [file ...]
# Input:  one or more VTune Amplifier XE reports in the hotspots format
#         or a concatenation of such.
# Output:  sample counts by function, one row per run, in R table format.

# Hardcoded fixed columns for val1.
$fns = ["function1", "function2", "function3", "function4", "function5", "main", "other"]
$counts = Array.new($fns.size, 0)

# Print array contents on one line with spaces between fields.
def space_nicely(a)
  a.take(a.size-1).each { |x| print x.to_s + " " }
  # "other" shows up with useless digits due to accumulated error
  if a.last.is_a?(Float)
    puts a.last.round(3)
  else
    puts a.last
  end
end

# Add x samples for function f, redirecting to "other" as applicable.
def tally(f,x)
  fni = $fns.index(f)
  fni = $fns.size-1 if fni.nil?
  $counts[fni] += x
end

space_nicely($fns)

state = 0
ARGF.lines do |line|
  if /\S/ !~ line
    # Appending the reports adds an empty line.
  elsif line.include? "CPU Time:Self"
    if state == 0
      state = 1
    else
      space_nicely($counts)
    end
    $counts.fill(0)
  elsif line.include? "-------------"
    # pass
  else
    ls = line.split(' ')
    tally(ls[0], ls[2].to_f)
  end
end
space_nicely($counts) if state == 1
