/* val5.c  2013-03-08 10:34
   Reference executable for validating application profiling tools.
   val5:  recursive function with one self-invocation.

   With default values of FN1LOOP and FN2LOOP, the expected distribution of
   time is 100 % to cycfn, of which 33 % is in the first (top) invocation and
   66 % is in the second (leaf) invocation.

   Spin for Windows + Intel Composer XE 2013 + Microsoft Visual Studio 2012.
   Language /Qstd=c99.
   See release notes for details of the changes.
*/

// Configurable FN1LOOP:  how many busy-work iterations in top invocation.
#ifndef FN1LOOP
#define FN1LOOP 100000000
#endif

// Configurable FN2LOOP:  how many busy-work iterations in leaf invocation.
#ifndef FN2LOOP
#define FN2LOOP (FN1LOOP*2)
#endif

#include <stdint.h>
#define PRIu64 "I64u"
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>

uint64_t accumulator=1;
double   adder=0;

#pragma auto_inline(off)
void cycfn (int leaf) {
  for (uint64_t looper=0; looper<(leaf ? FN2LOOP : FN1LOOP); ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
  if (!leaf)
    cycfn (1);
}

int main() {
  cycfn (0);
  printf ("%" PRIu64 " %f\n", accumulator, adder);
  return 0;
}
