/* val3.c  2013-02-28 10:15
   Reference executable for validating application profiling tools.
   val3:  mutually recursive functions.

   With default values of FN1LOOP and FN2LOOP, the expected distribution
   of time is approximately
     main    total 100 % self  0 %
     cycfn2  total 100 % self 67 %
     cycfn1  total  67 % self 33 %
   resulting from the following call chains and proportions of samples:
     2  main->cycfn2
     1  main->cycfn2->cycfn1
     2  main->cycfn2->cycfn1->cycfn2
     1  main->cycfn2->cycfn1->cycfn2->cycfn1

   Spin for Windows + Intel Composer XE 2013 + Microsoft Visual Studio 2012.
   Language /Qstd=c99.
   See release notes for details of the changes.
*/

// Configurable FN1LOOP:  how many busy-work iterations in cycfn1.
#ifndef FN1LOOP
#define FN1LOOP 100000000
#endif

// Configurable FN2LOOP:  how many busy-work iterations in cycfn2.
#ifndef FN2LOOP
#define FN2LOOP (FN1LOOP*2)
#endif

#include <stdint.h>
#define PRIu64 "I64u"
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>

uint64_t accumulator=1;
double   adder=0;

#pragma auto_inline(off)
void cycfn2 (int leaf);

void cycfn1 (int leaf) {
  for (uint64_t looper=0; looper<FN1LOOP; ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
  if (!leaf)
    cycfn2 (1);
}

void cycfn2 (int leaf) {
  for (uint64_t looper=0; looper<FN2LOOP; ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
  cycfn1 (leaf);
}

int main() {
  cycfn2 (0);
  printf ("%" PRIu64 " %f\n", accumulator, adder);
  return 0;
}
