/* val1.c  2013-02-28 10:15
   Reference executable for validating application profiling tools.
   val1:  triangular distribution of time among N functions.

   With default values of the parameters, the expected distribution of
   time (both self and total) is approximately
     function1  5x
     function2  4x
     function3  3x
     function4  2x
     function5   x
     main        0
   for x = 6.67 %.

   Spin for Windows + Intel Composer XE 2013 + Microsoft Visual Studio 2012.
   Language /Qstd=c99.
   See release notes for details of the changes.
*/

// NUMFUN is not configurable in this spin of val1.
#define NUMFUN 5

// Configurable INNERLOOP:  how many iterations in leaf functions.
#ifndef INNERLOOP
#define INNERLOOP 256
#endif

// Configurable OUTERLOOP:  how many iterations in main program.
#ifndef OUTERLOOP
#define OUTERLOOP (200000000/INNERLOOP)
#endif

// Configurable REVERSE:  define to reverse order of function invocations
// #define REVERSE

#include <stdint.h>
#define PRIu64 "I64u"
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>

uint64_t accumulator=1;
double   adder=0;

// Define NUMFUN functions.
#define defun(funnam) void funnam() {                      \
  for (uint64_t looper=0; looper<INNERLOOP; ++looper)      \
    adder += M_PI*3, accumulator = accumulator*3 + adder;  \
}
#pragma auto_inline(off)
defun(function1)
defun(function2)
defun(function3)
defun(function4)
defun(function5)

// The number of invocations forms a triangular distribution.
#ifdef REVERSE
#define callfun \
  if (loopmod < 1) function5(); \
  if (loopmod < 2) function4(); \
  if (loopmod < 3) function3(); \
  if (loopmod < 4) function2(); \
  if (loopmod < 5) function1();
#else
#define callfun \
  if (loopmod < 5) function1(); \
  if (loopmod < 4) function2(); \
  if (loopmod < 3) function3(); \
  if (loopmod < 2) function4(); \
  if (loopmod < 1) function5();
#endif

int main() {
  for (uint64_t looper=0; looper<OUTERLOOP; ++looper) {
    const uint64_t loopmod = looper % NUMFUN;
    callfun
  }
  printf ("%" PRIu64 " %f\n", accumulator, adder);
  return 0;
}
