/* val4.c  2013-02-28 10:15
   Reference executable for validating application profiling tools.
   val4:  three functions with a single invocation and no recursion.

   With default values of FN1LOOP and FN2LOOP, the expected distribution of
   time is approximately
     main   total 100 % self  0 %
     fn2    total 100 % self 50 %
     fn1    total  50 % self 50 %

   Spin for Windows + Intel Composer XE 2013 + Microsoft Visual Studio 2012.
   Language /Qstd=c99.
   See release notes for details of the changes.
*/

// Configurable FN1LOOP:  how many busy-work iterations in fn1.
#ifndef FN1LOOP
#define FN1LOOP 100000000
#endif

// Configurable FN2LOOP:  how many busy-work iterations in fn2.
#ifndef FN2LOOP
#define FN2LOOP 100000000
#endif

#include <stdint.h>
#define PRIu64 "I64u"
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>

uint64_t accumulator=1;
double   adder=0;

#pragma auto_inline(off)
void fn1() {
  for (uint64_t looper=0; looper<FN1LOOP; ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
}

void fn2() {
  for (uint64_t looper=0; looper<FN2LOOP; ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
  fn1();
}

int main() {
  fn2();
  printf ("%" PRIu64 " %f\n", accumulator, adder);
  return 0;
}
