/* val2.c  2013-02-28 10:15
   Reference executable for validating application profiling tools.
   val2:  two functions with a single invocation and no recursion.

   The call graph is simply
     main->leaffn
   with nearly 100 % of time spent in leaffn.

   Spin for Windows + Intel Composer XE 2013 + Microsoft Visual Studio 2012.
   Language /Qstd=c99.
   See release notes for details of the changes.
*/

// Configurable INNERLOOP:  how many iterations in leaf function.
#ifndef INNERLOOP
#define INNERLOOP 200000000
#endif

#include <stdint.h>
#define PRIu64 "I64u"
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>

uint64_t accumulator=1;
double   adder=0;

#pragma auto_inline(off)
void leaffn() {
  for (uint64_t looper=0; looper<INNERLOOP; ++looper)
    adder += M_PI*3, accumulator = accumulator*3 + adder;
}

int main() {
  leaffn();
  printf ("%" PRIu64 " %f\n", accumulator, adder);
  return 0;
}
