/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateSignature {
    static boolean etat;
    private KeyStore ks;
    private X509Certificate pkCert;
    String filename = "sign.xml";

    public ValidateSignature() {
        etat = this.checkKeyPass(".keystore", "scriba".toCharArray());
        if (etat) {
            try {
                this.validateSig(this.filename);
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("ERROR") + exp.getMessage(), "Error", 0);
                System.out.println(exp.getMessage());
            }
            new File(this.filename).delete();
        }
    }

    public ValidateSignature(String filename) {
        this.filename = filename;
        etat = this.checkKeyPass(".keystore", "scriba".toCharArray());
        if (etat) {
            try {
                this.validateSig(filename);
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("ERROR") + exp.getMessage(), "Error", 0);
                System.out.println(exp.getMessage());
            }
        }
    }

    public ValidateSignature(String filename, String ksName, char[] keystorePass) {
        etat = this.checkKeyPass(ksName, keystorePass);
        if (etat) {
            try {
                this.validateSig(filename);
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("ERROR") + exp.getMessage(), "Error", 0);
                System.out.println(exp.getMessage());
            }
        }
    }

    public void validateSig(String filename) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(filename));
        NodeList xmlSigs = doc.getElementsByTagName("ds:Signature");
        System.out.println("ds:Signature " + xmlSigs);
        if (xmlSigs.getLength() == 0) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CANNOT_FIND_SIGNATURE_ELEMENT"));
            throw new Exception(ResourceBundle.getBundle("Sign/Bundle").getString("CANNOT_FIND_SIGNATURE_ELEMENT"));
        }
        for (int j = 0; j < xmlSigs.getLength(); ++j) {
            Element xmlSigElement = (Element)xmlSigs.item(j);
            XMLSignature signature = new XMLSignature(xmlSigElement, filename);
            KeyInfo keyInfo = signature.getKeyInfo();
            this.pkCert = keyInfo.getX509Certificate();
            boolean coreValidity = signature.checkSignatureValue(this.pkCert);
            System.out.println(coreValidity);
            if (!coreValidity) {
                System.err.println(ResourceBundle.getBundle("Sign/Bundle").getString("SIGNATURE_FAILED_CORE_VALIDATION"));
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("SIGNATURE_FAILED_CORE_VALIDATION"), ResourceBundle.getBundle("Sign/Bundle").getString("ERROR"), 0);
            } else {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("SIGNATURE_") + xmlSigElement.getParentNode().getNodeName() + ResourceBundle.getBundle("Sign/Bundle").getString("_PASSED_CORE_VALIDATION_!"));
                System.out.println(ResourceBundle.getBundle("Sign/Bundle").getString("SIGNATURE_PASSED_CORE_VALIDATION"));
            }
            this.validateCertificate();
        }
    }

    void validateCertificate() {
        try {
            if (this.ks.isCertificateEntry(this.ks.getCertificateAlias(this.pkCert))) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("THE_CERTIFICATE_IS_A_TRUSTED_CERTIFICATE_ENTRY"));
            } else {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("THE_CERTIFICATE_IS_NOT_A_TRUSTED_CERTIFICATE_ENTRY!"), ResourceBundle.getBundle("Sign/Bundle").getString("ERROR"), 0);
            }
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("ERROR") + exp.getMessage(), "Error", 0);
        }
    }

    boolean checkKeyPass(String ksName, char[] keystorePass) {
        try {
            this.ks = KeyStore.getInstance("JKS");
            FileInputStream ksfis = new FileInputStream(ksName);
            BufferedInputStream ksbufin = new BufferedInputStream(ksfis);
            this.ks.load(ksbufin, keystorePass);
            return true;
        }
        catch (IOException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE_INFORMATION"));
        }
        catch (NoSuchAlgorithmException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE1_INFORMATION2"));
        }
        catch (KeyStoreException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE2_INFORMATION3"));
            exp.printStackTrace();
            return false;
        }
        catch (CertificateException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE3_INFORMATION4"));
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            ValidateSignature handler = new ValidateSignature();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

