/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import Sign.AddCertificatesFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class NewIDPanelBC
extends JPanel {
    JPanel parent;
    AddCertificatesFrame frame;
    Vector<String> aliases = new Vector();
    KeyStore ksout;
    private JLabel AliasError;
    private JComboBox country;
    private JButton jButtonBack;
    private JButton jButtonCancel;
    private JButton jButtonFinish;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanelAction;
    private JPanel jPanelInput;
    private JPanel jPanelMain;
    private JTextField jTFAlias;
    private JTextField jTFDepartement;
    private JTextField jTFEmail;
    private JTextField jTFLocation;
    private JTextField jTFName;
    private JTextField jTFOrgName;
    private JPasswordField jTFPassword;
    private JTextField jTFState;
    private JComboBox keyAlgo;
    private JComboBox keySize;
    private JComboBox signAlgo;
    JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
    String[] countries = new String[]{"AD - Andorra", "AE - United Arab Emirates", "AF - Afghanistan", "AG - Antigua & Barbuda", "AI - Anguilla", "AL - Albania", "AM - Armenia", "AN - Netherlands Antilles", "AO - Angola", "AQ - Antarctica", "AR - Argentina", "AS - American Samoa", "AT - Austria", "AU - Australia", "AW - Aruba", "AZ - Azerbaijan", "BA - Bosnia and Herzegovina", "BB - Barbados", "BD - Bangladesh", "BE - Belgium", "BF - Burkina Faso", "BG - Bulgaria", "BH - Bahrain", "BI - Burundi", "BJ - Benin", "BM - Bermuda", "BN - Brunei Darussalam", "BO - Bolivia", "BR - Brazil", "BS - Bahama", "BT - Bhutan", "BV - Bouvet Island", "BW - Botswana", "BY - Belarus", "BZ - Belize", "CA - Canada", "CC - Cocos (Keeling) Islands", "CF - Central African Republic", "CG - Congo", "CH - Switzerland", "CI - C\u00f4te D'ivoire (Ivory Coast)", "CK - Cook Iislands", "CL - Chile", "CM - Cameroon", "CN - China", "CO - Colombia", "CR - Costa Rica", "CU - Cuba", "CV - Cape Verde", "CX - Christmas Island", "CY - Cyprus", "CZ - Czech Republic", "DE - Germany", "DJ - Djibouti", "DK - Denmark", "DM - Dominica", "DO - Dominican Republic", "DZ - Algeria", "EC - Ecuador", "EE - Estonia", "EG - Egypt", "EH - Western Sahara", "ER - Eritrea", "ES - Spain", "ET - Ethiopia", "FI - Finland", "FJ - Fiji", "FK - Falkland Islands (Malvinas)", "FM - Micronesia", "FO - Faroe Islands", "FR - France", "FX - France, Metropolitan", "GA - Gabon", "GB - United Kingdom (Great Britain)", "GD - Grenada", "GE - Georgia", "GF - French Guiana", "GH - Ghana", "GI - Gibraltar", "GL - Greenland", "GM - Gambia", "GN - Guinea", "GP - Guadeloupe", "GQ - Equatorial Guinea", "GR - Greece", "GS - South Georgia and the South Sandwich Islands", "GT - Guatemala", "GU - Guam", "GW - Guinea-Bissau", "GY - Guyana", "HK - Hong Kong", "HM - Heard & McDonald Islands", "HN - Honduras", "HR - Croatia", "HT - Haiti", "HU - Hungary", "ID - Indonesia", "IE - Ireland", "IL - Israel", "IN - India", "IO - British Indian Ocean Territory", "IQ - Iraq", "IR - Islamic Republic of Iran", "IS - Iceland", "IT - Italy", "JM - Jamaica", "JO - Jordan", "JP - Japan", "KE - Kenya", "KG - Kyrgyzstan", "KH - Cambodia", "KI - Kiribati", "KM - Comoros", "KN - St. Kitts and Nevis", "KP - Korea, Democratic People's Republic of", "KR - Korea, Republic of", "KW - Kuwait", "KY - Cayman Islands", "KZ - Kazakhstan", "LA - Lao People's Democratic Republic", "LB - Lebanon", "LC - Saint Lucia", "LI - Liechtenstein", "LK - Sri Lanka", "LR - Liberia", "LS - Lesotho", "LT - Lithuania", "LU - Luxembourg", "LV - Latvia", "LY - Libyan Arab Jamahiriya", "MA - Morocco", "MC - Monaco", "MD - Moldova, Republic of", "MG - Madagascar", "MH - Marshall Islands", "ML - Mali", "MN - Mongolia", "MM - Myanmar", "MO - Macau", "MP - Northern Mariana Islands", "MQ - Martinique", "MR - Mauritania", "MS - Monserrat", "MT - Malta", "MU - Mauritius", "MV - Maldives", "MW - Malawi", "MX - Mexico", "MY - Malaysia", "MZ - Mozambique", "NA - Namibia", "NC - New Caledonia", "NE - Niger", "NF - Norfolk Island", "NG - Nigeria", "NI - Nicaragua", "NL - Netherlands", "NO - Norway", "NP - Nepal", "NR - Nauru", "NT - Neutral Zone (no longer exists)", "NU - Niue", "NZ - New Zealand", "OM - Oman", "PA - Panama", "PE - Peru", "PF - French Polynesia", "PG - Papua New Guinea", "PH - Philippines", "PK - Pakistan", "PL - Poland", "PM - St. Pierre & Miquelon", "PN - Pitcairn", "PR - Puerto Rico", "PT - Portugal", "PW - Palau", "PY - Paraguay", "QA - Qatar", "RE - R\u00e9union", "RO - Romania", "RU - Russian Federation", "RW - Rwanda", "SA - Saudi Arabia", "SB - Solomon Islands", "SC - Seychelles", "SD - Sudan", "SE - Sweden", "SG - Singapore", "SH - St. Helena", "SI - Slovenia", "SJ - Svalbard & Jan Mayen Islands", "SK - Slovakia", "SL - Sierra Leone", "SM - San Marino", "SN - Senegal", "SO - Somalia", "SR - Suriname", "ST - Sao Tome & Principe", "SV - El Salvador", "SY - Syrian Arab Republic", "SZ - Swaziland", "TC - Turks & Caicos Islands", "TD - Chad", "TF - French Southern Territories", "TG - Togo", "TH - Thailand", "TJ - Tajikistan", "TK - Tokelau", "TM - Turkmenistan", "TN - Tunisia", "TO - Tonga", "TP - East Timor", "TR - Turkey", "TT - Trinidad & Tobago", "TV - Tuvalu", "TW - Taiwan, Province of China", "TZ - Tanzania, United Republic of", "UA - Ukraine", "UG - Uganda", "UM - United States Minor Outlying Islands", "US - United States of America", "UY - Uruguay", "UZ - Uzbekistan", "VA - Vatican City State (Holy See)", "VC - St. Vincent & the Grenadines", "VE - Venezuela", "VG - British Virgin Islands", "VI - United States Virgin Islands", "VN - Viet Nam", "VU - Vanuatu", "WF - Wallis & Futuna Islands", "WS - Samoa", "YD - Democratic Yemen (no longer exists)", "YE - Yemen", "YT - Mayotte", "YU - Yugoslavia", "ZA - South Africa", "ZM - Zambia", "ZR - Zaire", "ZW - Zimbabwe", "ZZ - Unknown or unspecified country"};

    public NewIDPanelBC() {
        this.initComponents();
    }

    public NewIDPanelBC(AddCertificatesFrame frame, JPanel parent) {
        this.parent = parent;
        this.frame = frame;
        this.initAliases();
        this.initComponents();
        this.keyAlgoItemStateChanged(null);
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        try {
            this.initAliases();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jPanelInput = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTFPassword = new JPasswordField();
        this.jLabel10 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTFName = new JTextField();
        this.jTFOrgName = new JTextField();
        this.jTFEmail = new JTextField();
        this.country = new JComboBox();
        this.AliasError = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTFDepartement = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTFState = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTFLocation = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTFAlias = new JTextField();
        this.keyAlgo = new JComboBox();
        this.signAlgo = new JComboBox();
        this.keySize = new JComboBox();
        this.jPanelAction = new JPanel();
        this.jButtonFinish = new JButton();
        this.jButtonBack = new JButton();
        this.jButtonCancel = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanelMain.setMaximumSize(new Dimension(700, 411));
        this.jPanelMain.setLayout(new GridBagLayout());
        this.jPanelInput.setMinimumSize(new Dimension(700, 350));
        this.jPanelInput.setPreferredSize(new Dimension(700, 350));
        this.jPanelInput.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("Sign/Bundle");
        this.jLabel1.setText(bundle.getString("NewIDPanelBC.jLabel1.text"));
        this.jLabel1.setMaximumSize(new Dimension(150, 19));
        this.jLabel1.setMinimumSize(new Dimension(150, 19));
        this.jLabel1.setPreferredSize(new Dimension(150, 19));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel1, gridBagConstraints);
        this.jTFPassword.setMinimumSize(new Dimension(11, 19));
        this.jTFPassword.setPreferredSize(new Dimension(11, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 17, 0);
        this.jPanelInput.add((Component)this.jTFPassword, gridBagConstraints);
        this.jLabel10.setText(bundle.getString("NewIDPanelBC.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 35, 13, 6);
        this.jPanelInput.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("NewIDPanelBC.jLabel2.text"));
        this.jLabel2.setMaximumSize(new Dimension(150, 19));
        this.jLabel2.setMinimumSize(new Dimension(150, 19));
        this.jLabel2.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("NewIDPanelBC.jLabel3.text"));
        this.jLabel3.setMaximumSize(new Dimension(150, 19));
        this.jLabel3.setMinimumSize(new Dimension(150, 19));
        this.jLabel3.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(bundle.getString("NewIDPanelBC.jLabel4.text"));
        this.jLabel4.setMaximumSize(new Dimension(150, 19));
        this.jLabel4.setMinimumSize(new Dimension(150, 19));
        this.jLabel4.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("NewIDPanelBC.jLabel5.text"));
        this.jLabel5.setMaximumSize(new Dimension(150, 19));
        this.jLabel5.setMinimumSize(new Dimension(150, 19));
        this.jLabel5.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(bundle.getString("NewIDPanelBC.jLabel6.text"));
        this.jLabel6.setMaximumSize(new Dimension(150, 19));
        this.jLabel6.setMinimumSize(new Dimension(150, 19));
        this.jLabel6.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(2, 35, 13, 6);
        this.jPanelInput.add((Component)this.jLabel6, gridBagConstraints);
        this.jTFName.setMinimumSize(new Dimension(150, 19));
        this.jTFName.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFName, gridBagConstraints);
        this.jTFOrgName.setMinimumSize(new Dimension(150, 19));
        this.jTFOrgName.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFOrgName, gridBagConstraints);
        this.jTFEmail.setMinimumSize(new Dimension(150, 19));
        this.jTFEmail.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFEmail, gridBagConstraints);
        this.country.setModel(new DefaultComboBoxModel<String>(this.countries));
        this.country.setSelectedItem("US - United States of America");
        this.country.setMinimumSize(new Dimension(300, 18));
        this.country.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.jPanelInput.add((Component)this.country, gridBagConstraints);
        this.AliasError.setForeground(new Color(255, 51, 51));
        this.AliasError.setMaximumSize(new Dimension(150, 19));
        this.AliasError.setMinimumSize(new Dimension(150, 19));
        this.AliasError.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 6, 2, 0);
        this.jPanelInput.add((Component)this.AliasError, gridBagConstraints);
        this.jLabel8.setText(bundle.getString("NewIDPanelBC.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 9, 0, 35);
        this.jPanelInput.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel11.setText(bundle.getString("NewIDPanelBC.jLabel11.text"));
        this.jLabel11.setMaximumSize(new Dimension(150, 19));
        this.jLabel11.setMinimumSize(new Dimension(150, 19));
        this.jLabel11.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel11, gridBagConstraints);
        this.jTFDepartement.setMinimumSize(new Dimension(150, 19));
        this.jTFDepartement.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFDepartement, gridBagConstraints);
        this.jLabel12.setText(bundle.getString("NewIDPanelBC.jLabel12.text"));
        this.jLabel12.setMaximumSize(new Dimension(150, 19));
        this.jLabel12.setMinimumSize(new Dimension(150, 19));
        this.jLabel12.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel12, gridBagConstraints);
        this.jTFState.setMinimumSize(new Dimension(150, 19));
        this.jTFState.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFState, gridBagConstraints);
        this.jLabel13.setText(bundle.getString("NewIDPanelBC.jLabel13.text"));
        this.jLabel13.setMaximumSize(new Dimension(150, 19));
        this.jLabel13.setMinimumSize(new Dimension(150, 19));
        this.jLabel13.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel13, gridBagConstraints);
        this.jTFLocation.setMinimumSize(new Dimension(150, 19));
        this.jTFLocation.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFLocation, gridBagConstraints);
        this.jLabel14.setText(bundle.getString("NewIDPanelBC.jLabel14.text"));
        this.jLabel14.setMaximumSize(new Dimension(150, 19));
        this.jLabel14.setMinimumSize(new Dimension(150, 19));
        this.jLabel14.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(16, 35, 2, 6);
        this.jPanelInput.add((Component)this.jLabel14, gridBagConstraints);
        this.jTFAlias.setMinimumSize(new Dimension(150, 19));
        this.jTFAlias.setPreferredSize(new Dimension(150, 19));
        this.jTFAlias.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                NewIDPanelBC.this.jTFAliasKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 6, 2, 35);
        this.jPanelInput.add((Component)this.jTFAlias, gridBagConstraints);
        this.keyAlgo.setModel(new DefaultComboBoxModel<String>(new String[]{"RSA", "DSA", "ECDSA"}));
        this.keyAlgo.setMinimumSize(new Dimension(150, 19));
        this.keyAlgo.setPreferredSize(new Dimension(150, 19));
        this.keyAlgo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                NewIDPanelBC.this.keyAlgoItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.keyAlgo, gridBagConstraints);
        this.signAlgo.setMinimumSize(new Dimension(150, 19));
        this.signAlgo.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 13, 35);
        this.jPanelInput.add((Component)this.signAlgo, gridBagConstraints);
        this.keySize.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.keySize.setMinimumSize(new Dimension(150, 19));
        this.keySize.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 35);
        this.jPanelInput.add((Component)this.keySize, gridBagConstraints);
        this.jPanelMain.add((Component)this.jPanelInput, new GridBagConstraints());
        this.jPanelAction.setMinimumSize(new Dimension(700, 61));
        this.jPanelAction.setPreferredSize(new Dimension(700, 61));
        this.jPanelAction.setLayout(new GridBagLayout());
        this.jButtonFinish.setText(bundle.getString("NewIDPanelBC.jButtonFinish.text"));
        this.jButtonFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewIDPanelBC.this.jButtonFinishActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(23, 0, 15, 0);
        this.jPanelAction.add((Component)this.jButtonFinish, gridBagConstraints);
        this.jButtonBack.setText(bundle.getString("NewIDPanelBC.jButtonBack.text"));
        this.jButtonBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewIDPanelBC.this.jButtonBackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(23, 0, 15, 0);
        this.jPanelAction.add((Component)this.jButtonBack, gridBagConstraints);
        this.jButtonCancel.setText(bundle.getString("NewIDPanelBC.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewIDPanelBC.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(23, 35, 15, 200);
        this.jPanelAction.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelMain.add((Component)this.jPanelAction, gridBagConstraints);
        this.add((Component)this.jPanelMain, "Center");
    }

    private void jButtonFinishActionPerformed(ActionEvent evt) {
        if (!this.jTFAlias.getText().equals("")) {
            if (this.checkAlias(this.jTFAlias.getText())) {
                if (!this.jTFName.getText().equals("")) {
                    if (NewIDPanelBC.hasNameAndDomain(this.jTFEmail.getText())) {
                        if (!this.jTFPassword.getText().trim().equals("")) {
                            try {
                                KeyPair pair = this.generateRSAKeyPair();
                                X500Principal dname = this.getX500Name();
                                X509Certificate cert = this.generateV3Certificate(pair, dname);
                                this.generateKeystore(pair.getPrivate(), cert, this.jTFAlias.getText(), this.jTFPassword.getPassword());
                                this.frame.model.setVisible(true);
                                this.frame.dispose();
                            }
                            catch (Exception ex) {
                                Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
                                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("ERROR") + ex.getMessage(), "Error", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("PASSWORD_&_OUTPUTFILE_ARE_REQUIERED_TO_CREATE_THE_CERTIFICATE_!"));
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("EMAIL_IS_REQUIERED_TO_CREATE_THE_CERTIFICATE_!_CHECK_FORMAT_IE_ERIC@NIST.GOV_"));
                    }
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("NAME_IS_REQUIERED_TO_CREATE_THE_CERTIFICATE_!"));
                }
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("ALIAS_ALREADY_EXIST_ON_THE_KEYSTORE,_PLEASE_CHANGE_IT_!"));
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("ALIAS_IS_REQUIERED_TO_CREATE_THE_CERTIFICATE_!"));
        }
    }

    private void jButtonBackActionPerformed(ActionEvent evt) {
        this.frame.setContentPane(this.parent);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.frame.dispose();
    }

    private void jTFAliasKeyReleased(KeyEvent evt) {
        if (!this.checkAlias(this.jTFAlias.getText())) {
            this.AliasError.setText(ResourceBundle.getBundle("Sign/Bundle").getString("ALIAS_ALREADY_EXIST_!"));
        } else {
            this.AliasError.setText("");
        }
    }

    private void keyAlgoItemStateChanged(ItemEvent evt) {
        if (evt != null) {
            if (evt.getStateChange() == 2) {
                return;
            }
        }
        if (this.keyAlgo.getSelectedItem().equals("RSA")) {
            this.keySize.setModel(new DefaultComboBoxModel<String>(new String[]{"1024", "2048", "3072"}));
            this.signAlgo.setModel(new DefaultComboBoxModel<String>(new String[]{"SHA1withRSA", "SHA224withRSA", "SHA256withRSA", "SHA384withRSA", "SHA512withRSA", "RIPEMD128withRSA", "RIPEMD160withRSA", "RIPEMD256withRSA"}));
        }
        if (this.keyAlgo.getSelectedItem().equals("DSA")) {
            this.keySize.setModel(new DefaultComboBoxModel<String>(new String[]{"1024"}));
            this.signAlgo.setModel(new DefaultComboBoxModel<String>(new String[]{"SHA1withDSA", "SHA224withDSA", "SHA256withDSA"}));
        }
        if (this.keyAlgo.getSelectedItem().equals("ECDSA")) {
            this.keySize.setModel(new DefaultComboBoxModel<String>(new String[]{"192", "239", "256"}));
            this.signAlgo.setModel(new DefaultComboBoxModel<String>(new String[]{"SHA1withECDSA", "SHA224withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA"}));
        }
    }

    public void generateKeystore(Key key, X509Certificate cert, String alias, char[] password) {
        try {
            this.ksout.setCertificateEntry(alias, cert);
            Certificate[] chain = new X509Certificate[]{cert};
            this.ksout.setKeyEntry(alias, key, password, chain);
            FileOutputStream out = new FileOutputStream(".keystore");
            this.ksout.store(out, "scriba".toCharArray());
            out.close();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_GENERATED_!"));
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (CertificateException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public X509Certificate generateV3Certificate(KeyPair pair, X500Principal x500Principal) throws InvalidKeyException, NoSuchProviderException, SignatureException, CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, CertificateException {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(x500Principal);
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 10000L));
        Calendar cal = Calendar.getInstance();
        cal.add(1, 10);
        certGen.setNotAfter(cal.getTime());
        certGen.setSubjectDN(x500Principal);
        certGen.setPublicKey(pair.getPublic());
        certGen.setSignatureAlgorithm(this.signAlgo.getSelectedItem().toString());
        certGen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
        certGen.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(160));
        certGen.addExtension(X509Extensions.ExtendedKeyUsage, true, (DEREncodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        certGen.addExtension(X509Extensions.SubjectAlternativeName, false, (DEREncodable)new GeneralNames(new GeneralName(1, this.jTFEmail.getText())));
        return certGen.generate(pair.getPrivate(), "BC");
    }

    public KeyPair generateRSAKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(this.keyAlgo.getSelectedItem().toString(), "BC");
        kpGen.initialize(Integer.parseInt(this.keySize.getSelectedItem().toString()), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    private static boolean hasNameAndDomain(String aEmailAddress) {
        String[] tokens = aEmailAddress.split("@");
        return tokens.length == 2 && tokens[0].length() != 0 && tokens[1].length() != 0;
    }

    private boolean checkAlias(String text) {
        this.initAliases();
        return !this.aliases.contains(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAliases() {
        FileInputStream fis = null;
        try {
            this.ksout = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(".keystore");
            this.ksout.load(fis, "scriba".toCharArray());
            fis.close();
            Enumeration<String> aliases = this.ksout.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.aliases.add(alias);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (CertificateException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NewIDPanelBC.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private X500Principal getX500Name() {
        String dname = "CN=" + this.jTFName.getText() + ", C=" + this.country.getSelectedItem() + ", EMAILADDRESS=" + this.jTFEmail.getText() + ", O=" + this.jTFOrgName.getText() + ", OU=" + this.jTFDepartement.getText() + ", L=" + this.jTFLocation.getText() + ", S=" + this.jTFState.getText();
        X500Principal name = new X500Principal(dname);
        return name;
    }
}

