/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import Sign.AddCertificatesFrame;
import Sign.ImportCertificateFrame;
import Sign.ViewCertificateFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import sun.misc.BASE64Encoder;

public class ManageCertificateFrame
extends JFrame {
    KeyStore ks;
    FileInputStream fis;
    private JLabel KsSize;
    private JLabel KsSize1;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButtonAddID;
    private JButton jButtonAddID1;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonOk;
    private JButton jButtonRemoveCertificate;
    private JButton jButtonRemoveID;
    private JButton jButtonViewCert;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableCertificate;
    private JTable jTableID;

    public ManageCertificateFrame() {
        this.initComponents();
        try {
            this.verifKeyStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        try {
            this.verifKeyStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verifKeyStore() throws Exception {
        this.clear();
        this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
        this.fis = new FileInputStream(".keystore");
        this.ks.load(this.fis, "scriba".toCharArray());
        this.fis.close();
        if (this.ks.size() == 0) {
            this.KsSize.setText(ResourceBundle.getBundle("Sign/Bundle").getString("NO_ID_IN_YOUR_KEY_STORE"));
        } else {
            this.KsSize.setText("");
        }
        Enumeration<String> aliases = this.ks.aliases();
        int i = 0;
        int i1 = 0;
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        this.jTableID.getTableHeader().setReorderingAllowed(false);
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            String alias = aliases.nextElement();
            if (this.ks.isKeyEntry(alias)) {
                cert = (X509Certificate)this.ks.getCertificate(alias);
                ((DefaultTableModel)this.jTableID.getModel()).addRow(new Vector());
                this.jTableID.setValueAt(alias, i, 0);
                if (cert.getIssuerDN().getName().split("CN=")[1].split(",") != null) {
                    this.jTableID.setValueAt(cert.getIssuerDN().getName().split("CN=")[1].split(",")[0], i, 1);
                    this.jTableID.setValueAt(cert.getSubjectDN().getName().split("CN=")[1].split(",")[0], i, 2);
                } else {
                    this.jTableID.setValueAt(cert.getIssuerDN().getName().split("CN=")[1], i, 1);
                    this.jTableID.setValueAt(cert.getSubjectDN().getName().split("CN=")[1], i, 2);
                }
                this.jTableID.setValueAt(format.format(cert.getNotAfter()), i, 3);
                this.jTableID.setValueAt(cert.getSigAlgName(), i, 4);
                ++i;
                continue;
            }
            cert = (X509Certificate)this.ks.getCertificate(alias);
            ((DefaultTableModel)this.jTableCertificate.getModel()).addRow(new Vector());
            this.jTableCertificate.setValueAt(alias, i1, 0);
            if (cert.getIssuerDN().getName().split("CN=")[1].split(",") != null) {
                this.jTableCertificate.setValueAt(cert.getIssuerDN().getName().split("CN=")[1].split(",")[0], i1, 1);
                this.jTableCertificate.setValueAt(cert.getSubjectDN().getName().split("CN=")[1].split(",")[0], i1, 2);
            } else {
                this.jTableCertificate.setValueAt(cert.getIssuerDN().getName().split("CN=")[1], i1, 1);
                this.jTableCertificate.setValueAt(cert.getSubjectDN().getName().split("CN=")[1], i1, 2);
            }
            this.jTableCertificate.setValueAt(format.format(cert.getNotAfter()), i1, 3);
            ++i1;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.KsSize = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableID = new JTable();
        this.jPanel3 = new JPanel();
        this.jButtonAddID = new JButton();
        this.jButtonRemoveID = new JButton();
        this.jButton1 = new JButton();
        this.jButtonExport = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCertificate = new JTable();
        this.jPanel10 = new JPanel();
        this.jButtonAddID1 = new JButton();
        this.jButtonRemoveCertificate = new JButton();
        this.KsSize1 = new JLabel();
        this.jButtonViewCert = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("Sign/Bundle");
        this.setTitle(bundle.getString("APPLY_DIGITAL_SIGNATURE_-_DIGITAL_ID_SELECTION"));
        this.jPanel1.setMaximumSize(new Dimension(700, 440));
        this.jPanel1.setMinimumSize(new Dimension(700, 440));
        this.jPanel1.setPreferredSize(new Dimension(700, 440));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 1));
        this.jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.jPanel5.setPreferredSize(new Dimension(100, 30));
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText(bundle.getString("_____LIST_OF_DIGITAL_ID'S_USED_TO_SIGN."));
        this.jPanel5.add(this.jLabel1);
        this.KsSize.setMinimumSize(new Dimension(200, 20));
        this.KsSize.setPreferredSize(new Dimension(200, 20));
        this.jPanel5.add(this.KsSize);
        this.jPanel6.add(this.jPanel5);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("ManageCertificateFrame.jPanel2.border.title")));
        this.jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 350));
        this.jPanel2.setMinimumSize(new Dimension(700, 350));
        this.jPanel2.setPreferredSize(new Dimension(1600, 350));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(650, 280));
        this.jScrollPane1.setPreferredSize(new Dimension(650, 280));
        this.jTableID.setModel(new DefaultTableModel(new Object[0][], new String[]{ResourceBundle.getBundle("Sign/Bundle").getString("NAME"), ResourceBundle.getBundle("Sign/Bundle").getString("ISSUER"), ResourceBundle.getBundle("Sign/Bundle").getString("OWNER"), ResourceBundle.getBundle("Sign/Bundle").getString("EXPIRES"), ResourceBundle.getBundle("Sign/Bundle").getString("ALGORITHM")}));
        this.jScrollPane1.setViewportView(this.jTableID);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 59, 0, 59);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jPanel3.setMinimumSize(new Dimension(499, 30));
        this.jPanel3.setPreferredSize(new Dimension(499, 30));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButtonAddID.setText(bundle.getString("ADD_DIGITAL_ID"));
        this.jButtonAddID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonAddIDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel3.add((Component)this.jButtonAddID, gridBagConstraints);
        this.jButtonRemoveID.setText(bundle.getString("REMOVE_ID"));
        this.jButtonRemoveID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonRemoveIDActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 20);
        this.jPanel3.add((Component)this.jButtonRemoveID, gridBagConstraints);
        this.jButton1.setText(bundle.getString("VIEW"));
        this.jButton1.setMaximumSize(new Dimension(100, 23));
        this.jButton1.setMinimumSize(new Dimension(100, 23));
        this.jButton1.setPreferredSize(new Dimension(100, 23));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 20, 12, 5);
        this.jPanel3.add((Component)this.jButton1, gridBagConstraints);
        this.jButtonExport.setText(bundle.getString("EXPORT_CERTIFICATE"));
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 5, 12, 200);
        this.jPanel3.add((Component)this.jButtonExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 59, 0, 59);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel6.add(this.jPanel2);
        this.jTabbedPane1.addTab(bundle.getString("ManageCertificateFrame.jPanel6.TabConstraints.tabTitle"), this.jPanel6);
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.jPanel8.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.jPanel8.setPreferredSize(new Dimension(100, 30));
        this.jPanel8.setLayout(new GridLayout(1, 0));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText(bundle.getString("_____LIST_OF_CERTIFICATES(PUBLIC_KEYS)_USED_TO_VALIDATE_SIGNATURE."));
        this.jPanel8.add(this.jLabel2);
        this.jPanel7.add(this.jPanel8);
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(bundle.getString("ManageCertificateFrame.jPanel9.border.title")));
        this.jPanel9.setMaximumSize(new Dimension(Integer.MAX_VALUE, 350));
        this.jPanel9.setMinimumSize(new Dimension(700, 350));
        this.jPanel9.setPreferredSize(new Dimension(1600, 350));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(650, 280));
        this.jScrollPane2.setPreferredSize(new Dimension(650, 280));
        this.jTableCertificate.setModel(new DefaultTableModel(new Object[0][], new String[]{ResourceBundle.getBundle("Sign/Bundle").getString("NAME"), ResourceBundle.getBundle("Sign/Bundle").getString("ISSUER"), ResourceBundle.getBundle("Sign/Bundle").getString("OWNER"), ResourceBundle.getBundle("Sign/Bundle").getString("EXPIRES")}));
        this.jScrollPane2.setViewportView(this.jTableCertificate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 59, 0, 59);
        this.jPanel9.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel10.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jPanel10.setMinimumSize(new Dimension(499, 30));
        this.jPanel10.setPreferredSize(new Dimension(499, 30));
        this.jPanel10.setLayout(new GridBagLayout());
        this.jButtonAddID1.setText(bundle.getString("IMPORT_CERTIFICATE"));
        this.jButtonAddID1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonAddID1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel10.add((Component)this.jButtonAddID1, gridBagConstraints);
        this.jButtonRemoveCertificate.setText(bundle.getString("REMOVECERTIFICATE"));
        this.jButtonRemoveCertificate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonRemoveCertificateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 59);
        this.jPanel10.add((Component)this.jButtonRemoveCertificate, gridBagConstraints);
        this.KsSize1.setMinimumSize(new Dimension(200, 20));
        this.KsSize1.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 58, 10, 0);
        this.jPanel10.add((Component)this.KsSize1, gridBagConstraints);
        this.jButtonViewCert.setText(bundle.getString("VIEW"));
        this.jButtonViewCert.setMaximumSize(new Dimension(100, 23));
        this.jButtonViewCert.setMinimumSize(new Dimension(100, 23));
        this.jButtonViewCert.setPreferredSize(new Dimension(100, 23));
        this.jButtonViewCert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonViewCertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 20, 12, 0);
        this.jPanel10.add((Component)this.jButtonViewCert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 59, 0, 59);
        this.jPanel9.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel7.add(this.jPanel9);
        this.jTabbedPane1.addTab(bundle.getString("ManageCertificateFrame.jPanel7.TabConstraints.tabTitle"), this.jPanel7);
        this.jPanel1.add(this.jTabbedPane1);
        this.jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.jPanel4.setMinimumSize(new Dimension(362, 50));
        this.jPanel4.setPreferredSize(new Dimension(362, 50));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonOk.setText(bundle.getString("OK"));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 9, 0);
        this.jPanel4.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText(bundle.getString("CANCEL"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManageCertificateFrame.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 9, 0);
        this.jPanel4.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jLabel3.setMinimumSize(new Dimension(250, 0));
        this.jLabel3.setPreferredSize(new Dimension(250, 0));
        this.jLabel3.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel1.add(this.jPanel4);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRemoveIDActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRows().length > 0 && JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("DO_YOU_REALLY_WANT_TO_REMOVE_THIS_ENTRY?")) == 0) {
            for (int row = 0; row < this.jTableID.getSelectedRows().length; ++row) {
                String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRows()[row], 0);
                try {
                    this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    this.fis = new FileInputStream(".keystore");
                    this.ks.load(this.fis, "scriba".toCharArray());
                    this.fis.close();
                    this.ks.deleteEntry(alias);
                    FileOutputStream fout = new FileOutputStream(".keystore");
                    this.ks.store(fout, "scriba".toCharArray());
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
                    System.out.println(e.getMessage());
                }
            }
            int count = this.jTableID.getRowCount();
            for (int i = 0; i < count; ++i) {
                ((DefaultTableModel)this.jTableID.getModel()).removeRow(0);
            }
            try {
                this.verifKeyStore();
            }
            catch (Exception ex) {
                Logger.getLogger(ManageCertificateFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButtonAddIDActionPerformed(ActionEvent evt) {
        new AddCertificatesFrame(this).setVisible(true);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRow() > -1) {
            String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRow(), 0);
            new ViewCertificateFrame(alias).setVisible(true);
        }
    }

    private void jButtonAddID1ActionPerformed(ActionEvent evt) {
        new ImportCertificateFrame(this).setVisible(true);
    }

    private void jButtonRemoveCertificateActionPerformed(ActionEvent evt) {
        if (this.jTableCertificate.getSelectedRow() > -1 && this.jTableCertificate.getSelectedRows().length > 0 && JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("DO_YOU_REALLY_WANT_TO_REMOVE_THIS_ENTRY?")) == 0) {
            for (int row = 0; row < this.jTableCertificate.getSelectedRows().length; ++row) {
                String alias = (String)this.jTableCertificate.getValueAt(this.jTableCertificate.getSelectedRows()[row], 0);
                try {
                    this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    this.fis = new FileInputStream(".keystore");
                    this.ks.load(this.fis, "scriba".toCharArray());
                    this.fis.close();
                    this.ks.deleteEntry(alias);
                    FileOutputStream fout = new FileOutputStream(".keystore");
                    this.ks.store(fout, "scriba".toCharArray());
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
                    System.out.println(e.getMessage());
                }
            }
            int count = this.jTableCertificate.getRowCount();
            for (int i = 0; i < count; ++i) {
                ((DefaultTableModel)this.jTableCertificate.getModel()).removeRow(0);
            }
            try {
                this.verifKeyStore();
            }
            catch (Exception ex) {
                Logger.getLogger(ManageCertificateFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButtonViewCertActionPerformed(ActionEvent evt) {
        if (this.jTableCertificate.getSelectedRow() > -1) {
            String alias = (String)this.jTableCertificate.getValueAt(this.jTableCertificate.getSelectedRow(), 0);
            new ViewCertificateFrame(alias).setVisible(true);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.jTableID.getSelectedRow() > -1) {
            String alias = (String)this.jTableID.getValueAt(this.jTableID.getSelectedRow(), 0);
            JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
            if (fileDlg.showSaveDialog(this) == 0) {
                try {
                    X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                    File file = fileDlg.getSelectedFile();
                    FileOutputStream os = new FileOutputStream(file);
                    PrintStream ps = new PrintStream(os);
                    BASE64Encoder encoder = new BASE64Encoder();
                    ps.println("-----BEGIN CERTIFICATE-----");
                    encoder.encodeBuffer(cert.getEncoded(), (OutputStream)ps);
                    ps.println("-----END CERTIFICATE-----");
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_EXPORTED"));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CAN_NOT_GENERATE_CERTIFICATE"));
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ManageCertificateFrame().setVisible(true);
            }
        });
    }

    private void clear() {
        int i;
        int row = this.jTableID.getRowCount();
        for (i = 0; i < row; ++i) {
            ((DefaultTableModel)this.jTableID.getModel()).removeRow(0);
        }
        row = this.jTableCertificate.getRowCount();
        for (i = 0; i < row; ++i) {
            ((DefaultTableModel)this.jTableCertificate.getModel()).removeRow(0);
        }
    }
}

