/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RohsMapXML {
    static String sep = System.getProperty("file.separator");
    static String rohsFolder = "RohsLists";
    public static HashMap queryLists = new HashMap();

    public static void createMap() {
        RohsMapXML.createMapQueryConf();
    }

    public static void createMapQueryConf() {
        File[] children = new File(rohsFolder).listFiles();
        if (children != null) {
            for (File child : children) {
                try {
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(child);
                    doc.getDocumentElement().normalize();
                    Node QueryListNode = doc.getElementsByTagName("QueryList").item(0);
                    String key = QueryListNode.getAttributes().getNamedItem("identity").getNodeValue();
                    NodeList QueryList = doc.getElementsByTagName("Query");
                    queryLists.put(key, RohsMapXML.createTable(QueryList, "statement"));
                }
                catch (SAXParseException err) {
                    JOptionPane.showMessageDialog(null, "Error: " + err.getMessage(), "Error", 0);
                    System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println(" " + err.getMessage());
                }
                catch (SAXException e) {
                    Exception x = e.getException();
                    (x == null ? e : x).printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public String getElementString(Node node) {
        Element nodeElement = (Element)node;
        NodeList textLNList = nodeElement.getChildNodes();
        return textLNList.item(0).getNodeValue();
    }

    public static String[] createTable(NodeList nodelist, String attribute) {
        String[] list = new String[nodelist.getLength()];
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Element nodeElement = (Element)nodelist.item(i);
            list[i] = nodeElement.getAttributes().getNamedItem(attribute).getNodeValue();
        }
        return list;
    }

    public static String[] getQueryVersions() {
        String[] versions = new String[queryLists.size() + 1];
        Iterator iter = queryLists.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            versions[i] = (String)iter.next();
            ++i;
        }
        versions[i] = ResourceBundle.getBundle("RepeateTables/Bundle").getString("CUSTOM");
        return versions;
    }

    public static boolean isVersion(String version) {
        Iterator iter = queryLists.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (version.equals((String)iter.next())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

