/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import ReadConf.SubProduct;
import RepeateTables.ComboBoxMapXML;
import RepeateTables.RepeatTable;
import RepeateTables.XMLTable;
import Util.Convert;
import Util.StaticComboBox;
import View.FileWarning;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class MaterialGroupTable
extends RepeatTable {
    private String version;
    SubProduct subProduct;
    static int[] columnDim = new int[]{15, 15, 300, 300, 300};

    public MaterialGroupTable(String version, SubProduct subProduct) {
        this.subProduct = subProduct;
        this.setVersion(version);
    }

    public void addEmptyCell(int col, Vector row) {
        row.addElement("+");
        row.addElement("-");
        row.addElement("");
        row.addElement("");
        row.addElement("");
    }

    public void setCellValue(int col, String value) {
        this.model.setValueAt(value, this.model.getRowCount() - 1, col);
    }

    public String getValueOfRow(int row) {
        String value = "";
        value = value + "\n                <MaterialGroup name=\"" + Convert.convertToXML((String)this.table.getXMLValueAt(row, 2)) + "\">" + "\n                <Amount UOM=\"" + this.table.getXMLValueAt(row, 4) + "\" value=\"" + this.table.getXMLValueAt(row, 3) + "\"  />" + "\n                </MaterialGroup>";
        return value;
    }

    public void init() {
        this.table = new MyJTable(this.model);
        String[] columnNames = new String[]{"+", "-", ResourceBundle.getBundle("RepeateTables/Bundle").getString("MATERIAL_GROUP"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("MASS"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("UOM")};
        this.addColumns(columnNames);
        this.setColDimension(columnDim);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (!ComboBoxMapXML.isMGVersion(version) && !version.equals("")) {
            String versions = "[";
            for (int i = 0; i < ComboBoxMapXML.getMGVersions().length; ++i) {
                versions = versions + ComboBoxMapXML.getMGVersions()[i] + "; ";
            }
            versions = versions + "]";
            FileWarning.log.append("\n Wrong MaterialGroupList  version : " + version + " should be one of " + versions);
        }
        this.version = version;
        this.createMG(version);
    }

    public boolean isEmpty() {
        int rowNbr = this.table.getRowCount();
        for (int i = 0; i < rowNbr; ++i) {
            for (int j = 2; j < 4; ++j) {
                if (((String)this.table.getXMLValueAt(i, j)).replaceAll(" ", "").equals("")) continue;
                return false;
            }
        }
        return true;
    }

    private void createMG(String version) {
        this.subProduct.setMaterialGVersion(version);
        this.model.fireTableStructureChanged();
        this.setColDimension(columnDim);
    }

    public class MyJTable
    extends XMLTable {
        MyJTable(DefaultTableModel model) {
            super(model);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 0: {
                    if (this.getValueAt(row, column) != null) {
                        return MaterialGroupTable.this.addButton;
                    }
                }
                case 1: {
                    if (this.getValueAt(row, column) != null) {
                        return MaterialGroupTable.this.delButton;
                    }
                }
                case 2: {
                    if (MaterialGroupTable.this.subProduct.getMaterialG() != null) {
                        return MaterialGroupTable.this.subProduct.getMaterialG();
                    }
                    return super.getCellEditor(row, column);
                }
                case 3: {
                    return RepeatTable.floatEditor;
                }
                case 4: {
                    return StaticComboBox.uomppm;
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

