/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import Parse.ParseSaveXML;
import RepeateTables.ButtonEditor;
import RepeateTables.ButtonRenderer;
import RepeateTables.RepeatTable;
import RepeateTables.XMLTable;
import Util.Base64;
import View.ScribaView;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class AttachementTable
extends RepeatTable {
    private ScribaView main;
    private String node;
    private Vector fileData = new Vector();
    public ButtonEditor attachButton = new ButtonEditor(this, ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH"));
    public ButtonEditor saveButton = new ButtonEditor(this, ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE"));

    public AttachementTable() {
    }

    public AttachementTable(ScribaView main, String node) {
        this.node = node;
        this.main = main;
    }

    public void addEmptyCell(int col, Vector row) {
        row.addElement("+");
        row.addElement("-");
        row.addElement("");
        row.addElement("");
        row.addElement(ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH"));
        row.addElement(ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE"));
    }

    public String getValueOfRow(int row) {
        String value = "";
        value = value + "\n";
        for (int i = 0; i < ParseSaveXML.indent + 1; ++i) {
            value = value + "    ";
        }
        value = value + "<Attachment name=\"" + (String)this.table.getXMLValueAt(row, 2) + "\" fileType=\"" + (String)this.table.getXMLValueAt(row, 3) + "\" fileData=\"" + this.getFileData(row) + "\"/>";
        return value;
    }

    public void setCellValue(int col, String value) {
        if (col == 4) {
            this.setFileData(this.model.getRowCount() - 1, value);
        } else {
            this.model.setValueAt(value, this.model.getRowCount() - 1, col);
        }
    }

    public void init() {
        this.table = new MyJTable(this.model);
        String[] columnNames = new String[]{"+", "-", ResourceBundle.getBundle("RepeateTables/Bundle").getString("NAME"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("FILE_TYPE"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH"), ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE")};
        this.addColumns(columnNames);
        int[] columnDim = new int[]{15, 15, 500, 100, 80, 80};
        this.setColDimension(columnDim);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn(ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH")).setCellRenderer(new ButtonRenderer(ResourceBundle.getBundle("RepeateTables/Bundle").getString("ATTACH")));
        this.table.getColumn(ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE")).setCellRenderer(new ButtonRenderer(ResourceBundle.getBundle("RepeateTables/Bundle").getString("SAVE")));
    }

    public String getFileData(int index) {
        if (this.fileData.size() <= index) {
            return "";
        }
        return (String)this.fileData.get(index);
    }

    public void decodetoFile(int index, String fileName) {
        if (this.fileData.size() > index) {
            try {
                Base64.decodeToFile((String)this.fileData.get(index), fileName);
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("RepeateTables/Bundle").getString("FILE_SAVED!"));
            }
            catch (IOException ex) {
                Logger.getLogger(AttachementTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setFileData(int index, String fileData) {
        if (this.fileData.size() <= index) {
            this.fileData.add(fileData);
        } else {
            this.fileData.set(index, fileData.getBytes());
        }
    }

    public void encodeFileData(int index, String fileData) {
        if (this.fileData.size() <= index) {
            try {
                this.fileData.add(Base64.encodeFromFile(fileData));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.table, ex.getMessage());
            }
        } else {
            try {
                this.fileData.set(index, Base64.encodeFromFile(fileData));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.table, ex.getMessage());
            }
        }
    }

    public void clear() {
        this.fileData = new Vector();
    }

    public void deleteRow(int index) {
        super.deleteRow(index);
        if (this.fileData.size() > index) {
            this.fileData.remove(index);
        }
    }

    public class MyJTable
    extends XMLTable {
        boolean[] canEdit;

        MyJTable(DefaultTableModel model) {
            super(model);
            this.canEdit = new boolean[]{true, true, false, false, true, true};
        }

        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 0: {
                    if (this.getValueAt(row, column) != null) {
                        return AttachementTable.this.addButton;
                    }
                }
                case 1: {
                    if (this.getValueAt(row, column) != null) {
                        return AttachementTable.this.delButton;
                    }
                }
                case 4: {
                    if (this.getValueAt(row, column) != null) {
                        return AttachementTable.this.attachButton;
                    }
                }
                case 5: {
                    if (this.getValueAt(row, column) == null) break;
                    return AttachementTable.this.saveButton;
                }
            }
            return super.getCellEditor(row, column);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }
    }
}

