/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.TTFFont;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CIDFontType2
extends TTFFont {
    private Map widths;
    private int defaultWidth = 1000;
    private ByteBuffer cidToGidMap;

    public CIDFontType2(String baseName, PDFObject fontObj, PDFFontDescriptor descriptor) throws IOException {
        super(baseName, fontObj, descriptor);
        this.parseWidths(fontObj);
        PDFObject mapObj = fontObj.getDictRef("CIDToGIDMap");
        if (mapObj != null && mapObj.getType() == 7) {
            this.cidToGidMap = mapObj.getStreamBuffer();
        }
    }

    private void parseWidths(PDFObject fontObj) throws IOException {
        PDFObject widthObj;
        PDFObject defaultWidthObj = fontObj.getDictRef("DW");
        if (defaultWidthObj != null) {
            this.defaultWidth = defaultWidthObj.getIntValue();
        }
        if ((widthObj = fontObj.getDictRef("W")) == null) {
            return;
        }
        this.widths = new HashMap();
        PDFObject[] widthArray = widthObj.getArray();
        int entryIdx = 0;
        int first = 0;
        int last = 0;
        for (int i = 0; i < widthArray.length; ++i) {
            int c;
            if (entryIdx == 0) {
                first = widthArray[i].getIntValue();
            } else if (entryIdx == 1) {
                if (widthArray[i].getType() == 5) {
                    PDFObject[] entries = widthArray[i].getArray();
                    for (c = 0; c < entries.length; ++c) {
                        Character key = new Character((char)(c + first));
                        float value = entries[c].getIntValue();
                        this.widths.put(key, new Float(value));
                    }
                    entryIdx = -1;
                } else {
                    last = widthArray[i].getIntValue();
                }
            } else {
                int value = widthArray[i].getIntValue();
                for (c = first; c <= last; ++c) {
                    this.widths.put(new Character((char)c), new Float(value));
                }
                entryIdx = -1;
            }
            ++entryIdx;
        }
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public float getWidth(char code, String name) {
        Float w = (Float)this.widths.get(new Character(code));
        if (w == null) {
            return 1.0f;
        }
        return w.floatValue() / (float)this.getDefaultWidth();
    }

    protected synchronized GeneralPath getOutline(char src, float width) {
        int glyphId = src & 0xFFFF;
        if (this.cidToGidMap != null) {
            glyphId = this.cidToGidMap.getChar(glyphId * 2);
        }
        return this.getOutline(glyphId, width);
    }
}

