/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import Parse.ParseSaveXML;
import ReadConf.SubProduct;
import RepeateTables.ComboBoxMapXML;
import RepeateTables.RepeatTable;
import RepeateTables.XMLTable;
import View.FileWarning;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ExemptTable
extends RepeatTable {
    private String version;
    static int[] columnDim3 = new int[]{15, 15, 1000};
    SubProduct subProduct;

    public ExemptTable(String version, SubProduct subProduct) {
        this.subProduct = subProduct;
        this.setVersion(version);
    }

    public void addEmptyCell(int col, Vector row) {
        row.addElement("+");
        row.addElement("-");
        row.addElement("");
    }

    public void createExempt(String version) {
        this.subProduct.setExemptVersion(version);
        this.model.fireTableStructureChanged();
        this.setColDimension(columnDim3);
    }

    public void setCellValue(int col, String value) {
        String[] list = this.subProduct.getListExempt();
        if (this.subProduct.getExemptVersion().equals("") || list == null) {
            this.model.setValueAt(value, this.model.getRowCount() - 1, col);
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            String[] tmp = list[i].split("-");
            if (tmp == null || tmp.length <= 0 || !tmp[0].equals(value)) continue;
            this.model.setValueAt(list[i], this.model.getRowCount() - 1, col);
            break;
        }
    }

    public String getValueOfRow(int row) {
        int i;
        String value = "";
        if (row == 0) {
            value = value + "\n";
            for (i = 0; i < ParseSaveXML.indent + 1; ++i) {
                value = value + "    ";
            }
            value = value + "<ExemptionList>";
            if (!this.isEmpty()) {
                value = value + "\n";
                for (i = 0; i < ParseSaveXML.indent + 2; ++i) {
                    value = value + "    ";
                }
                value = value + "<ExemptionListID ";
                value = !this.subProduct.getExemptVersion().equals("") ? value + "authority=\"IPC\" identity=\"" + this.subProduct.getExemptVersion() + "\"/>" : value + "authority=\"NONE\" />";
            }
        }
        if (!((String)this.table.getXMLValueAt(row, 2)).trim().equals("")) {
            int index = ((String)this.table.getXMLValueAt(row, 2)).indexOf("-") + 1;
            value = value + "\n";
            for (i = 0; i < ParseSaveXML.indent + 1; ++i) {
                value = value + "    ";
            }
            value = value + "<Exemption description=\"" + ((String)this.table.getXMLValueAt(row, 2)).substring(index, ((String)this.table.getXMLValueAt(row, 2)).length()) + "\" identity=\"" + ((String)this.table.getXMLValueAt(row, 2)).split("-")[0] + "\"/>";
        }
        if (row == this.table.getRowCount() - 1) {
            value = value + "\n";
            for (i = 0; i < ParseSaveXML.indent + 2; ++i) {
                value = value + "    ";
            }
            value = value + " </ExemptionList>";
        }
        return value;
    }

    public void init() {
        this.table = new MyJTable(this.model);
        String[] columnNames3 = new String[]{"+", "-", ResourceBundle.getBundle("RepeateTables/Bundle").getString("EXEMPTION")};
        this.addColumns(columnNames3);
        this.setColDimension(columnDim3);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (!ComboBoxMapXML.isExeptionVersion(version) && !version.equals("")) {
            String versions = "[";
            for (int i = 0; i < ComboBoxMapXML.getExemptionVersions().length; ++i) {
                versions = versions + ComboBoxMapXML.getExemptionVersions()[i] + "; ";
            }
            versions = versions + "]";
            FileWarning.log.append("\n Wrong ExemptionList  version : " + version + " should be one of " + versions);
        }
        this.version = version;
        this.createExempt(version);
    }

    private boolean isEmpty() {
        int rowNbr = this.table.getRowCount();
        for (int i = 0; i < rowNbr; ++i) {
            if (((String)this.table.getXMLValueAt(i, 2)).trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public class MyJTable
    extends XMLTable {
        MyJTable(DefaultTableModel model) {
            super(model);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 0: {
                    if (this.getValueAt(row, column) != null) {
                        return ExemptTable.this.addButton;
                    }
                }
                case 1: {
                    if (this.getValueAt(row, column) != null) {
                        return ExemptTable.this.delButton;
                    }
                }
                case 2: {
                    if (ExemptTable.this.subProduct.getExempt() != null) {
                        return ExemptTable.this.subProduct.getExempt();
                    }
                    return super.getCellEditor(row, column);
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

