/*
 * Decompiled with CFR 0.152.
 */
package validate;

import View.ScribaView;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import validate.ForgivingErrorHandler;
import validate.ForgivingStructureErrorHandler;

public class ValidateXML {
    public boolean validate(File xml, InputStream xsd, boolean popup) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream schemaLocation = xsd;
        StreamSource xmlSource = new StreamSource(schemaLocation);
        Schema schema = factory.newSchema(xmlSource);
        Validator validator = schema.newValidator();
        ForgivingErrorHandler lenient = new ForgivingErrorHandler();
        validator.setErrorHandler(lenient);
        StreamSource source = new StreamSource(xml);
        try {
            validator.validate(source);
            if (lenient.errors.equals("")) {
                if (popup) {
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("validate/Bundle").getString("THE_XML_FILE_IS_VALID"));
                }
                return true;
            }
            JTextArea area = new JTextArea(lenient.errors);
            area.setRows(30);
            area.setColumns(80);
            area.setLineWrap(true);
            JScrollPane pane = new JScrollPane(area);
            if (popup) {
                JOptionPane.showMessageDialog(null, pane);
            }
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("validate/Bundle").getString("THE_XML_FILE_IS_NOT_VALID") + ex.getMessage() + " | " + ex.toString());
        }
        return false;
    }

    public boolean validateStructure(File xml, JTextArea area) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream schemaLocation = ClassLoader.getSystemResourceAsStream("EmptyIPCSchema.xsd");
        StreamSource xmlSource = new StreamSource(schemaLocation);
        Schema schema = factory.newSchema(xmlSource);
        Validator validator = schema.newValidator();
        ForgivingStructureErrorHandler lenient = new ForgivingStructureErrorHandler(area);
        validator.setErrorHandler(lenient);
        StreamSource source = new StreamSource(xml);
        try {
            validator.validate(source);
            if (lenient.errors.getText().equals("")) {
                return true;
            }
            ScribaView.errorFrame.setFile(xml);
            area.setText("File :: " + xml.getAbsolutePath() + "\n" + area.getText());
            ScribaView.errorFrame.setVisible(true);
            int result = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("validate/Bundle").getString("DO_YOU_WANT_TO_CONTINUE_LOADING"));
            if (result == 0) {
                return true;
            }
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("validate/Bundle").getString("THE_XML_FILE_IS_NOT_VALID") + ex.getMessage() + " | " + ex.toString());
        }
        return false;
    }

    public static void main(String[] args) throws SAXException, IOException {
        File source = new File("C:\\Documents and Settings\\fzelosbi\\Desktop\\Scriba\\TestFile\\memory_ST9250315ASVer2-3290.xml");
        ValidateXML test = new ValidateXML();
        JTextArea area = new JTextArea();
        test.validateStructure(source, area);
    }
}

