/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class CheckBoxCellEditor
extends JCheckBox
implements TableCellEditor {
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected EventListenerList listenerList = new EventListenerList();
    boolean selected = false;
    boolean cellEnabled = true;

    public CheckBoxCellEditor() {
        this.setSize(10, 10);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                CheckBoxCellEditor.this.fireEditingStopped();
            }
        });
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selected = isSelected;
        this.requestFocus();
        if (table.isCellEditable(row, column)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        if (value.equals(new Boolean(true))) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
        return this;
    }

    public void setCellEnabled(boolean enabled) {
        this.cellEnabled = enabled;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.cellEnabled;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    public void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }
}

