/*
 * Decompiled with CFR 0.152.
 */
package ReadConf;

import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReadConfXML {
    String sep = System.getProperty("file.separator");
    public String[][][] repeat;
    public String fichier;

    public ReadConfXML(String fichier) {
        this.fichier = fichier;
    }

    public void ProcessConf() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream ips = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.fichier);
            Document doc = docBuilder.parse(ips);
            doc.getDocumentElement().normalize();
            NodeList listOfTables = doc.getElementsByTagName("table");
            int totalTables = listOfTables.getLength();
            this.repeat = new String[totalTables][][];
            for (int table = 0; table < listOfTables.getLength(); ++table) {
                Node TableNode = listOfTables.item(table);
                if (TableNode.getNodeType() != 1) continue;
                Element TableElement = (Element)TableNode;
                NodeList fractionList = TableElement.getElementsByTagName("fraction");
                this.repeat[table] = new String[fractionList.getLength()][];
                for (int fraction = 0; fraction < fractionList.getLength(); ++fraction) {
                    Element fractionElement = (Element)fractionList.item(fraction);
                    NodeList PathList = fractionElement.getElementsByTagName("node");
                    this.repeat[table][fraction] = new String[PathList.getLength()];
                    for (int node = 0; node < PathList.getLength(); ++node) {
                        Element nodeElement = (Element)PathList.item(node);
                        NodeList textLNList = nodeElement.getChildNodes();
                        this.repeat[table][fraction][node] = textLNList.item(0).getNodeValue().trim();
                    }
                }
            }
        }
        catch (SAXParseException err) {
            JOptionPane.showMessageDialog(null, "Error: " + err.getMessage(), "Error", 0);
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

