/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ScribaSignatureBC {
    private String signatureAlgo;
    private String canonicalizationMethod;
    private Signature signature;
    private Document doc;
    private String fileName;
    private String outputFile;
    private X509Certificate certificate;
    private PublicKey publicKey;
    private PrivateKey privKey;
    String signedElement;
    String location;
    static boolean etat;

    public ScribaSignatureBC(String inputFile, String CBC14, String alias, char[] kpass, String ksName, char[] keystorePass, String output, String signedElement, String location) throws Exception {
        this.signedElement = signedElement;
        this.location = location;
        this.fileName = inputFile;
        this.outputFile = output;
        if (this.testSign()) {
            etat = this.checkAliasPass(alias, kpass, ksName, keystorePass);
            if (etat) {
                this.CreateSignAlgo();
                this.CreateCanonicalizationMethod(CBC14);
                this.CreateSignature();
                this.CreateContext();
                this.CreateRef();
                this.CreateKeyInfo();
                this.CreateOutput(this.outputFile);
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CAN'T_GENERATE_") + signedElement + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_!"));
        }
    }

    public ScribaSignatureBC(String inputFile, String alias, char[] kpass, String output, String signedElement, String location) throws Exception {
        this.signedElement = signedElement;
        this.location = location;
        this.fileName = inputFile;
        this.outputFile = output;
        if (this.testSign()) {
            etat = this.checkAliasPass(alias, kpass, ".keystore", "scriba".toCharArray());
            if (etat) {
                this.CreateSignAlgo();
                this.CreateCanonicalizationMethod("EXCLUSIVE");
                this.CreateSignature();
                this.CreateContext();
                this.CreateRef();
                this.CreateKeyInfo();
                this.CreateOutput(this.outputFile);
                new File(inputFile).delete();
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CAN'T_GENERATE_") + signedElement + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_!"));
        }
    }

    public boolean testSign() throws Exception {
        this.Createdocument();
        NodeList nl = this.doc.getElementsByTagName("ds:Signature");
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getParentNode().getNodeName().equals(this.location)) continue;
            int choix = JOptionPane.showConfirmDialog(null, this.signedElement + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_ALREADY_EXIST_DO_YOU_REALY_WANT_TO_RESIGN_!"), ResourceBundle.getBundle("Sign/Bundle").getString("WARNING"), 0);
            if (choix == 0) {
                int j = 0;
                while (j < this.doc.getElementsByTagName("ds:Signature").getLength()) {
                    if (!this.doc.getElementsByTagName("ds:Signature").item(0).getParentNode().getNodeName().equals(this.location)) continue;
                    this.doc.getElementsByTagName(this.location).item(0).removeChild(this.doc.getElementsByTagName("ds:Signature").item(0));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void CreateRef() throws Exception {
    }

    public void CreateCanonicalizationMethod(String cMethode) throws Exception {
    }

    void CreateSignAlgo() {
        this.signatureAlgo = this.certificate.getSigAlgName();
        System.out.println(this.certificate.getSigAlgOID());
        System.out.println(this.certificate.getSigAlgName());
    }

    public void CreateKeyInfo() throws Exception {
    }

    public void Createdocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.doc = dbf.newDocumentBuilder().parse(new FileInputStream(this.fileName));
    }

    public void CreateContext() throws Exception {
    }

    public void CreateSignature() throws Exception {
    }

    public void CreateOutput(String outputFile) throws Exception {
        FileOutputStream os = outputFile == null ? new FileOutputStream(this.fileName) : new FileOutputStream(outputFile);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(this.doc), new StreamResult(os));
        JOptionPane.showMessageDialog(null, this.signedElement + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_GENERATED_!"));
    }

    boolean checkAliasPass(String alias, char[] kpass, String ksName, char[] keystorePass) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream ksfis = new FileInputStream(ksName);
            BufferedInputStream ksbufin = new BufferedInputStream(ksfis);
            ks.load(ksbufin, keystorePass);
            this.publicKey = ks.getCertificate(alias).getPublicKey();
            this.certificate = (X509Certificate)ks.getCertificate(alias);
            this.privKey = (PrivateKey)ks.getKey(alias, kpass);
            return true;
        }
        catch (IOException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE_INFORMATION"));
        }
        catch (NoSuchAlgorithmException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE1_INFORMATION2"));
        }
        catch (KeyStoreException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE2_INFORMATION3"));
            exp.printStackTrace();
            return false;
        }
        catch (CertificateException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_PASSWORD"));
        }
        catch (UnrecoverableKeyException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE4_INFORMATION5"));
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE5_INFORMATION6"));
        }
        return false;
    }
}

