/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import RepeateTables.ButtonColumn;
import RepeateTables.ButtonEditor;
import RepeateTables.RepeatTableCellRenderer;
import RepeateTables.XMLTable;
import Util.CFloatEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public abstract class RepeatTable
implements ActionListener,
TableModelListener {
    public DefaultTableModel model;
    public XMLTable table;
    public ButtonEditor addButton = new ButtonEditor(this, "+");
    public ButtonEditor delButton = new ButtonEditor(this, "-");
    public static CFloatEditor floatEditor = new CFloatEditor();
    RepeatTableCellRenderer repeatTableCellRenderer = new RepeatTableCellRenderer();

    public RepeatTable() {
        this.model = new MyModel();
        this.table = new XMLTable(this.model);
        this.table.setDefaultRenderer(this.table.getModel().getColumnClass(0), this.repeatTableCellRenderer);
        this.init();
        this.addRow(null);
    }

    public void removeAll() {
        int rows = this.model.getRowCount();
        for (int j = 0; j < rows; ++j) {
            this.model.removeRow(0);
        }
        this.addRow(null);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setColDimension(int[] width) {
        for (int i = 0; i < width.length; ++i) {
            this.table.getColumnModel().getColumn(i).setMaxWidth(width[i]);
        }
    }

    public void tableChanged(TableModelEvent source) {
        DefaultTableModel tabMod = (DefaultTableModel)source.getSource();
    }

    public abstract void init();

    public void addColumns(String[] colName) {
        for (int i = 0; i < colName.length; ++i) {
            this.model.addColumn(colName[i]);
        }
    }

    public void insertRow(int index, Object[] row) {
        this.model.insertRow(index, row);
    }

    public void insertRow(int index, int col) {
        Vector<Object> row = new Vector<Object>();
        for (int i = 0; i < col; ++i) {
            row.addElement(null);
        }
        this.addEmptyCell(col, row);
        this.model.insertRow(index, row);
    }

    public abstract void addEmptyCell(int var1, Vector var2);

    public abstract String getValueOfRow(int var1);

    public void addInserRemoveCol(int col) {
        ButtonColumn buttonColumn = new ButtonColumn(this.table, col);
    }

    public void addRow(Object[] row) {
        this.addRow(0);
    }

    public void addRow(int col) {
        Vector<Object> row = new Vector<Object>();
        for (int i = 0; i < col; ++i) {
            row.addElement(null);
        }
        this.addEmptyCell(col, row);
        this.model.addRow(row);
    }

    public void clear() {
        int rowNbr = this.table.getRowCount();
        for (int i = 0; i < rowNbr; ++i) {
            this.model.removeRow(0);
        }
        this.addRow(0);
    }

    public void deleteRow(int index) {
        this.model.removeRow(index);
    }

    public void setCellValue(int row, int col, String value) {
        this.model.setValueAt(value, row, col);
    }

    public void setCellValue(int col, String value) {
        this.model.setValueAt(value, this.model.getRowCount() - 1, col);
    }

    public class MyModel
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return RepeatTable.this.table.getValueAt(row, column) != null;
        }

        public Vector getColumnIdentifiers() {
            return this.columnIdentifiers;
        }
    }
}

