/*
 * Decompiled with CFR 0.152.
 */
package Parse;

import ReadConf.ReadConfXML;
import ReadConf.SubProduct;
import RepeateTables.ExemptTable;
import RepeateTables.HomogeneousTable;
import RepeateTables.MaterialGroupTable;
import RepeateTables.MaterialTable;
import RepeateTables.OtherMaterialTable;
import RepeateTables.ProductTable;
import RepeateTables.QueryTable;
import RepeateTables.RepeatTable;
import RepeateTables.RequestMaterialTable;
import RepeateTables.RohsMapXML;
import RepeateTables.RohsQueryTable;
import RepeateTables.TerminalTable;
import RepeateTables.UniqueIDTable;
import View.IncludeTree;
import View.ScribaView;
import View.Sectionnal;
import View.SubProductTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseXML
extends DefaultHandler {
    private static Writer out;
    private String Path = "";
    ScribaView view;
    int productID = 0;
    static ReadConfXML conf;
    static ReadConfXML subconf;
    int[][] flag;
    int[][] subflag;
    int table;
    InputStream file;
    boolean merge = false;
    boolean save = false;
    String savevalue = "";
    private boolean inProduct = false;
    private SubProduct subProduct;
    private Sectionnal sectionnal;
    private Attributes attrs;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode currentIncludeNode;
    private DefaultMutableTreeNode rootInclude;
    private Tag t;
    private RepeatTable currentTable;
    private RepeatTable otherMaterialTable;
    private RepeatTable requestMaterialTable;

    public ParseXML(ScribaView view, File file) {
        try {
            this.file = new FileInputStream(file);
            this.view = view;
            this.otherMaterialTable = view.getOtherMaterialTable();
            this.requestMaterialTable = view.getRequestMaterialTable();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage(), "Error", 0);
            Logger.getLogger(ParseXML.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ParseXML(ScribaView view, InputStream file) {
        this.file = file;
        this.view = view;
        this.otherMaterialTable = view.getOtherMaterialTable();
        this.requestMaterialTable = view.getRequestMaterialTable();
    }

    public void Start() {
        int loop;
        this.productID = 0;
        this.subflag = new int[ParseXML.subconf.repeat.length][];
        for (loop = 0; loop < ParseXML.subconf.repeat.length; ++loop) {
            this.subflag[loop] = new int[ParseXML.subconf.repeat[loop].length];
        }
        this.flag = new int[ParseXML.conf.repeat.length][];
        for (loop = 0; loop < ParseXML.conf.repeat.length; ++loop) {
            this.flag[loop] = new int[ParseXML.conf.repeat[loop].length];
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.file, (DefaultHandler)this);
        }
        catch (Throwable t) {
            System.out.println("ParseXML ::" + t.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, "Error: " + t.getMessage(), "Error", 0);
            t.printStackTrace();
        }
    }

    public void StartMerge() {
        this.merge = true;
        this.Start();
    }

    public static void main(String[] args) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            out.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
            throw new SAXException(" ParseXML :: I/O error", e);
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        block40: {
            String aName;
            DefaultMutableTreeNode newNode;
            String eName;
            block38: {
                block39: {
                    this.attrs = attrs;
                    this.Path = qName + "_" + this.Path;
                    eName = sName;
                    if ("".equals(eName)) {
                        eName = qName;
                    }
                    if (this.currentNode == null) {
                        if (this.merge) {
                            this.root = (DefaultMutableTreeNode)this.view.getSubProductTree().getModel().getRoot();
                        } else {
                            this.root = new DefaultMutableTreeNode(ResourceBundle.getBundle("Parse/Bundle").getString("PRODUCT_LIST"));
                            this.view.setSubProductTree(new SubProductTree(this.root, this.view));
                        }
                        ((DefaultTreeModel)this.view.getSubProductTree().getModel()).nodeStructureChanged(this.root);
                    }
                    if (eName.equals("Product") || eName.equals("SubProduct")) {
                        this.inProduct = true;
                        this.t = new Tag(ResourceBundle.getBundle("Parse/Bundle").getString(eName), attrs);
                        this.productID = 0;
                        newNode = new DefaultMutableTreeNode(this.t);
                        if (this.currentNode == null) {
                            this.root.add(newNode);
                            ((DefaultTreeModel)this.view.getSubProductTree().getModel()).nodeStructureChanged(this.root);
                        } else {
                            this.currentNode.add(newNode);
                            ((DefaultTreeModel)this.view.getSubProductTree().getModel()).nodeStructureChanged(this.currentNode);
                        }
                        this.currentNode = newNode;
                        this.subProduct = new SubProduct(this.currentNode, this.view.getSubProductTree());
                        this.view.getSubProductTree().addLink(this.currentNode, this.subProduct);
                    }
                    if (eName.equals("ProductID") && attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            aName = attrs.getLocalName(i);
                            if ("".equals(aName)) {
                                aName = attrs.getQName(i);
                            }
                            if (aName.equals("itemNumber") && this.productID < 2) {
                                if (this.t.getData() == null) {
                                    this.t.setData(ResourceBundle.getBundle("Parse/Bundle").getString("MFRITEMNUMBER") + attrs.getValue(i) + "\"");
                                    ++this.productID;
                                } else {
                                    this.t.setData(this.t.getData() + ResourceBundle.getBundle("Parse/Bundle").getString("_MFRITEMNUMBER") + attrs.getValue(i) + "\"");
                                    ++this.productID;
                                }
                            }
                            if (!aName.equals("itemName") || this.productID >= 2) continue;
                            if (this.t.getData() == null) {
                                this.t.setData(ResourceBundle.getBundle("Parse/Bundle").getString("MFRITEMNAME") + attrs.getValue(i) + "\"");
                                ++this.productID;
                                continue;
                            }
                            this.t.setData(this.t.getData() + ResourceBundle.getBundle("Parse/Bundle").getString("_MFRITEMNAME") + attrs.getValue(i) + "\"");
                            ++this.productID;
                        }
                    }
                    if (!this.inProduct) break block38;
                    if (!this.save) break block39;
                    this.savevalue = this.savevalue + "<" + eName;
                    if (attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            aName = attrs.getLocalName(i);
                            if ("".equals(aName)) {
                                aName = attrs.getQName(i);
                            }
                            this.savevalue = this.savevalue + " " + aName + "=\"" + attrs.getValue(i) + "\"";
                        }
                    }
                    this.savevalue = this.savevalue + ">";
                    break block40;
                }
                this.compareElementSubTab(this.Path);
                if (attrs == null) break block40;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String subPath;
                    int[] index;
                    aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if ((index = this.compareAttSubTab(aName + "_" + this.Path)) != null) {
                        this.ProcessSubProductTable(index[0], index[1], index[2], attrs.getValue(i));
                        continue;
                    }
                    if (!this.merge) {
                        if (this.Path.split("SubProduct") != null && this.Path.split("SubProduct").length > 1) {
                            subPath = this.Path.split("SubProduct")[0];
                            this.subProduct.Update(aName + "_" + subPath, attrs.getValue(i));
                            continue;
                        }
                        if (this.Path.split("Product") == null) continue;
                        subPath = this.Path.split("Product")[0];
                        this.subProduct.Update(aName + "_" + subPath, attrs.getValue(i));
                        continue;
                    }
                    if (this.Path.split("SubProduct") != null && this.Path.split("SubProduct").length > 1) {
                        subPath = this.Path.split("SubProduct")[0];
                        if (this.subProduct.getValueView(aName + "_" + subPath) == null) continue;
                        this.subProduct.Update(aName + "_" + subPath, attrs.getValue(i));
                        continue;
                    }
                    if (this.Path.split("Product") == null || this.Path.split("Product").length <= 1) continue;
                    subPath = this.Path.split("Product")[0];
                    if (this.subProduct.getValueView(aName + "_" + subPath) == null) continue;
                    this.subProduct.Update(aName + "_" + subPath, attrs.getValue(i));
                }
                break block40;
            }
            if (eName.equals("Sectional") || eName.equals("SubSectional")) {
                this.t = new Tag(eName, attrs);
                newNode = new DefaultMutableTreeNode(this.t);
                this.t.setData(attrs.getValue(0));
                if (this.currentIncludeNode == null) {
                    this.rootInclude = new DefaultMutableTreeNode("Include");
                    this.view.setIncludeTree(new IncludeTree(this.rootInclude, this.view));
                    this.rootInclude.add(newNode);
                } else {
                    this.currentIncludeNode.add(newNode);
                }
                this.currentIncludeNode = newNode;
                this.sectionnal = new Sectionnal(attrs.getValue(0));
                this.view.getIncludeTree().addLink(this.currentIncludeNode, this.sectionnal);
                return;
            }
            if (this.Path.equals("ds:Signature_Request_BusinessInfo_MainDeclaration_")) {
                this.view.getsignature_Request_BusinessInfo_MainDeclaration_();
                this.save = true;
            }
            if (this.Path.equals("ds:Signature_BusinessInfo_MainDeclaration_")) {
                this.view.getsignature_Response_BusinessInfo_MainDeclaration_();
                this.save = true;
            }
            if (this.save) {
                this.savevalue = this.savevalue + "<" + eName;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        aName = attrs.getLocalName(i);
                        if ("".equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        this.savevalue = this.savevalue + " " + aName + "=\"" + attrs.getValue(i) + "\"";
                    }
                }
                this.savevalue = this.savevalue + ">";
            } else {
                this.compareElementTab(this.Path);
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        int[] index;
                        aName = attrs.getLocalName(i);
                        if ("".equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if ((index = this.compareAttTab(aName + "_" + this.Path)) == null) {
                            if (!this.merge) {
                                this.view.UpdateView(aName + "_" + this.Path, attrs.getValue(i));
                                continue;
                            }
                            if (this.view.getValueView(aName + "_" + this.Path) == null || !this.view.getValueView(aName + "_" + this.Path).trim().equals("")) continue;
                            this.view.UpdateView(aName + "_" + this.Path, attrs.getValue(i));
                            continue;
                        }
                        this.ProcessTable(index[0], index[1], index[2], attrs.getValue(i));
                    }
                }
            }
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("Product") || qName.equals("SubProduct")) {
            if (qName.equals("Product")) {
                this.inProduct = false;
            }
            if (this.subProduct.getProductTable() == null) {
                this.subProduct.setProductTable(new ProductTable());
            }
            if (this.subProduct.getUniqueIDTable() == null) {
                this.subProduct.setUniqueIDTable(new UniqueIDTable());
            }
            this.currentNode = (DefaultMutableTreeNode)this.currentNode.getParent();
        } else if (qName.equals("Sectional") || qName.equals("SubSectional")) {
            this.currentIncludeNode = (DefaultMutableTreeNode)this.currentIncludeNode.getParent();
        } else if (this.save) {
            this.savevalue = this.savevalue + "</" + qName + ">";
            if (this.Path.equals("ds:Signature_Request_BusinessInfo_MainDeclaration_")) {
                this.save = false;
                this.view.setsignature_Request_BusinessInfo_MainDeclaration_(this.savevalue);
            }
            if (this.Path.equals("ds:Signature_Request_BusinessInfo_MainDeclaration_")) {
                this.save = false;
                this.view.setsignature_Response_BusinessInfo_MainDeclaration_(this.savevalue);
            }
        }
        this.Path = this.Path.substring(qName.length() + 1);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.save) {
            this.savevalue = this.savevalue + s;
        }
    }

    private void emit(String s) throws SAXException {
        try {
            out.write(s);
            out.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
            throw new SAXException("ParseXML :: I/O error", e);
        }
    }

    private void nl() throws SAXException {
        String lineEnd = System.getProperty("line.separator");
        try {
            out.write(lineEnd);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
            throw new SAXException("ParseXML :: I/O error", e);
        }
    }

    public int[] compareAttTab(String Path2) {
        int col = 2;
        int[] index = new int[3];
        for (int loop = 0; loop < ParseXML.conf.repeat.length; ++loop) {
            for (int i = 0; i < ParseXML.conf.repeat[loop].length; ++i) {
                for (int j = 1; j < ParseXML.conf.repeat[loop][i].length; ++j) {
                    if (ParseXML.conf.repeat[loop][i][j].equals(Path2)) {
                        index[0] = i;
                        index[1] = col;
                        index[2] = loop;
                        return index;
                    }
                    ++col;
                }
                col += 2;
            }
            col = 2;
        }
        return null;
    }

    public int[] compareAttSubTab(String Path2) {
        int col = 2;
        int[] index = new int[3];
        for (int loop = 0; loop < ParseXML.subconf.repeat.length; ++loop) {
            for (int i = 0; i < ParseXML.subconf.repeat[loop].length; ++i) {
                for (int j = 1; j < ParseXML.subconf.repeat[loop][i].length; ++j) {
                    if (Path2.startsWith(ParseXML.subconf.repeat[loop][i][j])) {
                        index[0] = i;
                        index[1] = col;
                        index[2] = loop;
                        return index;
                    }
                    ++col;
                }
                col += 2;
            }
            col = 2;
        }
        return null;
    }

    public int compareElementTab(String Path2) {
        int col = 0;
        for (int loop = 0; loop < ParseXML.conf.repeat.length; ++loop) {
            for (int i = 0; i < ParseXML.conf.repeat[loop].length; ++i) {
                if (ParseXML.conf.repeat[loop][i][0].equals(Path2)) {
                    if (this.flag[loop][i] == 1) {
                        this.view.repeat[loop].addRow(col + 2 * i);
                        this.initFlag(i, loop);
                    }
                    return i;
                }
                col = col + ParseXML.conf.repeat[loop][i].length - 1;
            }
            col = 0;
        }
        return -1;
    }

    public int compareElementSubTab(String Path2) {
        int col = 0;
        for (int loop = 0; loop < ParseXML.subconf.repeat.length; ++loop) {
            for (int i = 0; i < ParseXML.subconf.repeat[loop].length; ++i) {
                if (Path2.startsWith(ParseXML.subconf.repeat[loop][i][0])) {
                    if (loop == 0) {
                        if (this.subProduct.getHomogeneousMaterial() == null) {
                            this.currentTable = new HomogeneousTable((RequestMaterialTable)this.requestMaterialTable, this.subProduct);
                            this.subProduct.setHomogeneousMaterial(this.currentTable);
                            this.initSubFlag(i, loop);
                        }
                        if (!((DefaultMutableTreeNode)this.currentNode.getParent()).isRoot()) {
                            this.currentNode.setAllowsChildren(false);
                            this.subProduct.UpdateSubProduct();
                        }
                    }
                    if (loop == 1 && this.subProduct.getMaterial() == null) {
                        this.currentTable = new MaterialTable((OtherMaterialTable)this.otherMaterialTable);
                        this.subProduct.setMaterial(this.currentTable);
                        this.initSubFlag(i, loop);
                    }
                    if (loop == 2) {
                        if (this.subProduct.getProductTable() == null) {
                            this.subProduct.setProductTable(new ProductTable());
                            this.initSubFlag(i, loop);
                        }
                        this.currentTable = this.subProduct.getProductTable();
                    }
                    if (loop == 7 && this.subProduct.getExemptionList() == null) {
                        this.currentTable = this.attrs.getValue("identity") == null ? new ExemptTable("", this.subProduct) : new ExemptTable(this.attrs.getValue("identity"), this.subProduct);
                        this.subProduct.setExemptionList(this.currentTable);
                        this.initSubFlag(i, 3);
                    }
                    if (loop == 9 && this.subProduct.getTerminalTable() == null) {
                        this.currentTable = new TerminalTable();
                        this.subProduct.setTerminalTable(this.currentTable);
                        this.initSubFlag(i, loop);
                    }
                    if (loop == 6) {
                        this.currentTable = this.attrs.getValue("identity") == null ? new QueryTable("") : (RohsMapXML.isVersion(this.attrs.getValue("identity")) ? new RohsQueryTable(this.attrs.getValue("identity")) : new QueryTable(this.attrs.getValue("identity")));
                        this.subProduct.addQuery(this.currentTable);
                        this.initSubFlag(i, 4);
                    }
                    if (loop == 8 && this.subProduct.getMaterialGroup() == null) {
                        this.currentTable = this.attrs.getValue("identity") == null ? new MaterialGroupTable("", this.subProduct) : new MaterialGroupTable(this.attrs.getValue("identity"), this.subProduct);
                        this.subProduct.setMaterialGroup(this.currentTable);
                        this.initSubFlag(i, 5);
                    }
                    if (this.subflag[loop][i] == 1) {
                        if (loop == 2) {
                            if (!ProductTable.request && col > 2) {
                                this.currentTable.addRow(col + 2 * i - 2);
                            } else {
                                this.currentTable.addRow(col + 2 * i);
                            }
                        } else {
                            this.currentTable.addRow(col + 2 * i);
                        }
                        this.initSubFlag(i, loop);
                    }
                    return i;
                }
                col = col + ParseXML.subconf.repeat[loop][i].length - 1;
            }
            col = 0;
        }
        return -1;
    }

    public void ProcessTable(int ligne, int col, int tab, String value) {
        this.view.repeat[tab].setCellValue(col, value);
        this.addFlag(ligne, tab);
    }

    private void addFlag(int col, int tab) {
        for (int i = col; i >= 0; --i) {
            this.flag[tab][i] = 1;
        }
    }

    public void initFlag(int col, int tab) {
        for (int i = col + 1; i < this.flag[tab].length; ++i) {
            this.flag[tab][i] = 0;
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    private void ProcessSubProductTable(int ligne, int col, int tab, String value) {
        if (tab == 6 || tab == 7 || tab == 8) {
            return;
        }
        this.currentTable.setCellValue(col, value);
        this.addSubFlag(ligne, tab);
    }

    private void addSubFlag(int col, int tab) {
        for (int i = col; i >= 0; --i) {
            this.subflag[tab][i] = 1;
        }
    }

    private void initSubFlag(int col, int tab) {
        for (int i = col; i < this.subflag[tab].length; ++i) {
            this.subflag[tab][i] = 0;
        }
    }

    static {
        conf = new ReadConfXML("table.xml");
        subconf = new ReadConfXML("subProduct.xml");
        conf.ProcessConf();
        subconf.ProcessConf();
    }

    public static class Tag {
        private String name;
        private String data;
        private Attributes attr;

        public Tag(String n, Attributes a) {
            this.name = n;
            this.attr = a;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attr;
        }

        public void setData(String d) {
            this.data = d;
        }

        public String getData() {
            return this.data;
        }

        public void addData(String d) {
            if (this.data == null) {
                this.setData(d);
            } else {
                this.data = this.data + d;
            }
        }

        public String getAttributesAsString() {
            StringBuffer buf = new StringBuffer(256);
            for (int i = 0; i < this.attr.getLength(); ++i) {
                buf.append(this.attr.getQName(i));
                buf.append("=\"");
                buf.append(this.attr.getValue(i));
                buf.append("\"");
            }
            return buf.toString();
        }

        public String toString() {
            String a = this.getAttributesAsString();
            return this.name + ": " + (this.data == null ? "" : " (" + this.data + ")");
        }
    }
}

