#!/bin/sh 
################################################################################
# 
# This script is part of the NIST Source Code Analysis Tool Assessment Test Suite
#
# This software was developed at the National Institute of Standards and
# Technology by employees of the Federal Government in the course of their
# official duties. Pursuant to title 17 Section 105 of the United States
# Code this software is not subject to copyright protection and is in the
# public domain. NIST assumes no responsibility whatsoever for its use by
# other parties, and makes no guarantees, expressed or implied, about its
# quality, reliability, or any other characteristic.
#
################################################################################
#
# This is an acessory script for the test_tools.sh shell script.  It accepts 
# the input for locating test files and running compilers or other code analysis
# tools against the tests.
#
echo "test base directory is" 
echo $1
#
# set recognizable variable names for input parameters
#
directory=$1
tool=$2
tool_opts=$3
language=$4
build=$5

#
# if a directory is provided, move into it and traverse test directories
#
if test $directory
then
cd $directory
ls  | while read i
do
echo "subdirectory is " 
echo $i
cd $i
#
# if we're building using "make", "nmake", "ant"..etc... don't compile files
# otherwise, compile them
#
if test $build
then
echo $tool $tool_opts
#$tool $tool_opts 
else
echo $tool $tool_opts *.$language
$tool $tool_opts *.$language
fi
cd ..
done
fi

